/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.net.URL;
import java.util.Iterator;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;
import oracle.jdeveloper.deploy.dt.DeployElement;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdevimpl.deploy.DeploymentProfilesMigrator;
import oracle.jdevimpl.deploy.common.DefaultProfileDependable;
import oracle.jdevimpl.deploy.common.DependableContainer;
import oracle.jdevimpl.jar.JarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Profile
extends DeployElement
implements Interdependency {
    public static String PROFILE_NAME = "profileName";
    public static String PROFILE_CLASS_NAME = "profileClass";
    public static String PROFILE_DEPENDENCIES = "dependencies";
    protected DependableContainer _dependableContainer;
    protected DataContainer _dataContainer;

    public Profile() {
        Profile.setProfileClass(this, this.getClass());
    }

    public Profile(HashStructure hash) {
        super(hash);
    }

    public String getName() {
        return this._hash.getString(PROFILE_NAME);
    }

    public void setName(String name) {
        this._hash.putString(PROFILE_NAME, name);
    }

    public static <T extends Profile> void setProfileClass(Profile profile, Class<T> profileClass) {
        profile.getHashStructure().putString(PROFILE_CLASS_NAME, profileClass.getName());
    }

    public static <T extends Profile> Class<T> getProfileClass(HashStructure hash, ClassLoader loader) throws ClassNotFoundException {
        String className;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (!ModelUtil.hasLength((String)(className = hash.getString(PROFILE_CLASS_NAME)))) {
            throw new ClassNotFoundException("Profile class value is empty");
        }
        Class<?> anyClass = loader.loadClass(className);
        try {
            Class<?> clazz;
            Class<?> clazz2 = clazz = anyClass;
            return clazz2;
        }
        catch (ClassCastException e) {
            throw new ClassNotFoundException(anyClass.getName() + " does not extend Profile");
        }
    }

    public Object copyTo(Object object) {
        if (object != null && !(object instanceof Profile)) {
            throw new IllegalArgumentException("Attempt to copy " + this.getClass() + " to " + object.getClass());
        }
        Object copy = object;
        if (copy == null) {
            try {
                copy = (Profile)this.getClass().getConstructor(new Class[0]).newInstance(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot call default constructor for copying object", e);
            }
        }
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(Object object) {
        Profile copy = (Profile)object;
        this._hash.copyTo(copy._hash);
        copy._dataContainer = this._dataContainer;
        copy._dependableContainer = this._dependableContainer;
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public DataContainer getDataContainer() {
        return this._dataContainer;
    }

    public void setDataContainer(DataContainer dataContainer) {
        this._dataContainer = dataContainer;
    }

    private void initDependableContainer() {
        HashStructure dependenciesHash = this._hash.getOrCreateHashStructure(PROFILE_DEPENDENCIES);
        this._dependableContainer = new DependableContainer(dependenciesHash);
    }

    @Override
    public Iterator<Dependable> getDependencies() {
        if (this._dependableContainer == null) {
            this.initDependableContainer();
        }
        return this._dependableContainer.getDependencies();
    }

    private Dependable getDependable(Element elem, DataContainer container) {
        try {
            Dependable dependable = Deployment.getDependableFactory().findOrCreate(elem, (Folder)container);
            return dependable;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void addDependency(Profile profile) {
        this.addDependency(this.getDependable(profile, profile.getDataContainer()));
    }

    public Dependable removeDependency(Profile profile) {
        Assert.check((profile != null ? 1 : 0) != 0, (String)"Cannot remove dependency to null profile.");
        ProfileDependable[] profileDependableArray = (ProfileDependable[])DeployUtil.getDependables((Interdependency)this, ProfileDependable.class);
        int n = 0;
        while (n < profileDependableArray.length) {
            ProfileDependable dep = profileDependableArray[n];
            if (profile.equals(dep.getProfile())) {
                this._dependableContainer.removeDependency(dep);
                return dep;
            }
            ++n;
        }
        return null;
    }

    public void addDependency(Node node, DataContainer container) {
        Assert.check((boolean)(node instanceof JarNode), (String)"The Node has to be a JarNode in order for a Dependable object to be built.");
        this.addDependency(this.getDependable((Element)node, container));
    }

    @Override
    public void addDependency(Dependable dependable) {
        if (this._dependableContainer == null) {
            this.initDependableContainer();
        }
        this._dependableContainer.addDependency(dependable);
    }

    @Override
    public Dependable removeDependency(Dependable dependable) {
        if (this._dependableContainer == null) {
            this.initDependableContainer();
        }
        return this._dependableContainer.removeDependency(dependable);
    }

    @Override
    public String getShortLabel() {
        if (this.isContainedProfile()) {
            int containedNameIndex = this.getName().indexOf("_");
            if (containedNameIndex == -1) {
                return this.getName();
            }
            return this.getName().substring(containedNameIndex + 1);
        }
        return this.getName();
    }

    @Deprecated
    public void setContainedProfile(boolean containedProfile) {
        this._hash.putBoolean("containedProfile", containedProfile);
    }

    @Deprecated
    public boolean isContainedProfile() {
        return this._hash.getBoolean("containedProfile", false);
    }

    @Deprecated
    public String getParentProfileName() {
        if (this.isContainedProfile() && this.getName().indexOf("_") != -1) {
            return this.getName().substring(0, this.getName().indexOf("_"));
        }
        return "";
    }

    @Deprecated
    protected static String getProfileNameFromRef(String profileRef) {
        if (profileRef.indexOf("#") == -1) {
            return profileRef;
        }
        return profileRef.substring(profileRef.indexOf("#") + 1);
    }

    protected static void resolveProfileDependencies(Project project, Profile profile, DeploymentProfilesMigrator migrator) {
        String[] _profileSuffixes = new String[]{".deploy", ".bcdeploy"};
        if (profile instanceof ArchiveProfile) {
            ArchiveProfile archiveProfile = (ArchiveProfile)profile;
            Iterator<Dependable> depIter = archiveProfile.getDependencies();
            while (depIter != null && depIter.hasNext()) {
                AbstractHashDependable dep = (AbstractHashDependable)depIter.next();
                if (!(dep instanceof DefaultProfileDependable)) continue;
                String profileDepURLString = DeploymentProfilesMigrator.getDependableProfileName(dep);
                URL profileDepURL = URLFactory.newURL((String)profileDepURLString);
                URL projectDepURL = DeploymentProfilesMigrator.getDependableContainerURL(dep);
                String refPart = migrator.getProfileRefPart(projectDepURL, profileDepURL);
                if (refPart != null) {
                    DeploymentProfilesMigrator.setDependableProfileName(dep, Profile.getProfileNameFromRef(refPart));
                    continue;
                }
                System.out.println("Could not find a profile with URL:" + profileDepURL + " in Project: " + projectDepURL);
            }
        }
    }

    public void migrate(TraversableContext tc) {
        Node profileNode = (Node)tc.get(DeploymentProfilesMigrator.PROFILE_NODE);
        URL profileURL = profileNode.getURL();
        Project project = (Project)tc.get("Project");
        DeploymentProfilesMigrator migrator = (DeploymentProfilesMigrator)((Object)tc.get(DeploymentProfilesMigrator.DEPLOYMENT_PROFILES_MIGRATOR));
        String newRefPart = migrator.getProfileRefPart(project.getURL(), profileURL);
        Profile.setProfileClass(this, this.getClass());
        if (newRefPart.indexOf("#") == -1) {
            this.setContainedProfile(false);
        } else {
            this.setContainedProfile(true);
        }
        this.setName(Profile.getProfileNameFromRef(newRefPart));
        Profile.resolveProfileDependencies(project, this, migrator);
    }
}

