/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.jar;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DefaultArchive;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.common.FileGroupPackager;
import oracle.jdeveloper.deploy.common.ModuleContext;
import oracle.jdeveloper.deploy.common.NodeDependable;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdevimpl.deploy.common.ProfileDeployer;
import oracle.jdevimpl.deploy.fwk.JarUtil;
import oracle.jdevimpl.deploy.res.JarArb;

public class ArchiveDeployer
extends ProfileDeployer {
    protected final ArchiveProfile _profile;
    protected DeploymentModule _depMod;

    private void $init$() {
        this._depMod = null;
    }

    public ArchiveDeployer(int deploySequence, DeployShell shell) {
        super(deploySequence, shell);
        this.$init$();
        this._profile = (ArchiveProfile)DeployUtil.getProfile(shell);
    }

    public void prepareImpl(int deploySequence, DeployShell dsh) throws DeployException {
        ArchiveProfile profile = this.getProfile();
        DeploymentModuleFactory factory = dsh.getDeploymentModuleFactory();
        this._depMod = factory.create(profile.getClass(), ModuleContext.newInstance(dsh, null, profile.getArchiveOptions()));
        FileGroupPackager.newInstance(profile.getFileGroups(), profile.getDataContainer(), this._depMod).process();
        this.maybeSetManifestClassPath(this._depMod, this.getProfile(), dsh);
        this.setDeploymentModule(this._depMod, dsh);
    }

    public void deployImpl(int deploySequence, DeployShell dsh) throws DeployException {
        PrintWriter log = dsh.getLog();
        URL targetURL = this.getTargetURL(dsh);
        String jarPath = URLFileSystem.getPlatformPathName((URL)targetURL);
        try {
            this._depMod.setURL(targetURL);
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
        this._depMod.commit();
        this.logFileWritten(log, jarPath);
    }

    public void finishImpl(int deploySequence, DeployShell dsh) {
        if (this._depMod == null) {
            return;
        }
        try {
            this._depMod.release();
        }
        catch (DeployException e) {
            e.printStackTrace();
        }
    }

    protected URL getTargetURL(DeployShell dsh) throws DeployException {
        URL targetURL = this._profile.getJarURL();
        if (targetURL == null) {
            dsh.getLog().println(JarArb.getString(16));
            throw new DeployException(JarArb.getString(16));
        }
        return targetURL;
    }

    @Deprecated
    public JarUtil getJarUtil() {
        return null;
    }

    @Deprecated
    public DefaultArchive getArchive() {
        return this._depMod;
    }

    @Deprecated
    protected void setJarUtil(JarUtil jarUtil) {
        Assert.fail((String)"setJarUtil should not be called");
    }

    public DeploymentModule getDeploymentModule(DeployShell shell) {
        return DeployUtil.getDeploymentModule(shell, this.getProfile());
    }

    public void setDeploymentModule(DeploymentModule module, DeployShell shell) {
        DeployUtil.setDeploymentModule(shell, this.getProfile(), module);
    }

    protected ArchiveProfile getProfile() {
        return this._profile;
    }

    protected void logFileWritten(PrintWriter log, String jarPath) {
        log.println(JarArb.format(87, jarPath));
    }

    protected void logFileUpToDate(PrintWriter log, String jarPath) {
        log.println(JarArb.format(104, jarPath));
    }

    protected void setDeploymentModuleURL(URL url, DeployShell shell) throws DeployException {
        try {
            this.getDeploymentModule(shell).setURL(url);
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
    }

    protected void maybeSetManifestClassPath(DeploymentModule archive, ArchiveProfile profile, DeployShell dsh) {
        ProfileDependable[] profileDependables;
        if (!dsh.findFlag("isAssembly")) {
            return;
        }
        NodeDependable[] jarDependables = DeployUtil.getAllJarDependables(profile);
        if (jarDependables.length + (profileDependables = DeployUtil.getProfileDependables(profile, ArchiveProfile.class)).length == 0) {
            return;
        }
        ArchiveOptions options = (ArchiveOptions)profile.getArchiveOptions().copyTo(null);
        options.setHasManifest(true);
        StringBuffer cp = new StringBuffer();
        NodeDependable[] nodeDependableArray = jarDependables;
        int n = 0;
        while (n < nodeDependableArray.length) {
            NodeDependable nodeDep = nodeDependableArray[n];
            ArchiveEntry ae = DeployUtil.createArchiveEntry(nodeDep, (String)null);
            cp.append(ae.getName()).append(" ");
            ++n;
        }
        ProfileDependable[] profileDependableArray = profileDependables;
        int n2 = 0;
        while (n2 < profileDependableArray.length) {
            ProfileDependable profileDep = profileDependableArray[n2];
            ArchiveEntry ae = DeployUtil.createArchiveEntry(profileDep, (String)null);
            cp.append(ae.getName()).append(" ");
            ++n2;
        }
        int cpLen = cp.length();
        if (cpLen > 0) {
            cp.setLength(cpLen - 1);
            String curCp = archive.getMainAttribute("Class-Path");
            String cpStr = cp.toString();
            String wholeCp = ModelUtil.hasLength((String)curCp) ? curCp + " " + cpStr : cpStr;
            archive.setMainAttribute("Class-Path", wholeCp);
        }
    }
}

