/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.jar;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdeveloper.deploy.res.DeployArb;

public class ArchiveOptions
extends DefaultLinkedDirtyable
implements Copyable {
    private final HashStructure _hash;

    public ArchiveOptions() {
        this(HashStructure.newInstance());
        this.setHasManifest(true);
    }

    public ArchiveOptions(HashStructure hash) {
        this._hash = hash;
    }

    public Object copyTo(Object target) {
        ArchiveOptions copy = target != null ? (ArchiveOptions)target : new ArchiveOptions(HashStructure.newInstance());
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(ArchiveOptions copy) {
        this._hash.copyTo(copy._hash);
    }

    public boolean isCompressed() {
        return this._hash.getBoolean("compressed");
    }

    public void setCompressed(boolean compressed) {
        if (this.isCompressed() != compressed) {
            this._hash.putBoolean("compressed", compressed);
            this.markDirty(true);
        }
    }

    public boolean getHasManifest() {
        return this._hash.getBoolean("hasManifest");
    }

    public void setHasManifest(boolean hasManifest) {
        if (this.getHasManifest() != hasManifest) {
            this._hash.putBoolean("hasManifest", hasManifest);
            this.markDirty(true);
        }
    }

    public String getMainClass() {
        return this._hash.getString("mainClass");
    }

    public void setMainClass(String mainClass) {
        if (ModelUtil.areDifferent((Object)this.getMainClass(), (Object)mainClass)) {
            this._hash.putString("mainClass", mainClass);
            this.markDirty(true);
        }
    }

    public URL[] getAdditionalManifests() {
        ListStructure list = this._hash.getListStructure("additionalManifests");
        if (list == null) {
            return null;
        }
        return (URL[])list.toArray((Object[])new URL[list.size()]);
    }

    public void setAdditionalManifests(URL[] additionalManifests) {
        if (!Arrays.equals(this.getAdditionalManifests(), additionalManifests)) {
            ListStructure list = this._hash.getOrCreateListStructure("additionalManifests");
            list.clear();
            if (additionalManifests != null) {
                list.addAll(Arrays.asList(additionalManifests));
            }
            this.markDirty(true);
        }
    }

    public void applyOptionsTo(Archive archive) throws IOException {
        if (archive != null) {
            archive.setCompressed(this.isCompressed());
            boolean includeManifest = this.getHasManifest();
            archive.setIncludeManifest(includeManifest);
            if (includeManifest) {
                String mainClass;
                URL[] moreManifests = this.getAdditionalManifests();
                if (moreManifests != null) {
                    int n = moreManifests.length;
                    int i = 0;
                    while (i < n) {
                        URL url = moreManifests[i];
                        try {
                            archive.mergeManifest(url);
                        }
                        catch (IOException e) {
                            String msg = DeployArb.format(10, url.getPath(), e.getMessage());
                            throw new IOException(msg);
                        }
                        ++i;
                    }
                }
                if (ModelUtil.hasLength((String)(mainClass = this.getMainClass()))) {
                    archive.setMainClass(mainClass);
                }
            }
        }
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ArchiveOptions)o);
    }

    protected final boolean equalsImpl(ArchiveOptions opts) {
        return this._hash.equals((Object)opts._hash);
    }
}

