/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.jar;

import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.common.FileGroupPackager;
import oracle.jdeveloper.deploy.common.ModuleContext;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdevimpl.deploy.common.ProfileDeployer;
import oracle.jdevimpl.deploy.jar.ArchivePreviewPacket;

public class ArchivePreviewer
extends ProfileDeployer {
    protected transient ArchivePreviewPacket _previewPacket;

    private void $init$() {
        this._previewPacket = null;
    }

    public ArchivePreviewer(int deploySequence, DeployShell shell) {
        super(deploySequence, shell);
        this.$init$();
    }

    public void deployImpl(int deploySequence, DeployShell dsh) throws DeployException {
        try {
            ArchiveProfile profile = (ArchiveProfile)DeployUtil.getProfile(dsh);
            DeploymentModuleFactory factory = dsh.getDeploymentModuleFactory();
            DeploymentModule archive = factory.create(profile.getClass(), ModuleContext.newInstance(dsh, null, profile.getArchiveOptions()));
            FileGroupPackager.newInstance(profile.getFileGroups(), profile.getDataContainer(), archive).process();
            this.processProfileSubtype(archive);
            this._previewPacket = new ArchivePreviewPacket(archive);
        }
        catch (Exception e) {
            if (e instanceof DeployException) {
                throw (DeployException)e;
            }
            throw new DeployException(e);
        }
    }

    protected void processProfileSubtype(Archive archive) {
    }

    public ArchivePreviewPacket getPreviewPacket() {
        Assert.check((this._previewPacket != null ? 1 : 0) != 0, (String)"ArchivePreviewer should be deployed first");
        return this._previewPacket;
    }
}

