/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.jar;

import java.lang.reflect.Constructor;
import java.net.URL;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;
import oracle.jdeveloper.deploy.common.SelectedProjectFiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdeveloper.deploy.jar.JarPackaging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveProfile
extends Profile
implements Copyable,
JarPackaging {
    public static final String ACTION_DEPLOY_TO_JAR_FILE = "ArchiveProfile.deployToJarFile";
    public static final String ACTION_PREVIEW = "ArchiveProfile.preview";
    public static final String ACTION_SETTINGS_DIALOG = "ArchiveProfile.settingsDialog";

    public ArchiveProfile() {
        this._hash.setParentDirtyable((Dirtyable)this);
        this.setArchiveOptionsImpl(new ArchiveOptions());
    }

    public ArchiveProfile(HashStructure hash) {
        super(hash);
    }

    public static ArchiveProfile newDefaultArchiveProfile() {
        return ArchiveProfile.newDefaultArchiveProfile(Project.class, null);
    }

    public static ArchiveProfile newDefaultArchiveProfile(Class<? extends ArchiveProfile> prototypeClass) {
        return ArchiveProfile.newDefaultArchiveProfile(Project.class, prototypeClass);
    }

    public static ArchiveProfile newDefaultArchiveProfile(Class<? extends DataContainer> profileContainerClass, Class<? extends ArchiveProfile> prototypeClass) {
        ArchiveProfile profile = ArchiveProfile.newLike(prototypeClass, null);
        profile.initArchiveProfile(profileContainerClass);
        return profile;
    }

    protected void initArchiveProfile(Class<? extends DataContainer> profileContainerClass) {
        FileGroups fileGroups = this.getFileGroups();
        fileGroups.addFileGroup(PackagingFileGroup.newDefaultGroup(profileContainerClass));
    }

    @Override
    public URL getJarURL() {
        return this._hash.getURL("jarURL");
    }

    public void setJarURL(URL jarURL) {
        this._hash.putURL("jarURL", jarURL);
    }

    @Override
    public ArchiveOptions getArchiveOptions() {
        HashStructure archiveOptionsHash = this._hash.getOrCreateHashStructure("archiveOptions");
        return new ArchiveOptions(archiveOptionsHash);
    }

    public void setArchiveOptions(ArchiveOptions archiveOptions) {
        if (archiveOptions == null) {
            throw new IllegalArgumentException();
        }
        if (ModelUtil.areDifferent((Object)this.getArchiveOptions(), (Object)archiveOptions)) {
            this.setArchiveOptionsImpl(archiveOptions);
            this.markDirty(true);
        }
    }

    private void setArchiveOptionsImpl(ArchiveOptions archiveOptions) {
        this.unlinkEmbeddedDirtyable(this.getArchiveOptions());
        if (archiveOptions != null) {
            this._hash.putHashStructure("archiveOptions", archiveOptions.getHashStructure());
        } else {
            this._hash.putHashStructure("archiveOptions", null);
        }
        this.linkEmbeddedDirtyable(this.getArchiveOptions());
    }

    @Override
    public FileGroups getFileGroups() {
        HashStructure fileGroupHash = this._hash.getOrCreateHashStructure("fileGroups");
        return new FileGroups(fileGroupHash);
    }

    public void setFileGroups(FileGroups fileGroups) {
        if (ModelUtil.areDifferent((Object)this.getFileGroups(), (Object)fileGroups)) {
            this.setFileGroupsImpl(fileGroups);
            this.markDirty(true);
        }
    }

    private void setFileGroupsImpl(FileGroups fileGroups) {
        this.unlinkEmbeddedDirtyable(this.getFileGroups());
        if (fileGroups != null) {
            this._hash.putHashStructure("fileGroups", fileGroups.getHashStructure());
        } else {
            this._hash.putHashStructure("fileGroups", null);
        }
        this.linkEmbeddedDirtyable(this.getFileGroups());
    }

    public boolean isClasspathJar() {
        return true;
    }

    public void addFileGroup(FileGroup fileGroup) {
        if (fileGroup != null) {
            FileGroups groups = this.getFileGroups();
            if (groups == null) {
                groups = new FileGroups();
                this.setFileGroups(groups);
            }
            groups.addFileGroup(fileGroup);
        }
    }

    public PackagingFileGroup findPackagingFileGroup(String internalName) {
        FileGroups groups = this.getFileGroups();
        return groups != null ? groups.findPackagingFileGroup(internalName) : null;
    }

    public ProjectFileGroup findProjectFileGroup(String internalName) {
        FileGroups groups = this.getFileGroups();
        return groups != null ? groups.findProjectFileGroup(internalName) : null;
    }

    public LibraryFileGroup findLibraryFileGroup(String internalName) {
        FileGroups groups = this.getFileGroups();
        return groups != null ? groups.findLibraryFileGroup(internalName) : null;
    }

    public void selectLibraryForDeployment(Object id) {
        LibraryFileGroup lfg = this.findLibraryFileGroup("libraries");
        if (lfg != null) {
            lfg.addSelectedLibrary(id);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ArchiveProfile)o);
    }

    protected final boolean equalsImpl(ArchiveProfile profile) {
        return this._hash.equals((Object)profile._hash);
    }

    public final SelectedProjectFiles getSelectedProjectFiles() throws TransientMarker {
        new Exception("Call to deprecated method").printStackTrace();
        return new SelectedProjectFiles();
    }

    private static ArchiveProfile newLike(Class<? extends ArchiveProfile> prototypeClass, HashStructure hash) {
        if (prototypeClass == null) {
            prototypeClass = ArchiveProfile.class;
        }
        try {
            if (hash == null) {
                ArchiveProfile archiveProfile = prototypeClass.newInstance();
                return archiveProfile;
            }
            Constructor<? extends ArchiveProfile> ctor = prototypeClass.getConstructor(HashStructure.class);
            ArchiveProfile archiveProfile = ctor.newInstance(hash);
            return archiveProfile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

