/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta;

import java.util.ArrayList;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.meta.PlatformVersion;

public class PlatformRegistry {
    private ArrayList<Platform> platforms_;
    private static PlatformRegistry platformRegistry_ = null;
    private static Platform defaultPlatform_ = null;
    private static final String PLATFORM_REGISTRY_METADATA_ERROR = "No such platform defined";

    public static void setDefaultPlatform(Platform platform) throws MetadataException {
        defaultPlatform_ = PlatformRegistry.getPlatform(platform.getType(), platform.getVersion());
    }

    public static Platform getDefaultPlatform() {
        return defaultPlatform_;
    }

    private PlatformRegistry() {
        this.$init$();
    }

    private static synchronized PlatformRegistry getInstance() {
        if (platformRegistry_ == null) {
            platformRegistry_ = new PlatformRegistry();
        }
        return platformRegistry_;
    }

    public static void registerPlatform(Platform platform) {
        PlatformRegistry.getInstance().platforms_.add(platform);
    }

    public static Platform getPlatform(PlatformType type, PlatformVersion version) throws MetadataException {
        return PlatformRegistry.getInstance().getPlatformImpl(type, version);
    }

    private Platform getPlatformImpl(PlatformType type, PlatformVersion version) throws MetadataException {
        Platform platform = this.getPlatformImpl(type, version, VersionMatch.MATCH_ALL);
        if (platform == null) {
            throw new MetadataException(PLATFORM_REGISTRY_METADATA_ERROR);
        }
        return platform;
    }

    public static Platform getPlatform(PlatformType type, String version) throws MetadataException {
        return PlatformRegistry.getInstance().getPlatformImpl(type, version);
    }

    private Platform getPlatformImpl(PlatformType type, String version) throws MetadataException {
        return this.getPlatformImpl(type, new PlatformVersion(version));
    }

    public static Platform getPlatform(PlatformType type, PlatformVersion version, VersionMatch matchType) {
        return PlatformRegistry.getInstance().getPlatformImpl(type, version, matchType);
    }

    private Platform getPlatformImpl(PlatformType type, PlatformVersion version, VersionMatch matchType) {
        int matchedNumbers = 0;
        Platform matchedPlatform = null;
        int matchRequired = 0;
        matchRequired = matchType == VersionMatch.MATCH_EXACT || matchType == VersionMatch.MATCH_ALL ? version.toIntArray().length : matchType.matchRequired();
        for (Platform platform : this.platforms_) {
            int m;
            if (platform.getType() != type || Math.abs(m = platform.getVersion().matchNumbers(version)) < matchRequired) continue;
            boolean store = false;
            boolean exactMatch = false;
            switch (1.$sm$oracle$jdeveloper$deploy$meta$PlatformRegistry$VersionMatch[matchType.ordinal()]) {
                case 1: {
                    if (Math.abs(m) < matchedNumbers || matchedPlatform != null && platform.getVersion().compareTo((Object)matchedPlatform.getVersion()) <= 0) break;
                    store = true;
                    break;
                }
                case 2: {
                    if (m != matchRequired) break;
                    store = true;
                    exactMatch = true;
                    break;
                }
                default: {
                    if (Math.abs(m) < matchedNumbers) break;
                    if (matchedPlatform == null) {
                        store = true;
                        break;
                    }
                    if (platform.getVersion().compareTo((Object)matchedPlatform.getVersion()) == 0) {
                        store = true;
                        exactMatch = true;
                        break;
                    }
                    if (platform.getVersion().compareTo((Object)matchedPlatform.getVersion()) <= 0) break;
                    store = true;
                    break;
                }
            }
            if (store) {
                matchedPlatform = platform;
                matchedNumbers = m;
            }
            if (exactMatch) break;
        }
        return matchedPlatform;
    }

    public static Platform[] getPlatforms() {
        return PlatformRegistry.getInstance().getPlatformsImpl(PlatformType.ANY, true);
    }

    public static Platform[] getPlatforms(PlatformType filterOnType) {
        return PlatformRegistry.getInstance().getPlatformsImpl(filterOnType, false);
    }

    public static Platform[] getPlatforms(PlatformType filterOnType, boolean includeSubTypes) {
        return PlatformRegistry.getInstance().getPlatformsImpl(filterOnType, includeSubTypes);
    }

    private Platform[] getPlatformsImpl(PlatformType filterOnType, boolean includeSubTypes) {
        ArrayList<Platform> platforms = new ArrayList<Platform>();
        for (Platform p : this.platforms_) {
            PlatformType type = p.getType();
            if (type == filterOnType) {
                platforms.add(p);
                continue;
            }
            if (!includeSubTypes || !type.isExtensionOf(filterOnType)) continue;
            platforms.add(p);
        }
        return platforms.toArray(new Platform[platforms.size()]);
    }

    static synchronized void reset() {
        platformRegistry_ = null;
    }

    private void $init$() {
        this.platforms_ = new ArrayList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class VersionMatch
    extends Enum<VersionMatch> {
        private static final /* synthetic */ VersionMatch[] $v;
        public static final /* enum */ VersionMatch MATCH_ALL;
        public static final /* enum */ VersionMatch MATCH_EXACT;
        public static final /* enum */ VersionMatch MATCH_NONE;
        public static final /* enum */ VersionMatch MATCH_MAJOR;
        public static final /* enum */ VersionMatch MATCH_MINOR;
        public static final /* enum */ VersionMatch MATCH_UPDATE;
        private int matchRequired;

        public static VersionMatch valueOf(String string) {
            return Enum.valueOf(VersionMatch.class, string);
        }

        public static final VersionMatch[] values() {
            return (VersionMatch[])$v.clone();
        }

        static {
            VersionMatch[] versionMatchArray = new VersionMatch[6];
            versionMatchArray[5] = MATCH_UPDATE = new VersionMatch("MATCH_UPDATE", 5, 3);
            versionMatchArray[4] = MATCH_MINOR = new VersionMatch("MATCH_MINOR", 4, 2);
            versionMatchArray[3] = MATCH_MAJOR = new VersionMatch("MATCH_MAJOR", 3, 1);
            versionMatchArray[2] = MATCH_NONE = new VersionMatch("MATCH_NONE", 2, 0);
            versionMatchArray[1] = MATCH_EXACT = new VersionMatch("MATCH_EXACT", 1, -1);
            versionMatchArray[0] = MATCH_ALL = new VersionMatch("MATCH_ALL", 0, -2);
            $v = versionMatchArray;
        }

        private VersionMatch(String matchRequired, int n2, int n3) {
            this.matchRequired = (int)matchRequired;
        }

        public int matchRequired() {
            return this.matchRequired;
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$jdeveloper$deploy$meta$PlatformRegistry$VersionMatch;

        static {
            int[] nArray = new int[VersionMatch.values().length];
            $sm$oracle$jdeveloper$deploy$meta$PlatformRegistry$VersionMatch = nArray;
            try {
                nArray[VersionMatch.MATCH_ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$jdeveloper$deploy$meta$PlatformRegistry$VersionMatch[VersionMatch.MATCH_EXACT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

