/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta;

import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.pattern.ChainOfR;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradableStore<L, N, R> {
    final ChainOfR<L, UpgradableNode<N>, WrappedRequest<N, R>> impl_;

    public UpgradableStore(Handler<N, R> handler) {
        this.impl_ = new ChainOfR(new UpgradedNodeHandler<N, R>(handler));
    }

    public boolean handle(L start, R request) throws Exception {
        return this.impl_.handle(start, new WrappedRequest(request));
    }

    public N getHandlingObject(L start, R request) throws Exception {
        WrappedRequest wrappedRequest = new WrappedRequest(request);
        if (this.impl_.handle(start, wrappedRequest)) {
            return wrappedRequest.nodeHandled_;
        }
        return (N)((Object)null);
    }

    public void addNode(L label, L parent, N node) throws ChainOfR.DuplicateIndexException, MetadataException {
        this.impl_.add(label, parent, new UpgradableNode<N>(node));
    }

    public void addNode(L label, N node) throws ChainOfR.DuplicateIndexException, MetadataException {
        this.addNode(label, null, node);
    }

    public void upgradeNode(L label, N node) throws ChainOfR.IndexNotFoundException {
        UpgradableNode<N> nodeToUpgrade = this.impl_.get(label);
        nodeToUpgrade.add(node);
    }

    public void replaceNode(L label, N node) throws MetadataException {
        this.impl_.replace(label, new UpgradableNode<N>(node));
    }

    public void replaceTargetedNode(L label, N oldNode, N newNode) throws ChainOfR.IndexNotFoundException {
        UpgradableNode<N> upgNode = this.impl_.get(label);
        upgNode.replace(oldNode, newNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UpgradedNodeHandler<N, R>
    implements Handler<UpgradableNode<N>, WrappedRequest<N, R>> {
        final ChainOfR.RequestHandler<N, R> delegate_;

        UpgradedNodeHandler(ChainOfR.RequestHandler<N, R> realHandler) {
            this.delegate_ = realHandler;
        }

        @Override
        public boolean handle(UpgradableNode<N> upgradedNode, WrappedRequest<N, R> request) throws Exception {
            N[] nodes = upgradedNode.getNodes();
            Object unwrappedRequest = request.request_;
            int i = nodes.length - 1;
            while (i >= 0) {
                if (this.delegate_.handle(nodes[i], unwrappedRequest)) {
                    request.nodeHandled_ = nodes[i];
                    return true;
                }
                --i;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WrappedRequest<N, R> {
        N nodeHandled_;
        R request_;

        private void $init$() {
            this.nodeHandled_ = null;
            this.request_ = null;
        }

        WrappedRequest(R r) {
            this.$init$();
            this.request_ = r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UpgradableNode<N> {
        N[] nodes_;

        UpgradableNode(N node) {
            this.add(node);
        }

        void add(N node) {
            int len = this.nodes_ == null ? 1 : this.nodes_.length + 1;
            N[] temp = this.nodes_;
            this.nodes_ = new Object[len];
            if (len > 1) {
                System.arraycopy(temp, 0, this.nodes_, 0, temp.length);
            }
            this.nodes_[this.nodes_.length - 1] = node;
        }

        N[] getNodes() {
            return this.nodes_;
        }

        public void replace(N oldNode, N newNode) {
            Assert.check((newNode != null ? 1 : 0) != 0, (String)"Cannot replace with a null node");
            if (newNode == null) {
                throw new IllegalArgumentException("Attempt to replace a node with null.");
            }
            int i = 0;
            while (i < this.nodes_.length) {
                if (this.nodes_[i].equals(oldNode)) {
                    this.nodes_[i] = newNode;
                    return;
                }
                ++i;
            }
            throw new IllegalArgumentException("Could not replace node. Missing: " + oldNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public interface Handler<N, R>
    extends ChainOfR.RequestHandler<N, R> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<A, B>
    extends oracle.javatools.util.Pair<A, B> {
        public Pair(A a, B b) {
            super(a, b);
        }
    }
}

