/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta.pattern;

import java.util.HashMap;
import java.util.Map;
import oracle.ide.util.Assert;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.res.MetaArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainOfR<T, V, S>
implements Copyable {
    private Map<T, ChainNode<T, V, S>> nodes_;
    private RequestHandler<V, S> handler_;

    private void $init$() {
        this.nodes_ = new HashMap<T, ChainNode<T, V, S>>();
        this.handler_ = null;
    }

    public ChainOfR(RequestHandler<V, S> handler) {
        this.$init$();
        this.handler_ = handler;
    }

    public boolean handle(T startNodeIndex, S request) throws Exception {
        ChainNode<T, V, S> node = this.getHandlingNode(startNodeIndex, request);
        return node != null;
    }

    public V getHandlingObject(T startNodeIndex, S request) throws Exception {
        ChainNode<T, V, S> node = this.getHandlingNode(startNodeIndex, request);
        if (node != null) {
            return node.userObject_;
        }
        return null;
    }

    private ChainNode<T, V, S> getHandlingNode(T startIndex, S request) throws Exception {
        ChainNode<T, V, S> node;
        T nodeIndex = startIndex;
        do {
            if ((node = this.nodes_.get(nodeIndex)) == null) {
                throw new IndexNotFoundException(MetaArb.getString(3));
            }
            if (!this.handler_.handle(node.userObject_, request)) continue;
            return node;
        } while ((nodeIndex = node.parentNodeIndex_) != null);
        return null;
    }

    public void add(T chainIndex, T chainParentIndex, V userObject) throws DuplicateIndexException, MetadataException {
        if (userObject == null || chainIndex == null) {
            throw new MetadataException("Index or indexed object cannot be null");
        }
        this.addNode(chainIndex, chainParentIndex, userObject);
    }

    public void replace(T chainIndex, V userObject) throws MetadataException {
        Assert.check((userObject != null ? 1 : 0) != 0, (String)"User Object cannot be null");
        try {
            this.replaceNode(chainIndex, userObject);
        }
        catch (Exception e) {
            throw new MetadataException(e.getMessage());
        }
    }

    private ChainNode<T, V, S> addNode(T chainIndex, T parentIndex, V userObject) throws DuplicateIndexException, IndexNotFoundException {
        ChainNode newNode = new ChainNode(chainIndex, parentIndex, userObject);
        if (this.nodes_.containsKey(chainIndex)) {
            throw new DuplicateIndexException(MetaArb.getString(4));
        }
        if (parentIndex != null && !this.nodes_.containsKey(parentIndex)) {
            throw new IndexNotFoundException(MetaArb.getString(1));
        }
        return this.nodes_.put(chainIndex, newNode);
    }

    private ChainNode<T, V, S> replaceNode(T chainIndex, V userObject) throws IndexNotFoundException {
        ChainNode<T, V, S> node = this.nodes_.get(chainIndex);
        if (node == null) {
            throw new IndexNotFoundException(MetaArb.getString(0));
        }
        ChainNode newNode = new ChainNode(chainIndex, node.parentNodeIndex_, userObject);
        return this.nodes_.put(chainIndex, newNode);
    }

    private ChainNode<T, V, S> getChainNode(T chainIndex) throws IndexNotFoundException {
        ChainNode<T, V, S> node = this.nodes_.get(chainIndex);
        if (node == null) {
            throw new IndexNotFoundException(MetaArb.getString(2));
        }
        return node;
    }

    public T getParentLabel(T chainIndex) throws IndexNotFoundException {
        return this.getChainNode(chainIndex).parentNodeIndex_;
    }

    public V getParent(T chainIndex) throws IndexNotFoundException {
        return this.getChainNode(chainIndex).userObject_;
    }

    public V get(T chainIndex) throws IndexNotFoundException {
        return this.getChainNode(chainIndex).userObject_;
    }

    public void purge() {
        this.nodes_ = new HashMap<T, ChainNode<T, V, S>>();
    }

    public Object copyTo(Object target) {
        ChainOfR<T, V, S> copy = target != null ? (ChainOfR<T, V, S>)target : new ChainOfR<T, V, S>(null);
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(ChainOfR<T, V, S> copy) {
        copy.nodes_ = new HashMap<T, ChainNode<T, V, S>>();
        copy.handler_ = this.handler_;
        for (T key : this.nodes_.keySet()) {
            if (copy.nodes_.containsKey(key)) continue;
            this.copyChainNode(this.nodes_, copy.nodes_, key);
        }
    }

    private void copyChainNode(Map<T, ChainNode<T, V, S>> from, Map<T, ChainNode<T, V, S>> to, T key) {
        ChainNode<T, V, S> source = from.get(key);
        Object parentKey = source.parentNodeIndex_;
        if (source.parentNodeIndex_ != null && !to.containsKey(parentKey)) {
            this.copyChainNode(from, to, parentKey);
        }
        ChainNode target = new ChainNode(source.nodeIndex_, parentKey, source.userObject_);
        to.put(key, target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RequestHandler<V, S> {
        public boolean handle(V var1, S var2) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChainNode<T, V, S> {
        final T nodeIndex_;
        final T parentNodeIndex_;
        final V userObject_;

        public ChainNode(T nodeIndex, T parentNodeIndex, V userObject) {
            this.nodeIndex_ = nodeIndex;
            this.parentNodeIndex_ = parentNodeIndex;
            this.userObject_ = userObject;
        }
    }

    public static class IndexNotFoundException
    extends MetadataException {
        IndexNotFoundException(String cause) {
            super(cause);
        }
    }

    public static class DuplicateIndexException
    extends MetadataException {
        DuplicateIndexException(String cause) {
            super(cause);
        }
    }
}

