/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.res;

import java.text.DateFormat;
import java.util.Calendar;
import oracle.jdeveloper.deploy.res.DeployArb;

public class DeployMessages {
    public static String deploymentStarted() {
        return DeployArb.format(57, DeployMessages.currentDateTime());
    }

    public static String deploymentFinished() {
        return DeployArb.format(68, DeployMessages.currentDateTime());
    }

    public static String deploymentIncomplete() {
        return DeployArb.format(86, DeployMessages.currentDateTime());
    }

    public static String deploymentElapsed(long milliseconds) {
        long seconds = (milliseconds + 500L) / 1000L;
        if (seconds == 0L) {
            String fastText = DeployArb.getString(71);
            return DeployArb.format(78, fastText);
        }
        long minutes = seconds / (long)60;
        seconds -= minutes * (long)60;
        long hours = minutes / (long)60;
        String secondsText = DeployArb.format(seconds == 1L ? 9 : 62, Long.toString(seconds));
        String minutesText = "";
        if ((minutes -= hours * (long)60) > 0L) {
            minutesText = DeployArb.format(minutes == 1L ? 52 : 13, Long.toString(minutes));
        }
        String hoursText = "";
        if (hours > 0L) {
            hoursText = DeployArb.format(hours == 1L ? 93 : 15, Long.toString(hours));
        }
        String elapsedText = secondsText;
        if (hoursText.length() > 0) {
            elapsedText = DeployArb.format(25, hoursText, minutesText, secondsText);
        } else if (minutesText.length() > 0) {
            elapsedText = DeployArb.format(26, minutesText, secondsText);
        }
        return DeployArb.format(78, elapsedText);
    }

    public static String currentDateTime() {
        return DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
    }
}

