/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import oracle.ide.Ide;
import oracle.ide.util.ArraySortedSet;
import oracle.ide.util.Assert;
import oracle.ide.util.ModelUtil;
import oracle.javatools.editor.insight.CamelCaseInsightInputFilter;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.editor.insight.ReadOnlyListModel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.dialogs.ClassPackageNamePrefixFilter;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;
import oracle.jdevimpl.java.JavaArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BrowseHandler {
    private boolean _copyQualifiedClassNameToField;
    private String _previousText;
    private final boolean USE_POPUP_WINDOW;
    private JList resultsList;
    private JTextField browseField;
    private ActionListener clientListener;
    private ListGestureHandler listBrowseListener;
    private PopupGestureHandler popupGestureHandler;
    private ClassNameFilter classFilter;
    private PackageNameFilter packageFilter;
    private JWindow popupWindow;
    private ListInsightView popupList;
    private BrowseTask browseTask;
    private PopulateTask populateTask;
    private Map<String, String[]> brPackageMap;
    private Set<String> brPackageSet;
    private JavaManager brJavaManager;
    private int classOrPackage;
    private FoundItem lastDefaultItem;
    private boolean pendingLookup;
    private boolean inNavigation;
    private int lastLength;
    private boolean gotLonger;
    private AsyncScheduler brScheduler;
    private boolean CHECK_FOR_INTERFACE;
    private static final int PACKAGE_ONLY = 1;
    private static final int CLASS_ONLY = 2;
    private static final int CLASS_AND_PACKAGE = 3;
    static final String EMPTY_LIST_ITEM = DialogsArb.getString(9);
    static final String PROGRESS_LIST_ITEM = DialogsArb.getString(10);
    private static final FoundItem[] PROGRESS_FEEDBACK = new FoundItem[]{new FoundItem(PROGRESS_LIST_ITEM, -1, null)};
    private static final DefaultListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final DefaultListModel PROGRESS_LIST_MODEL = new DefaultListModel();
    private static final int PACKAGE_ITEM = 1;
    private static final int UNQ_CLASS_ITEM = 2;
    private static final int UNQ_INTERFACE_ITEM = 4;
    private static final int FQ_CLASS_ITEM = 3;
    private static final int FQ_INTERFACE_ITEM = 5;
    private static final int MIN_PREFIX_LEN = 1;

    private void $init$() {
        this._previousText = "";
        this.pendingLookup = false;
        this.inNavigation = false;
        this.lastLength = 0;
        this.gotLonger = false;
        this.brScheduler = new AsyncScheduler("BrowseHandlerBrowser", 10000);
        this.CHECK_FOR_INTERFACE = false;
    }

    public static BrowseHandler createClassBrowserPopup(JavaManager javaManager, JTextField textField, ActionListener actionListener) {
        return new BrowseHandler(true, javaManager, textField, actionListener, null, 2, null, null);
    }

    public static BrowseHandler createPackageBrowserPopup(JavaManager javaManager, JTextField textField, ActionListener actionListener) {
        return new BrowseHandler(true, javaManager, textField, actionListener, null, 1, null, null);
    }

    public static BrowseHandler createClassPackageBrowserPopup(JavaManager javaManager, JTextField textField, ActionListener actionListener) {
        return new BrowseHandler(true, javaManager, textField, actionListener, null, 3, null, null);
    }

    public static BrowseHandler createClassBrowserList(JavaManager javaManager, JTextField textField, JList list) {
        return new BrowseHandler(false, javaManager, textField, null, list, 2, null, null);
    }

    public static BrowseHandler createClassBrowserList(JavaManager javaManager, JTextField textField, JList list, ClassNameFilter classFilter) {
        return new BrowseHandler(false, javaManager, textField, null, list, 2, classFilter, null);
    }

    public static BrowseHandler createPackageBrowserList(JavaManager javaManager, JTextField textField, JList list) {
        return new BrowseHandler(false, javaManager, textField, null, list, 1, null, null);
    }

    public static BrowseHandler createPackageBrowserList(JavaManager javaManager, JTextField textField, JList list, PackageNameFilter packageFilter) {
        return new BrowseHandler(false, javaManager, textField, null, list, 1, null, packageFilter);
    }

    public static BrowseHandler createClassPackageBrowserList(JavaManager javaManager, JTextField textField, JList list) {
        return new BrowseHandler(false, javaManager, textField, null, list, 3, null, null);
    }

    public static BrowseHandler createClassPackageBrowserList(JavaManager javaManager, JTextField textField, JList list, ClassNameFilter classFilter, PackageNameFilter packageFilter) {
        return new BrowseHandler(false, javaManager, textField, null, list, 3, classFilter, packageFilter);
    }

    private BrowseHandler(boolean showResultsInPopup, JavaManager javaManager, JTextField textField, ActionListener actionListener, JList list, int matchClassAndOrPackage, ClassNameFilter classFilter, PackageNameFilter packageFilter) {
        this.$init$();
        this.USE_POPUP_WINDOW = showResultsInPopup;
        if (javaManager == null) {
            throw new IllegalArgumentException("The JavaManager cannot be null.");
        }
        if (this.USE_POPUP_WINDOW) {
            if (textField == null) {
                throw new IllegalArgumentException("The text field cannot be null.");
            }
        } else if (list == null) {
            throw new IllegalArgumentException("The list cannot be null.");
        }
        this.brJavaManager = javaManager;
        this.browseField = textField;
        this.clientListener = actionListener;
        this.resultsList = list;
        this.classOrPackage = matchClassAndOrPackage;
        this.initializeFilters(classFilter, packageFilter);
        if (this.resultsList != null) {
            this.resultsList.setModel(EMPTY_LIST_MODEL);
            if (EMPTY_LIST_MODEL.size() == 0) {
                EMPTY_LIST_MODEL.addElement(EMPTY_LIST_ITEM);
            }
            if (PROGRESS_LIST_MODEL.size() == 0) {
                PROGRESS_LIST_MODEL.addElement(PROGRESS_LIST_ITEM);
            }
        }
        if (this.USE_POPUP_WINDOW) {
            this._previousText = textField.getText();
            Caret oldCaret = textField.getCaret();
            DefaultCaret newCaret = new DefaultCaret();
            newCaret.setBlinkRate(oldCaret.getBlinkRate());
            textField.setCaret(newCaret);
            this.browseField.addCaretListener(this.getPopupGestureHandler());
            this.browseField.addKeyListener(this.getPopupGestureHandler());
            this.browseField.addFocusListener(this.getPopupGestureHandler());
            this.browseField.addAncestorListener(this.getPopupGestureHandler());
        } else {
            this.browseField.getDocument().addDocumentListener(this.getListGestureHandler());
        }
    }

    public void dispose() {
        this.cancelLookup();
        this.cancelPopulate();
        if (this.popupList != null) {
            this.popupList.removeListSelectionListener((ListSelectionListener)this.getPopupGestureHandler());
            this.popupList.removeMouseListener((MouseListener)this.getPopupGestureHandler());
            this.popupList = null;
        }
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
        if (this.resultsList != null) {
            this.browseField.getDocument().removeDocumentListener(this.getListGestureHandler());
            this.resultsList = null;
        }
        if (this.browseField != null) {
            this.browseField.removeCaretListener(this.getPopupGestureHandler());
            this.browseField.removeKeyListener(this.getPopupGestureHandler());
            this.browseField.removeFocusListener(this.getPopupGestureHandler());
            this.browseField.removeAncestorListener(this.getPopupGestureHandler());
            this.browseField = null;
        }
        if (this.CHECK_FOR_INTERFACE) {
            CacheSupport cacheSupport = this.brJavaManager.getCacheSupport();
            cacheSupport.flushCache();
        }
    }

    public String getSelectedItem() {
        if (this.lastDefaultItem != null) {
            return FoundItem.ra$name(this.lastDefaultItem);
        }
        if (this.browseField != null) {
            return this.browseField.getText();
        }
        return null;
    }

    void doLookup(String lookupText) {
        this.scheduleLookup(lookupText);
    }

    private void initializeFilters(ClassNameFilter clsFilter, PackageNameFilter pkgFilter) {
        if (clsFilter == null || pkgFilter == null) {
            ClassPackageNamePrefixFilter filter = new ClassPackageNamePrefixFilter();
            this.classFilter = clsFilter != null ? clsFilter : filter;
            this.packageFilter = pkgFilter != null ? pkgFilter : filter;
        } else {
            this.classFilter = clsFilter;
            this.packageFilter = pkgFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLookup(String prefixText) {
        if (this.populateTask == null || this.populateTask.brText != Character.toUpperCase(prefixText.charAt(0))) {
            this.cancelPopulate();
            FoundData searchingData = new FoundData(PROGRESS_FEEDBACK, "", null);
            this.displayResults(searchingData);
            BrowseHandler browseHandler = this;
            synchronized (browseHandler) {
                this.populateTask = new PopulateTask(prefixText, null);
                this.brScheduler.scheduleTask((AsyncTask)this.populateTask);
            }
        } else if (!this.populateTask.isFinished()) {
            return;
        }
        BrowseTask task = new BrowseTask(prefixText, null);
        BrowseHandler browseHandler = this;
        synchronized (browseHandler) {
            if (this.browseTask != null) {
                this.brScheduler.cancelTask((AsyncTask)this.browseTask);
            }
            this.browseTask = task;
        }
        this.brScheduler.scheduleTask((AsyncTask)task);
        this.pendingLookup = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelLookup() {
        BrowseTask pendingTask;
        BrowseHandler browseHandler = this;
        synchronized (browseHandler) {
            pendingTask = this.browseTask;
            this.browseTask = null;
        }
        if (pendingTask != null) {
            this.brScheduler.cancelTask((AsyncTask)pendingTask);
        }
        this.pendingLookup = false;
    }

    private void cancelPopulate() {
        if (this.populateTask != null) {
            this.brScheduler.cancelTask((AsyncTask)this.populateTask);
        }
    }

    private void updatePopup() {
        if (this.browseField == null || !this.browseField.isVisible() || !this.browseField.hasFocus()) {
            return;
        }
        int caretPosition = this.browseField.getCaretPosition();
        if (caretPosition >= 1) {
            String text = this.browseField.getText().substring(0, caretPosition);
            this.scheduleLookup(text);
        } else {
            this.hidePopup();
        }
    }

    private void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
    }

    private void displayResults(FoundData data) {
        if (this.USE_POPUP_WINDOW) {
            ListDataItem[] foundItems;
            if (this.browseField == null || !this.browseField.isVisible()) {
                return;
            }
            if (!this.browseField.hasFocus() && !this.popupList.hasFocus()) {
                return;
            }
            if (this.popupWindow == null) {
                this.popupList = new ListInsightView((ListCellRenderer)((Object)new FoundRenderer(null)));
                this.popupList.addListSelectionListener((ListSelectionListener)this.getPopupGestureHandler());
                this.popupList.addMouseListener((MouseListener)this.getPopupGestureHandler());
                this.popupList.setData((InsightData)data);
                JScrollPane scroller = new JScrollPane((Component)this.popupList);
                scroller.setHorizontalScrollBarPolicy(31);
                scroller.setFocusable(false);
                this.popupList.setFocusable(false);
                this.popupList.getComponent().setFocusable(false);
                Window parentWindow = SwingUtilities.getWindowAncestor(this.browseField);
                this.popupWindow = new JWindow(parentWindow);
                this.popupWindow.getContentPane().add(scroller);
                this.popupWindow.setFocusableWindowState(false);
            } else {
                this.popupList.setData((InsightData)data);
            }
            if (!this.popupWindow.isVisible()) {
                Point location = this.browseField.getLocationOnScreen();
                location.y += this.browseField.getHeight() + 2;
                this.popupWindow.setLocation(location);
            }
            if ((foundItems = data.getData()).length == 0) {
                this.lastDefaultItem = null;
                this.popupWindow.setVisible(false);
            } else {
                String fieldText;
                String replaceText;
                this.inNavigation = true;
                this.popupList.selectDefault();
                this.inNavigation = false;
                this.lastDefaultItem = (FoundItem)((Object)data.getDefault());
                if (this.gotLonger && !PROGRESS_LIST_ITEM.equals(data.toString()) && (replaceText = CamelCaseInsightInputFilter.INSTANCE.findCommonPrefix(foundItems, fieldText = this.browseField.getText())) != null) {
                    this.inNavigation = true;
                    int selectStart = Math.min(fieldText.length(), replaceText.length());
                    int selectEnd = replaceText.length();
                    this.browseField.setText(replaceText);
                    this.browseField.setCaretPosition(selectEnd);
                    this.browseField.moveCaretPosition(selectStart);
                    this.inNavigation = false;
                }
                if (this.popupWindow.isVisible() || this.browseField == null || !this.browseField.getText().equals(this._previousText)) {
                    this.popupWindow.pack();
                    this.popupWindow.setVisible(true);
                }
            }
        } else {
            ListModel model = data.getListModel();
            if (model.getSize() > 0) {
                this.resultsList.setModel(model);
                this.resultsList.setSelectedIndex(0);
            } else {
                this.resultsList.setModel(EMPTY_LIST_MODEL);
            }
        }
        this.pendingLookup = false;
    }

    private void populateFinished(Map<String, String[]> packageMap, Set<String> packageSet) {
        this.brPackageMap = packageMap;
        this.brPackageSet = packageSet;
        1 invokeTask = new 1();
        SwingUtilities.invokeLater(invokeTask);
    }

    public boolean isCopyQualifiedClassNameToField() {
        return this._copyQualifiedClassNameToField;
    }

    public void setCopyQualifiedClassNameToField(boolean copyQualifiedClassNameToField) {
        this._copyQualifiedClassNameToField = copyQualifiedClassNameToField;
    }

    private PopupGestureHandler getPopupGestureHandler() {
        if (this.popupGestureHandler == null) {
            this.popupGestureHandler = new PopupGestureHandler(null);
        }
        return this.popupGestureHandler;
    }

    private ListGestureHandler getListGestureHandler() {
        if (this.listBrowseListener == null) {
            this.listBrowseListener = new ListGestureHandler(null);
        }
        return this.listBrowseListener;
    }

    static JavaManager ra$brJavaManager(BrowseHandler browseHandler) {
        return browseHandler.brJavaManager;
    }

    static boolean ra$CHECK_FOR_INTERFACE(BrowseHandler browseHandler) {
        return browseHandler.CHECK_FOR_INTERFACE;
    }

    static ClassNameFilter ra$classFilter(BrowseHandler browseHandler) {
        return browseHandler.classFilter;
    }

    static Map ra$brPackageMap(BrowseHandler browseHandler) {
        return browseHandler.brPackageMap;
    }

    static int ra$classOrPackage(BrowseHandler browseHandler) {
        return browseHandler.classOrPackage;
    }

    static PackageNameFilter ra$packageFilter(BrowseHandler browseHandler) {
        return browseHandler.packageFilter;
    }

    static Set ra$brPackageSet(BrowseHandler browseHandler) {
        return browseHandler.brPackageSet;
    }

    static JList ra$resultsList(BrowseHandler browseHandler) {
        return browseHandler.resultsList;
    }

    static DefaultListModel ra$EMPTY_LIST_MODEL() {
        return EMPTY_LIST_MODEL;
    }

    static void mav$populateFinished(BrowseHandler browseHandler, Map map, Set set) {
        browseHandler.populateFinished(map, set);
    }

    static JTextField ra$browseField(BrowseHandler browseHandler) {
        return browseHandler.browseField;
    }

    static DefaultListModel ra$PROGRESS_LIST_MODEL() {
        return PROGRESS_LIST_MODEL;
    }

    static void mav$scheduleLookup(BrowseHandler browseHandler, String string) {
        browseHandler.scheduleLookup(string);
    }

    static void mav$cancelLookup(BrowseHandler browseHandler) {
        browseHandler.cancelLookup();
    }

    static void mav$hidePopup(BrowseHandler browseHandler) {
        browseHandler.hidePopup();
    }

    static boolean ra$inNavigation(BrowseHandler browseHandler) {
        return browseHandler.inNavigation;
    }

    static ListInsightView ra$popupList(BrowseHandler browseHandler) {
        return browseHandler.popupList;
    }

    static void wa$lastDefaultItem(BrowseHandler browseHandler, FoundItem foundItem) {
        browseHandler.lastDefaultItem = foundItem;
    }

    static FoundItem ra$lastDefaultItem(BrowseHandler browseHandler) {
        return browseHandler.lastDefaultItem;
    }

    static void wa$inNavigation(BrowseHandler browseHandler, boolean bl) {
        browseHandler.inNavigation = bl;
    }

    static ActionListener ra$clientListener(BrowseHandler browseHandler) {
        return browseHandler.clientListener;
    }

    static boolean ra$_copyQualifiedClassNameToField(BrowseHandler browseHandler) {
        return browseHandler._copyQualifiedClassNameToField;
    }

    static void wa$_previousText(BrowseHandler browseHandler, String string) {
        browseHandler._previousText = string;
    }

    static boolean ra$pendingLookup(BrowseHandler browseHandler) {
        return browseHandler.pendingLookup;
    }

    static JWindow ra$popupWindow(BrowseHandler browseHandler) {
        return browseHandler.popupWindow;
    }

    static void mav$updatePopup(BrowseHandler browseHandler) {
        browseHandler.updatePopup();
    }

    static int ra$lastLength(BrowseHandler browseHandler) {
        return browseHandler.lastLength;
    }

    static void wa$gotLonger(BrowseHandler browseHandler, boolean bl) {
        browseHandler.gotLonger = bl;
    }

    static void wa$lastLength(BrowseHandler browseHandler, int n) {
        browseHandler.lastLength = n;
    }

    static void mav$displayResults(BrowseHandler browseHandler, FoundData foundData) {
        browseHandler.displayResults(foundData);
    }

    final class 1
    implements Runnable {
        public void run() {
            try {
                Thread.sleep(25);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            BrowseHandler.mav$updatePopup(BrowseHandler.this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BrowseTask
    extends AsyncTask {
        private String brText;
        private boolean brCancelled;

        private BrowseTask(String prefixText) {
            this.$init$();
            this.brText = prefixText;
        }

        private void $init$() {
            this.brCancelled = false;
        }

        protected void requestCancelImpl() {
            this.brCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.brCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            if (this.brText == null || this.brText.length() == 0) {
                BrowseHandler.ra$resultsList(BrowseHandler.this).setModel(BrowseHandler.ra$EMPTY_LIST_MODEL());
                return null;
            }
            BrowseTask.sleep((int)10);
            this.bailIfCancelled();
            Map packageMap = BrowseHandler.ra$brPackageMap(BrowseHandler.this);
            if (packageMap == null) {
                BrowseHandler.ra$resultsList(BrowseHandler.this).setModel(BrowseHandler.ra$EMPTY_LIST_MODEL());
                return null;
            }
            ArrayList<FoundItem> matchList = new ArrayList<FoundItem>();
            this.taskMatchClassOrPackage(this.brText, matchList);
            int count = matchList.size();
            FoundItem[] items = matchList.toArray(new FoundItem[count]);
            FoundData data = new FoundData(items, this.brText, null);
            1 invokeTask = new 1(this, data);
            SwingUtilities.invokeLater(invokeTask);
            return data;
        }

        private void taskMatchClassOrPackage(String prefixText, List<FoundItem> resultList) throws AsyncTask.CancelledException {
            boolean hasDot;
            Map packageMap = BrowseHandler.ra$brPackageMap(BrowseHandler.this);
            if ((BrowseHandler.ra$classOrPackage(BrowseHandler.this) & 1) > 0) {
                BrowseHandler.ra$packageFilter(BrowseHandler.this).setMatchName(prefixText);
                Set packageSet = BrowseHandler.ra$brPackageSet(BrowseHandler.this);
                for (String packagePrefix : packageSet) {
                    this.bailIfCancelled();
                    if (!BrowseHandler.ra$packageFilter(BrowseHandler.this).acceptPackageName(packagePrefix)) continue;
                    resultList.add(new FoundItem(packagePrefix, 1, null));
                }
            }
            boolean bl = hasDot = prefixText.indexOf(46) != -1;
            if ((BrowseHandler.ra$classOrPackage(BrowseHandler.this) & 2) > 0) {
                BrowseHandler.ra$classFilter(BrowseHandler.this).setMatchName(prefixText);
                if (hasDot) {
                    int dotPos = prefixText.lastIndexOf(46);
                    String packagePrefix = prefixText.substring(0, dotPos);
                    String[] classes = (String[])packageMap.get(packagePrefix);
                    this.addMatchingClasses(classes, packagePrefix, resultList, hasDot);
                } else {
                    for (String packagePrefix : packageMap.keySet()) {
                        this.bailIfCancelled();
                        String[] classes = (String[])packageMap.get(packagePrefix);
                        this.addMatchingClasses(classes, packagePrefix, resultList, hasDot);
                    }
                }
                if (packageMap.containsKey(prefixText)) {
                    if ((BrowseHandler.ra$classOrPackage(BrowseHandler.this) & 2) > 0) {
                        BrowseHandler.ra$classFilter(BrowseHandler.this).setMatchName(prefixText + ".");
                    }
                    String[] classes = (String[])packageMap.get(prefixText);
                    this.addMatchingClasses(classes, prefixText, resultList, true);
                }
            }
        }

        private void addMatchingClasses(String[] classes, String packagePrefix, List resultList, boolean hasDot) throws AsyncTask.CancelledException {
            int numClasses = classes != null ? classes.length : 0;
            int i = 0;
            while (i < numClasses) {
                this.bailIfCancelled();
                String name = classes[i];
                if (BrowseHandler.ra$classFilter(BrowseHandler.this).acceptClassName(name, packagePrefix)) {
                    String fqName;
                    String string = fqName = packagePrefix.length() > 0 ? packagePrefix + "." + name : name;
                    int type = this.isInterface(fqName) ? (hasDot ? 5 : 4) : (hasDot ? 3 : 2);
                    resultList.add(new FoundItem(fqName, type, null));
                }
                ++i;
            }
        }

        private boolean checkForInterface() {
            return BrowseHandler.ra$CHECK_FOR_INTERFACE(BrowseHandler.this);
        }

        private boolean isInterface(String fqClassName) {
            if (!this.checkForInterface()) {
                return false;
            }
            JavaManager jm = BrowseHandler.ra$brJavaManager(BrowseHandler.this);
            JavaClass foundClass = jm.getClass(fqClassName);
            if (foundClass != null) {
                return foundClass.isInterface();
            }
            return false;
        }

        BrowseTask(String string, 1 var3_3) {
            this(string);
        }

        static boolean ra$brCancelled(BrowseTask browseTask) {
            return browseTask.brCancelled;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ FoundData v$data;
            final /* synthetic */ BrowseTask this$0;

            public void run() {
                if (!BrowseTask.ra$brCancelled(this.this$0)) {
                    BrowseHandler.mav$displayResults(this.this$0.BrowseHandler.this, this.v$data);
                }
            }

            public 1(BrowseTask browseTask, FoundData foundData) {
                this.v$data = foundData;
                this.this$0 = browseTask;
            }
        }
    }

    private final class PopulateTask
    extends AsyncTask {
        public final char brText;
        private boolean popCancelled;

        private PopulateTask(String prefixText) {
            this.$init$();
            this.brText = (char)(prefixText == null || prefixText.length() < 1 ? 32 : (int)Character.toUpperCase(prefixText.charAt(0)));
        }

        private void $init$() {
            this.popCancelled = false;
        }

        protected void requestCancelImpl() {
            this.popCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.popCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            JavaManager jm = BrowseHandler.ra$brJavaManager(BrowseHandler.this);
            String feedbackText = JavaArb.getString(269);
            Ide.getStatusBar().setText(feedbackText);
            try {
                JavaClassLocator locator = jm.getJavaClassLocator();
                Collection fqClasses = locator.getAllClasses((ClassNameFilter)new 1());
                HashMap<String, Set> packageMap = new HashMap<String, Set>(500);
                for (String fqClassName : fqClasses) {
                    String className;
                    this.bailIfCancelled();
                    int lastDot = fqClassName.lastIndexOf(46);
                    String packageName = lastDot == -1 ? "" : fqClassName.substring(0, lastDot);
                    String string = className = lastDot == -1 ? fqClassName : fqClassName.substring(lastDot + 1);
                    if (className.length() <= 0) continue;
                    Set classSet = (Set)packageMap.get(packageName);
                    if (classSet == null) {
                        classSet = new ArraySortedSet(100);
                        packageMap.put(packageName, classSet);
                    }
                    classSet.add(className);
                }
                HashMap<String, String[]> finalPackageMap = new HashMap<String, String[]>(packageMap.size());
                for (String packageName : packageMap.keySet()) {
                    int classCount;
                    Set classSet = (Set)packageMap.get(packageName);
                    int n = classCount = classSet == null ? 0 : classSet.size();
                    if (classCount <= 0) continue;
                    String[] classes = classSet.toArray(new String[classCount]);
                    finalPackageMap.put(packageName, classes);
                }
                BrowseHandler.mav$populateFinished(BrowseHandler.this, finalPackageMap, finalPackageMap.keySet());
                HashMap<String, String[]> hashMap = finalPackageMap;
                return hashMap;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                String currentText = Ide.getStatusBar().getText();
                if (currentText.equals(feedbackText)) {
                    Ide.getStatusBar().setText("");
                }
            }
        }

        PopulateTask(String string, 1 var3_3) {
            this(string);
        }

        final class 1
        implements ClassNameFilter {
            public boolean acceptClassName(String className, String packagePrefix) {
                if (PopulateTask.this.brText == '*' || PopulateTask.this.brText == '?') {
                    return true;
                }
                return Character.toUpperCase(className.charAt(0)) == PopulateTask.this.brText || packagePrefix != null && packagePrefix.length() > 0 && Character.toUpperCase(packagePrefix.charAt(0)) == PopulateTask.this.brText;
            }

            public void setMatchName(String matchName) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FoundItem
    extends ListDataItem {
        private int type;
        private String name;
        private String display;
        private static final String[] PRIO_PKGS = new String[]{"java.lang.", "java.util", "java.", "javax."};

        private FoundItem(String name, int type) {
            this.type = type;
            this.name = name;
        }

        public Icon getIcon() {
            switch (this.type) {
                case 1: {
                    return OracleIcons.getIcon((String)"package.png");
                }
                case 2: 
                case 3: {
                    return OracleIcons.getIcon((String)"class.png");
                }
                case 4: 
                case 5: {
                    return OracleIcons.getIcon((String)"interface.png");
                }
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public String getDisplayText() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            if (this.display == null) {
                String classPart;
                String packagePrefix;
                int dotPos = this.name.lastIndexOf(46);
                if (dotPos == -1) {
                    packagePrefix = "";
                    classPart = this.name;
                } else {
                    packagePrefix = this.name.substring(0, dotPos);
                    classPart = this.name.substring(dotPos + 1);
                }
                this.display = packagePrefix.length() > 0 ? classPart + " ( " + packagePrefix + " )" : classPart;
            }
            return this.display;
        }

        public String getName() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            int dotPos = this.name.lastIndexOf(46);
            return dotPos != -1 ? this.name.substring(dotPos + 1) : this.name;
        }

        private String getPackage() {
            int dotPos = this.name.lastIndexOf(46);
            return dotPos != -1 ? this.name.substring(0, dotPos) : this.name;
        }

        public int compareTo(Object object) {
            String name2;
            FoundItem item2 = (FoundItem)((Object)object);
            String name1 = this.getName();
            if (name1.equalsIgnoreCase(name2 = item2.getName())) {
                int type1 = this.type;
                int type2 = item2.type;
                if ((type1 == 1 || type2 == 1) && type1 != type2) {
                    return type1 - type2;
                }
                if (!(type1 != 2 && type1 != 4 || type2 != 2 && type2 != 4)) {
                    int prio2;
                    String pkg1 = this.getPackage();
                    String pkg2 = item2.getPackage();
                    int prio1 = FoundItem.getPackagePriority(pkg1);
                    if (prio1 != (prio2 = FoundItem.getPackagePriority(pkg2))) {
                        return prio1 - prio2;
                    }
                }
            }
            String display1 = this.getDisplayText();
            String display2 = item2.getDisplayText();
            return FoundItem.compareInsensitive((String)display1, (String)display2);
        }

        private static int getPackagePriority(String pkg) {
            int i = 0;
            while (i < PRIO_PKGS.length) {
                String prioPkg = PRIO_PKGS[i];
                if (pkg.startsWith(prioPkg)) {
                    return i;
                }
                ++i;
            }
            return PRIO_PKGS.length;
        }

        FoundItem(String string, int n, 1 var3_3) {
            this(string, n);
        }

        static String ra$name(FoundItem foundItem) {
            return foundItem.name;
        }

        static int ra$type(FoundItem foundItem) {
            return foundItem.type;
        }

        public final class 1 {
        }
    }

    private static final class FoundData
    implements ListInsightData {
        private FoundItem[] items;
        private ReadOnlyListModel model;
        private String prefix;

        private FoundData(FoundItem[] items, String prefix) {
            CamelCaseInsightInputFilter.INSTANCE.sort((ListDataItem[])items, prefix);
            this.items = items;
            this.prefix = prefix;
        }

        public ListModel getListModel() {
            if (this.model == null) {
                this.model = new ReadOnlyListModel((Object[])this.items);
            }
            return this.model;
        }

        public FoundItem[] getData() {
            return this.items;
        }

        public FoundItem[] getMatchingData() {
            return this.items;
        }

        public int getMatchingDataCount() {
            return this.items.length;
        }

        public Object getDefault() {
            return CamelCaseInsightInputFilter.INSTANCE.findClosestDataItem((ListDataItem[])this.items, this.prefix);
        }

        public boolean complete(Object selectedObject) {
            return false;
        }

        public void partialComplete() {
        }

        FoundData(FoundItem[] foundItemArray, String string, 1 var3_3) {
            this(foundItemArray, string);
        }

        public final class 1 {
        }
    }

    private static final class FoundRenderer
    extends ListDataItemCellRenderer {
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            Dimension newSize = new Dimension(Math.max(size.width, 200), size.height);
            return newSize;
        }

        private FoundRenderer() {
        }

        FoundRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class ListGestureHandler
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            this.lookup();
        }

        public void removeUpdate(DocumentEvent e) {
            this.lookup();
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private void lookup() {
            String searchText = BrowseHandler.ra$browseField(BrowseHandler.this).getText().trim();
            if (searchText.length() >= 1) {
                BrowseHandler.ra$resultsList(BrowseHandler.this).setModel(BrowseHandler.ra$PROGRESS_LIST_MODEL());
                BrowseHandler.mav$scheduleLookup(BrowseHandler.this, searchText);
            } else {
                BrowseHandler.ra$resultsList(BrowseHandler.this).setModel(BrowseHandler.ra$EMPTY_LIST_MODEL());
                BrowseHandler.mav$cancelLookup(BrowseHandler.this);
            }
        }

        private ListGestureHandler() {
        }

        ListGestureHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class PopupGestureHandler
    implements CaretListener,
    FocusListener,
    KeyListener,
    ListSelectionListener,
    MouseListener,
    AncestorListener {
        public void caretUpdate(CaretEvent event) {
            if (!BrowseHandler.ra$inNavigation(BrowseHandler.this)) {
                SwingUtilities.invokeLater(new 1());
            }
        }

        private void caretChanged() {
            if (BrowseHandler.ra$browseField(BrowseHandler.this) != null) {
                int newLength = BrowseHandler.ra$browseField(BrowseHandler.this).getText().length();
                BrowseHandler.wa$gotLonger(BrowseHandler.this, newLength > BrowseHandler.ra$lastLength(BrowseHandler.this));
                BrowseHandler.wa$lastLength(BrowseHandler.this, newLength);
                BrowseHandler.mav$updatePopup(BrowseHandler.this);
            }
        }

        public void focusGained(FocusEvent event) {
            if (BrowseHandler.ra$popupWindow(BrowseHandler.this) != null && !BrowseHandler.ra$popupWindow(BrowseHandler.this).isVisible()) {
                BrowseHandler.mav$updatePopup(BrowseHandler.this);
            }
        }

        public void focusLost(FocusEvent event) {
            if (!event.isTemporary()) {
                FoundItem item;
                if (BrowseHandler.ra$_copyQualifiedClassNameToField(BrowseHandler.this) && BrowseHandler.ra$popupList(BrowseHandler.this) != null && ModelUtil.hasLength((String)BrowseHandler.ra$browseField(BrowseHandler.this).getText()) && (item = (FoundItem)((Object)BrowseHandler.ra$popupList(BrowseHandler.this).getSelectedValue())) != null) {
                    String qualifiedName = item.toString();
                    BrowseHandler.ra$browseField(BrowseHandler.this).setText(qualifiedName);
                }
                BrowseHandler.mav$hidePopup(BrowseHandler.this);
            }
        }

        public void keyTyped(KeyEvent event) {
        }

        public void keyPressed(KeyEvent event) {
            int keycode = event.getKeyCode();
            if (!(BrowseHandler.ra$pendingLookup(BrowseHandler.this) || BrowseHandler.ra$popupWindow(BrowseHandler.this) != null && BrowseHandler.ra$popupWindow(BrowseHandler.this).isVisible())) {
                if (keycode == 40) {
                    BrowseHandler.wa$_previousText(BrowseHandler.this, null);
                    BrowseHandler.mav$updatePopup(BrowseHandler.this);
                }
                return;
            }
            switch (keycode) {
                case 10: 
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    if (!BrowseHandler.ra$pendingLookup(BrowseHandler.this)) break;
                    event.consume();
                    return;
                }
                case 27: {
                    if (!BrowseHandler.ra$pendingLookup(BrowseHandler.this)) break;
                    BrowseHandler.mav$cancelLookup(BrowseHandler.this);
                    BrowseHandler.mav$hidePopup(BrowseHandler.this);
                    event.consume();
                    return;
                }
                default: {
                    return;
                }
            }
            Assert.check((BrowseHandler.ra$popupList(BrowseHandler.this) != null ? 1 : 0) != 0, (String)"missing list");
            try {
                BrowseHandler.wa$inNavigation(BrowseHandler.this, true);
                switch (keycode) {
                    default: {
                        throw new IllegalStateException("unexpected key: " + keycode);
                    }
                    case 40: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).down();
                        break;
                    }
                    case 38: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).up();
                        break;
                    }
                    case 34: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).pageDown();
                        break;
                    }
                    case 33: {
                        BrowseHandler.ra$popupList(BrowseHandler.this).pageUp();
                        break;
                    }
                    case 10: {
                        FoundItem clickedItem = (FoundItem)((Object)BrowseHandler.ra$popupList(BrowseHandler.this).getSelectedValue());
                        if (PROGRESS_LIST_ITEM.equals(clickedItem.toString())) {
                            return;
                        }
                        if (clickedItem != null && BrowseHandler.ra$browseField(BrowseHandler.this) != null && BrowseHandler.ra$_copyQualifiedClassNameToField(BrowseHandler.this)) {
                            BrowseHandler.ra$browseField(BrowseHandler.this).setText(clickedItem.toString());
                        }
                        BrowseHandler.wa$_previousText(BrowseHandler.this, BrowseHandler.ra$browseField(BrowseHandler.this).getText());
                        BrowseHandler.mav$hidePopup(BrowseHandler.this);
                        if (BrowseHandler.ra$clientListener(BrowseHandler.this) != null) {
                            ActionEvent actionEvent = new ActionEvent(this, 1001, null);
                            BrowseHandler.ra$clientListener(BrowseHandler.this).actionPerformed(actionEvent);
                        }
                        event.consume();
                        return;
                    }
                    case 27: {
                        BrowseHandler.mav$hidePopup(BrowseHandler.this);
                        event.consume();
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                BrowseHandler.wa$inNavigation(BrowseHandler.this, false);
            }
            BrowseHandler.wa$lastDefaultItem(BrowseHandler.this, (FoundItem)((Object)BrowseHandler.ra$popupList(BrowseHandler.this).getSelectedValue()));
            BrowseHandler.wa$inNavigation(BrowseHandler.this, true);
            String replaceText = BrowseHandler.ra$lastDefaultItem(BrowseHandler.this).getName();
            BrowseHandler.ra$browseField(BrowseHandler.this).setText(replaceText);
            BrowseHandler.wa$inNavigation(BrowseHandler.this, false);
        }

        public void keyReleased(KeyEvent event) {
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() > 1) {
                if (BrowseHandler.ra$popupList(BrowseHandler.this) != null) {
                    FoundItem clickedItem = (FoundItem)((Object)BrowseHandler.ra$popupList(BrowseHandler.this).getSelectedValue());
                    if (PROGRESS_LIST_ITEM.equals(clickedItem.toString())) {
                        return;
                    }
                    if (clickedItem != null && FoundItem.ra$type(clickedItem) == 1) {
                        String replaceText = (BrowseHandler.ra$classOrPackage(BrowseHandler.this) & 2) == 0 ? BrowseHandler.ra$lastDefaultItem(BrowseHandler.this).getName() : BrowseHandler.ra$lastDefaultItem(BrowseHandler.this).getName() + ".";
                        BrowseHandler.ra$browseField(BrowseHandler.this).setText(replaceText);
                        return;
                    }
                }
                if (BrowseHandler.ra$clientListener(BrowseHandler.this) != null) {
                    ActionEvent actionEvent = new ActionEvent(this, 1001, null);
                    BrowseHandler.ra$clientListener(BrowseHandler.this).actionPerformed(actionEvent);
                } else if (BrowseHandler.ra$popupList(BrowseHandler.this) != null) {
                    FoundItem clickedItem = (FoundItem)((Object)BrowseHandler.ra$popupList(BrowseHandler.this).getSelectedValue());
                    if (clickedItem != null && BrowseHandler.ra$_copyQualifiedClassNameToField(BrowseHandler.this)) {
                        BrowseHandler.ra$browseField(BrowseHandler.this).setText(clickedItem.toString());
                    }
                    BrowseHandler.wa$_previousText(BrowseHandler.this, BrowseHandler.ra$browseField(BrowseHandler.this).getText());
                    BrowseHandler.mav$hidePopup(BrowseHandler.this);
                }
                event.consume();
            }
        }

        public void mousePressed(MouseEvent event) {
        }

        public void mouseReleased(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void valueChanged(ListSelectionEvent event) {
            if (!BrowseHandler.ra$inNavigation(BrowseHandler.this) && BrowseHandler.ra$popupList(BrowseHandler.this) != null) {
                BrowseHandler.wa$lastDefaultItem(BrowseHandler.this, (FoundItem)((Object)BrowseHandler.ra$popupList(BrowseHandler.this).getSelectedValue()));
                if (BrowseHandler.ra$lastDefaultItem(BrowseHandler.this) != null) {
                    BrowseHandler.wa$inNavigation(BrowseHandler.this, true);
                    String replaceText = BrowseHandler.ra$lastDefaultItem(BrowseHandler.this).getName();
                    if (!BrowseHandler.ra$browseField(BrowseHandler.this).getText().equals(replaceText)) {
                        BrowseHandler.ra$browseField(BrowseHandler.this).setText(replaceText);
                    }
                    BrowseHandler.wa$inNavigation(BrowseHandler.this, false);
                }
            }
        }

        public void ancestorAdded(AncestorEvent event) {
        }

        public void ancestorRemoved(AncestorEvent event) {
        }

        public void ancestorMoved(AncestorEvent event) {
            BrowseHandler.mav$hidePopup(BrowseHandler.this);
        }

        private PopupGestureHandler() {
        }

        PopupGestureHandler(1 var2_2) {
            this();
        }

        static void mav$caretChanged(PopupGestureHandler popupGestureHandler) {
            popupGestureHandler.caretChanged();
        }

        final class 1
        implements Runnable {
            public void run() {
                PopupGestureHandler.mav$caretChanged(PopupGestureHandler.this);
            }
        }
    }
}

