/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserContext;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageView;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;

public class ClassPackageSearchPanel
extends JPanel
implements ClassPackageView {
    private final JLabel searchLabel;
    private final JTextField searchTextField;
    private final JLabel classPkgLabel;
    private final ListSelectionModel selectionModel;
    private final JList classPkgList;
    private final JScrollPane scroller;
    private final DefaultListCellRenderer renderer;
    private final GridBagLayout mainLayout;
    private boolean _multiSelect;
    private int _classPackageMode;
    private BrowseHandler _browseHandler;
    private JavaManager _javaManager;
    private final ClassPackageBrowserContext _browserContext;
    private String[] _selection;

    private void $init$() {
        this.searchLabel = new JLabel();
        this.searchTextField = new JTextField();
        this.classPkgLabel = new JLabel();
        this.selectionModel = new DefaultListSelectionModel();
        this.classPkgList = new JList();
        this.scroller = new JScrollPane(this.classPkgList);
        this.renderer = new ListDataItemCellRenderer();
        this.mainLayout = new GridBagLayout();
    }

    public ClassPackageSearchPanel(ClassPackageBrowserContext browseContext) {
        this.$init$();
        this._browserContext = browseContext;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void activateView() {
        String lookup;
        Object firstElement;
        if (this.classPkgList.getModel().getSize() == 1 && (BrowseHandler.PROGRESS_LIST_ITEM.equals((firstElement = this.classPkgList.getModel().getElementAt(0)).toString()) || BrowseHandler.EMPTY_LIST_ITEM.equals(firstElement.toString())) && (lookup = this.searchTextField.getText()).length() > 0) {
            this._browseHandler.doLookup(lookup);
        }
        this.enableControls();
    }

    public String getTitle() {
        return DialogsArb.getString(16);
    }

    public Component getComponent() {
        return this.searchTextField;
    }

    public void setSelection(String singleSelection) {
        this.searchTextField.setText(singleSelection);
    }

    public String getSelection() {
        String[] sels = this.getSelectedItems();
        return sels.length > 0 ? sels[0] : null;
    }

    public void setSelectedItems(String[] multiSelection) {
        if (multiSelection != null && multiSelection.length > 0) {
            this.setSelection(multiSelection[0]);
        }
    }

    public String[] getSelectedItems() {
        return this._selection != null ? this._selection : new String[]{};
    }

    public void setJavaManager(JavaManager javaManager) {
        this._javaManager = javaManager;
    }

    public void setClassAndPackageNameFilters(ClassNameFilter classFilter, PackageNameFilter pkgFilter) {
        if (this._javaManager != null) {
            switch (this._classPackageMode) {
                case 1: {
                    ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(5));
                    ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(4));
                    this._browseHandler = BrowseHandler.createPackageBrowserList(this._javaManager, this.searchTextField, this.classPkgList, pkgFilter);
                    break;
                }
                case 2: {
                    ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(14));
                    ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(1));
                    this._browseHandler = BrowseHandler.createClassBrowserList(this._javaManager, this.searchTextField, this.classPkgList, classFilter);
                    break;
                }
                default: {
                    ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(17));
                    ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(11));
                    this._browseHandler = BrowseHandler.createClassPackageBrowserList(this._javaManager, this.searchTextField, this.classPkgList, classFilter, pkgFilter);
                }
            }
        }
    }

    public void setFilter(ClassPackageBrowserFilterV2 filterV2) {
    }

    public void setMultiSelect(boolean isMultiSelect) {
        if (isMultiSelect != this._multiSelect) {
            this._multiSelect = isMultiSelect;
        }
        this.selectionModel.setSelectionMode(this._multiSelect ? 2 : 0);
    }

    public void setMode(int classPackageMode) {
        this._classPackageMode = classPackageMode;
        switch (this._classPackageMode) {
            case 1: {
                ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(5));
                ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(4));
                break;
            }
            case 2: {
                ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(14));
                ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(1));
                break;
            }
            default: {
                ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(17));
                ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(11));
            }
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.classPkgLabel, (Component)this.scroller, (String)DialogsArb.getString(17));
        ResourceUtils.resLabel((JLabel)this.searchLabel, (Component)this.searchTextField, (String)DialogsArb.getString(11));
        InteractionHandler guiHandler = new InteractionHandler(null);
        this.classPkgList.addListSelectionListener(guiHandler);
        this.searchTextField.addFocusListener(guiHandler);
        this.searchTextField.addKeyListener(guiHandler);
        this.classPkgList.addMouseListener(guiHandler);
        this.selectionModel.setSelectionMode(0);
        this.classPkgList.setCellRenderer(this.renderer);
        this.setLayout(this.mainLayout);
        int y = -1;
        this.add((Component)this.searchLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.searchTextField, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.classPkgLabel, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)this.scroller, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
    }

    private void enableControls() {
        Object selection = this.classPkgList.getSelectedValue();
        String text = selection != null ? selection.toString() : null;
        this._browserContext.enableControls(selection != null && !BrowseHandler.EMPTY_LIST_ITEM.equals(text) && !BrowseHandler.PROGRESS_LIST_ITEM.equals(text));
    }

    static JList ra$classPkgList(ClassPackageSearchPanel classPackageSearchPanel) {
        return classPackageSearchPanel.classPkgList;
    }

    static ClassPackageBrowserContext ra$_browserContext(ClassPackageSearchPanel classPackageSearchPanel) {
        return classPackageSearchPanel._browserContext;
    }

    static void mav$enableControls(ClassPackageSearchPanel classPackageSearchPanel) {
        classPackageSearchPanel.enableControls();
    }

    static void wa$_selection(ClassPackageSearchPanel classPackageSearchPanel, String[] stringArray) {
        classPackageSearchPanel._selection = stringArray;
    }

    static JTextField ra$searchTextField(ClassPackageSearchPanel classPackageSearchPanel) {
        return classPackageSearchPanel.searchTextField;
    }

    private final class InteractionHandler
    implements FocusListener,
    KeyListener,
    ListSelectionListener,
    MouseListener {
        public void focusLost(FocusEvent e) {
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() != ClassPackageSearchPanel.ra$searchTextField(ClassPackageSearchPanel.this)) {
                return;
            }
            int len = ClassPackageSearchPanel.ra$searchTextField(ClassPackageSearchPanel.this).getText().length();
            ClassPackageSearchPanel.ra$searchTextField(ClassPackageSearchPanel.this).setSelectionStart(0);
            ClassPackageSearchPanel.ra$searchTextField(ClassPackageSearchPanel.this).setSelectionEnd(len);
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ClassPackageSearchPanel.mav$enableControls(ClassPackageSearchPanel.this);
                Object[] selection = ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getSelectedValues();
                if (selection.length == 0) {
                    ClassPackageSearchPanel.wa$_selection(ClassPackageSearchPanel.this, new String[0]);
                } else {
                    ArrayList<String> resultList = new ArrayList<String>();
                    Object[] objectArray = selection;
                    int n = 0;
                    while (n < objectArray.length) {
                        Object item = objectArray[n];
                        if (!BrowseHandler.EMPTY_LIST_ITEM.equals(item.toString()) && !BrowseHandler.PROGRESS_LIST_ITEM.equals(item.toString())) {
                            resultList.add(item.toString());
                        }
                        ++n;
                    }
                    String[] results = new String[resultList.size()];
                    ClassPackageSearchPanel.wa$_selection(ClassPackageSearchPanel.this, resultList.toArray(results));
                }
            }
        }

        public void keyPressed(KeyEvent e) {
            int index;
            int keyCode = e.getKeyCode();
            if (40 == keyCode) {
                int index2 = ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getSelectedIndex();
                if (index2 < ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getModel().getSize() - 1) {
                    ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).setSelectedIndex(index2 + 1);
                }
            } else if (38 == keyCode && (index = ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getSelectedIndex()) > 0) {
                ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).setSelectedIndex(index - 1);
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            int clicks = e.getClickCount();
            int index = ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getSelectedIndex();
            if (clicks == 2 && index != -1) {
                Object selection;
                if (index == 0 && (BrowseHandler.EMPTY_LIST_ITEM.equals((selection = ClassPackageSearchPanel.ra$classPkgList(ClassPackageSearchPanel.this).getSelectedValue()).toString()) || BrowseHandler.PROGRESS_LIST_ITEM.equals(selection.toString()))) {
                    return;
                }
                ClassPackageSearchPanel.ra$_browserContext(ClassPackageSearchPanel.this).classPackageSelected();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private InteractionHandler() {
        }

        InteractionHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

