/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Ide;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.WaitCursor;
import oracle.ide.util.Assert;
import oracle.ide.util.SwingWorker;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.dialogs.ClassPackageBrowserContext;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageView;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;

public class ClassPackageTreePanel
extends JPanel
implements ClassPackageView {
    JScrollPane pkgScrollPane;
    JTree pkgTree;
    DefaultTreeModel pkgModel;
    DefaultTreeCellRenderer renderer;
    GridBagLayout mainLayout;
    TreeSelectionModel selModel;
    private JavaManager _jmgr;
    private int mode;
    private ClassPackageBrowserFilterV2 _filter;
    private boolean _multiSelect;
    private final ClassPackageBrowserContext _browserContext;

    private void $init$() {
        this.pkgScrollPane = new JScrollPane();
        this.pkgTree = KeyNavigationManager.createNavigableTree();
        this.pkgModel = new DefaultTreeModel(new DefaultMutableTreeNode("Packages"));
        this.renderer = new TreeRenderer(null);
        this.mainLayout = new GridBagLayout();
        this.selModel = new DefaultTreeSelectionModel();
        this.mode = 1;
    }

    public ClassPackageTreePanel(ClassPackageBrowserContext browseContext, ClassPackageBrowserFilterV2 filter) {
        this.$init$();
        this._browserContext = browseContext;
        this._filter = filter;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void activateView() {
        this.enableControls();
    }

    public String getTitle() {
        return DialogsArb.getString(8);
    }

    public Component getComponent() {
        return this.pkgTree;
    }

    public void setSelection(String singleSelection) {
        if (singleSelection != null) {
            String[] multiSelection = new String[]{singleSelection};
            this.setSelectedItems(multiSelection);
        }
    }

    public String getSelection() {
        String[] sels = this.getSelectedItems();
        return sels.length > 0 ? sels[0] : null;
    }

    public void setSelectedItems(String[] multiSelection) {
        this.setSelectedItemsImpl(multiSelection);
    }

    public String[] getSelectedItems() {
        ArrayList<String> resultList = new ArrayList<String>();
        TreePath[] paths = this.pkgTree.getSelectionPaths();
        if (paths != null) {
            int i = 0;
            while (i < paths.length) {
                Object o = paths[i].getLastPathComponent();
                if (o instanceof PackageNode && (this.mode & 1) > 0) {
                    resultList.add(((PackageNode)o).getPackage());
                } else if (o instanceof ClassNode && (this.mode & 2) > 0) {
                    resultList.add(((ClassNode)o).getClassName());
                }
                ++i;
            }
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    public void setJavaManager(JavaManager javaManager) {
        Assert.check((javaManager != null ? 1 : 0) != 0);
        this._jmgr = javaManager;
        Collection allPackages = this._jmgr.getJavaClassLocator().getPackages("");
        this.setPackageList(allPackages.iterator());
    }

    public void setClassAndPackageNameFilters(ClassNameFilter classFilter, PackageNameFilter pkgFilter) {
    }

    public void setFilter(ClassPackageBrowserFilterV2 filterV2) {
        this._filter = filterV2;
        Assert.check((this._jmgr != null ? 1 : 0) != 0);
        Collection allPackages = this._jmgr.getJavaClassLocator().getPackages("");
        this.setPackageList(allPackages.iterator());
    }

    public void setMultiSelect(boolean isMultiSelect) {
        if (isMultiSelect != this._multiSelect) {
            this._multiSelect = isMultiSelect;
        }
        this.selModel.setSelectionMode(this._multiSelect ? 4 : 1);
    }

    public void setMode(int classPackageMode) {
        this.mode = classPackageMode;
    }

    private void jbInit() throws Exception {
        this.pkgTree.setVisibleRowCount(10);
        this.pkgTree.setRootVisible(false);
        this.pkgTree.setShowsRootHandles(true);
        this.pkgTree.setModel(this.pkgModel);
        this.pkgTree.setCellRenderer(this.renderer);
        TreeAdapter treeListener = new TreeAdapter(null);
        this.pkgTree.addTreeSelectionListener(treeListener);
        this.pkgTree.addTreeWillExpandListener(treeListener);
        this.pkgTree.addFocusListener(treeListener);
        this.pkgTree.setSelectionModel(this.selModel);
        this.selModel.setSelectionMode(1);
        this.selModel.addTreeSelectionListener(treeListener);
        this.pkgScrollPane.getViewport().add((Component)this.pkgTree, null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pkgScrollPane, "Center");
    }

    private void setPackageList(Iterator list) {
        MutableTreeNode root = (MutableTreeNode)this.pkgModel.getRoot();
        int i = root.getChildCount() - 1;
        while (i >= 0) {
            root.remove(i);
            --i;
        }
        while (list.hasNext()) {
            String pkg = list.next().toString();
            if (pkg == null || !this._filter.acceptPackage(pkg)) continue;
            PackageNode pkgNode = new PackageNode(pkg);
            pkgNode.loadChildren(false);
            if ((this.mode & 1) <= 0 && (this.mode ^ 1) > 0 && pkgNode.children() == DefaultMutableTreeNode.EMPTY_ENUMERATION) continue;
            root.insert(pkgNode, root.getChildCount());
        }
        if ((this.mode & 2) > 0) {
            for (String cname : this._jmgr.getJavaClassLocator().getClassesInPackage("")) {
                JavaClass cls = this._jmgr.getClass(cname);
                if (cls == null || !this._filter.acceptClass(cls)) continue;
                root.insert(new ClassNode(cls), root.getChildCount());
            }
        }
        if (root.getChildCount() == 0) {
            String label = DialogsArb.getString(9);
            root.insert(new DefaultMutableTreeNode(label), 0);
        }
        this.pkgModel.nodeChanged(root);
        this.pkgTree.updateUI();
        this.pkgTree.expandPath(new TreePath(new Object[]{root}));
    }

    private void setSelectedItemsImpl(String[] sel) {
        if (sel == null || sel.length == 0) {
            this.pkgTree.setSelectionRow(0);
        } else {
            String[] cleanSel = new String[sel.length];
            System.arraycopy(sel, 0, cleanSel, 0, sel.length);
            HashSet<String> pathSet = new HashSet<String>();
            int i = 0;
            while (i < cleanSel.length) {
                String path = cleanSel[i];
                if (path.endsWith(".*")) {
                    cleanSel[i] = path = path.substring(0, path.length() - 2);
                }
                int idx = path.lastIndexOf(46);
                while (idx != -1) {
                    path = path.substring(0, idx);
                    pathSet.add(path);
                    idx = path.lastIndexOf(46);
                }
                ++i;
            }
            Object[] paths = pathSet.toArray(new String[pathSet.size()]);
            Arrays.sort(paths);
            MutableTreeNode root = (MutableTreeNode)this.pkgModel.getRoot();
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            1 worker = new 1(this, root, (String[])paths, cleanSel, wc);
            worker.start();
        }
    }

    private void enableControls() {
        boolean validSelection = false;
        TreePath[] paths = this.selModel.getSelectionPaths();
        if (paths != null) {
            int i = 0;
            while (!validSelection && i < paths.length) {
                TreePath path = paths[i];
                if (path != null) {
                    Object o = path.getLastPathComponent();
                    if (o instanceof PackageNode) {
                        validSelection = (this.mode & 1) > 0;
                    } else if (o instanceof ClassNode) {
                        validSelection = (this.mode & 2) > 0;
                    }
                }
                ++i;
            }
        }
        this._browserContext.enableControls(validSelection);
    }

    void pkgTree_treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        PackageNode node;
        TreePath path = e.getPath();
        Object o = path.getLastPathComponent();
        if (o instanceof PackageNode && !(node = (PackageNode)o).isChildrenLoaded()) {
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            this.pkgModel.addTreeModelListener(new 2(this, path, wc));
            node.loadChildren(true);
            throw new ExpandVetoException(e);
        }
    }

    static JavaManager ra$_jmgr(ClassPackageTreePanel classPackageTreePanel) {
        return classPackageTreePanel._jmgr;
    }

    static ClassPackageBrowserFilterV2 ra$_filter(ClassPackageTreePanel classPackageTreePanel) {
        return classPackageTreePanel._filter;
    }

    static int ra$mode(ClassPackageTreePanel classPackageTreePanel) {
        return classPackageTreePanel.mode;
    }

    static ClassPackageBrowserContext ra$_browserContext(ClassPackageTreePanel classPackageTreePanel) {
        return classPackageTreePanel._browserContext;
    }

    static void mav$enableControls(ClassPackageTreePanel classPackageTreePanel) {
        classPackageTreePanel.enableControls();
    }

    final class 1
    extends SwingWorker {
        private final /* synthetic */ MutableTreeNode v$root;
        private final /* synthetic */ String[] v$paths;
        private final /* synthetic */ String[] v$cleanSel;
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ ClassPackageTreePanel this$0;

        public Object construct() {
            HashMap<String, TreePath> pathMap = new HashMap<String, TreePath>();
            pathMap.put("", new TreePath(this.v$root));
            int i = 0;
            while (i < this.v$paths.length) {
                MutableTreeNode parentNode;
                TreeNode child;
                String pkg = this.v$paths[i];
                int idx = pkg.lastIndexOf(46);
                String base = idx != -1 ? pkg.substring(0, idx) : "";
                String rest = pkg.substring(idx + 1);
                TreePath parent = (TreePath)pathMap.get(base);
                if (parent != null && (child = this.getChild(parentNode = (MutableTreeNode)parent.getLastPathComponent(), rest)) instanceof PackageNode) {
                    PackageNode pNode = (PackageNode)child;
                    if (!pNode.isChildrenLoaded()) {
                        pNode.loadChildren(false);
                    }
                    TreePath childPath = parent.pathByAddingChild(pNode);
                    pathMap.put(pkg, childPath);
                }
                ++i;
            }
            return pathMap;
        }

        public void finished() {
            try {
                Map pathMap = (Map)this.get();
                int i = 0;
                while (i < this.v$paths.length) {
                    TreePath path = (TreePath)pathMap.get(this.v$paths[i]);
                    if (path != null) {
                        this.this$0.pkgTree.expandPath(path);
                    }
                    ++i;
                }
                this.this$0.selModel.clearSelection();
                int i2 = 0;
                while (i2 < this.v$cleanSel.length) {
                    MutableTreeNode parentNode;
                    TreeNode child;
                    String path = this.v$cleanSel[i2];
                    int idx = path.lastIndexOf(46);
                    String base = idx != -1 ? path.substring(0, idx) : "";
                    String rest = path.substring(idx + 1);
                    TreePath parent = (TreePath)pathMap.get(base);
                    if (parent != null && (child = this.getChild(parentNode = (MutableTreeNode)parent.getLastPathComponent(), rest)) != null) {
                        TreePath newPath = parent.pathByAddingChild(child);
                        this.this$0.selModel.addSelectionPath(newPath);
                        this.this$0.pkgTree.scrollPathToVisible(newPath);
                    }
                    ++i2;
                }
            }
            finally {
                this.v$wc.hide();
            }
        }

        private TreeNode getChild(MutableTreeNode parentNode, String name) {
            TreeNode child = null;
            int childCount = parentNode.getChildCount();
            int i = 0;
            while (i < childCount) {
                TreeNode node = parentNode.getChildAt(i);
                if (name.equals(node.toString())) {
                    child = node;
                    break;
                }
                ++i;
            }
            return child;
        }

        public 1(ClassPackageTreePanel classPackageTreePanel, MutableTreeNode mutableTreeNode, String[] stringArray, String[] stringArray2, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.v$cleanSel = stringArray2;
            this.v$paths = stringArray;
            this.v$root = mutableTreeNode;
            this.this$0 = classPackageTreePanel;
        }
    }

    final class 2
    implements TreeModelListener {
        private final /* synthetic */ TreePath v$path;
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ ClassPackageTreePanel this$0;

        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.this$0.pkgTree.expandPath(this.v$path);
            this.this$0.pkgModel.removeTreeModelListener(this);
            this.v$wc.hide();
        }

        public 2(ClassPackageTreePanel classPackageTreePanel, TreePath treePath, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.v$path = treePath;
            this.this$0 = classPackageTreePanel;
        }
    }

    private class PackageNode
    extends DefaultMutableTreeNode {
        String displayName;
        String pkgName;
        boolean childrenFetched;
        boolean isSelectable;
        boolean loading;

        PackageNode(String pkgName) {
            this.pkgName = pkgName;
            int idx = pkgName.lastIndexOf(".");
            this.displayName = idx != -1 ? pkgName.substring(idx + 1) : pkgName;
            this.isSelectable = true;
        }

        Icon getIcon() {
            return null;
        }

        public String toString() {
            return this.displayName;
        }

        public String getPackage() {
            return this.pkgName;
        }

        boolean isSelectable() {
            return this.isSelectable;
        }

        void setSelectable(boolean isSelectable) {
            this.isSelectable = isSelectable;
        }

        boolean isChildrenLoaded() {
            return this.childrenFetched;
        }

        void setChildrenLoaded(boolean childrenFetched) {
            this.childrenFetched = childrenFetched;
        }

        public boolean isLeaf() {
            return !this.childrenFetched ? false : super.isLeaf();
        }

        void loadChildren(boolean useWorker) {
            if (this.loading) {
                return;
            }
            this.loading = true;
            if (useWorker) {
                1 worker = new 1();
                worker.start();
            } else {
                ArrayList children = null;
                try {
                    children = this._loadChildList();
                }
                finally {
                    this._finishChildLoad(children);
                }
            }
        }

        private ArrayList _loadChildList() {
            ArrayList<DefaultMutableTreeNode> nodes;
            block5: {
                nodes = new ArrayList<DefaultMutableTreeNode>();
                try {
                    Iterator iter = ClassPackageTreePanel.ra$_jmgr(ClassPackageTreePanel.this).getJavaClassLocator().getPackages(this.pkgName).iterator();
                    while (iter.hasNext()) {
                        String childPackage = this.pkgName.length() == 0 ? (String)iter.next() : this.pkgName + '.' + iter.next();
                        if (childPackage == null || !ClassPackageTreePanel.ra$_filter(ClassPackageTreePanel.this).acceptPackage(childPackage)) continue;
                        nodes.add(new PackageNode(childPackage));
                    }
                    if ((ClassPackageTreePanel.ra$mode(ClassPackageTreePanel.this) & 2) > 0) {
                        iter = ClassPackageTreePanel.ra$_jmgr(ClassPackageTreePanel.this).getJavaClassLocator().getClassesInPackage(this.pkgName).iterator();
                        while (iter.hasNext()) {
                            String cname = this.pkgName.length() == 0 ? (String)iter.next() : this.pkgName + '.' + iter.next();
                            JavaClass cls = ClassPackageTreePanel.ra$_jmgr(ClassPackageTreePanel.this).getClass(cname);
                            if (cls == null || !ClassPackageTreePanel.ra$_filter(ClassPackageTreePanel.this).acceptClass(cls)) continue;
                            nodes.add(new ClassNode(cls));
                        }
                    }
                }
                catch (Throwable t) {
                    Assert.printStackTrace((Throwable)t);
                    if (!(t instanceof ThreadDeath)) break block5;
                    throw (ThreadDeath)t;
                }
            }
            return nodes;
        }

        private void _finishChildLoad(Object obj) {
            try {
                if (obj instanceof ArrayList) {
                    ArrayList result = (ArrayList)obj;
                    Iterator iter = result.iterator();
                    while (iter.hasNext()) {
                        this.add((MutableTreeNode)iter.next());
                    }
                }
            }
            finally {
                this.childrenFetched = true;
                TreePath[] sel = ClassPackageTreePanel.this.selModel.getSelectionPaths();
                ClassPackageTreePanel.this.pkgModel.reload(this);
                ClassPackageTreePanel.this.selModel.setSelectionPaths(sel);
            }
        }

        public Object getUserObject() {
            return this.displayName;
        }

        static void mav$_finishChildLoad(PackageNode packageNode, Object object) {
            packageNode._finishChildLoad(object);
        }

        static ArrayList mav$_loadChildList(PackageNode packageNode) {
            return packageNode._loadChildList();
        }

        final class 1
        extends SwingWorker {
            public Object construct() {
                return PackageNode.mav$_loadChildList(PackageNode.this);
            }

            public void finished() {
                PackageNode.mav$_finishChildLoad(PackageNode.this, this.get());
            }
        }
    }

    private class ClassNode
    extends DefaultMutableTreeNode {
        private String displayName;
        private JavaClass cls;

        ClassNode(JavaClass cls) {
            super(cls, false);
            this.cls = cls;
            this.displayName = cls.getName();
        }

        public String toString() {
            return this.displayName;
        }

        String getClassName() {
            return this.cls.getQualifiedName();
        }

        public Object getUserObject() {
            return this.displayName;
        }

        public boolean isInterface() {
            return this.cls.isInterface();
        }
    }

    private static final class TreeRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof PackageNode) {
                if (leaf) {
                    this.setLeafIcon(OracleIcons.getIcon((String)"package.png"));
                }
                if (expanded) {
                    this.setOpenIcon(OracleIcons.getIcon((String)"package.png"));
                } else {
                    this.setClosedIcon(OracleIcons.getIcon((String)"package.png"));
                }
            } else if (value instanceof ClassNode) {
                this.setLeafIcon(((ClassNode)value).isInterface() ? OracleIcons.getIcon((String)"interface.png") : OracleIcons.getIcon((String)"class.png"));
            }
            Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            return c;
        }

        private TreeRenderer() {
        }

        TreeRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class TreeAdapter
    implements FocusListener,
    MouseListener,
    TreeSelectionListener,
    TreeWillExpandListener {
        int y;

        public void focusGained(FocusEvent e) {
            if (ClassPackageTreePanel.this.pkgTree.getSelectionCount() == 0) {
                ClassPackageTreePanel.this.pkgTree.setSelectionInterval(0, 0);
            }
        }

        public void focusLost(FocusEvent e) {
        }

        public void valueChanged(TreeSelectionEvent e) {
            ClassPackageTreePanel.mav$enableControls(ClassPackageTreePanel.this);
        }

        public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            ClassPackageTreePanel.this.pkgTree_treeWillExpand(e);
        }

        public void treeWillCollapse(TreeExpansionEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            TreePath path;
            int clicks = e.getClickCount();
            if (clicks == 1) {
                this.y = e.getY();
            }
            if (this.y == e.getY() && clicks == 2 && (path = ((JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null && path.getLastPathComponent() instanceof ClassNode) {
                ClassPackageTreePanel.ra$_browserContext(ClassPackageTreePanel.this).classPackageSelected();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private TreeAdapter() {
        }

        TreeAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

