/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.engine.EngineUtils;
import oracle.jdeveloper.engine.JavaInfo;
import oracle.jdeveloper.engine.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInfo
implements JavaInfo,
Copyable,
Comparable {
    public String name;
    public String type;
    public String typeSignature;
    public String declaringClassName;
    public int modifiers;
    public int accessorModifiers;

    private void $init$() {
        this.type = "java.lang.String";
        this.modifiers = 0;
        this.accessorModifiers = 0;
    }

    public FieldInfo() {
        this.$init$();
    }

    public FieldInfo(String type, String name, int modifiers) {
        this.$init$();
        this.name = name;
        this.type = type;
        this.modifiers = modifiers;
    }

    public FieldInfo(JavaVariable javaVar) {
        this.$init$();
        if (javaVar != null) {
            this.name = javaVar.getName();
            JavaType javaType = javaVar.getResolvedType();
            if (javaType != null) {
                this.type = javaType.getQualifiedName();
            }
            this.modifiers = javaVar.getModifiers();
        }
    }

    public FieldInfo(FieldInfo fi) {
        this.$init$();
        if (fi != null) {
            this.name = fi.name;
            this.type = fi.type;
            this.modifiers = fi.modifiers;
            this.typeSignature = fi.typeSignature;
            this.declaringClassName = fi.declaringClassName;
        }
    }

    public Object copyTo(Object target) {
        FieldInfo copy = target != null ? (FieldInfo)target : new FieldInfo();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(FieldInfo copy) {
        copy.name = this.name;
        copy.type = this.type;
        copy.modifiers = this.modifiers;
        copy.typeSignature = this.typeSignature;
        copy.declaringClassName = this.declaringClassName;
    }

    public String render() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(this.name);
        strBuf.append(" : ");
        strBuf.append(EngineUtils.getShortName(this.type));
        return strBuf.toString();
    }

    public int compareTo(Object o) {
        FieldInfo other = (FieldInfo)o;
        return (this.name + " " + this.type).compareTo(other.name + " " + other.type);
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((FieldInfo)o);
    }

    protected final boolean equalsImpl(FieldInfo fieldInfo) {
        return ModelUtil.areEqual((Object)this.name, (Object)fieldInfo.name) && ModelUtil.areEqual((Object)this.type, (Object)fieldInfo.type);
    }

    public String toString() {
        return this.name + " : " + this.type;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int validate() {
        if (this.name != null) {
            this.name = this.name.trim();
        }
        if (this.type != null) {
            this.type = this.type.trim();
        }
        if (this.name != null && this.name.length() > 0) {
            if (!IdeUtil.isJavaIdentifier((String)this.name)) {
                return 1;
            }
        } else {
            return 2;
        }
        if (this.type == null) {
            return 4;
        }
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public MethodInfo makeGetter() {
        return this.makeGetter(this.name, this.type);
    }

    public MethodInfo makeGetter(String fieldName, String fieldType) {
        MethodInfo mi = new MethodInfo(fieldType, EngineUtils.makeReaderName(fieldName, fieldType), this.accessorModifiers);
        return mi;
    }

    public MethodInfo makeSetter() {
        return this.makeSetter(this.name, this.type);
    }

    public MethodInfo makeSetter(String fieldName, String fieldType) {
        MethodInfo mi = new MethodInfo("void", EngineUtils.makeWriterName(fieldName), this.accessorModifiers);
        mi.addParameter(fieldType, fieldName);
        return mi;
    }

    public SourceFieldDeclaration createSourceFieldDecl(SourceFile srcFile) {
        return this.createSourceFieldDecl(srcFile, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceFieldDeclaration createSourceFieldDecl(SourceFile srcFile, String expr) {
        SourceFieldDeclaration sourceFieldDeclaration;
        try {
            if (!EngineUtils.isAbstract(this.modifiers)) {
                SourceFactory factory = srcFile.getFactory();
                EngineUtils.addImport(this.type, srcFile);
                SourceTypeReference mtype = EngineUtils.createType(factory, this.type);
                sourceFieldDeclaration = ModelUtil.hasLength((String)expr) ? factory.createFieldDeclaration(this.modifiers, mtype, this.name, factory.createExpression(expr)) : factory.createFieldDeclaration(this.modifiers, mtype, this.name);
                return sourceFieldDeclaration;
            }
            SourceFieldDeclaration sourceFieldDeclaration2 = null;
            return sourceFieldDeclaration2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (srcFile.getTransaction() == null) return sourceFieldDeclaration;
            srcFile.getTransaction().savepoint();
        }
    }

    public SourceLocalVariableDeclaration createLocalVariableDeclaration(SourceFile srcFile) {
        return this.createLocalVariableDeclaration(srcFile, null);
    }

    public SourceLocalVariableDeclaration createLocalVariableDeclaration(SourceFile srcFile, String expr) {
        if (!EngineUtils.isAbstract(this.modifiers)) {
            SourceFactory factory = srcFile.getFactory();
            EngineUtils.addImport(this.type, srcFile);
            SourceTypeReference mtype = EngineUtils.createType(factory, this.type);
            return ModelUtil.hasLength((String)expr) ? factory.createLocalVariableDeclaration(this.modifiers, mtype, this.name, factory.createExpression(expr)) : factory.createLocalVariableDeclaration(this.modifiers, mtype, this.name);
        }
        return null;
    }

    public SourceLocalVariable createLocalVariable(SourceFile srcFile) {
        return this.createLocalVariable(srcFile, null);
    }

    public SourceLocalVariable createLocalVariable(SourceFile srcFile, String expr) {
        if (!EngineUtils.isAbstract(this.modifiers)) {
            SourceFactory factory = srcFile.getFactory();
            EngineUtils.addImport(this.type, srcFile);
            SourceTypeReference mtype = EngineUtils.createType(factory, this.type);
            return ModelUtil.hasLength((String)expr) ? factory.createLocalVariable(this.modifiers, mtype, this.name, factory.createExpression(expr)) : factory.createLocalVariable(this.modifiers, mtype, this.name);
        }
        return null;
    }
}

