/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.browse;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import oracle.ide.ceditor.options.DisplayOptions;
import oracle.ide.config.Preferences;
import oracle.ide.peek.Peek;
import oracle.ide.peek.Peekable;
import oracle.ide.peek.PeekableDelegator;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public abstract class AbstractEditorPeekPlugin
implements EditorPlugin {
    private StructureChangeListener _optionsListener;
    private BasicEditorPane _editor;
    private boolean _peekEnabled;

    public void install(BasicEditorPane editor) {
        if (editor instanceof PeekableDelegator && this.installPeekableEditor(editor)) {
            this._editor = editor;
            PeekableImpl peekable = new PeekableImpl(null);
            ((PeekableDelegator)editor).setPeekable((Peekable)peekable);
            DisplayOptions displayOptions = DisplayOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            displayOptions.addStructureChangeListener(this._optionsListener);
            this._peekEnabled = displayOptions.getUsePeek();
        }
    }

    public void deinstall(BasicEditorPane editor) {
        this._editor = null;
        DisplayOptions displayOptions = DisplayOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        displayOptions.removeStructureChangeListener(this._optionsListener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected abstract boolean installPeekableEditor(BasicEditorPane var1);

    protected abstract NumberRange getRectangleOffsets(BasicEditorPane var1, int var2);

    protected abstract Peek getPeek(BasicEditorPane var1, int var2, Rectangle var3);

    private void $init$() {
        this._optionsListener = new 1();
        this._peekEnabled = true;
    }

    public AbstractEditorPeekPlugin() {
        this.$init$();
    }

    static BasicEditorPane ra$_editor(AbstractEditorPeekPlugin abstractEditorPeekPlugin) {
        return abstractEditorPeekPlugin._editor;
    }

    static boolean ra$_peekEnabled(AbstractEditorPeekPlugin abstractEditorPeekPlugin) {
        return abstractEditorPeekPlugin._peekEnabled;
    }

    static void wa$_peekEnabled(AbstractEditorPeekPlugin abstractEditorPeekPlugin, boolean bl) {
        abstractEditorPeekPlugin._peekEnabled = bl;
    }

    private class PeekableImpl
    implements Peekable {
        public Peek peek(Point p) {
            SwingUtilities.convertPointFromScreen(p, (Component)AbstractEditorPeekPlugin.ra$_editor(AbstractEditorPeekPlugin.this));
            if (!AbstractEditorPeekPlugin.ra$_peekEnabled(AbstractEditorPeekPlugin.this)) {
                return null;
            }
            int offset = AbstractEditorPeekPlugin.ra$_editor(AbstractEditorPeekPlugin.this).viewToModel(p);
            NumberRange range = AbstractEditorPeekPlugin.this.getRectangleOffsets(AbstractEditorPeekPlugin.ra$_editor(AbstractEditorPeekPlugin.this), offset);
            if (range != null) {
                try {
                    Rectangle sRect = AbstractEditorPeekPlugin.ra$_editor(AbstractEditorPeekPlugin.this).modelToView(range.start);
                    Rectangle eRect = AbstractEditorPeekPlugin.ra$_editor(AbstractEditorPeekPlugin.this).modelToView(range.end);
                    sRect.add(eRect);
                    Rectangle r = sRect.intersection(AbstractEditorPeekPlugin.ra$_editor(AbstractEditorPeekPlugin.this).getVisibleRect());
                    Peek peek = AbstractEditorPeekPlugin.this.getPeek(AbstractEditorPeekPlugin.ra$_editor(AbstractEditorPeekPlugin.this), offset, r);
                    if (peek != null) {
                        peek.showPeek();
                        Peek peek2 = peek;
                        return peek2;
                    }
                }
                catch (BadLocationException e) {
                    Peek peek = null;
                    return peek;
                }
            }
            return null;
        }

        private PeekableImpl() {
        }

        PeekableImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    final class 1
    extends StructureChangeListener {
        public void structureValuesChanged(StructureChangeEvent e) {
            DisplayOptions options = DisplayOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            AbstractEditorPeekPlugin.wa$_peekEnabled(AbstractEditorPeekPlugin.this, options.getUsePeek());
        }
    }
}

