/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.clients.uieditor;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.JavaResourceLocator;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.provider.CachedFileProvider;
import oracle.jdeveloper.java.provider.ProjectFileProvider;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.java.util.JRLClassLoader;

class CombinedProvider
extends CachedFileProvider {
    private CachedFileProvider _primaryProvider;
    private URLPath _secondaryPath;
    private BaseClassLocator _secondaryLocator;
    private ClassLoader _primaryLoader;
    private JavaClassLocator _mainLocator;

    CombinedProvider(ProviderContext e, CachedFileProvider primaryProvider, URLPath secondaryPath) {
        super(e, primaryProvider.getScopeDescription());
        this._primaryProvider = primaryProvider;
        this._primaryLoader = null;
        ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
        this._secondaryPath = secondaryPath;
        this._secondaryLocator = factory.getPathLocator(null, secondaryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader() {
        ClassLoader checkPrimary = this._primaryProvider.getClassLoader();
        CombinedProvider combinedProvider = this;
        synchronized (combinedProvider) {
            if (this._primaryLoader != checkPrimary) {
                this._primaryLoader = null;
                this.clearClassLoader();
            }
            if (this._defaultClassLoader == null) {
                this._primaryLoader = checkPrimary;
                this._defaultClassLoader = new JRLClassLoader(this._primaryLoader, (JavaResourceLocator)this._secondaryLocator);
            }
            ClassLoader classLoader = this._defaultClassLoader;
            return classLoader;
        }
    }

    public void reloadProjectPaths() {
        ((ProjectFileProvider)this._primaryProvider).reloadClassLocator();
        this.flushCache();
        this.clearCompiledInfo();
        this.clearClassLoader();
    }

    public void beginCacheUse() {
        super.beginCacheUse();
        this._primaryProvider.beginCacheUse();
    }

    public void endCacheUse() {
        super.endCacheUse();
        this._primaryProvider.endCacheUse();
    }

    public void flushCache() {
        super.flushCache();
        this._primaryProvider.flushCache();
    }

    public JavaClassLocator getClassLocator() {
        return this._secondaryLocator;
    }

    public JavaClassLocator getPublicClassLocator() {
        if (this._mainLocator == null) {
            this._mainLocator = new CombinedLocator(null);
        }
        return this._mainLocator;
    }

    public JavaFile getFile(URL url) {
        URL[] paths = this._secondaryPath.getEntries();
        int pathCount = paths == null ? 0 : paths.length;
        int i = 0;
        while (i < pathCount) {
            URL path = paths[i];
            if (URLFileSystem.isBaseURLFor((URL)path, (URL)url)) {
                return super.getFile(url);
            }
            ++i;
        }
        JavaFile javaFile = this._primaryProvider.getFile(url);
        if (javaFile == null) {
            javaFile = super.getFile(url);
        }
        return javaFile;
    }

    JavaFile getOwningFile(JavaClass javaClass) {
        return this.getJavaFile(javaClass);
    }

    public SourceFile getSourceFile(URL sourceURL) {
        return this._primaryProvider.getSourceFile(sourceURL);
    }

    public SourceFile createSourceFile(URL sourceURL) throws IOException, IllegalArgumentException {
        return this._primaryProvider.createSourceFile(sourceURL);
    }

    public JavaClass getClass(String fqName) {
        JavaClass javaClass = this._primaryProvider.getClass(fqName);
        if (javaClass == null) {
            javaClass = super.getClass(fqName);
        }
        return javaClass;
    }

    public JavaClass getClass(String fqPrefix, String name) {
        JavaClass javaClass = this._primaryProvider.getClass(fqPrefix, name);
        if (javaClass == null) {
            javaClass = super.getClass(fqPrefix, name);
        }
        return javaClass;
    }

    public JavaClass getClassByVMName(String fqVMName) {
        JavaClass javaClass = this._primaryProvider.getClassByVMName(fqVMName);
        if (javaClass == null) {
            javaClass = super.getClassByVMName(fqVMName);
        }
        return javaClass;
    }

    public SourceClass getSourceClass(String fqName) {
        return this._primaryProvider.getSourceClass(fqName);
    }

    public TextBuffer getTextBuffer(URL url) {
        return this._primaryProvider.getTextBuffer(url);
    }

    static CachedFileProvider ra$_primaryProvider(CombinedProvider combinedProvider) {
        return combinedProvider._primaryProvider;
    }

    static BaseClassLocator ra$_secondaryLocator(CombinedProvider combinedProvider) {
        return combinedProvider._secondaryLocator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CombinedLocator
    implements JavaClassLocator,
    JavaResourceLocator {
        public void buildIndex() {
        }

        public Collection getPackages(String packagePrefix) {
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            Collection primaryPackages = primaryLocator.getPackages(packagePrefix);
            Collection secondaryPackages = CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getPackages(packagePrefix);
            int count = primaryPackages.size() + secondaryPackages.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection getClassesInPackage(String packagePrefix) {
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            Collection primaryClasses = primaryLocator.getClassesInPackage(packagePrefix);
            Collection secondaryClasses = CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getClassesInPackage(packagePrefix);
            int count = primaryClasses.size() + secondaryClasses.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection getAllClasses() {
            return this.getAllClasses(null);
        }

        public Collection getAllClasses(ClassNameFilter filter) {
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            Collection primaryClasses = primaryLocator.getAllClasses(filter);
            Collection secondaryClasses = CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getAllClasses(filter);
            int count = primaryClasses.size() + secondaryClasses.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection getAllPackages() {
            return this.getAllPackages(null);
        }

        public Collection getAllPackages(PackageNameFilter filter) {
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            Collection primaryPackages = primaryLocator.getAllPackages(filter);
            Collection secondaryPackages = CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getAllPackages(filter);
            int count = primaryPackages.size() + secondaryPackages.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection getClassesByName(String name, boolean matchCase) {
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            Collection primaryClasses = primaryLocator.getClassesByName(name, matchCase);
            Collection secondaryClasses = CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getClassesByName(name, matchCase);
            int count = primaryClasses.size() + secondaryClasses.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public Collection getClassesByPrefix(String prefix, boolean matchCase) {
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            Collection primaryClasses = primaryLocator.getClassesByPrefix(prefix, matchCase);
            Collection secondaryClasses = CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getClassesByPrefix(prefix, matchCase);
            int count = primaryClasses.size() + secondaryClasses.size();
            ArraySortedSet resultSet = new ArraySortedSet(count);
            return resultSet;
        }

        public URL getURL(String fqClassName) {
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            URL resultURL = primaryLocator.getURL(fqClassName);
            if (resultURL == null) {
                resultURL = CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getClassURL(fqClassName);
            }
            return resultURL;
        }

        public URL getSourceURL(String fqClassName) {
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            return primaryLocator.getSourceURL(fqClassName);
        }

        public URL getClassURL(String fqClassName) {
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            URL resultURL = primaryLocator.getClassURL(fqClassName);
            if (resultURL == null) {
                resultURL = CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getClassURL(fqClassName);
            }
            return resultURL;
        }

        public URL getResourceURL(String resourceName) {
            URL resultURL = null;
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            if (primaryLocator instanceof JavaResourceLocator) {
                resultURL = ((JavaResourceLocator)primaryLocator).getResourceURL(resourceName);
            }
            if (resultURL == null) {
                resultURL = CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getResourceURL(resourceName);
            }
            return resultURL;
        }

        public Collection<URL> getResourceURLs(String resourceName) {
            LinkedList<URL> result = new LinkedList<URL>();
            JavaClassLocator primaryLocator = CombinedProvider.ra$_primaryProvider(CombinedProvider.this).getClassLocator();
            if (primaryLocator instanceof JavaResourceLocator) {
                result.addAll(((JavaResourceLocator)primaryLocator).getResourceURLs(resourceName));
            }
            result.addAll(CombinedProvider.ra$_secondaryLocator(CombinedProvider.this).getResourceURLs(resourceName));
            return result;
        }

        private CombinedLocator() {
        }

        CombinedLocator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

