/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.editing;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import oracle.ide.feedback.FeedbackManager;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.ActionPostInvoker;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.jdeveloper.resource.EditingArb;

public abstract class AbstractEditingPlugin
implements ActionHookInvoker,
ActionPostInvoker,
CaretListener,
CharacterTypedListener,
EditorPlugin {
    private static final EditDescriptor asteriskDescriptor;
    private static final EditDescriptor commentEndDescriptor;
    private static final EditDescriptor splitSingleLineCommentDescriptor;
    private static final EditDescriptor moveOpenBraceDescriptor;
    private static final EditDescriptor braceEndDescriptor;
    private static final EditDescriptor autoIndentBlockDescriptor;
    private static final EditDescriptor alignBraceDescriptor;
    private static final EditDescriptor quoteEndDescriptor;
    private static final EditDescriptor quoteExtendDescriptor;
    private static final EditDescriptor parenEndDescriptor;
    public static final String PROPERTY_AUTO_ASTERISK = "java-auto-asterisk";
    public static final String PROPERTY_AUTO_COMMENT_END = "java-auto-comment-end";
    public static final String PROPERTY_AUTO_SPLIT_SINGLE_LINE_COMMENT = "auto-split-single-line-comment";
    public static final String PROPERTY_AUTO_GEN_DOC_COMMENTS = "java-auto-gen-doc-comments";
    public static final String PROPERTY_AUTO_BRACE_END = "java-auto-brace-end";
    public static final String PROPERTY_OPEN_BRACE_SAME_LINE = "java-open-brace-same-line";
    public static final String PROPERTY_MOVE_OPEN_BRACE = "java-move-open-brace";
    public static final String PROPERTY_ALIGN_CLOSE_BRACE = "java-align-close-brace";
    public static final String PROPERTY_AUTO_QUOTE_END = "java-auto-quote-end";
    public static final String PROPERTY_AUTO_QUOTE_EXTEND = "java-auto-quote-extend";
    public static final String PROPERTY_AUTO_PAREN_END = "java-auto-paren-end";
    private boolean autoAsteriskEnabled;
    private boolean autoCommentEndEnabled;
    private boolean autoSplitSingleLineCommentEnabled;
    private boolean autoGenDocCommentsEnabled;
    private boolean moveOpenBraceEnabled;
    private boolean autoBraceEndEnabled;
    private boolean alignCloseBraceEnabled;
    private boolean autoQuoteEndEnabled;
    private boolean autoQuoteExtendEnabled;
    private boolean autoParenEndEnabled;
    private boolean lastBackspace;
    private int lastInvokedOffset;
    private int lastInvokedLine;
    private int lastInvokedToken;
    private BasicEditorPane editor;
    private static final int IN_PLAIN = 0;
    private static final int IN_ML_COMMENT_BODY = 1;
    private static final int IN_ML_COMMENT_HEADER = 2;
    private static final int IN_SL_COMMENT = 3;
    private static final int IN_STRING = 4;
    private static final int IN_CHARS = 5;
    private int caretToken;
    private int caretTokenStart;
    private AbstractLexer lexer;
    private LexerToken lexerToken;
    private static final int LAST_TYPED_CHARS_SIZE = 8;
    private char[] lastTypedChars;
    private int lastTypedOffset;
    private int numLastChars;
    private boolean isEmptyQuotes;
    private boolean shouldExtendQuotes;
    private boolean isEmptyParens;
    private final List _trackerList;

    public AbstractEditingPlugin() {
        this.$init$();
    }

    static {
        String editName = EditingArb.getString(4);
        asteriskDescriptor = new EditDescriptor(editName);
        editName = EditingArb.getString(2);
        commentEndDescriptor = new EditDescriptor(editName);
        editName = EditingArb.getString(7);
        splitSingleLineCommentDescriptor = new EditDescriptor(editName);
        editName = EditingArb.getString(9);
        moveOpenBraceDescriptor = new EditDescriptor(editName);
        editName = EditingArb.getString(0);
        braceEndDescriptor = new EditDescriptor(editName);
        editName = EditingArb.getString(5);
        autoIndentBlockDescriptor = new EditDescriptor(editName);
        editName = EditingArb.getString(3);
        alignBraceDescriptor = new EditDescriptor(editName);
        editName = EditingArb.getString(8);
        quoteEndDescriptor = new EditDescriptor(editName);
        editName = EditingArb.getString(1);
        quoteExtendDescriptor = new EditDescriptor(editName);
        editName = EditingArb.getString(6);
        parenEndDescriptor = new EditDescriptor(editName);
    }

    protected BasicEditorPane getEditorPane() {
        return this.editor;
    }

    protected abstract AbstractLexer getLexer();

    protected abstract boolean isEofToken(int var1);

    protected abstract boolean isSingleLineCommentToken(int var1);

    protected abstract boolean isMultiLineOrDocCommentToken(int var1);

    protected abstract boolean isCharacterLiteralToken(int var1);

    protected abstract boolean isStringLiteralToken(int var1);

    protected abstract int getRightParenToken();

    protected abstract int getRightBracketToken();

    protected abstract boolean skipCloseParenGeneration(int var1);

    protected abstract void addJavadocCommentsAtOffset();

    protected void clearLastTypedChars() {
        this.numLastChars = 0;
        this.lastTypedOffset = 0;
    }

    protected void updateLastTypedChars(int offset, char c) {
        if (!this.shouldUpdateLastTypedChars()) {
            // empty if block
        }
        if (offset != this.lastTypedOffset + 1) {
            this.numLastChars = 0;
        }
        if (this.numLastChars == 8) {
            --this.numLastChars;
            System.arraycopy(this.lastTypedChars, 1, this.lastTypedChars, 0, this.numLastChars);
        }
        this.lastTypedChars[this.numLastChars++] = c;
        this.lastTypedOffset = offset;
    }

    protected BasicDocument getDocument() {
        BasicDocument document = (BasicDocument)this.editor.getDocument();
        return document;
    }

    protected BraceProvider getBraceProvider() {
        LanguageSupport languageSupport = this.getDocument().getLanguageSupport();
        return languageSupport.getBraceProvider();
    }

    protected LexerDocumentRenderer getDocumentRenderer() {
        LexerDocumentRenderer renderer = (LexerDocumentRenderer)this.getDocument().getDocumentRenderer();
        return renderer;
    }

    public void install(BasicEditorPane editor) {
        this.editor = editor;
        editor.addActionHookInvoker((ActionHookInvoker)this);
        editor.addActionPostInvoker((ActionPostInvoker)this);
        editor.addCaretListener((CaretListener)this);
        editor.addCharacterTypedListener((CharacterTypedListener)this);
        this.lexer = this.getLexer();
        this.lexerToken = this.lexer.createLexerToken();
        this.numLastChars = 0;
        this.updatePropertyStatus();
    }

    public void deinstall(BasicEditorPane editor) {
        this.removeAllTrackers();
        editor.removeActionHookInvoker((ActionHookInvoker)this);
        editor.removeActionPostInvoker((ActionPostInvoker)this);
        editor.removeCaretListener((CaretListener)this);
        editor.removeCharacterTypedListener((CharacterTypedListener)this);
        this.editor = null;
        this.lexer = null;
        this.lexerToken = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if (propertyName.equals(PROPERTY_AUTO_ASTERISK) || propertyName.equals(PROPERTY_AUTO_COMMENT_END) || propertyName.equals(PROPERTY_AUTO_SPLIT_SINGLE_LINE_COMMENT) || propertyName.equals(PROPERTY_AUTO_GEN_DOC_COMMENTS) || propertyName.equals(PROPERTY_MOVE_OPEN_BRACE) || propertyName.equals(PROPERTY_AUTO_BRACE_END) || propertyName.equals(PROPERTY_ALIGN_CLOSE_BRACE) || propertyName.equals(PROPERTY_AUTO_QUOTE_END) || propertyName.equals(PROPERTY_AUTO_QUOTE_EXTEND) || propertyName.equals(PROPERTY_AUTO_PAREN_END)) {
            this.updatePropertyStatus();
        }
    }

    private void updatePropertyStatus() {
        this.autoAsteriskEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_ASTERISK);
        this.autoCommentEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_COMMENT_END);
        this.autoSplitSingleLineCommentEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_SPLIT_SINGLE_LINE_COMMENT);
        this.autoGenDocCommentsEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_GEN_DOC_COMMENTS);
        this.autoQuoteEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_QUOTE_END);
        this.autoQuoteExtendEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_QUOTE_EXTEND);
        this.autoParenEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_PAREN_END);
        this.moveOpenBraceEnabled = this.editor.getBooleanProperty(PROPERTY_MOVE_OPEN_BRACE);
        this.autoBraceEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_BRACE_END);
        this.alignCloseBraceEnabled = this.editor.getBooleanProperty(PROPERTY_ALIGN_CLOSE_BRACE);
        this.updateTokenStatus();
    }

    private boolean isAutoAsteriskEnabled() {
        return this.autoAsteriskEnabled;
    }

    private boolean isAutoCommentEndEnabled() {
        return this.autoCommentEndEnabled;
    }

    private boolean isAutoSplitSingleLineCommentEnabled() {
        return this.autoSplitSingleLineCommentEnabled;
    }

    private boolean isAutoGenDocCommentsEnabled() {
        return this.autoGenDocCommentsEnabled;
    }

    private boolean isMoveOpenBraceEnabled() {
        return this.moveOpenBraceEnabled;
    }

    private boolean isAutoBraceEndEnabled() {
        return this.autoBraceEndEnabled;
    }

    private boolean isAlignCloseBraceEnabled() {
        return this.alignCloseBraceEnabled;
    }

    private boolean isAutoQuoteEndEnabled() {
        return this.autoQuoteEndEnabled;
    }

    private boolean isAutoQuoteExtendEnabled() {
        return this.autoQuoteExtendEnabled;
    }

    private boolean isAutoParenEndEnabled() {
        return this.autoParenEndEnabled;
    }

    private boolean shouldRecordInvokedOffset() {
        return this.isAutoAsteriskEnabled() || this.isAutoCommentEndEnabled() || this.isAutoSplitSingleLineCommentEnabled() || this.isMoveOpenBraceEnabled() || this.isAutoBraceEndEnabled() || this.isAutoQuoteEndEnabled();
    }

    private boolean shouldUpdateTokenStatus() {
        return this.isAutoAsteriskEnabled() || this.isAutoCommentEndEnabled() || this.isAutoSplitSingleLineCommentEnabled() || this.isMoveOpenBraceEnabled() || this.isAutoBraceEndEnabled() || this.isAlignCloseBraceEnabled() || this.isAutoQuoteEndEnabled();
    }

    private boolean shouldUpdateLastTypedChars() {
        return this.isAutoCommentEndEnabled() || this.isMoveOpenBraceEnabled() || this.isAutoBraceEndEnabled() || this.isAutoQuoteEndEnabled();
    }

    public boolean invokeAction(String actionKey) {
        BasicDocument document = this.getDocument();
        if (document.getTextBuffer().isReadOnly()) {
            return false;
        }
        if (actionKey.equals("insert-break")) {
            this.recordInvokedOffset();
            this.enterKey_preAutoQuoteExtend();
        } else if (actionKey.equals("delete-previous")) {
            this.lastBackspace = this.editor.hasSelection() ^ true;
            if (this.lastBackspace) {
                this.recordInvokedOffset();
                this.delete_preAutoRemoveQuoteEnd();
                this.delete_preAutoRemoveParenEnd();
            }
        }
        return false;
    }

    private void $init$() {
        this.lastBackspace = false;
        this.editor = null;
        this.caretToken = 0;
        this.lexer = null;
        this.lexerToken = null;
        this.lastTypedChars = new char[8];
        this.lastTypedOffset = 0;
        this.numLastChars = 0;
        this.isEmptyQuotes = false;
        this.shouldExtendQuotes = false;
        this.isEmptyParens = false;
        this._trackerList = new ArrayList();
    }

    private void recordInvokedOffset() {
        if (!this.shouldRecordInvokedOffset()) {
            return;
        }
        this.lastInvokedOffset = this.editor.getCaretPosition();
        this.lastInvokedLine = this.editor.getLineFromOffset(this.lastInvokedOffset);
        this.lastInvokedToken = this.getCaretToken();
    }

    private int getLastInvokedOffset() {
        return this.lastInvokedOffset;
    }

    private int getLastInvokedLine() {
        return this.lastInvokedLine;
    }

    private int getLastInvokedToken() {
        return this.lastInvokedToken;
    }

    public void invokedAction(String actionKey) {
        BasicDocument document = this.getDocument();
        if (document.getTextBuffer().isReadOnly()) {
            return;
        }
        if (actionKey.equals("insert-break")) {
            this.enterKey_doAutoAsterisk();
            this.enterKey_doAutoEndComment();
            this.enterKey_doAutoSplitSingleLineComment();
            this.enterKey_doOpenBraceTasks();
            this.enterKey_doAutoQuoteExtend();
        } else if (actionKey.equals("delete-previous") && this.lastBackspace) {
            this.lastBackspace = false;
            this.deleteLastTypedChar(this.getLastInvokedOffset());
            this.delete_doAutoRemoveQuoteEnd();
            this.delete_doAutoRemoveParenEnd();
            return;
        }
        this.clearLastTypedChars();
    }

    public void caretUpdate(CaretEvent event) {
        this.updateTokenStatus();
    }

    public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
        this.updateLastTypedChars(offset, typedChar);
        this.charTyped_doAlignCloseBrace(offset, typedChar);
        this.charTyped_doAutoQuoteEnd(offset, typedChar);
        this.charTyped_doAutoParenEnd(offset, typedChar);
    }

    private TextBuffer getTextBuffer() {
        BasicDocument document = this.getDocument();
        return document.getTextBuffer();
    }

    private void updateTokenStatus() {
        if (!this.shouldUpdateTokenStatus()) {
            return;
        }
        int caretOffset = this.editor.getCaretPosition();
        this.caretToken = this.getTokenForOffset(caretOffset);
    }

    private int getTokenForOffset(int offset) {
        int currentToken = 0;
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            LexerDocumentRenderer renderer = this.getDocumentRenderer();
            LexerDocumentRenderer.LexerOffsetsCache cache = renderer.getOffsetsCache();
            int searchOffset = cache.findClosestOffset((Lexer)this.lexer, this.lexerToken, offset);
            this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
            this.lexer.setPosition(searchOffset);
            int currentOffset = searchOffset;
            int bufferEnd = textBuffer.getLength();
            while (currentOffset < bufferEnd) {
                int token = this.lexer.lex(this.lexerToken);
                if (token == 0) {
                } else {
                    int tokenStart = this.lexerToken.getStartOffset();
                    int tokenEnd = this.lexerToken.getEndOffset();
                    this.caretTokenStart = tokenStart;
                    if (tokenStart == offset) {
                    } else if (tokenStart < offset && offset < tokenEnd) {
                        if (this.isMultiLineOrDocCommentToken(token)) {
                            currentToken = 1;
                            int headerLength = 2;
                            if (offset < tokenStart + headerLength) {
                                currentToken = 2;
                            }
                        } else if (this.isSingleLineCommentToken(token)) {
                            currentToken = 3;
                        } else if (this.isCharacterLiteralToken(token)) {
                            currentToken = 5;
                        } else if (this.isStringLiteralToken(token)) {
                            currentToken = 4;
                        }
                    } else if (tokenEnd == offset) {
                        if (this.isMultiLineOrDocCommentToken(token)) {
                            if (textBuffer.getChar(tokenEnd - 2) != '*' || textBuffer.getChar(tokenEnd - 1) != '/') {
                                currentToken = 1;
                            }
                        } else if (this.isSingleLineCommentToken(token)) {
                            currentToken = 3;
                        } else if (this.isCharacterLiteralToken(token)) {
                            if (!this.isCharLiteralTerminated(textBuffer, tokenStart, tokenEnd)) {
                                currentToken = 5;
                            }
                        } else if (this.isStringLiteralToken(token) && !this.isStringLiteralTerminated(textBuffer, tokenStart, tokenEnd)) {
                            currentToken = 4;
                        }
                    } else if (offset >= tokenStart) continue;
                }
                break;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return currentToken;
    }

    private boolean isCharLiteralTerminated(TextBuffer textBuffer, int startOffset, int endOffset) {
        int pending = 2;
        int i = startOffset;
        while (i < endOffset) {
            char c = textBuffer.getChar(i);
            switch (c) {
                case '\'': {
                    --pending;
                    break;
                }
                case '\\': {
                    ++i;
                    break;
                }
            }
            ++i;
        }
        return pending == 0;
    }

    private boolean isStringLiteralTerminated(TextBuffer textBuffer, int startOffset, int endOffset) {
        int pending = 2;
        int i = startOffset;
        while (i < endOffset) {
            char c = textBuffer.getChar(i);
            switch (c) {
                case '\"': {
                    --pending;
                    break;
                }
                case '\\': {
                    ++i;
                    break;
                }
            }
            ++i;
        }
        return pending == 0;
    }

    private int getCaretToken() {
        return this.caretToken;
    }

    private int getCaretTokenStart() {
        return this.caretTokenStart;
    }

    private void enterKey_doAutoAsterisk() {
        block16: {
            if (!this.isAutoAsteriskEnabled()) {
                return;
            }
            if (this.getCaretToken() == 1) {
                BasicDocument document = this.getDocument();
                document.writeLock();
                try {
                    int invokedLine = this.getLastInvokedLine();
                    int commentStart = this.getCaretTokenStart();
                    TextBuffer textBuffer = this.getTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    int currentOffset = this.editor.getCaretPosition();
                    int currentLine = this.editor.getLineFromOffset(currentOffset);
                    if (invokedLine + 1 != currentLine) {
                        break block16;
                    }
                    int currentStart = this.editor.getLineStartOffset(currentLine);
                    int whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, currentStart, currentOffset);
                    if (whitespaceEnd != currentOffset) {
                        break block16;
                    }
                    int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int commentStartLine = this.editor.getLineFromOffset(commentStart);
                    int asteriskColumn = 0;
                    int numAsterisks = 0;
                    int numSpaces = 0;
                    if (commentStartLine == invokedLine) {
                        int asteriskOffset = commentStart + 1;
                        asteriskColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)commentStartLine, (int)asteriskOffset, (int)tabSize);
                        numAsterisks = 1;
                        numSpaces = 1;
                    } else {
                        int invokedEnd;
                        int invokedStart = lineMap.getLineStartOffset(invokedLine);
                        int asteriskOffset = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)invokedStart, (int)(invokedEnd = lineMap.getLineEndOffset(invokedLine)));
                        if (asteriskOffset != -1) {
                            asteriskColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)invokedLine, (int)asteriskOffset, (int)tabSize);
                            numAsterisks = this.countAsterisks(textBuffer, asteriskOffset, invokedEnd);
                            int whitespaceStart = asteriskOffset + numAsterisks;
                            whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, whitespaceStart, invokedEnd);
                            numSpaces = 1;
                            if (whitespaceEnd > whitespaceStart) {
                                int nonWhitespaceColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)invokedLine, (int)whitespaceEnd, (int)tabSize);
                                numSpaces = nonWhitespaceColumn - (asteriskColumn + numAsterisks);
                            }
                        }
                    }
                    if (numAsterisks <= false) break block16;
                    String leadingIndent = this.buildAsterisks(useTabs, tabSize, asteriskColumn, numAsterisks, numSpaces);
                    int currentIndentSize = currentOffset - currentStart;
                    this.editor.beginEdit(asteriskDescriptor);
                    try {
                        try {
                            document.remove(currentStart, currentIndentSize);
                            document.insertString(currentStart, leadingIndent, null);
                        }
                        catch (BadLocationException e) {}
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                finally {
                    document.writeUnlock();
                }
            }
        }
    }

    private String buildAsterisks(boolean useTabs, int tabSize, int asteriskColumn, int numAsterisks, int numSpaces) {
        String leadingIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)asteriskColumn);
        while (numAsterisks-- > 0) {
            leadingIndent = leadingIndent + "*";
        }
        while (numSpaces-- > 0) {
            leadingIndent = leadingIndent + " ";
        }
        return leadingIndent;
    }

    private int countAsterisks(TextBuffer textBuffer, int startOffset, int endOffset) {
        int i = startOffset;
        while (i < endOffset) {
            char c = textBuffer.getChar(i);
            if (c != '*') {
                return i - startOffset;
            }
            ++i;
        }
        return endOffset - startOffset;
    }

    private int firstNonWhitespaceOffset(TextBuffer textBuffer, int startOffset, int endOffset) {
        int i = startOffset;
        while (i < endOffset) {
            char c = textBuffer.getChar(i);
            if (!Character.isWhitespace(c)) {
                return i;
            }
            ++i;
        }
        return endOffset;
    }

    private void deleteLastTypedChar(int offset) {
        if (!this.shouldUpdateLastTypedChars()) {
            // empty if block
        }
        if (this.numLastChars == 0) {
            return;
        }
        if (offset != this.lastTypedOffset + 1) {
            this.clearLastTypedChars();
            return;
        }
        --this.numLastChars;
        this.lastTypedOffset = Math.max(0, this.lastTypedOffset - 1);
    }

    private boolean matchLastTypedChars(String matchString, int offset) {
        if (this.numLastChars < matchString.length()) {
            return false;
        }
        if (this.lastTypedOffset + 1 != offset) {
            return false;
        }
        int numToMatch = matchString.length();
        int i = 0;
        int checkPos = this.numLastChars - numToMatch;
        while (i < numToMatch) {
            if (this.lastTypedChars[checkPos] != matchString.charAt(i)) {
                return false;
            }
            ++i;
            ++checkPos;
        }
        return true;
    }

    private boolean matchLastTypedChars(String matchString) {
        if (this.numLastChars < matchString.length()) {
            return false;
        }
        int numToMatch = matchString.length();
        int i = 0;
        int checkPos = this.numLastChars - numToMatch;
        while (i < numToMatch) {
            if (this.lastTypedChars[checkPos] != matchString.charAt(i)) {
                return false;
            }
            ++i;
            ++checkPos;
        }
        return true;
    }

    private void enterKey_doAutoEndComment() {
        block17: {
            if (!this.isAutoCommentEndEnabled()) {
                return;
            }
            boolean inJavadoc = false;
            if (this.getCaretToken() == 1) {
                BasicDocument document = this.getDocument();
                document.writeLock();
                try {
                    int invokedOffset = this.getLastInvokedOffset();
                    int invokedLine = this.getLastInvokedLine();
                    int commentStart = this.getCaretTokenStart();
                    TextBuffer textBuffer = this.getTextBuffer();
                    int currentOffset = this.editor.getCaretPosition();
                    int currentLine = this.editor.getLineFromOffset(currentOffset);
                    if (this.matchLastTypedChars("/**", invokedOffset)) {
                        inJavadoc = true;
                    } else if (!this.matchLastTypedChars("/*", invokedOffset)) {
                        break block17;
                    }
                    if (invokedLine + 1 != currentLine) {
                        break block17;
                    }
                    if (invokedOffset - 3 > commentStart) {
                        break block17;
                    }
                    int currentLineEnd = this.editor.getLineEndOffset(currentLine);
                    int whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, currentOffset, currentLineEnd);
                    if (whitespaceEnd != currentLineEnd) {
                        break block17;
                    }
                    int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int commentLine = this.editor.getLineFromOffset(commentStart);
                    int asteriskOffset = commentStart + 1;
                    int asteriskColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)commentLine, (int)asteriskOffset, (int)tabSize);
                    String leadingIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)asteriskColumn);
                    this.editor.beginEdit(commentEndDescriptor);
                    try {
                        try {
                            String commentEnd = "\n" + leadingIndent + "*/";
                            document.insertString(currentOffset, commentEnd, null);
                            this.editor.setCaretPosition(currentOffset);
                        }
                        catch (BadLocationException e) {}
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                finally {
                    if (this.isAutoGenDocCommentsEnabled() && inJavadoc) {
                        this.addJavadocCommentsAtOffset();
                    }
                    document.writeUnlock();
                }
            }
        }
    }

    private void enterKey_doAutoSplitSingleLineComment() {
        block13: {
            if (!this.isAutoSplitSingleLineCommentEnabled()) {
                return;
            }
            if (this.getLastInvokedToken() == 3) {
                BasicDocument document = this.getDocument();
                document.writeLock();
                try {
                    int currentOffset = this.editor.getCaretPosition();
                    int currentLine = this.editor.getLineFromOffset(currentOffset);
                    int lineEndOffset = this.editor.getLineEndOffset(currentLine);
                    if (currentOffset + 1 >= lineEndOffset) break block13;
                    int invokedOffset = this.getLastInvokedOffset();
                    TextBuffer textBuffer = document.getTextBuffer();
                    this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                    this.lexer.setPosition(0);
                    int lastSingleLineTokenStart = -1;
                    int token = this.lexer.lex(this.lexerToken);
                    while (this.lexerToken.getStartOffset() < invokedOffset) {
                        if (this.isEofToken(token)) break;
                        if (this.isSingleLineCommentToken(token)) {
                            lastSingleLineTokenStart = this.lexerToken.getStartOffset();
                        }
                        token = this.lexer.lex(this.lexerToken);
                    }
                    if (lastSingleLineTokenStart <= 0) break block13;
                    int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int indentSize = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)lastSingleLineTokenStart, (int)tabSize);
                    StringBuilder indentedCommentStart = new StringBuilder(80);
                    indentedCommentStart.append(BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)indentSize));
                    indentedCommentStart.append("//");
                    char charAfterSLC = textBuffer.getChar(lastSingleLineTokenStart + 2);
                    if (charAfterSLC == ' ' || charAfterSLC == '\t') {
                        indentedCommentStart.append(charAfterSLC);
                    }
                    this.editor.beginEdit(splitSingleLineCommentDescriptor);
                    try {
                        try {
                            int currentLineStart = this.editor.getLineStartOffset(currentLine);
                            int oldIndentSize = currentOffset - currentLineStart;
                            document.remove(currentLineStart, oldIndentSize);
                            document.insertString(currentLineStart, indentedCommentStart.toString(), null);
                            int indentLength = indentedCommentStart.length();
                            this.editor.setCaretPosition(currentLineStart + indentLength);
                        }
                        catch (BadLocationException e) {
                            FeedbackManager.reportException((Throwable)e);
                        }
                    }
                    finally {
                        this.editor.endEdit();
                    }
                }
                finally {
                    document.writeUnlock();
                }
            }
        }
    }

    private boolean isOpenBraceAlone() {
        return this.editor.getBooleanProperty(PROPERTY_OPEN_BRACE_SAME_LINE) ^ true;
    }

    private void enterKey_doOpenBraceTasks() {
        block24: {
            boolean braceEndEnabled = this.isAutoBraceEndEnabled();
            boolean moveBraceEnabled = this.isMoveOpenBraceEnabled();
            if (this.getCaretToken() == 0) {
                BasicDocument document = this.getDocument();
                document.writeLock();
                try {
                    int openLineEnd;
                    char c;
                    int invokedOffset = this.getLastInvokedOffset();
                    int invokedLine = this.getLastInvokedLine();
                    int invokedToken = this.getLastInvokedToken();
                    TextBuffer textBuffer = this.getTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    int currentOffset = this.editor.getCaretPosition();
                    int currentLine = this.editor.getLineFromOffset(currentOffset);
                    if (invokedToken != 0) {
                        break block24;
                    }
                    if (!this.matchLastTypedChars("{")) {
                        break block24;
                    }
                    if (invokedLine + 1 != currentLine) {
                        break block24;
                    }
                    if (invokedOffset == 0) break block24;
                    if (textBuffer.getChar(invokedOffset - 1) != '{') {
                        break block24;
                    }
                    int currentLineEnd = this.editor.getLineEndOffset(currentLine);
                    int whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, currentOffset, currentLineEnd);
                    if (whitespaceEnd != currentLineEnd && (c = textBuffer.getChar(whitespaceEnd)) != ')') {
                        break block24;
                    }
                    int indentSize = BasicAction.getIndentSizeProperty((BasicEditorPane)this.editor);
                    int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int openLine = invokedLine;
                    int openLineStart = lineMap.getLineStartOffset(openLine);
                    int firstOffset = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)openLineStart, (int)(openLineEnd = lineMap.getLineEndOffset(openLine)));
                    if (firstOffset == -1) {
                        throw new IllegalStateException("unexpected empty line");
                    }
                    int firstColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)openLine, (int)firstOffset, (int)tabSize);
                    boolean openBraceAlone = firstOffset == invokedOffset - 1;
                    boolean needMoveBrace = moveBraceEnabled && openBraceAlone != this.isOpenBraceAlone();
                    int indentedColumn = firstColumn + indentSize;
                    int currentLineStart = lineMap.getLineStartOffset(currentLine);
                    EditDescriptor descriptorToUse = braceEndEnabled ? braceEndDescriptor : (moveBraceEnabled ? moveOpenBraceDescriptor : autoIndentBlockDescriptor);
                    this.editor.beginEdit(descriptorToUse);
                    try {
                        try {
                            String indentedIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)indentedColumn);
                            int oldIndentSize = currentOffset - currentLineStart;
                            document.remove(currentLineStart, oldIndentSize);
                            document.insertString(currentLineStart, indentedIndent, null);
                            int newCaretOffset = this.editor.getCaretPosition();
                            String braceIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)firstColumn);
                            String braceEnd = "\n" + braceIndent + "}";
                            if (braceEndEnabled) {
                                document.insertString(newCaretOffset, braceEnd, null);
                                this.editor.setCaretPosition(newCaretOffset);
                                Rectangle visibleRect = new Rectangle();
                                this.editor.computeVisibleRect(visibleRect);
                                try {
                                    int closeOffset = newCaretOffset + 2;
                                    Rectangle closeRect = this.editor.modelToView(closeOffset);
                                    if (!visibleRect.contains(closeRect) && visibleRect.y <= closeRect.y) {
                                        int diff = closeRect.y - (visibleRect.y + visibleRect.height);
                                        visibleRect.y += diff + closeRect.height * 2;
                                        visibleRect.y = Math.min(visibleRect.y, this.editor.getHeight() - visibleRect.height);
                                        this.editor.scrollRectToVisible(visibleRect);
                                    }
                                }
                                catch (BadLocationException e) {
                                    // empty catch block
                                }
                            }
                            if (needMoveBrace) {
                                if (this.isOpenBraceAlone()) {
                                    String openBraceIndent = "\n" + braceIndent;
                                    document.insertString(invokedOffset - 1, openBraceIndent, null);
                                } else {
                                    int previousLine = openLine - 1;
                                    if (previousLine >= 0) {
                                        int previousEnd = lineMap.getLineEndOffset(previousLine);
                                        int previousStart = lineMap.getLineStartOffset(previousLine);
                                        int realStart = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)previousStart, (int)previousEnd);
                                        if (realStart != -1 && this.getTokenForOffset(previousEnd - 1) == 0) {
                                            document.remove(openLineStart, openLineEnd - openLineStart);
                                            char charBeforeBrace = textBuffer.getChar(previousEnd - 2);
                                            String braceToAdd = charBeforeBrace != ' ' ? " {" : "{";
                                            document.insertString(previousEnd - 1, braceToAdd, null);
                                        }
                                    }
                                }
                            }
                        }
                        catch (BadLocationException e) {}
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                finally {
                    document.writeUnlock();
                }
            }
        }
    }

    private void charTyped_doAlignCloseBrace(int typedOffset, char typedChar) {
        block18: {
            if (!this.isAlignCloseBraceEnabled()) {
                return;
            }
            if (typedChar == '}' && this.getCaretToken() == 0) {
                BasicDocument document = this.getDocument();
                document.writeLock();
                try {
                    int currentColumn;
                    TextBuffer textBuffer = this.getTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    int currentOffset = this.editor.getCaretPosition();
                    int currentLine = this.editor.getLineFromOffset(currentOffset);
                    if (currentOffset != typedOffset + 1) {
                        break block18;
                    }
                    if (typedOffset >= textBuffer.getLength()) break block18;
                    if (textBuffer.getChar(typedOffset) != '}') {
                        break block18;
                    }
                    int currentLineStart = lineMap.getLineStartOffset(currentLine);
                    int whitespaceEnd = this.firstNonWhitespaceOffset(textBuffer, currentLineStart, typedOffset);
                    if (whitespaceEnd != typedOffset) {
                        break block18;
                    }
                    BraceProvider braceProvider = this.getBraceProvider();
                    if (braceProvider == null) {
                        break block18;
                    }
                    NumberRange braceLocation = new NumberRange(0, 0);
                    NumberRange matchingLocation = new NumberRange(0, 0);
                    int braceType = braceProvider.isPartOfBrace(typedOffset, braceLocation);
                    if (braceType == -1) {
                        throw new IllegalStateException("could not get brace");
                    }
                    int matchResult = braceProvider.findMatchingBrace(braceType, braceLocation, matchingLocation);
                    if (matchResult == 3) {
                        break block18;
                    }
                    int matchingOffset = matchingLocation.start;
                    int matchingLine = lineMap.getLineFromOffset(matchingOffset);
                    int matchingLineStart = lineMap.getLineStartOffset(matchingLine);
                    int matchingLineEnd = lineMap.getLineEndOffset(matchingLine);
                    int tabSize = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean useTabs = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int firstOffset = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)matchingLineStart, (int)matchingLineEnd);
                    if (firstOffset == -1) {
                        throw new IllegalStateException("unexpected empty line");
                    }
                    int firstColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)matchingLine, (int)firstOffset, (int)tabSize);
                    if (firstColumn == (currentColumn = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)currentLine, (int)typedOffset, (int)tabSize))) {
                        break block18;
                    }
                    String newIndent = BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)firstColumn);
                    this.editor.beginEdit(alignBraceDescriptor);
                    try {
                        try {
                            int oldIndentSize = typedOffset - currentLineStart;
                            document.remove(currentLineStart, oldIndentSize);
                            document.insertString(currentLineStart, newIndent, null);
                        }
                        catch (BadLocationException e) {}
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                finally {
                    document.writeUnlock();
                }
            }
        }
    }

    private void delete_preAutoRemoveQuoteEnd() {
        this.isEmptyQuotes = false;
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        BasicDocument document = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        document.readLock();
        try {
            int caretToken = this.getCaretToken();
            if (caretToken == 5 || caretToken == 4) {
                char endChar;
                char startChar;
                int tokenStart = this.getCaretTokenStart();
                int caretOffset = this.editor.getCaretPosition();
                if (caretOffset - 1 == tokenStart && caretOffset < textBuffer.getLength() && (startChar = textBuffer.getChar(tokenStart)) == (endChar = textBuffer.getChar(caretOffset))) {
                    this.isEmptyQuotes = true;
                }
            }
        }
        finally {
            document.readUnlock();
        }
    }

    private void delete_doAutoRemoveQuoteEnd() {
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        if (this.isEmptyQuotes) {
            this.isEmptyQuotes = false;
            BasicDocument document = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            this.editor.beginEdit(quoteEndDescriptor);
            try {
                try {
                    int caretOffset = this.editor.getCaretPosition();
                    if (caretOffset < textBuffer.getLength()) {
                        document.remove(caretOffset, 1);
                    }
                }
                catch (BadLocationException e) {}
            }
            finally {
                this.editor.endEdit(true);
            }
        }
    }

    private void charTyped_doAutoQuoteEnd(int typedOffset, char typedChar) {
        block18: {
            if (!this.isAutoQuoteEndEnabled()) {
                return;
            }
            BasicDocument document = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            document.writeLock();
            try {
                int caretOffset;
                int caretToken = this.getCaretToken();
                if (typedChar == '\'' && caretToken == 5 || typedChar == '\"' && caretToken == 4) {
                    char nextChar;
                    int tokenStart = this.getCaretTokenStart();
                    if (tokenStart != typedOffset) {
                        return;
                    }
                    int caretOffset2 = this.editor.getCaretPosition();
                    boolean trailingIdentifier = false;
                    if (caretOffset2 < textBuffer.getLength() && Character.isJavaIdentifierPart(nextChar = textBuffer.getChar(caretOffset2))) {
                        trailingIdentifier = true;
                    }
                    if (trailingIdentifier) break block18;
                    this.editor.beginEdit(quoteEndDescriptor);
                    try {
                        try {
                            document.insertString(caretOffset2, Character.toString(typedChar), null);
                            this.editor.setCaretPosition(caretOffset2);
                        }
                        catch (BadLocationException e) {}
                        break block18;
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                if (caretToken != 0 || typedChar != '\'' && typedChar != '\"' || (caretOffset = this.editor.getCaretPosition()) >= textBuffer.getLength() || textBuffer.getChar(caretOffset) != typedChar) break block18;
                this.editor.beginEdit(quoteEndDescriptor);
                try {
                    try {
                        document.remove(caretOffset, 1);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    this.editor.endEdit(true);
                }
            }
            finally {
                document.writeUnlock();
            }
        }
    }

    private void enterKey_preAutoQuoteExtend() {
        this.shouldExtendQuotes = false;
        if (!this.isAutoQuoteExtendEnabled()) {
            return;
        }
        BasicDocument document = this.getDocument();
        document.readLock();
        try {
            int caretToken = this.getCaretToken();
            if (caretToken == 4) {
                this.shouldExtendQuotes = true;
            }
        }
        finally {
            document.readUnlock();
        }
    }

    private void enterKey_doAutoQuoteExtend() {
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        if (this.shouldExtendQuotes) {
            this.shouldExtendQuotes = false;
            int currentLine = this.editor.getLineFromOffset(this.editor.getCaretPosition());
            if (this.lastInvokedLine + 1 != currentLine) {
                return;
            }
            this.editor.beginEdit(quoteExtendDescriptor);
            try {
                try {
                    BasicDocument document = this.getDocument();
                    document.insertString(this.editor.getCaretPosition(), "\"", null);
                    document.insertString(this.lastInvokedOffset, "\" +", null);
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                this.editor.endEdit(true);
            }
        }
    }

    private void delete_preAutoRemoveParenEnd() {
        this.isEmptyParens = false;
        if (!this.isAutoParenEndEnabled()) {
            return;
        }
        BasicDocument document = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        document.readLock();
        try {
            int closeOffset;
            int openOffset;
            int caretToken = this.getCaretToken();
            if (caretToken == 0 && (openOffset = (closeOffset = this.editor.getCaretPosition()) - 1) >= 0 && closeOffset < textBuffer.getLength()) {
                char openChar = textBuffer.getChar(openOffset);
                char closeChar = textBuffer.getChar(closeOffset);
                if (openChar == '(' && closeChar == ')' || openChar == '[' && closeChar == ']') {
                    this.isEmptyParens = true;
                }
            }
        }
        finally {
            document.readUnlock();
        }
    }

    private void delete_doAutoRemoveParenEnd() {
        if (!this.isAutoParenEndEnabled()) {
            return;
        }
        if (this.isEmptyParens) {
            this.isEmptyParens = false;
            BasicDocument document = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            this.editor.beginEdit(quoteEndDescriptor);
            try {
                try {
                    int caretOffset = this.editor.getCaretPosition();
                    if (caretOffset < textBuffer.getLength()) {
                        char closeChar = textBuffer.getChar(caretOffset);
                        document.remove(caretOffset, 1);
                        this.removeTracker(caretOffset, closeChar);
                    }
                }
                catch (BadLocationException e) {}
            }
            finally {
                this.editor.endEdit(true);
            }
        }
    }

    private void charTyped_doAutoParenEnd(int typedOffset, char typedChar) {
        block28: {
            if (!this.isAutoParenEndEnabled()) {
                return;
            }
            BasicDocument document = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            document.writeLock();
            try {
                boolean isBalanced;
                int caretOffset;
                block30: {
                    NumberRange matchingLocation;
                    NumberRange braceLocation;
                    int braceType;
                    int matchResult;
                    if (this.caretToken != 0) break block28;
                    if (typedChar == '(' || typedChar == '[') {
                        int caretOffset2 = this.editor.getCaretPosition();
                        if (typedChar == '(') {
                            int line = lineMap.getLineFromOffset(caretOffset2);
                            int endOffset = lineMap.getLineEndOffset(line);
                            this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                            this.lexer.setPosition(caretOffset2);
                            int token = this.lexer.lex(this.lexerToken);
                            int tokenStart = this.lexerToken.getStartOffset();
                            if (tokenStart < endOffset && this.skipCloseParenGeneration(token)) {
                                return;
                            }
                        }
                        char closeChar = typedChar == '(' ? (char)')' : ']';
                        this.editor.beginEdit(parenEndDescriptor);
                        try {
                            try {
                                document.insertString(caretOffset2, Character.toString(closeChar), null);
                                this.editor.setCaretPosition(caretOffset2);
                                this.addTracker(caretOffset2, closeChar);
                            }
                            catch (BadLocationException e) {}
                            break block28;
                        }
                        finally {
                            this.editor.endEdit(true);
                        }
                    }
                    if (typedChar != ')' && typedChar != ']' || (caretOffset = this.editor.getCaretPosition()) >= textBuffer.getLength() || textBuffer.getChar(caretOffset) != typedChar) break block28;
                    boolean hasAutoClose = this.hasTracker(caretOffset, typedChar);
                    if (hasAutoClose) {
                        this.editor.beginEdit(quoteEndDescriptor);
                        try {
                            try {
                                document.remove(caretOffset, 1);
                            }
                            catch (BadLocationException e) {}
                        }
                        finally {
                            this.editor.endEdit(true);
                        }
                        return;
                    }
                    BraceProvider braceProvider = this.getBraceProvider();
                    if (braceProvider == null) {
                        return;
                    }
                    this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                    this.lexer.setPosition(caretOffset);
                    int expectedToken = typedChar == ')' ? this.getRightParenToken() : this.getRightBracketToken();
                    isBalanced = true;
                    do {
                        int token = this.lexer.lex(this.lexerToken);
                        int tokenStart = this.lexerToken.getStartOffset();
                        if (token != expectedToken) break block30;
                        braceLocation = new NumberRange(0, 0);
                        matchingLocation = new NumberRange(0, 0);
                        braceType = braceProvider.isPartOfBrace(tokenStart, braceLocation);
                        if (braceType != -1) continue;
                        throw new IllegalStateException("could not get brace");
                    } while ((matchResult = braceProvider.findMatchingBrace(braceType, braceLocation, matchingLocation)) != 3);
                    isBalanced = false;
                }
                if (isBalanced) break block28;
                this.editor.beginEdit(quoteEndDescriptor);
                try {
                    try {
                        document.remove(caretOffset, 1);
                    }
                    catch (BadLocationException e) {}
                }
                finally {
                    this.editor.endEdit(true);
                }
            }
            finally {
                document.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTracker(int offset, char closeChar) {
        TextBuffer textBuffer = this.getTextBuffer();
        OffsetMark front = textBuffer.addOffsetMark(offset, true);
        OffsetMark back = textBuffer.addOffsetMark(offset + 1, false);
        EndTracker tracker = new EndTracker(closeChar, front, back, null);
        List list = this._trackerList;
        synchronized (list) {
            this._trackerList.add(tracker);
        }
    }

    private boolean hasTracker(int offset, char closeChar) {
        EndTracker tracker = this.findTracker(offset, closeChar);
        boolean hasTracker = tracker != null;
        return hasTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTracker(int offset, char closeChar) {
        EndTracker tracker = this.findTracker(offset, closeChar);
        if (tracker != null) {
            List list = this._trackerList;
            synchronized (list) {
                this._trackerList.remove(tracker);
                this.freeTracker(tracker);
            }
        }
    }

    private void freeTracker(EndTracker tracker) {
        TextBuffer textBuffer = this.getTextBuffer();
        if (tracker != null) {
            textBuffer.removeOffsetMark(EndTracker.ra$front(tracker));
            textBuffer.removeOffsetMark(EndTracker.ra$back(tracker));
            EndTracker.wa$back(tracker, null);
            EndTracker.wa$front(tracker, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndTracker findTracker(int offset, char closeChar) {
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            List list = this._trackerList;
            synchronized (list) {
                Iterator iterator = this._trackerList.iterator();
                while (iterator.hasNext()) {
                    int end;
                    EndTracker tracker = (EndTracker)iterator.next();
                    int start = EndTracker.ra$front(tracker).getOffset();
                    if (start == (end = EndTracker.ra$back(tracker).getOffset())) {
                        iterator.remove();
                        this.freeTracker(tracker);
                        continue;
                    }
                    if (start != offset || EndTracker.ra$closeChar(tracker) != closeChar) continue;
                    EndTracker endTracker = tracker;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var8_4
                    textBuffer.readUnlock();
                    return endTracker;
                }
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllTrackers() {
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            List list = this._trackerList;
            synchronized (list) {
                for (EndTracker tracker : this._trackerList) {
                    this.freeTracker(tracker);
                }
                this._trackerList.clear();
            }
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private static class EndTracker {
        private OffsetMark front;
        private OffsetMark back;
        private char closeChar;

        private EndTracker(char closeChar, OffsetMark front, OffsetMark back) {
            this.front = front;
            this.back = back;
            this.closeChar = closeChar;
        }

        static OffsetMark ra$front(EndTracker endTracker) {
            return endTracker.front;
        }

        static OffsetMark ra$back(EndTracker endTracker) {
            return endTracker.back;
        }

        static char ra$closeChar(EndTracker endTracker) {
            return endTracker.closeChar;
        }

        static void wa$back(EndTracker endTracker, OffsetMark offsetMark) {
            endTracker.back = offsetMark;
        }

        static void wa$front(EndTracker endTracker, OffsetMark offsetMark) {
            endTracker.front = offsetMark;
        }

        EndTracker(char c, OffsetMark offsetMark, OffsetMark offsetMark2, 1 var4_4) {
            this(c, offsetMark, offsetMark2);
        }

        public final class 1 {
        }
    }
}

