/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.imports;

import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.Utilities;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.JavaArb;

public abstract class AbstractSurrounder {
    protected final EditDescriptor undoDescriptor;
    protected CodingStyleOptions codingStyleOptions;
    public int startPos;
    public int endPos;
    public int surroundedStartPos;
    public int surroundedEndPos;

    protected AbstractSurrounder() {
        this.$init$();
        String undoText = JavaArb.getString(322);
        this.undoDescriptor = new EditDescriptor(undoText);
    }

    private void $init$() {
        this.codingStyleOptions = CodingStyleManager.getCodingStyleManager().getCodingStyleOptions();
    }

    protected abstract void doSurroundImpl(BasicEditorPane var1, Context var2) throws BadLocationException;

    protected abstract String getNameImpl();

    public String toString() {
        return this.getNameImpl();
    }

    public final void doSurround(BasicEditorPane editorPane, Context context) {
        editorPane.beginEdit(this.undoDescriptor);
        try {
            try {
                this.doSurroundImpl(editorPane, context);
            }
            catch (BadLocationException badLocationException) {}
        }
        finally {
            editorPane.endEdit();
        }
    }

    protected static final void blockIndent(BasicEditorPane editorPane, int start, int end) {
        editorPane.select(start, end);
        editorPane.getActionInvoker().invokeAction("block-indent");
    }

    protected static final boolean isBraceAlone() {
        CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
        CodingStyleOptions styleOptions = csm.getCodingStyleOptions();
        return styleOptions.getBlockBracePosition() == 1;
    }

    protected static final int getIndentSize(BasicEditorPane editorPane) {
        return BasicAction.getIndentSizeProperty((BasicEditorPane)editorPane);
    }

    protected static final int getTabSize(BasicEditorPane editorPane) {
        return BasicAction.getTabSizeProperty((BasicEditorPane)editorPane);
    }

    protected static final boolean getUseTabs(BasicEditorPane editorPane) {
        return BasicAction.getUseTabsProperty((BasicEditorPane)editorPane);
    }

    protected static final int getOuterIndent(BasicEditorPane editorPane) {
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        LineMap lineMap = document.getLineMap();
        TextBuffer textBuffer = document.getTextBuffer();
        int outerToUse = -1;
        int spaceToUse = -1;
        int selectStart = editorPane.getSelectionStart();
        int startLine = lineMap.getLineFromOffset(selectStart);
        int selectEnd = editorPane.getSelectionEnd();
        int endLine = lineMap.getLineFromOffset(selectEnd);
        boolean useTabs = AbstractSurrounder.getUseTabs(editorPane);
        int tabSize = AbstractSurrounder.getTabSize(editorPane);
        int i = startLine;
        while (i <= endLine) {
            int lineEnd;
            int lineStart = lineMap.getLineStartOffset(i);
            int indentEndOffset = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)lineStart, (int)(lineEnd = lineMap.getLineEndOffset(i)));
            if (indentEndOffset == -1) {
                int realLineEnd = lineEnd == textBuffer.getLength() ? lineEnd : lineEnd - 1;
                int foundSpace = lineEnd - lineStart;
                if (foundSpace > 0 && spaceToUse == -1) {
                    spaceToUse = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)i, (int)indentEndOffset, (int)tabSize);
                }
            } else {
                outerToUse = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)i, (int)indentEndOffset, (int)tabSize);
                break;
            }
            ++i;
        }
        spaceToUse = Math.max(spaceToUse, 0);
        if (outerToUse == -1) {
            outerToUse = spaceToUse;
        }
        return outerToUse;
    }

    protected static final String getIndentString(BasicEditorPane editorPane, int indent) {
        boolean useTabs = AbstractSurrounder.getUseTabs(editorPane);
        int tabSize = AbstractSurrounder.getTabSize(editorPane);
        return BasicAction.buildIndent((boolean)useTabs, (int)tabSize, (int)indent);
    }
}

