/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.imports;

import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.java.imports.AbstractSurrounder;
import oracle.jdevimpl.java.JavaArb;

public abstract class AbstractTryCatchFinallySurrounder
extends AbstractSurrounder {
    public static final int TRY_CATCH = 1;
    public static final int TRY_FINALLY = 2;
    public static final int TRY_CATCH_FINALLY = 3;
    private int type;

    public AbstractTryCatchFinallySurrounder(int type) {
        this.type = type;
    }

    protected abstract String[] getExceptions();

    protected String getNameImpl() {
        switch (this.type) {
            case 1: {
                return JavaArb.getString(252);
            }
            case 2: {
                return JavaArb.getString(152);
            }
            case 3: {
                return JavaArb.getString(22);
            }
        }
        throw new IllegalStateException("unknown type: " + this.type);
    }

    protected void doSurroundImpl(BasicEditorPane editorPane, Context context) throws BadLocationException {
        StringBuffer buffer;
        int blockStart;
        int outer = AbstractTryCatchFinallySurrounder.getOuterIndent(editorPane);
        String outerIndent = AbstractTryCatchFinallySurrounder.getIndentString(editorPane, outer);
        int nested = outer + AbstractTryCatchFinallySurrounder.getIndentSize(editorPane);
        String nestedIndent = AbstractTryCatchFinallySurrounder.getIndentString(editorPane, nested);
        boolean braceAlone = AbstractTryCatchFinallySurrounder.isBraceAlone();
        BasicDocument document = (BasicDocument)editorPane.getDocument();
        LineMap lineMap = document.getLineMap();
        String openBraceText = (braceAlone ? "\n" + outerIndent : " ") + "{\n";
        String closeBraceText = outerIndent + "}\n";
        String caretMarker = nestedIndent + "|\n";
        int selectStart = this.startPos;
        int startLine = lineMap.getLineFromOffset(selectStart);
        this.surroundedStartPos = blockStart = lineMap.getLineStartOffset(startLine);
        int selectEnd = this.endPos;
        int endLine = lineMap.getLineFromOffset(selectEnd - 1);
        endLine = Math.max(endLine, startLine);
        int blockEnd = lineMap.getLineEndOffset(endLine);
        AbstractTryCatchFinallySurrounder.blockIndent(editorPane, blockStart, blockEnd);
        this.surroundedEndPos = blockEnd = lineMap.getLineEndOffset(endLine);
        String statement = "System.out.println(\"hi\")";
        if (this.type == 2 || this.type == 3) {
            buffer = new StringBuffer();
            buffer.append(outerIndent);
            buffer.append("finally");
            buffer.append(openBraceText);
            buffer.append(caretMarker);
            buffer.append(closeBraceText);
            int caretAdjust = buffer.indexOf("|");
            buffer.replace(caretAdjust, caretAdjust + 1, "");
            String finallyText = buffer.toString();
            document.insertString(blockEnd, finallyText, null);
            this.surroundedEndPos += finallyText.length();
            if (this.type == 2) {
                editorPane.setCaretPositionCenter(blockEnd + caretAdjust);
            }
        }
        if (this.type == 1 || this.type == 3) {
            String[] exceptions = this.getExceptions();
            int numExceptions = exceptions.length;
            buffer = new StringBuffer();
            int i = 0;
            while (i < numExceptions) {
                buffer.append(outerIndent);
                buffer.append("catch (");
                buffer.append(exceptions[i]);
                if (!"".equals(exceptions[i])) {
                    buffer.append(" ");
                }
                buffer.append("e)");
                buffer.append(openBraceText);
                if (i == 0) {
                    buffer.append(caretMarker);
                } else {
                    buffer.append(nestedIndent);
                    buffer.append("\n");
                }
                buffer.append(closeBraceText);
                ++i;
            }
            int caretAdjust = buffer.indexOf("|");
            buffer.replace(caretAdjust, caretAdjust + 1, "");
            String catchText = buffer.toString();
            document.insertString(blockEnd, catchText, null);
            this.surroundedEndPos += catchText.length();
            editorPane.setCaretPositionCenter(blockEnd + caretAdjust);
        }
        buffer = new StringBuffer();
        buffer.append(outerIndent);
        buffer.append("try");
        buffer.append(openBraceText);
        document.insertString(blockEnd, closeBraceText, null);
        this.surroundedEndPos += closeBraceText.length() - 1;
        document.insertString(blockStart, buffer.toString(), null);
        this.surroundedEndPos += buffer.length();
    }
}

