/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.index;

import javax.swing.text.Segment;
import oracle.ide.index.DataCollector;
import oracle.ide.index.IndexingContext;
import oracle.ide.index.keyword.KeywordIndexer;
import oracle.ideimpl.index.util.CharArrayPool;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;

public class JavaIndexer
extends KeywordIndexer {
    public static final String EXTENDS_OR_IMPLEMENTS = "java.extends.or.implements";
    public static final String ANNOTATION = "java.annotation";
    public static final int FLAG_COMMENT = 65536;
    public static final int FLAG_LITERAL = 131072;
    public static final int FLAG_SQLJ = 262144;
    private static final int DATA_TYPE_KEYWORD = 0;
    private static final int DATA_TYPE_EXTENDS_OR_IMPLEMENTS = 1;
    private static final int DATA_TYPE_ANNOTATION = 2;
    private static String[] DATA_KEYS = new String[]{"keyword.contains", "java.extends.or.implements", "java.annotation"};

    public void index(IndexingContext context, DataCollector data) {
        int filterType = -1;
        char[] filter = null;
        Object filterKey = context.getFilterKey();
        if (filterKey != null) {
            if ("keyword.contains".equals(filterKey)) {
                filterType = 0;
            } else if (EXTENDS_OR_IMPLEMENTS.equals(filterKey)) {
                filterType = 1;
            } else if (ANNOTATION.equals(filterKey)) {
                filterType = 2;
            } else {
                return;
            }
            if (filterType != -1) {
                String filterString = (String)context.getFilterValue();
                filter = filterString.toCharArray();
            }
        }
        Segment segment = new Segment();
        JavaLexer lexer = new JavaLexer();
        TextBuffer buffer = context.getTextBuffer();
        lexer.setTextBuffer((ReadTextBuffer)buffer);
        lexer.setSkipComments(false);
        lexer.setRecognizeSQLJ(true);
        LexerToken lexerToken = lexer.createLexerToken();
        block8: while (true) {
            int token = lexer.lex(lexerToken);
            int tokenStart = lexerToken.getStartOffset();
            int tokenEnd = lexerToken.getEndOffset();
            if (token == 0) {
                return;
            }
            switch (token) {
                case 24: 
                case 25: 
                case 26: {
                    this.scanText((ReadTextBuffer)buffer, filterType, filter, 65536, tokenStart, tokenEnd, data, segment);
                    continue block8;
                }
                case 14: {
                    this.scanText((ReadTextBuffer)buffer, filterType, filter, 131072, tokenStart, tokenEnd, data, segment);
                    continue block8;
                }
                case 6: {
                    this.scanText((ReadTextBuffer)buffer, filterType, filter, 262144, tokenStart, tokenEnd, data, segment);
                    continue block8;
                }
                case 4: {
                    buffer.getText(tokenStart, tokenEnd - tokenStart, segment);
                    int hash = data.hash(segment);
                    this.report(data, (ReadTextBuffer)buffer, tokenStart, tokenEnd, 0, filterType, filter, hash, 0, segment);
                    continue block8;
                }
                case 79: {
                    this.handleAnnotation((ReadTextBuffer)buffer, tokenEnd, filterType, filter, data, segment);
                    continue block8;
                }
                case 110: 
                case 117: {
                    this.handleExtendsOrImplements((ReadTextBuffer)buffer, tokenEnd, filterType, filter, data, segment);
                    continue block8;
                }
            }
        }
    }

    private void handleAnnotation(ReadTextBuffer buffer, int offset, int filterType, char[] filter, DataCollector data, Segment segment) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(offset);
        int lastIdStart = -1;
        int lastIdEnd = -1;
        boolean lastTokenWasDot = true;
        LexerToken lexerToken = lexer.createLexerToken();
        while (true) {
            int token;
            if ((token = lexer.lex(lexerToken)) == 4) {
                if (!lastTokenWasDot) break;
                lastIdStart = lexerToken.getStartOffset();
                lastIdEnd = lexerToken.getEndOffset();
                lastTokenWasDot = false;
                continue;
            }
            if (token != 43) break;
            lastTokenWasDot = true;
        }
        if (lastIdStart >= 0) {
            buffer.getText(lastIdStart, lastIdEnd - lastIdStart, segment);
            int hash = data.hash(segment);
            this.report(data, buffer, lastIdStart, lastIdEnd, 2, filterType, filter, hash, 0, segment);
        }
    }

    private void handleExtendsOrImplements(ReadTextBuffer buffer, int offset, int filterType, char[] filter, DataCollector data, Segment segment) {
        JavaLexer lexer = new JavaLexer();
        lexer.setTextBuffer(buffer);
        lexer.setSkipComments(true);
        lexer.setPosition(offset);
        int lastIdStart = -1;
        int lastIdEnd = -1;
        LexerToken lexerToken = lexer.createLexerToken();
        while (true) {
            int token;
            if ((token = lexer.lex(lexerToken)) == 4) {
                lastIdStart = lexerToken.getStartOffset();
                lastIdEnd = lexerToken.getEndOffset();
                continue;
            }
            if (token == 43) continue;
            if (lastIdStart >= 0) {
                buffer.getText(lastIdStart, lastIdEnd - lastIdStart, segment);
                int hash = data.hash(segment);
                this.report(data, buffer, lastIdStart, lastIdEnd, 1, filterType, filter, hash, 0, segment);
                lastIdStart = -1;
                lastIdEnd = -1;
            }
            if (token != 39 && token != 110 && token != 117) break;
        }
    }

    public void scanText(ReadTextBuffer buffer, int filterType, char[] filter, int flags, int startOffset, int endOffset, DataCollector data, Segment segment) {
        int pos = startOffset;
        int start = -1;
        int end = -1;
        int hash = 0;
        boolean recognizeEscapes = (flags & 0x20000) != 0;
        while (pos < endOffset) {
            char c = buffer.getChar(pos);
            if (start == -1) {
                if (c < '\u0100' && KeywordIndexer.IDENTIFIER_START[c] || Character.isJavaIdentifierStart(c)) {
                    start = pos;
                    hash = data.hash(0, c);
                }
            } else if (!(c < '\u0100' && KeywordIndexer.IDENTIFIER_PART[c] || Character.isJavaIdentifierPart(c))) {
                end = pos;
            } else {
                hash = data.hash(hash, c);
            }
            if (c == '\\' && ++pos < buffer.getLength()) {
                char c2 = buffer.getChar(pos);
                switch (c2) {
                    case '\"': 
                    case '\'': 
                    case '\\': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        if (!recognizeEscapes) break;
                        ++pos;
                        break;
                    }
                    case 'u': {
                        pos += 5;
                        break;
                    }
                }
            }
            if (start == -1) continue;
            if (end == -1 && pos >= endOffset) {
                end = endOffset;
            }
            if (end == -1) continue;
            this.report(data, buffer, start, end, 0, filterType, filter, hash, flags, segment);
            start = -1;
            end = -1;
        }
    }

    protected void report(DataCollector data, ReadTextBuffer buffer, int start, int end, int dataType, int filterType, char[] filter, int hash, int flags, Segment segment) {
        if (this.filter(buffer, start, end, dataType, filterType, filter, segment)) {
            data.add(DATA_KEYS[dataType], hash, flags, start, end);
        }
    }

    protected boolean filter(ReadTextBuffer buffer, int start, int end, int dataType, int filterType, char[] filter, Segment segment) {
        if (filter == null) {
            return true;
        }
        if (filterType != dataType) {
            return false;
        }
        buffer.getText(start, end - start, segment);
        return CharArrayPool.CHAR_ARRAY_COMPARATOR.compare(filter, segment) == 0;
    }
}

