/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.ide.util.BitField;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceDotExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceSimpleNameExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceForStatement;
import oracle.jdeveloper.java.util.NamingUtil;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VariableNaming {
    public static final NameFormater FIELD_FORMATER = new NameFormater(NameFormater.ra$TYPE_FIELD(), null);
    public static final NameFormater CONSTANT_FORMATER = new NameFormater(NameFormater.ra$TYPE_CONSTANT(), null);
    public static final NameFormater VARIABLE_FORMATER = new NameFormater(NameFormater.ra$TYPE_VARIABLE(), null);
    public static final NameFormater PARAMETER_FORMATER = new NameFormater(NameFormater.ra$TYPE_PARAM(), null);
    private static HashMap _altNames;

    private VariableNaming() {
    }

    public static boolean canIntroduceVariable(SourceElement sourceElement, String variableName) {
        SourceElement scope;
        boolean ret = true;
        ret = VariableNaming.isNameDefinedInParents(sourceElement.getParent(), sourceElement, variableName) ? false : (VariableNaming.isNameDefinedInChildren(scope = VariableNaming.getNameInChildrenScope(sourceElement), variableName) ? false : VariableNaming.fieldShadowing(scope, variableName) ^ true);
        return ret;
    }

    private static SourceElement getNameInChildrenScope(SourceElement sourceElement) {
        switch (sourceElement.getSymbolKind()) {
            case 2: 
            case 9: 
            case 18: {
                return sourceElement;
            }
            case 3: {
                return sourceElement;
            }
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                SourceBlock sourceBlock = sourceMethod.getBlock();
                if (sourceBlock != null) {
                    return sourceBlock;
                }
                return sourceMethod;
            }
        }
        return VariableNaming.getNameInChildrenScope(sourceElement.getParent());
    }

    private static boolean isNameDefinedInChildren(SourceElement sourceElement, String variableName) {
        boolean ret = false;
        List children = sourceElement.getChildren();
        int i = 0;
        while (!ret && i < children.size()) {
            SourceElement child = (SourceElement)children.get(i);
            switch (child.getSymbolKind()) {
                case 17: {
                    SourceLocalVariable sourceLocalVariable = (SourceLocalVariable)child;
                    if (!variableName.equals(sourceLocalVariable.getName())) break;
                    ret = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    ret = VariableNaming.isNameDefinedInChildren(child, variableName);
                    break;
                }
            }
            ++i;
        }
        return ret;
    }

    private static boolean isNameDefinedInParents(SourceElement scope, SourceElement skipChild, String variableName) {
        boolean ret = false;
        if (scope.getSymbolKind() != 4) {
            List children = scope.getChildren();
            int i = 0;
            while (!ret && i < children.size()) {
                SourceElement child = (SourceElement)children.get(i);
                if (skipChild != child && child.getSymbolKind() == 18) {
                    SourceLocalVariableDeclaration sourceLocalVariableDeclaration = (SourceLocalVariableDeclaration)child;
                    List variables = sourceLocalVariableDeclaration.getVariables();
                    int j = 0;
                    while (j < variables.size()) {
                        SourceVariable sourceVariable = (SourceVariable)variables.get(j);
                        if (sourceVariable != null && variableName.equals(sourceVariable)) {
                            ret = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            if (!ret) {
                ret = VariableNaming.isNameDefinedInParents(scope.getParent(), scope, variableName);
            }
        }
        return ret;
    }

    public static List<String> suggestNamesFromCamelWord(String shortName) {
        return VariableNaming.suggestNamesFromCamelWord(shortName, null);
    }

    public static List<String> suggestNamesFromCamelWord(String shortName, NameFormater nameFormater) {
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < shortName.length()) {
            char c = shortName.charAt(i);
            if (i == 0 || Character.isUpperCase(c)) {
                String formatedName;
                String name = Character.toLowerCase(c) + shortName.substring(i + 1);
                String string = formatedName = nameFormater == null ? name : nameFormater.toString(name);
                if (!NamingUtil.isJavaReservedWord((String)formatedName)) {
                    names.add(formatedName);
                } else {
                    String altName = VariableNaming.getAltName(formatedName);
                    if (altName != null) {
                        names.add(altName);
                    }
                }
            }
            ++i;
        }
        ArrayList<String> ret = new ArrayList<String>(names);
        Collections.sort(ret);
        return ret;
    }

    private static Collection<String> suggestNamesFromCamelWord(String shortName, Collection<String> excludeNames, NameFormater nameFormater) {
        List<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(shortName, nameFormater);
        suggestedNames.removeAll(excludeNames);
        return suggestedNames;
    }

    private static String getAltName(String name) {
        if (_altNames == null) {
            _altNames = new HashMap();
            _altNames.put("boolean", "b");
            _altNames.put("byte", "i");
            _altNames.put("short", "i");
            _altNames.put("int", "i");
            _altNames.put("long", "i");
            _altNames.put("char", "c");
            _altNames.put("float", "f");
            _altNames.put("double", "f");
            _altNames.put("class", "cls");
        }
        return (String)_altNames.get(name);
    }

    public static List<String> suggestVariableNames(SourceElement sourceElement, String typeName) {
        return VariableNaming.suggestNames(sourceElement, typeName, VARIABLE_FORMATER);
    }

    public static List<String> suggestParameterNames(SourceElement sourceElement, String typeName) {
        return VariableNaming.suggestNames(sourceElement, typeName, PARAMETER_FORMATER);
    }

    public static List<String> suggestFieldNames(SourceElement sourceElement, String typeName) {
        return VariableNaming.suggestNames(sourceElement, typeName, FIELD_FORMATER);
    }

    public static List<String> suggestConstantNames(SourceElement sourceElement, String typeName) {
        return VariableNaming.suggestNames(sourceElement, typeName, CONSTANT_FORMATER);
    }

    private static ArrayList<String> suggestNames(SourceElement sourceElement, String typeName, NameFormater nameFormater) {
        HashSet<String> set = new HashSet<String>();
        HashSet<String> existingNames = new HashSet<String>();
        VariableNaming.fillWithParentVariableDeclaration(sourceElement, existingNames);
        VariableNaming.fillWithMembers(sourceElement, existingNames);
        int nodeID = sourceElement.getSymbolKind();
        switch (nodeID) {
            case 53: {
                SourceMethodCallExpression sourceMethodCallExpression = (SourceMethodCallExpression)sourceElement;
                String methodName = sourceMethodCallExpression.getName();
                if (VariableNaming.suggestNamesForAccessor(set, methodName, "get", true, existingNames, nameFormater) || VariableNaming.suggestNamesForAccessor(set, methodName, "is", false, existingNames, nameFormater) || VariableNaming.suggestNamesForAccessor(set, methodName, "has", false, existingNames, nameFormater) || VariableNaming.suggestNamesForAccessor(set, methodName, "can", false, existingNames, nameFormater)) break;
                Collection<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(methodName, existingNames, nameFormater);
                set.addAll(suggestedNames);
                break;
            }
            case 49: {
                SourceDotExpression sourceDotExpression = (SourceDotExpression)sourceElement;
                VariableNaming.suggestNameForFieldAccess(nameFormater, existingNames, set, sourceDotExpression);
                break;
            }
            default: {
                String formatedName;
                if (!(sourceElement instanceof SourceHasName)) break;
                SourceHasName sourceHasName = (SourceHasName)sourceElement;
                String name = VariableNaming.getBaseName(sourceHasName);
                String string = formatedName = nameFormater == null ? name : nameFormater.toString(name);
                if (existingNames.contains(formatedName)) break;
                set.add(formatedName);
                break;
            }
        }
        if (typeName != null) {
            int firstLt;
            int firstBracket;
            int lastDollar;
            int lastDot = typeName.lastIndexOf(46);
            if (lastDot >= 0) {
                typeName = typeName.substring(lastDot + 1);
            }
            if ((lastDollar = typeName.lastIndexOf(36)) >= 0) {
                typeName = typeName.substring(lastDollar + 1);
            }
            if ((firstBracket = typeName.indexOf(91)) >= 0) {
                typeName = typeName.substring(0, firstBracket);
            }
            if ((firstLt = typeName.indexOf(60)) >= 0) {
                typeName = typeName.substring(0, firstLt);
            }
            Collection<String> typeNames = VariableNaming.suggestNamesFromCamelWord(typeName, existingNames, nameFormater);
            set.addAll(typeNames);
        }
        ArrayList<String> ret = new ArrayList<String>(set);
        Collections.sort(ret);
        return ret;
    }

    private static String getBaseName(SourceHasName sourceHasName) {
        String ret = sourceHasName.getName();
        if (sourceHasName instanceof SourceSimpleNameExpression) {
            CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
            CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
            String[][] fixes = new String[][]{{codingStyleOptions.getFieldPrefix(), codingStyleOptions.getFieldSuffix()}, {codingStyleOptions.getStaticFieldPrefix(), codingStyleOptions.getStaticFieldSuffix()}, {codingStyleOptions.getParameterPrefix(), codingStyleOptions.getParameterSuffix()}, {codingStyleOptions.getLocalVariablePrefix(), codingStyleOptions.getLocalVariableSuffix()}};
            boolean check = false;
            int i = 0;
            while (!check && i < fixes.length) {
                String[] fix = fixes[i];
                if (fix[0] != null && ret.startsWith(fix[0]) || fix[1] != null && ret.endsWith(fix[1])) {
                    check = true;
                }
                ++i;
            }
            if (check) {
                int fixNo;
                SourceSimpleNameExpression sourceSimpleNameExpression = (SourceSimpleNameExpression)sourceHasName;
                JavaHasType resolvedObject = sourceSimpleNameExpression.getResolvedObject();
                switch (resolvedObject.getElementKind()) {
                    case 5: {
                        JavaField javaField = (JavaField)resolvedObject;
                        fixNo = javaField.isStatic() ? 1 : 0;
                        break;
                    }
                    case 7: {
                        JavaLocalVariable javaLocalVariable = (JavaLocalVariable)resolvedObject;
                        SourceVariable sourceVariable = (SourceVariable)javaLocalVariable.getSourceElement();
                        fixNo = sourceVariable.getSymbolKind() == 13 ? 2 : 3;
                        break;
                    }
                    default: {
                        fixNo = -1;
                        break;
                    }
                }
                String[] fix = fixes[fixNo];
                String prefix = fix[0];
                String suffix = fix[1];
                if (prefix != null && ret.startsWith(prefix)) {
                    ret = ret.substring(prefix.length());
                }
                if (suffix != null && ret.endsWith(suffix)) {
                    ret = ret.substring(0, ret.length() - suffix.length());
                }
            }
        }
        return ret;
    }

    private static void suggestNameForFieldAccess(NameFormater nameFormater, HashSet existingNames, Collection ret, SourceDotExpression sourceDotExpression) {
        String name = sourceDotExpression.getName();
        int lastUnderscorePos = name.lastIndexOf(95);
        if ((name = name.substring(lastUnderscorePos + 1)).length() > 0) {
            Collection<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(name, existingNames, nameFormater);
            ret.addAll(suggestedNames);
        }
    }

    private static boolean suggestNamesForAccessor(Collection ret, String methodName, String accessorPrefix, boolean removePrefix, HashSet existingNames, NameFormater nameFormater) {
        if (methodName.startsWith(accessorPrefix)) {
            String baseName = removePrefix ? methodName.substring(accessorPrefix.length()) : methodName;
            Collection<String> suggestedNames = VariableNaming.suggestNamesFromCamelWord(baseName, existingNames, nameFormater);
            ret.addAll(suggestedNames);
            return true;
        }
        return false;
    }

    private static SourceClass getClassParent(SourceElement sourceElement) {
        while (sourceElement != null) {
            if (sourceElement instanceof SourceClass) {
                return (SourceClass)sourceElement;
            }
            sourceElement = sourceElement.getParent();
        }
        return null;
    }

    private static void fillWithMembers(SourceElement element, HashSet existingNames) {
        SourceClass sourceClass = VariableNaming.getClassParent(element);
        while (sourceClass != null) {
            Collection declaredFields = sourceClass.getDeclaredFields();
            for (JavaField javaField : declaredFields) {
                String fieldName = javaField.getName();
                existingNames.add(fieldName);
            }
            sourceClass = sourceClass.getSuperclass();
        }
    }

    public static void fillWithParentVariableDeclaration(SourceElement sourceElement, HashSet<String> existingNames) {
        while (sourceElement != null) {
            int nodeID = sourceElement.getSymbolKind();
            if (nodeID == 19 || nodeID == 5 || nodeID == 6) {
                return;
            }
            SourceElement parent = sourceElement.getParent();
            if (parent != null) {
                VariableNaming.fillWithVariableDeclarations(parent, existingNames);
                SourceElement[] containedElements = parent.getContainedElements();
                int i = 0;
                while (i < containedElements.length) {
                    SourceElement containedElement = containedElements[i];
                    if (containedElement != sourceElement) {
                        VariableNaming.fillWithVariableDeclarations(containedElement, existingNames);
                    }
                    ++i;
                }
            }
            sourceElement = parent;
        }
    }

    private static void fillWithVariableDeclarations(SourceElement sourceElement, HashSet existingNames) {
        int nodeID = sourceElement.getSymbolKind();
        switch (nodeID) {
            case 18: {
                SourceLocalVariableDeclaration declaration = (SourceLocalVariableDeclaration)sourceElement;
                List variables = declaration.getVariables();
                for (SourceVariable sourceVariable : variables) {
                    String localVariableName = sourceVariable.getName();
                    existingNames.add(localVariableName);
                }
                break;
            }
            case 19: {
                SourceMethod sourceMethod = (SourceMethod)sourceElement;
                Collection parameters = sourceMethod.getParameters();
                for (JavaVariable javaVariable : parameters) {
                    String paramName = javaVariable.getName();
                    existingNames.add(paramName);
                }
                break;
            }
            case 31: {
                SourceCatchClause sourceCatchClause = (SourceCatchClause)sourceElement;
                SourceVariable catchVariable = sourceCatchClause.getCatchVariable();
                String exceptionName = catchVariable.getName();
                existingNames.add(exceptionName);
                break;
            }
            case 38: {
                SourceForStatement sourceForStatement = (SourceForStatement)sourceElement;
                if (sourceForStatement.getForType() != 1) break;
                List variables = sourceForStatement.getForVariables();
                for (SourceVariable sourceVariable : variables) {
                    String variableName = sourceVariable.getName();
                    existingNames.add(variableName);
                }
                break;
            }
        }
    }

    public static String canIntroduceField(SourceElement sourceElement, String fieldName) {
        String message = null;
        if (!NamingUtil.isJavaIdentifier((String)fieldName)) {
            message = "Invalid field name";
        } else if (NamingUtil.isJavaReservedWord((String)fieldName)) {
            message = "Invalid field name";
        } else if (VariableNaming.isFieldAlreadyPresent(sourceElement, fieldName)) {
            message = MessageFormat.format("Variable {0} already exists in the current method", fieldName);
        }
        return message;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isFieldAlreadyPresent(SourceElement sourceElement, String fieldName) {
        declClass = VariableNaming.getClassParent(sourceElement.getParent());
        if (declClass.getDeclaredField(fieldName) == null) ** GOTO lbl8
        return true;
lbl-1000:
        // 1 sources

        {
            declaredField = declClass.getDeclaredField(fieldName);
            if (declaredField != null && !BitField.isSet((int)(modifiers = declaredField.getModifiers()), (int)2)) {
                return true;
            }
            declClass = declClass.getSuperclass();
lbl8:
            // 2 sources

            ** while (declClass != null)
        }
lbl9:
        // 1 sources

        return false;
    }

    private static boolean fieldShadowing(SourceElement element, String variableName) {
        SourceElement parent;
        SourceName name;
        if (element.getSymbolKind() == 20 && variableName.equals((name = (SourceName)element).getName()) && (parent = name.getParent()).getSymbolKind() != 49) {
            return true;
        }
        List children = element.getChildren();
        if (children.isEmpty()) {
            return false;
        }
        Iterator iterator = children.iterator();
        if (iterator.hasNext()) {
            SourceElement child = (SourceElement)iterator.next();
            return VariableNaming.fieldShadowing(child, variableName);
        }
        return false;
    }

    public static class NameFormater {
        private static final int TYPE_FIELD = 1;
        private static final int TYPE_CONSTANT = 2;
        private static final int TYPE_VARIABLE = 3;
        private static final int TYPE_PARAM = 4;
        private int _type;

        private NameFormater(int type) {
            this._type = type;
        }

        public String toString(String name) {
            CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
            if (codingStyleManager == null) {
                return name;
            }
            CodingStyleOptions codingStyleOptions = codingStyleManager.getCodingStyleOptions();
            name = name.substring(name.lastIndexOf(46) + 1);
            name = name.substring(name.lastIndexOf(36) + 1);
            switch (this._type) {
                case 1: {
                    name = NameFormater.lowCapName(name);
                    return codingStyleOptions.getFieldName(name);
                }
                case 2: {
                    return codingStyleOptions.getStaticFieldName(name).toUpperCase();
                }
                case 3: {
                    name = NameFormater.lowCapName(name);
                    return codingStyleOptions.getLocalVariableName(name);
                }
                case 4: {
                    name = NameFormater.lowCapName(name);
                    return codingStyleOptions.getParameterName(name);
                }
            }
            return null;
        }

        private static String lowCapName(String name) {
            name = name.length() > 1 ? Character.toLowerCase(name.charAt(0)) + name.substring(1) : Character.toString(Character.toLowerCase(name.charAt(0)));
            return name;
        }

        static int ra$TYPE_FIELD() {
            return TYPE_FIELD;
        }

        NameFormater(int n, 1 var2_2) {
            this(n);
        }

        static int ra$TYPE_CONSTANT() {
            return TYPE_CONSTANT;
        }

        static int ra$TYPE_VARIABLE() {
            return TYPE_VARIABLE;
        }

        static int ra$TYPE_PARAM() {
            return TYPE_PARAM;
        }

        public final class 1 {
        }
    }
}

