/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.javadoc;

import java.util.ArrayList;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.javadoc.TagDefs;

public class TagDescriptor
implements Copyable,
TagDefs {
    private String _name;
    private int _params;
    private String _reference;
    private int _scope;
    private boolean _custom;
    private boolean _allowDuplicates;
    private boolean _required;
    private boolean _allowsTemplate;
    private String _template;
    private String _label;

    public TagDescriptor() {
        this("", 0, 1);
    }

    public TagDescriptor(String name, int scope, int params) {
        this(name, scope, params, "", true, true, false, true, "", name);
    }

    public TagDescriptor(String name, int scope, int params, String ref, boolean custom, boolean allowsDups, boolean required, boolean allowsTemplates, String template, String label) {
        this._name = name;
        this._scope = scope;
        this._params = params;
        this._reference = ref;
        this._custom = custom;
        this._allowDuplicates = allowsDups;
        this._required = required;
        this._allowsTemplate = allowsTemplates;
        this._template = template;
        this._label = label;
    }

    public Object copyTo(Object target) {
        TagDescriptor copy = target instanceof TagDescriptor ? (TagDescriptor)target : new TagDescriptor();
        this.copyToImpl(copy);
        return copy;
    }

    private void copyToImpl(TagDescriptor copy) {
        copy._name = this._name;
        copy._params = this._params;
        copy._reference = this._reference;
        copy._scope = this._scope;
        copy._custom = this._custom;
        copy._allowDuplicates = this._allowDuplicates;
        copy._required = this._required;
        copy._allowsTemplate = this._allowsTemplate;
        copy._template = this._template;
        copy._label = this._label;
    }

    public boolean equals(TagDescriptor td) {
        return td != null && this.getName().equals(td.getName()) && this.getTemplate().equals(td.getTemplate()) && this.isCustom() == td.isCustom() && this.getParams() == td.getParams() && this.getScope() == td.getScope() && this.isRequired() == td.isRequired() && this.isAllowDuplicates() == td.isAllowDuplicates() && this.isAllowsTemplate() == td.isAllowsTemplate() && this.getLabel().equals(td.getLabel()) && this.getReference() == td.getReference();
    }

    public boolean nameAndReferenceEquals(SourceDocTag sourceDocTag) {
        return this.nameEquals(sourceDocTag) && this.referenceEquals(sourceDocTag);
    }

    public boolean equals(SourceDocTag sourceDocTag) {
        if (this.nameEquals(sourceDocTag)) {
            if (this.getParams() == 2) {
                return this.referenceEquals(sourceDocTag) && this.templateEquals(sourceDocTag);
            }
            return this.templateEquals(sourceDocTag);
        }
        return false;
    }

    private boolean nameEquals(SourceDocTag sourceDocTag) {
        String srcTagName = sourceDocTag.getName();
        if (srcTagName.equals(this.getName())) {
            return true;
        }
        if ("@throws".equals(this.getName()) && sourceDocTag.isException()) {
            return "@throws".equals(srcTagName) || "@exception".equals(srcTagName);
        }
        return false;
    }

    private boolean referenceEquals(SourceDocTag sourceDocTag) {
        if (this.getParams() == 2) {
            String reference = this.getReference();
            if (sourceDocTag.isParameter()) {
                SourceDocReference ref = sourceDocTag.getReference();
                String param = ref != null ? ref.getParameterName() : sourceDocTag.getArgumentText();
                return param.equals(reference);
            }
            if (sourceDocTag.isException()) {
                String tagText = sourceDocTag.getReferenceText();
                if (tagText == null || tagText.equals("")) {
                    return reference.equals("");
                }
                return tagText.equals(reference) || tagText.endsWith("." + reference);
            }
        }
        return true;
    }

    private boolean templateEquals(SourceDocTag sourceDocTag) {
        String template = this.getTemplate();
        if (template.length() == 0) {
            return true;
        }
        String tagText = sourceDocTag.getArgumentText();
        tagText = tagText == null ? "" : tagText.trim();
        return tagText.startsWith(template);
    }

    public SourceDocTag[] findDocTags(SourceDocTag[] tags) {
        ArrayList<SourceDocTag> tagList = new ArrayList<SourceDocTag>();
        int i = 0;
        while (i < tags.length) {
            SourceDocTag sourceDocTag = tags[i];
            if (this.equals(sourceDocTag)) {
                tagList.add(sourceDocTag);
            }
            ++i;
        }
        SourceDocTag[] found = new SourceDocTag[tagList.size()];
        tagList.toArray(found);
        return found;
    }

    public boolean tagNamesAreEqual(TagDescriptor td) {
        if (this.getParams() == 1 && this.getParams() == td.getParams()) {
            return this.getName().equals(td.getName());
        }
        return this.getName().equals(td.getName()) && this.getReference().equals(td.getReference());
    }

    public String getFullTagName() {
        String fullName = this.getName();
        if (this.getParams() == 2 && this.getReference().length() > 0) {
            fullName = fullName + " " + this.getReference();
        }
        if (this.getTemplate().length() > 0) {
            fullName = fullName + " " + this.getTemplate();
        }
        return fullName;
    }

    public String getBriefName() {
        int index;
        String n = this.getName();
        if (n.startsWith("{") && (n = n.substring((index = n.indexOf(123)) + 1)).endsWith("}")) {
            index = n.lastIndexOf(125);
            n = n.substring(0, index);
        }
        if (n.startsWith("@")) {
            int index2 = n.indexOf(64);
            n = n.substring(index2 + 1);
        }
        return n;
    }

    public String toString() {
        return this.getName();
    }

    public void setReference(String reference) {
        this._reference = reference;
    }

    public String getReference() {
        return this._reference;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    public String getLabel() {
        return this._label;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setParams(int params) {
        this._params = params;
    }

    public int getParams() {
        return this._params;
    }

    public void setScope(int scope) {
        this._scope |= scope;
    }

    public void unsetScope(int scope) {
        this._scope &= ~scope;
    }

    public int getScope() {
        return this._scope;
    }

    public void setTemplate(String template) {
        this._template = template;
    }

    public String getTemplate() {
        return this._template;
    }

    public void setAllowDuplicates(boolean allowDuplicates) {
        this._allowDuplicates = allowDuplicates;
    }

    public boolean isAllowDuplicates() {
        return this._allowDuplicates;
    }

    public void setAllowsTemplate(boolean allowsTemplate) {
        this._allowsTemplate = allowsTemplate;
    }

    public boolean isAllowsTemplate() {
        return this._allowsTemplate;
    }

    public void setCustom(boolean custom) {
        this._custom = custom;
    }

    public boolean isCustom() {
        return this._custom;
    }

    public void setRequired(boolean required) {
        this._required = required;
    }

    public boolean isRequired() {
        return this._required;
    }
}

