/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.javadoc;

import java.util.ArrayList;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.javadoc.JavadocSettings;
import oracle.jdeveloper.javadoc.TagDefs;
import oracle.jdeveloper.javadoc.TagDescriptor;

public class TagManager
implements TagDefs {
    private static ArrayList _allTagsList;
    private static TagDescriptor[] _inlineTags;
    private static JavadocSettings _settings;
    private static TagManager _singleton;
    private static TagDescriptor[] _standaloneTags;

    private TagManager() {
        this.initStandaloneTags();
        this.initInlineTags();
    }

    private void initStandaloneTags() {
        ArrayList<TagDescriptor> standalone = new ArrayList<TagDescriptor>();
        TagDescriptor authorTag = new TagDescriptor("@author", 1, 1);
        authorTag.setCustom(false);
        authorTag.setRequired(false);
        authorTag.setAllowsTemplate(true);
        authorTag.setAllowDuplicates(true);
        standalone.add(authorTag);
        TagDescriptor versionTag = new TagDescriptor("@version", 1, 1);
        versionTag.setCustom(false);
        versionTag.setRequired(false);
        versionTag.setAllowsTemplate(true);
        versionTag.setAllowDuplicates(false);
        standalone.add(versionTag);
        TagDescriptor paramTag = new TagDescriptor("@param", 12, 2);
        paramTag.setCustom(false);
        paramTag.setAllowDuplicates(false);
        paramTag.setRequired(true);
        paramTag.setAllowsTemplate(false);
        paramTag.setTemplate("<parameter name>");
        standalone.add(paramTag);
        TagDescriptor returnTag = new TagDescriptor("@return", 4, 1);
        returnTag.setCustom(false);
        returnTag.setAllowDuplicates(false);
        returnTag.setRequired(true);
        returnTag.setAllowsTemplate(false);
        standalone.add(returnTag);
        TagDescriptor throwsTag = new TagDescriptor("@throws", 12, 2);
        throwsTag.setCustom(false);
        throwsTag.setAllowDuplicates(false);
        throwsTag.setRequired(true);
        throwsTag.setAllowsTemplate(false);
        throwsTag.setTemplate("<throws type>");
        standalone.add(throwsTag);
        TagDescriptor seeTag = new TagDescriptor("@see", 15, 1);
        seeTag.setCustom(false);
        seeTag.setAllowDuplicates(true);
        seeTag.setRequired(false);
        seeTag.setAllowsTemplate(false);
        standalone.add(seeTag);
        TagDescriptor sinceTag = new TagDescriptor("@since", 15, 1);
        sinceTag.setCustom(false);
        sinceTag.setAllowDuplicates(false);
        sinceTag.setRequired(false);
        sinceTag.setAllowsTemplate(true);
        standalone.add(sinceTag);
        TagDescriptor serialTag = new TagDescriptor("@serial", 3, 1);
        serialTag.setCustom(false);
        serialTag.setAllowDuplicates(false);
        serialTag.setRequired(false);
        serialTag.setAllowsTemplate(false);
        standalone.add(serialTag);
        TagDescriptor serialDataTag = new TagDescriptor("@serialData", 12, 1);
        serialDataTag.setCustom(false);
        serialDataTag.setAllowDuplicates(false);
        serialDataTag.setRequired(false);
        serialDataTag.setAllowsTemplate(false);
        standalone.add(serialDataTag);
        TagDescriptor serialFldTag = new TagDescriptor("@serialField", 2, 1);
        serialFldTag.setCustom(false);
        serialFldTag.setAllowDuplicates(false);
        serialFldTag.setRequired(false);
        serialFldTag.setAllowsTemplate(false);
        standalone.add(serialFldTag);
        TagDescriptor deprecatedTag = new TagDescriptor("@deprecated", 15, 1);
        deprecatedTag.setCustom(false);
        deprecatedTag.setAllowDuplicates(false);
        deprecatedTag.setRequired(false);
        deprecatedTag.setAllowsTemplate(false);
        standalone.add(deprecatedTag);
        _standaloneTags = new TagDescriptor[standalone.size()];
        standalone.toArray(_standaloneTags);
    }

    private void initInlineTags() {
        ArrayList<TagDescriptor> inline = new ArrayList<TagDescriptor>();
        TagDescriptor docRootTag = new TagDescriptor("@docRoot", 15, 1);
        docRootTag.setCustom(false);
        docRootTag.setAllowDuplicates(true);
        docRootTag.setRequired(false);
        docRootTag.setAllowsTemplate(false);
        docRootTag.setLabel("@docRoot");
        inline.add(docRootTag);
        TagDescriptor inheritDocTag = new TagDescriptor("@inheritDoc", 12, 1);
        inheritDocTag.setCustom(false);
        inheritDocTag.setAllowDuplicates(true);
        inheritDocTag.setRequired(false);
        inheritDocTag.setAllowsTemplate(false);
        inheritDocTag.setLabel("@inheritDoc");
        inline.add(inheritDocTag);
        TagDescriptor linkTag = new TagDescriptor("@link", 15, 1);
        linkTag.setCustom(false);
        linkTag.setAllowDuplicates(true);
        linkTag.setRequired(false);
        linkTag.setAllowsTemplate(false);
        linkTag.setLabel("@link");
        inline.add(linkTag);
        TagDescriptor linkPlainTag = new TagDescriptor("@linkplain", 15, 1);
        linkPlainTag.setCustom(false);
        linkPlainTag.setAllowDuplicates(true);
        linkPlainTag.setRequired(false);
        linkPlainTag.setAllowsTemplate(false);
        linkPlainTag.setLabel("@linkplain");
        inline.add(linkPlainTag);
        TagDescriptor valueTag = new TagDescriptor("@value", 2, 1);
        valueTag.setCustom(false);
        valueTag.setAllowDuplicates(true);
        valueTag.setRequired(false);
        valueTag.setAllowsTemplate(false);
        valueTag.setLabel("@value");
        inline.add(valueTag);
        TagDescriptor codeTag = new TagDescriptor("@code", 15, 1);
        valueTag.setCustom(false);
        valueTag.setAllowDuplicates(true);
        valueTag.setRequired(false);
        valueTag.setLabel("@code");
        inline.add(codeTag);
        TagDescriptor literalTag = new TagDescriptor("@literal", 15, 1);
        valueTag.setCustom(false);
        valueTag.setAllowDuplicates(true);
        valueTag.setRequired(false);
        valueTag.setAllowsTemplate(false);
        valueTag.setLabel("@value");
        inline.add(literalTag);
        _inlineTags = new TagDescriptor[inline.size()];
        inline.toArray(_inlineTags);
    }

    public TagDescriptor findTagDescriptorByName(TagDescriptor thisTD, TagDescriptor[] tds) {
        int i = 0;
        while (i < tds.length) {
            TagDescriptor td = tds[i];
            if (thisTD.tagNamesAreEqual(td)) {
                return td;
            }
            ++i;
        }
        return null;
    }

    public TagDescriptor[] getAllTags() {
        this.getSettings();
        this.refreshAllTagsList();
        TagDescriptor[] tagArray = new TagDescriptor[_allTagsList.size()];
        _allTagsList.toArray(tagArray);
        return tagArray;
    }

    public TagDescriptor[] getInlneTags() {
        return _inlineTags;
    }

    public ArrayList getTags(int key) {
        this.getSettings();
        this.refreshAllTagsList();
        int listSize = _allTagsList.size();
        ArrayList<TagDescriptor> tags = new ArrayList<TagDescriptor>();
        int i = 0;
        while (i < listSize) {
            TagDescriptor td = (TagDescriptor)_allTagsList.get(i);
            if ((td.getScope() & key) > 0) {
                tags.add(td);
            }
            ++i;
        }
        return tags;
    }

    public ArrayList getInlineTags(int key) {
        ArrayList<TagDescriptor> tags = new ArrayList<TagDescriptor>();
        int i = 0;
        while (i < _inlineTags.length) {
            TagDescriptor td = _inlineTags[i];
            if ((td.getScope() & key) > 0) {
                tags.add(td);
            }
            ++i;
        }
        return tags;
    }

    private void refreshAllTagsList() {
        _allTagsList = (ArrayList)_settings.getTagList();
        if (_allTagsList.size() == 0 || _allTagsList.get(0) == null) {
            _allTagsList = new ArrayList();
            this.addBuiltInTagsToList(_allTagsList);
            _settings.setTagList(_allTagsList);
        } else {
            for (TagDescriptor td : _allTagsList) {
                if (td.getName().startsWith("@")) continue;
                td.setName("@" + td.getName());
            }
        }
    }

    private void addBuiltInTagsToList(ArrayList al) {
        TagDescriptor[] customArr = new TagDescriptor[al.size()];
        al.toArray(customArr);
        int i = 0;
        while (i < _standaloneTags.length) {
            TagDescriptor newTD = _standaloneTags[i];
            TagDescriptor matchTD = this.findTagDescriptorByName(newTD, customArr);
            if (matchTD == null) {
                al.add(newTD);
            }
            ++i;
        }
    }

    public JavadocSettings getSettings() {
        if (_settings == null) {
            this.initializeSettings();
        }
        return _settings;
    }

    private void initializeSettings() {
        _settings = (JavadocSettings)Ide.getSettings().getData("JavadocSettings");
        if (_settings == null || _settings.getTagList().size() == 0) {
            _settings = new JavadocSettings();
            this.refreshAllTagsList();
            ClientSetting setting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
            setting.putData("JavadocSettings", (Copyable)_settings);
        }
    }

    public static TagManager getInstance() {
        if (_singleton == null) {
            _singleton = new TagManager();
        }
        return _singleton;
    }
}

