/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.util.ArrayList;
import oracle.ide.migration.MigrationInfo;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;

public class ProjectLibraryMigrator
extends NodeMigratorHelper {
    private static ProjectLibraryMigrator migrator = new ProjectLibraryMigrator();
    private static String[] removeLibraries = new String[]{"VisiBroker4"};

    public static ProjectLibraryMigrator getInstance() {
        return migrator;
    }

    private ProjectLibraryMigrator() {
    }

    public void migrate(MigrationInfo[] infos, TraversableContext context) {
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getMigrationStatus() == MigrationInfo.MIGRATION_PENDING) {
                Node node = infos[i].getNode();
                if (node instanceof Project) {
                    Project project = (Project)node;
                    this.cleanProjectLibraries(project);
                }
            } else if (infos[i].getMigrationStatus() == MigrationInfo.MIGRATION_CANCELED) {
                // empty if block
            }
            ++i;
        }
    }

    private void cleanProjectLibraries(Project project) {
        JProjectLibraries projectLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        JLibrary[] libs = projectLibs.getLibraries();
        boolean replaceLibraries = false;
        if (libs != null) {
            ArrayList<JLibrary> newLibList = new ArrayList<JLibrary>();
            JLibrary[] jLibraryArray = libs;
            int n = 0;
            while (n < jLibraryArray.length) {
                JLibrary lib = jLibraryArray[n];
                if (this.inObsoleteList(lib)) {
                    replaceLibraries = true;
                } else {
                    newLibList.add(lib);
                }
                ++n;
            }
            if (replaceLibraries) {
                JLibrary[] correctedLibs = null;
                if (newLibList.size() > 0) {
                    correctedLibs = new JLibrary[newLibList.size()];
                    correctedLibs = newLibList.toArray(correctedLibs);
                }
                projectLibs.setLibraries(correctedLibs);
            }
        }
    }

    private boolean inObsoleteList(JLibrary jlib) {
        boolean found = false;
        String[] stringArray = removeLibraries;
        int n = 0;
        while (n < stringArray.length) {
            String removeName = stringArray[n];
            if (removeName.equals(jlib.getName())) {
                found = true;
                break;
            }
            ++n;
        }
        return found;
    }
}

