/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.util.IdeUtil;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.resource.ModelArb;

public class ContentSetFilterChooser
extends DefaultTraversablePanel {
    static final int FOLDERS_ONLY = 0;
    static final int FOLDERS_AND_FILES = 1;
    static final int APPROVE_OPTION = 0;
    static final int CANCEL_OPTION = 1;
    static final int ERROR_OPTION = 2;
    private final int _scope;
    private final URLPath _path;
    private final URLNode _rootNode;
    private final JWrappedLabel _treeLabel;
    private final DefaultTreeModel _treeModel;
    private static final URLFilter GLOBAL_IGNORE_FILTER = GlobalIgnoreList.getURLFilter();
    private JTree _tree;
    private KeyNavigationManager keyMgr;
    private transient JEWTDialog _dialog;

    private void $init$() {
        this._rootNode = new URLNode("", true);
        this._treeLabel = new JWrappedLabel();
        this._treeModel = new DefaultTreeModel(this._rootNode);
    }

    ContentSetFilterChooser(int scope, URLPath path) {
        this.$init$();
        this._scope = scope;
        this._path = path;
        this._rootNode.buildChildren();
        JTree tree = this.getTree();
        this._treeModel.nodeStructureChanged(this._rootNode);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new TCR(null));
        TreeHandler treeHandler = new TreeHandler(null);
        tree.addTreeSelectionListener(treeHandler);
        tree.addTreeWillExpandListener(treeHandler);
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add((Component)this._tree, null);
        tree.setSelectionRow(0);
        this.setLayout(new BorderLayout());
        this.add((Component)this._treeLabel, "North");
        this.add(scroller, "Center");
    }

    String[] getSelections() {
        TreePath[] selectedNodes = this._tree.getSelectionPaths();
        int n = selectedNodes.length;
        ArrayList<String> relPaths = new ArrayList<String>(n);
        int i = 0;
        while (i < n) {
            URLNode node = (URLNode)selectedNodes[i].getLastPathComponent();
            if (node != null) {
                relPaths.add(node.getRelPath());
            }
            ++i;
        }
        return relPaths.toArray(new String[relPaths.size()]);
    }

    int showDialog(Component parent, boolean isInclude) {
        String title;
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), this.getHelpId(isInclude));
        String string = title = isInclude ? ModelArb.getString((int)20) : ModelArb.getString((int)56);
        if (this._scope == 1) {
            this._treeLabel.setText(isInclude ? ModelArb.getString((int)75) : ModelArb.getString((int)21));
        } else {
            this._treeLabel.setText(isInclude ? ModelArb.getString((int)24) : ModelArb.getString((int)96));
        }
        try {
            TreeSelectionModel selModel = this._tree.getSelectionModel();
            selModel.setSelectionMode(4);
            Frame frame = IdeUtil.findFrame((Component)parent);
            this._dialog = new JEWTDialog(frame, title, 7);
            this._dialog.setContent((Component)((Object)this));
            this._dialog.setResizable(true);
            this._dialog.setInitialFocus((Component)this._tree);
            this.updateOKButton();
            boolean result = WizardLauncher.runDialog((JDialog)this._dialog);
            this._dialog.dispose();
            this._dialog = null;
            int n = result ? 0 : 1;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = 2;
            return n;
        }
    }

    JTree getTree() {
        if (this._tree == null) {
            this._tree = new 1(this._treeModel);
            this.keyMgr = new KeyNavigationManager((KeyNavigationManager.KeyComponentAdapter)new KeyNavigationManager.TreeKeyAdapter(this._tree));
            this._tree.setExpandsSelectedPaths(true);
            this._tree.setScrollsOnExpand(true);
            this._tree.addMouseListener(new 2());
        }
        return this._tree;
    }

    private void updateOKButton() {
        if (this._dialog != null) {
            URLNode node;
            TreePath tp = this._tree.getSelectionPath();
            if (tp != null && (node = (URLNode)tp.getLastPathComponent()) != null) {
                this._dialog.setOKButtonEnabled(this._scope == 1 || this._scope == 0 && node.isPackage());
                return;
            }
            this._dialog.setOKButtonEnabled(false);
        }
    }

    private String getHelpId(boolean isInclude) {
        if (isInclude) {
            return "f1_idedaddincludefilters_html";
        }
        return "f1_idedaddexcludefilters_html";
    }

    static URLPath ra$_path(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser._path;
    }

    static int ra$_scope(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser._scope;
    }

    static URLFilter ra$GLOBAL_IGNORE_FILTER() {
        return GLOBAL_IGNORE_FILTER;
    }

    static DefaultTreeModel ra$_treeModel(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser._treeModel;
    }

    static void mav$updateOKButton(ContentSetFilterChooser contentSetFilterChooser) {
        contentSetFilterChooser.updateOKButton();
    }

    static KeyNavigationManager ra$keyMgr(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser.keyMgr;
    }

    static JEWTDialog ra$_dialog(ContentSetFilterChooser contentSetFilterChooser) {
        return contentSetFilterChooser._dialog;
    }

    final class 1
    extends JTree {
        protected void processKeyEvent(KeyEvent e) {
            if (ContentSetFilterChooser.ra$keyMgr(ContentSetFilterChooser.this) != null) {
                ContentSetFilterChooser.ra$keyMgr(ContentSetFilterChooser.this).preProcessKeyEvent(e);
            }
            super.processKeyEvent(e);
            if (ContentSetFilterChooser.ra$keyMgr(ContentSetFilterChooser.this) != null) {
                ContentSetFilterChooser.ra$keyMgr(ContentSetFilterChooser.this).postProcessKeyEvent(e);
            }
        }

        public 1(TreeModel treeModel) {
            super(treeModel);
        }
    }

    final class 2
    extends MouseAdapter {
        int y;

        public void mouseClicked(MouseEvent e) {
            TreePath path;
            int clicks = e.getClickCount();
            if (clicks == 1) {
                this.y = e.getY();
            }
            if (this.y == e.getY() && clicks == 2 && (path = ((JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null && ((DefaultMutableTreeNode)path.getLastPathComponent()).isLeaf()) {
                ContentSetFilterChooser.ra$_dialog(ContentSetFilterChooser.this).closeDialog(false);
            }
        }
    }

    private class URLNode
    extends DefaultMutableTreeNode {
        private final String _relPath;
        private final boolean _isPackage;
        private String _name;
        private boolean _isExpanded;

        URLNode(String relPath, boolean isPackage) {
            this._relPath = relPath;
            this._isPackage = isPackage;
        }

        public String toString() {
            if (this._name == null) {
                int lastSlash = this._relPath.lastIndexOf("/");
                this._name = lastSlash >= 0 ? this._relPath.substring(lastSlash + 1) : this._relPath;
            }
            return this._name;
        }

        public boolean isLeaf() {
            return this._isPackage ^ true;
        }

        boolean isPackage() {
            return this._isPackage;
        }

        Icon getIcon() {
            return this._isPackage ? OracleIcons.getIcon((String)"folder.png") : OracleIcons.getIcon((String)"file.png");
        }

        boolean isExpanded() {
            return this._isExpanded;
        }

        String getRelPath() {
            return this._isPackage ? this._relPath + "/" : this._relPath;
        }

        URLNode findChild(String name) {
            if (name == null) {
                return null;
            }
            if (!this._isExpanded) {
                this.buildChildren();
            }
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                URLNode child = (URLNode)enumeration.nextElement();
                if (!name.equals(child.toString())) continue;
                return child;
            }
            return null;
        }

        void buildChildren() {
            List childDirs = ContentSetFilterChooser.ra$_path(ContentSetFilterChooser.this).getDirectories(this._relPath);
            Iterator dirsIter = childDirs.iterator();
            while (dirsIter.hasNext()) {
                String dir = dirsIter.next().toString();
                URLNode dirNode = new URLNode(dir, true);
                this.add(dirNode);
            }
            if (ContentSetFilterChooser.ra$_scope(ContentSetFilterChooser.this) == 1) {
                List childFiles = ContentSetFilterChooser.ra$_path(ContentSetFilterChooser.this).getFiles(this._relPath);
                for (URL file : childFiles) {
                    if (!ContentSetFilterChooser.ra$GLOBAL_IGNORE_FILTER().accept(file)) continue;
                    String fileStr = ContentSetFilterChooser.ra$_path(ContentSetFilterChooser.this).toRelativePath(file);
                    URLNode fileNode = new URLNode(fileStr, false);
                    this.add(fileNode);
                }
            }
            ContentSetFilterChooser.ra$_treeModel(ContentSetFilterChooser.this).nodeStructureChanged(this);
            this._isExpanded = true;
        }
    }

    private static class TCR
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            URLNode node = (URLNode)value;
            label.setIcon(node.getIcon());
            return label;
        }

        private TCR() {
        }

        TCR(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class TreeHandler
    implements TreeSelectionListener,
    TreeWillExpandListener {
        public void valueChanged(TreeSelectionEvent e) {
            ContentSetFilterChooser.mav$updateOKButton(ContentSetFilterChooser.this);
        }

        public void treeWillExpand(TreeExpansionEvent e) {
            TreePath tp = e.getPath();
            URLNode node = (URLNode)tp.getLastPathComponent();
            if (node != null && !node.isExpanded()) {
                node.buildChildren();
            }
        }

        public void treeWillCollapse(TreeExpansionEvent e) {
        }

        private TreeHandler() {
        }

        TreeHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

