/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.controls.WaitCursor;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.model.ContentFolder;
import oracle.jdeveloper.model.ContentSetFilterChooser;
import oracle.jdeveloper.resource.ModelArb;
import oracle.jdevimpl.java.explorer.OverlayedIcon;

public class ContentSetFilterPanel
extends JTabbedPane {
    private static final String EMPTY_FILTER_LIST = ModelArb.getString((int)10);
    private static final String NO_EXCLUSIONS = ModelArb.getString((int)130);
    private static final String NO_COMMON_EXCLUSIONS = ModelArb.getString((int)70);
    private static final String NO_INCLUSIONS = ModelArb.getString((int)73);
    private static final String NO_COMMON_INCLUSIONS = ModelArb.getString((int)11);
    private static final Icon ICON_INCLUDE = ModelArb.getIcon((int)74);
    private static final Icon ICON_EXCLUDE = ModelArb.getIcon((int)87);
    private FilterPanel _inclusionsTab;
    private FilterPanel _exclusionsTab;
    private ContentFolder[] _activeContentFlders;

    public ContentSetFilterPanel() {
        try {
            this._inclusionsTab = new FilterPanel(true);
            this._exclusionsTab = new FilterPanel(false);
            this.add(ModelArb.getString((int)32), this._inclusionsTab);
            this.add(ModelArb.getString((int)71), this._exclusionsTab);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setData(ContentFolder[] folders) {
        this._inclusionsTab.loadFrom(folders);
        this._exclusionsTab.loadFrom(folders);
    }

    void refreshAllFilters() {
        FilterPanel.mav$refreshFilters(this._inclusionsTab);
        FilterPanel.mav$refreshFilters(this._exclusionsTab);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        FilterPanel.mav$enableControls(this._inclusionsTab);
        FilterPanel.mav$enableControls(this._exclusionsTab);
    }

    static ContentFolder[] ra$_activeContentFlders(ContentSetFilterPanel contentSetFilterPanel) {
        return contentSetFilterPanel._activeContentFlders;
    }

    static String ra$EMPTY_FILTER_LIST() {
        return EMPTY_FILTER_LIST;
    }

    static Icon ra$ICON_EXCLUDE() {
        return ICON_EXCLUDE;
    }

    static Icon ra$ICON_INCLUDE() {
        return ICON_INCLUDE;
    }

    static String ra$NO_EXCLUSIONS() {
        return NO_EXCLUSIONS;
    }

    static String ra$NO_COMMON_EXCLUSIONS() {
        return NO_COMMON_EXCLUSIONS;
    }

    static String ra$NO_INCLUSIONS() {
        return NO_INCLUSIONS;
    }

    static String ra$NO_COMMON_INCLUSIONS() {
        return NO_COMMON_INCLUSIONS;
    }

    static void wa$_activeContentFlders(ContentSetFilterPanel contentSetFilterPanel, ContentFolder[] contentFolderArray) {
        contentSetFilterPanel._activeContentFlders = contentFolderArray;
    }

    private class FilterPanel
    extends JPanel
    implements ActionListener,
    ItemListener,
    ListSelectionListener {
        private final JButton _addFilterButton;
        private final JButton _removeFilterButton;
        private final DefaultListModel _filterListModel;
        private final JList _filterList;
        private final JScrollPane _scroller;
        private final GridBagLayout layout;
        private final JCheckBox _includeSubFolders;
        private FilterListCellRenderer _cellRenderer;
        private boolean _includeExcludeMode;

        private void $init$() {
            this._addFilterButton = new JButton();
            this._removeFilterButton = new JButton();
            this._filterListModel = new DefaultListModel();
            this._filterList = new JList(this._filterListModel);
            this._scroller = new JScrollPane(this._filterList);
            this.layout = new GridBagLayout();
            this._includeSubFolders = new JCheckBox();
        }

        FilterPanel(boolean includeMode) throws Exception {
            this.$init$();
            ContentSetFilterPanel.wa$_activeContentFlders(ContentSetFilterPanel.this, new ContentFolder[0]);
            this._includeExcludeMode = includeMode;
            this.jbInit();
        }

        public void loadFrom(ContentFolder[] folders) {
            ContentSetFilterPanel.wa$_activeContentFlders(ContentSetFilterPanel.this, folders);
            this.refreshInclude();
            this.refreshFilters();
        }

        private FilterListCellRenderer getCellRenderer(Icon overlayIcon) {
            if (this._cellRenderer == null) {
                this._cellRenderer = new FilterListCellRenderer(overlayIcon);
            }
            return this._cellRenderer;
        }

        private void enableControls() {
            if (!this.isEnabled() || ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length == 0) {
                this._filterList.setEnabled(false);
                this._includeSubFolders.setEnabled(false);
                this._addFilterButton.setEnabled(false);
                this._removeFilterButton.setEnabled(false);
            } else {
                this._filterList.setEnabled(true);
                boolean hasContent = this.containsFilesOrFolders();
                this._addFilterButton.setEnabled(hasContent);
                this._includeSubFolders.setEnabled(hasContent);
                int selectedFilters = this._filterList.getSelectedIndices().length;
                Object selectedValue = this._filterList.getSelectedValue();
                if (selectedValue == ContentSetFilterPanel.ra$EMPTY_FILTER_LIST()) {
                    this._removeFilterButton.setEnabled(true);
                } else if (selectedFilters > 1 || selectedFilters == 1 && ContentSetFilterPanel.ra$NO_EXCLUSIONS() != selectedValue && ContentSetFilterPanel.ra$NO_COMMON_EXCLUSIONS() != selectedValue && ContentSetFilterPanel.ra$NO_COMMON_INCLUSIONS() != selectedValue && ContentSetFilterPanel.ra$NO_INCLUSIONS() != selectedValue) {
                    this._removeFilterButton.setEnabled(true);
                    this._includeSubFolders.setEnabled(false);
                } else {
                    this._removeFilterButton.setEnabled(false);
                    this._includeSubFolders.setEnabled(true);
                }
            }
        }

        private boolean containsFilesOrFolders() {
            ContentFolder[] contentFolderArray = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this);
            int n = 0;
            while (n < contentFolderArray.length) {
                ContentFolder folder = contentFolderArray[n];
                URL[] children = URLFileSystem.list((URL)folder.getContentFolderURL(), (URLFilter)GlobalIgnoreList.getURLFilter());
                if (children != null && children.length > 0) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private void setCheckboxState(TriStateBoolean bool) {
            boolean triState = bool.isTriState();
            if (!triState) {
                this._includeSubFolders.setSelected(bool.isTrue());
            }
            ButtonModel bm = this._includeSubFolders.getModel();
            bm.setArmed(triState);
            bm.setPressed(triState);
        }

        private void refreshInclude() {
            if (ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this) == null || ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length == 0) {
                return;
            }
            boolean includeSubs = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[0].isIncludeSubfolders();
            TriStateBoolean bool = includeSubs ? TriStateBoolean.TRUE : TriStateBoolean.FALSE;
            int i = 0;
            while (i < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                if (includeSubs != ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[i].isIncludeSubfolders()) {
                    bool = TriStateBoolean.TRI_STATE;
                    break;
                }
                ++i;
            }
            this.setCheckboxState(bool);
        }

        private void refreshFilters() {
            this._filterListModel.clear();
            ArrayList intersected = null;
            ArrayList nextGroup = new ArrayList();
            int i = 0;
            while (i < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                ContentFolder curContentFolder = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[i];
                ArrayList filters = this.isExclude() ? curContentFolder.getExcludeFilters() : curContentFolder.getIncludeFilters();
                for (PatternFilter filter : filters) {
                    this.addFilterToGroup(nextGroup, filter.getPattern(), curContentFolder);
                }
                if (intersected != null) {
                    intersected.retainAll(nextGroup);
                } else {
                    intersected = new ArrayList(nextGroup);
                }
                nextGroup.clear();
                ++i;
            }
            if (intersected != null) {
                Iterator iter = intersected.iterator();
                while (iter.hasNext()) {
                    this._filterListModel.addElement(iter.next());
                }
            }
            if (this._filterListModel.size() == 0) {
                String element = this.isExclude() ? (ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length == 1 ? (ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[0].isExcludeAll() ? ContentSetFilterPanel.ra$EMPTY_FILTER_LIST() : ContentSetFilterPanel.ra$NO_EXCLUSIONS()) : ContentSetFilterPanel.ra$NO_COMMON_EXCLUSIONS()) : (ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length == 1 ? ContentSetFilterPanel.ra$NO_INCLUSIONS() : ContentSetFilterPanel.ra$NO_COMMON_INCLUSIONS());
                this._filterListModel.addElement(element);
            }
            this._filterList.setSelectedIndex(0);
        }

        private void addFilterToGroup(ArrayList groups, String excludePattern, ContentFolder contentFolder) {
            for (FilterGroup group : groups) {
                if (!group._pattern.equals(excludePattern)) continue;
                group._contentFolders.add(contentFolder);
                return;
            }
            FilterGroup newGroup = new FilterGroup(contentFolder, excludePattern);
            newGroup._contentFolders.add(contentFolder);
            groups.add(newGroup);
        }

        private boolean isInclude() {
            return true == this._includeExcludeMode;
        }

        private boolean isExclude() {
            return false == this._includeExcludeMode;
        }

        private void jbInit() throws Exception {
            ResourceUtils.resButton((AbstractButton)this._includeSubFolders, (String)ModelArb.getString((int)27));
            ResourceUtils.resButton((AbstractButton)this._addFilterButton, (String)ModelArb.getString((int)62));
            ResourceUtils.resButton((AbstractButton)this._removeFilterButton, (String)ModelArb.getString((int)12));
            this._includeSubFolders.addItemListener(this);
            this._addFilterButton.addActionListener(this);
            this._removeFilterButton.addActionListener(this);
            this._filterList.addListSelectionListener(this);
            this._filterList.setCellRenderer(this.getCellRenderer(this.isExclude() ? ContentSetFilterPanel.ra$ICON_EXCLUDE() : ContentSetFilterPanel.ra$ICON_INCLUDE()));
            this._filterList.getSelectionModel().setSelectionMode(2);
            this.setLayout(this.layout);
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            Insets empty = new Insets(0, 0, 0, 0);
            Insets checkbox = new Insets(0, 0, 4, 0);
            Insets button = new Insets(0, 8, 5, 0);
            Insets lastButton = new Insets(0, 8, 0, 0);
            int y = -1;
            if (this.isInclude()) {
                this.add((Component)this._includeSubFolders, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 17, 0, checkbox, 0, 0));
            }
            this.add((Component)this._scroller, new GridBagConstraints(0, -1, 1, 2, 1.0, 1.0, 10, 1, empty, 0, 0));
            this.add((Component)this._addFilterButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, button, 0, 0));
            this.add((Component)this._removeFilterButton, new GridBagConstraints(1, -1, 1, 1, 0.0, 1.0, 12, 2, lastButton, 0, 0));
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == this._addFilterButton) {
                WaitCursor waitCursor = new WaitCursor((Component)ContentSetFilterPanel.this);
                waitCursor.show();
                URL[] activeURLs = new URL[ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length];
                int i = 0;
                while (i < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                    activeURLs[i] = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[i].getContentFolderURL();
                    ++i;
                }
                URLPath urlPath = new URLPath(activeURLs);
                int dialogMode = activeURLs.length > 1 ? 0 : 1;
                ContentSetFilterChooser chooser = new ContentSetFilterChooser(dialogMode, urlPath);
                chooser.setPreferredSize(new Dimension(300, 225));
                waitCursor.hide();
                waitCursor.dispose();
                int[] newSelection = new int[]{};
                if (chooser.showDialog(this.getParent(), this.isInclude()) == 0) {
                    String[] selectedPackages = chooser.getSelections();
                    newSelection = new int[selectedPackages.length];
                    int i2 = 0;
                    while (i2 < selectedPackages.length) {
                        String pattern = selectedPackages[i2];
                        int x = 0;
                        while (x < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                            ContentFolder folder = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[x];
                            if (this.isExclude()) {
                                folder.addRelativeExcludeFilter(pattern);
                            } else {
                                folder.addRelativeIncludeFilter(pattern);
                            }
                            ++x;
                        }
                        ++i2;
                    }
                    ContentSetFilterPanel.this.refreshAllFilters();
                    int length = this._filterListModel.size();
                    int index = length - newSelection.length;
                    int i3 = 0;
                    while (i3 < newSelection.length) {
                        newSelection[i3] = index++;
                        ++i3;
                    }
                    this._filterList.setSelectedIndices(newSelection);
                }
            } else if (src == this._removeFilterButton) {
                int index = this._filterList.getSelectedIndex();
                int i = 0;
                while (i < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                    ContentFolder folder = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[i];
                    Object[] selection = this._filterList.getSelectedValues();
                    int x = 0;
                    while (x < selection.length) {
                        if (selection[x] == ContentSetFilterPanel.ra$EMPTY_FILTER_LIST()) {
                            folder.addFilter(folder.getPrimaryIncludeFilter());
                        } else {
                            FilterGroup group = (FilterGroup)selection[x];
                            if (this.isExclude()) {
                                folder.removeRelativeExcludeFilter(group._pattern);
                            } else {
                                folder.removeRelativeIncludeFilter(group._pattern);
                            }
                        }
                        ++x;
                    }
                    ++i;
                }
                ContentSetFilterPanel.this.refreshAllFilters();
                int length = this._filterListModel.size();
                if (length > 0 && index <= length) {
                    if (index == length) {
                        --index;
                    }
                    this._filterList.setSelectedIndex(index);
                }
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                this.enableControls();
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this._includeSubFolders) {
                boolean include = this._includeSubFolders.isSelected();
                int i = 0;
                while (i < ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this).length) {
                    ContentFolder folder = ContentSetFilterPanel.ra$_activeContentFlders(ContentSetFilterPanel.this)[i];
                    folder.setIncludeSubfolders(include);
                    ++i;
                }
                this.refreshInclude();
            }
        }

        static void mav$enableControls(FilterPanel filterPanel) {
            filterPanel.enableControls();
        }

        static void mav$refreshFilters(FilterPanel filterPanel) {
            filterPanel.refreshFilters();
        }
    }

    private static class FilterGroup {
        private final char SEPARATOR_CHAR;
        final boolean _isFolderFilter;
        final String _pattern;
        final String _displayPattern;
        final ArrayList _contentFolders;

        private void $init$() {
            this.SEPARATOR_CHAR = File.separatorChar;
        }

        FilterGroup(ContentFolder contentFolder, String pattern) {
            URLPath urlPath;
            this.$init$();
            if (pattern == null) {
                throw new IllegalArgumentException();
            }
            this._pattern = pattern;
            this._contentFolders = new ArrayList();
            this._isFolderFilter = !pattern.endsWith("/") ? URLFileSystem.isDirectory((URL)(urlPath = new URLPath(contentFolder.getRootURL())).toQualifiedURL(pattern)) : true;
            String s = this._pattern.endsWith("/") ? this._pattern.substring(0, this._pattern.length() - 1) : this._pattern;
            this._displayPattern = s.replace('/', this.SEPARATOR_CHAR);
        }

        public String toString() {
            return this._displayPattern;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            return this._pattern.equals(((FilterGroup)o)._pattern);
        }

        public int hashCode() {
            return this._pattern.hashCode();
        }
    }

    private static class FilterListCellRenderer
    extends DefaultListCellRenderer {
        private OverlayedIcon _folderIcon;
        private OverlayedIcon _fileIcon;
        private Icon _warningIcon;

        private void $init$() {
            this._warningIcon = OracleIcons.getIcon((String)"warning.png");
        }

        FilterListCellRenderer(Icon icon) {
            this.$init$();
            this._folderIcon = new OverlayedIcon(icon, OracleIcons.getIcon((String)"folder.png"));
            this._fileIcon = new OverlayedIcon(icon, OracleIcons.getIcon((String)"file.png"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof FilterGroup) {
                if (((FilterGroup)value)._isFolderFilter) {
                    label.setIcon(this._folderIcon);
                } else {
                    label.setIcon(this._fileIcon);
                }
            } else if (value == ContentSetFilterPanel.ra$EMPTY_FILTER_LIST()) {
                label.setIcon(this._warningIcon);
            } else if (!(value instanceof String)) {
                System.err.println("**** Warning. Unrecognized list item type: " + (value != null ? value.getClass() : null));
            }
            return label;
        }
    }
}

