/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Assert;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.model.ContentFolder;
import oracle.jdeveloper.model.ContentSetFilterPanel;
import oracle.jdeveloper.model.ContentSetValidator;
import oracle.jdeveloper.resource.ModelArb;

public class ContentSetPanel
extends JPanel {
    private final JButton ADD_CONTENT_BUTTON;
    private final JButton REMOVE_CONTENT_BUTTON;
    private final JButton MOVE_UP_BUTTON;
    private final JButton MOVE_DOWN_BUTTON;
    private final JLabel CONTENT_SET_LABEL;
    private final DefaultListModel CONTENT_LIST_MODEL;
    private final JList _contentList;
    private final ContentSetFilterPanel FILTER_TABS;
    private final InteractionListener INTERACTION_LISTENER;
    private final LCR CELL_RENDERER;
    private URLChooser _contentChooser;
    private boolean _updating;
    private ContentSet _contentSet;
    private ContentSetValidator _validator;
    private URL _projectURL;
    private ContentFolder[] _activeContentFlders;

    private void $init$() {
        this.ADD_CONTENT_BUTTON = new JButton();
        this.REMOVE_CONTENT_BUTTON = new JButton();
        this.MOVE_UP_BUTTON = new JButton();
        this.MOVE_DOWN_BUTTON = new JButton();
        this.CONTENT_SET_LABEL = new JLabel();
        this.CONTENT_LIST_MODEL = new DefaultListModel();
        this._contentList = new JList(this.CONTENT_LIST_MODEL);
        this.FILTER_TABS = new ContentSetFilterPanel();
        this.INTERACTION_LISTENER = new InteractionListener(null);
        this.CELL_RENDERER = new LCR(null);
    }

    public ContentSetPanel() {
        this((ContentSetValidator)null);
    }

    public ContentSetPanel(ContentSetValidator validator) {
        this.$init$();
        this._validator = validator;
        this._activeContentFlders = new ContentFolder[0];
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setContentSetLabel(String label) {
        ResourceUtils.resLabel((JLabel)this.CONTENT_SET_LABEL, (Component)this._contentList, (String)label);
    }

    public void setValidator(ContentSetValidator validator) {
        this._validator = validator;
    }

    public ContentSetValidator getValidator() {
        return this._validator;
    }

    public void loadFrom(Project project, ContentSet contentSet) {
        this._projectURL = project.getURL();
        this._contentSet = contentSet;
        this.CONTENT_LIST_MODEL.clear();
        URLPath srcPath = this._contentSet.getURLPath();
        if (srcPath.size() > 0) {
            this.populateContentList(this._contentSet);
        }
        int contentSets = this._contentSet.countContentSets();
        int i = 0;
        while (i < contentSets) {
            ContentSet cs = this._contentSet.getContentSet(i);
            this.populateContentList(cs);
            ++i;
        }
        if (this.CONTENT_LIST_MODEL.size() > 0) {
            this._contentList.setSelectedIndex(0);
        }
        this.enableControls();
    }

    public void saveContentSet() throws EmptyContentSetException {
        Object[] contents = this.CONTENT_LIST_MODEL.toArray();
        ContentSet newContentSet = new ContentSet(HashStructure.newInstance());
        this._contentSet.copyTo((Object)newContentSet);
        if (contents.length == 0) {
            throw new EmptyContentSetException();
        }
        if (contents.length == 1) {
            ContentFolder folder = (ContentFolder)contents[0];
            newContentSet.removeAllContentSets();
            this.persistContentSet(folder, newContentSet);
        } else {
            newContentSet.getURLPath().setEntries(null);
            newContentSet.getPatternFilters().setFilters(null);
            newContentSet.removeAllContentSets();
            int i = 0;
            while (i < contents.length) {
                ContentFolder folder = (ContentFolder)contents[i];
                ContentSet subContentSet = new ContentSet(HashStructure.newInstance());
                newContentSet.addContentSet(subContentSet);
                this.persistContentSet(folder, subContentSet);
                ++i;
            }
        }
        if (!newContentSet.equals((Object)this._contentSet)) {
            this._contentSet.getURLPath().setEntries(null);
            this._contentSet.getPatternFilters().setFilters(null);
            this._contentSet.removeAllContentSets();
            newContentSet.copyTo((Object)this._contentSet);
        }
    }

    public void hideUpDownButtons() {
        this.MOVE_UP_BUTTON.setVisible(false);
        this.MOVE_DOWN_BUTTON.setVisible(false);
    }

    boolean addFolderToContentSet(URL contentFolderURL) {
        return this.addFolderToContentSet(contentFolderURL, contentFolderURL);
    }

    boolean addFolderToContentSet(URL contentFolderURL, URL srcRootURL) {
        String relPath = URLFileSystem.toRelativeSpec((URL)contentFolderURL, (URL)srcRootURL, (boolean)true);
        if (relPath == null) {
            Assert.printStackTrace((relPath == null ? 1 : 0) != 0, (String)"Content folder is not under the specified source root");
            return false;
        }
        if (this.contentSetContainsURL(contentFolderURL)) {
            return false;
        }
        ContentFolder contentFolder = new ContentFolder(contentFolderURL, srcRootURL);
        this.CONTENT_LIST_MODEL.addElement(contentFolder);
        return true;
    }

    URLPath getURLPath() {
        URLPath urlPath = new URLPath();
        Object[] contents = this.CONTENT_LIST_MODEL.toArray();
        int i = 0;
        while (i < contents.length) {
            ContentFolder contentFolder = (ContentFolder)contents[i];
            URL srcRootURL = contentFolder.getRootURL();
            urlPath.add(srcRootURL);
            ++i;
        }
        return urlPath;
    }

    public boolean contentSetContainsURL(URL url) {
        Object[] contents = this.CONTENT_LIST_MODEL.toArray();
        int i = 0;
        while (i < contents.length) {
            ContentFolder folder = (ContentFolder)contents[i];
            if (URLFileSystem.equals((URL)url, (URL)folder.getContentFolderURL())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void populateContentList(ContentSet contentSet) {
        URL contentFolderURL = contentSet.getContentFolderURL();
        URLPath urlPath = contentSet.getURLPath();
        URL[] entries = urlPath.getEntries();
        int i = 0;
        while (i < entries.length) {
            URL srcRootURL = entries[i];
            PatternFilter[] filters = contentSet.getPatternFilters().getFilters();
            ContentFolder folder = new ContentFolder(contentFolderURL, srcRootURL, filters);
            this.CONTENT_LIST_MODEL.addElement(folder);
            ++i;
        }
    }

    private void persistContentSet(ContentFolder contentFolder, ContentSet contentSet) {
        URL srcRootURL = contentFolder.getRootURL();
        URLPath existingURLPath = contentSet.getURLPath();
        if (existingURLPath.size() != 1 || !URLFileSystem.equals((URL)existingURLPath.getEntries()[0], (URL)srcRootURL)) {
            URL[] entries = new URL[]{srcRootURL};
            existingURLPath.setEntries(entries);
        }
        if (!contentFolder.getContentFolderURL().equals(srcRootURL)) {
            contentSet.setContentFolderURL(contentFolder.getContentFolderURL());
        } else {
            contentSet.setContentFolderURL(null);
        }
        PatternFilter[] filters = contentFolder.getAllFilters();
        contentSet.getPatternFilters().setFilters(filters);
    }

    private int getIndexOfURL(URL url) {
        Object[] contents = this.CONTENT_LIST_MODEL.toArray();
        int i = 0;
        while (i < contents.length) {
            ContentFolder folder = (ContentFolder)contents[i];
            if (URLFileSystem.equals((URL)url, (URL)folder.getContentFolderURL())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private URLChooser getContentChooser() {
        if (this._contentChooser == null) {
            this._contentChooser = DialogUtil.newURLChooser();
            this._contentChooser.setShowJarsAsDirs(false);
            this._contentChooser.setSelectionScope(1);
            this._contentChooser.setSelectionMode(2);
        }
        return this._contentChooser;
    }

    private void enableControls() {
        if (!this._updating) {
            int index = this._contentList.getSelectedIndex();
            boolean hasSelection = index != -1;
            this.REMOVE_CONTENT_BUTTON.setEnabled(hasSelection);
            this.FILTER_TABS.setEnabled(hasSelection);
            int length = this._contentList.getSelectedIndices().length;
            this.MOVE_UP_BUTTON.setEnabled(length == 1 && index > 0);
            this.MOVE_DOWN_BUTTON.setEnabled(length == 1 && index < this.CONTENT_LIST_MODEL.size() - 1);
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resButton((AbstractButton)this.ADD_CONTENT_BUTTON, (String)ModelArb.getString((int)92));
        ResourceUtils.resButton((AbstractButton)this.REMOVE_CONTENT_BUTTON, (String)ModelArb.getString((int)133));
        ResourceUtils.resButton((AbstractButton)this.MOVE_UP_BUTTON, (String)ModelArb.getString((int)50));
        ResourceUtils.resButton((AbstractButton)this.MOVE_DOWN_BUTTON, (String)ModelArb.getString((int)43));
        ResourceUtils.resLabel((JLabel)this.CONTENT_SET_LABEL, (Component)this._contentList, (String)ModelArb.getString((int)136));
        this.ADD_CONTENT_BUTTON.addActionListener(this.INTERACTION_LISTENER);
        this.REMOVE_CONTENT_BUTTON.addActionListener(this.INTERACTION_LISTENER);
        this.MOVE_UP_BUTTON.addActionListener(this.INTERACTION_LISTENER);
        this.MOVE_DOWN_BUTTON.addActionListener(this.INTERACTION_LISTENER);
        this._contentList.addListSelectionListener(this.INTERACTION_LISTENER);
        this._contentList.setCellRenderer(this.CELL_RENDERER);
        this._contentList.getSelectionModel().setSelectionMode(2);
        JScrollPane contentListScroller = new JScrollPane(this._contentList);
        this.setLayout(new GridBagLayout());
        Insets labelInsets = new Insets(0, 0, 2, 0);
        Insets tabPaneInsets = new Insets(5, 0, 0, 0);
        Insets listInsets = new Insets(0, 0, 0, 0);
        Insets buttonInsets = new Insets(0, 8, 5, 0);
        int Y = -1;
        this.add((Component)this.CONTENT_SET_LABEL, new GridBagConstraints(0, -1, 2, 1, 0.0, 0.0, 10, 2, labelInsets, 0, 0));
        this.add((Component)contentListScroller, new GridBagConstraints(0, -1, 1, 4, 1.0, 1.0, 10, 1, listInsets, 0, 0));
        this.add((Component)this.ADD_CONTENT_BUTTON, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 10, 2, buttonInsets, 0, 0));
        this.add((Component)this.REMOVE_CONTENT_BUTTON, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, buttonInsets, 0, 0));
        this.add((Component)this.MOVE_UP_BUTTON, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, buttonInsets, 0, 0));
        buttonInsets.bottom = 0;
        this.add((Component)this.MOVE_DOWN_BUTTON, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 11, 2, buttonInsets, 0, 0));
        this.add((Component)this.FILTER_TABS, new GridBagConstraints(0, -1, 2, 1, 1.0, 5.0, 17, 1, tabPaneInsets, 0, 0));
    }

    static JList ra$_contentList(ContentSetPanel contentSetPanel) {
        return contentSetPanel._contentList;
    }

    static void wa$_activeContentFlders(ContentSetPanel contentSetPanel, ContentFolder[] contentFolderArray) {
        contentSetPanel._activeContentFlders = contentFolderArray;
    }

    static ContentFolder[] ra$_activeContentFlders(ContentSetPanel contentSetPanel) {
        return contentSetPanel._activeContentFlders;
    }

    static ContentSetFilterPanel ra$FILTER_TABS(ContentSetPanel contentSetPanel) {
        return contentSetPanel.FILTER_TABS;
    }

    static void mav$enableControls(ContentSetPanel contentSetPanel) {
        contentSetPanel.enableControls();
    }

    static void wa$_updating(ContentSetPanel contentSetPanel, boolean bl) {
        contentSetPanel._updating = bl;
    }

    static JButton ra$ADD_CONTENT_BUTTON(ContentSetPanel contentSetPanel) {
        return contentSetPanel.ADD_CONTENT_BUTTON;
    }

    static URLChooser mav$getContentChooser(ContentSetPanel contentSetPanel) {
        return contentSetPanel.getContentChooser();
    }

    static URL ra$_projectURL(ContentSetPanel contentSetPanel) {
        return contentSetPanel._projectURL;
    }

    static ContentSetValidator ra$_validator(ContentSetPanel contentSetPanel) {
        return contentSetPanel._validator;
    }

    static DefaultListModel ra$CONTENT_LIST_MODEL(ContentSetPanel contentSetPanel) {
        return contentSetPanel.CONTENT_LIST_MODEL;
    }

    static int mav$getIndexOfURL(ContentSetPanel contentSetPanel, URL uRL) {
        return contentSetPanel.getIndexOfURL(uRL);
    }

    static JButton ra$REMOVE_CONTENT_BUTTON(ContentSetPanel contentSetPanel) {
        return contentSetPanel.REMOVE_CONTENT_BUTTON;
    }

    static JButton ra$MOVE_UP_BUTTON(ContentSetPanel contentSetPanel) {
        return contentSetPanel.MOVE_UP_BUTTON;
    }

    static JButton ra$MOVE_DOWN_BUTTON(ContentSetPanel contentSetPanel) {
        return contentSetPanel.MOVE_DOWN_BUTTON;
    }

    private class InteractionListener
    implements ActionListener,
    ListSelectionListener {
        public void actionPerformed(ActionEvent e) {
            int[] indexes;
            int selectionCount;
            ContentSetPanel.wa$_updating(ContentSetPanel.this, true);
            Object src = e.getSource();
            if (src == ContentSetPanel.ra$ADD_CONTENT_BUTTON(ContentSetPanel.this)) {
                WaitCursor waitCursor = new WaitCursor((Component)ContentSetPanel.this);
                waitCursor.show();
                URLChooser chooser = ContentSetPanel.mav$getContentChooser(ContentSetPanel.this);
                chooser.setRoots(URLFileSystem.listRoots());
                chooser.setSelectedURL(ContentSetPanel.ra$_projectURL(ContentSetPanel.this));
                if (ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this).length > 0) {
                    chooser.setSelectedURL(ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this)[0].getContentFolderURL());
                }
                waitCursor.hide();
                waitCursor.dispose();
                if (chooser.showOpenDialog((Component)ContentSetPanel.this.getParent()) == 0) {
                    URL[] selectedURLs = chooser.getSelectedURLs();
                    if (ContentSetPanel.ra$_validator(ContentSetPanel.this) != null) {
                        ContentSetPanel.ra$_validator(ContentSetPanel.this).validateAndProcessURLs(ContentSetPanel.this, selectedURLs);
                        ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).size() - 1);
                    } else {
                        int i = 0;
                        while (i < selectedURLs.length) {
                            URL url = selectedURLs[i];
                            ContentSetPanel.this.addFolderToContentSet(url, url);
                            int index = ContentSetPanel.mav$getIndexOfURL(ContentSetPanel.this, selectedURLs[i]);
                            ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(index);
                            ++i;
                        }
                    }
                }
                chooser.flush();
            } else if (src == ContentSetPanel.ra$REMOVE_CONTENT_BUTTON(ContentSetPanel.this)) {
                if (ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this).length == ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).size()) {
                    ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).clear();
                    ContentSetPanel.ra$ADD_CONTENT_BUTTON(ContentSetPanel.this).requestFocus();
                } else {
                    int index = ContentSetPanel.ra$_contentList(ContentSetPanel.this).getSelectedIndex();
                    int i = ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this).length - 1;
                    while (i >= 0) {
                        ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).removeElement(ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this)[i]);
                        --i;
                    }
                    int length = ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).size();
                    if (length > 0 && index <= length) {
                        if (index == length) {
                            --index;
                        }
                        ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(index);
                    }
                }
            } else if (src == ContentSetPanel.ra$MOVE_UP_BUTTON(ContentSetPanel.this)) {
                int[] indexes2 = ContentSetPanel.ra$_contentList(ContentSetPanel.this).getSelectedIndices();
                int selectionCount2 = indexes2.length;
                if (selectionCount2 == 1) {
                    int pos = indexes2[0];
                    ContentFolder folder = (ContentFolder)ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).getElementAt(pos);
                    ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).remove(pos);
                    ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).add(--pos, folder);
                    ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(pos);
                }
            } else if (src == ContentSetPanel.ra$MOVE_DOWN_BUTTON(ContentSetPanel.this) && (selectionCount = (indexes = ContentSetPanel.ra$_contentList(ContentSetPanel.this).getSelectedIndices()).length) == 1) {
                int pos = indexes[0];
                ContentFolder folder = (ContentFolder)ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).getElementAt(pos);
                ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).remove(pos);
                ContentSetPanel.ra$CONTENT_LIST_MODEL(ContentSetPanel.this).add(++pos, folder);
                ContentSetPanel.ra$_contentList(ContentSetPanel.this).setSelectedIndex(pos);
            }
            ContentSetPanel.wa$_updating(ContentSetPanel.this, false);
            ContentSetPanel.mav$enableControls(ContentSetPanel.this);
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == ContentSetPanel.ra$_contentList(ContentSetPanel.this) && !e.getValueIsAdjusting()) {
                Object[] selection = ContentSetPanel.ra$_contentList(ContentSetPanel.this).getSelectedValues();
                ContentSetPanel.wa$_activeContentFlders(ContentSetPanel.this, new ContentFolder[selection.length]);
                int i = 0;
                while (i < selection.length) {
                    ContentSetPanel.ra$_activeContentFlders((ContentSetPanel)ContentSetPanel.this)[i] = (ContentFolder)selection[i];
                    ++i;
                }
                ContentSetPanel.ra$FILTER_TABS(ContentSetPanel.this).setData(ContentSetPanel.ra$_activeContentFlders(ContentSetPanel.this));
                ContentSetPanel.mav$enableControls(ContentSetPanel.this);
            }
        }

        private InteractionListener() {
        }

        InteractionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public static class EmptyContentSetException
    extends Exception {
        EmptyContentSetException() {
            super("The ContentSet is empty.");
        }
    }

    private static class LCR
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof ContentFolder) {
                l.setIcon(OracleIcons.getIcon((String)"folder.png"));
                l.setText(URLFileSystem.getPlatformPathName((URL)((ContentFolder)value).getContentFolderURL()));
            } else if (!(value instanceof String)) {
                System.err.println("**** Warning: unrecognized list item type: " + (value != null ? value.getClass() : null));
            }
            return l;
        }

        private LCR() {
        }

        LCR(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

