/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyCache {
    private Workspace workspace;
    private boolean dirty;
    private WorkspaceObserver workspaceObserver;
    private ProjectObserver projectObserver;
    HashSet<Project> observedProjects;
    private final HashMap<Project, Collection<Project>> up;
    private final HashMap<Project, Collection<Project>> down;
    private static final HashMap<Workspace, DependencyCache> INSTANCES = new HashMap();
    private static final DependencyListener dependencyListener = new DependencyListener(null);

    private void $init$() {
        this.dirty = true;
        this.workspaceObserver = new WorkspaceObserver(null);
        this.projectObserver = new ProjectObserver(null);
        this.observedProjects = new HashSet();
        this.up = new HashMap();
        this.down = new HashMap();
    }

    static {
        Node.addNodeListenerForType(Workspace.class, (NodeListener)new WorkspaceListener(null));
        Project.addProjectChangeListener((String)(DependencyConfiguration.DATA_KEY + "/" + "dependencyList"), (ProjectChangeListener)dependencyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DependencyCache getInstance(Context context) {
        HashMap<Workspace, DependencyCache> hashMap = INSTANCES;
        synchronized (hashMap) {
            Workspace workspace = context.getWorkspace();
            DependencyCache instance = INSTANCES.get(workspace);
            if (instance == null) {
                instance = new DependencyCache(workspace);
                INSTANCES.put(workspace, instance);
            }
            DependencyCache dependencyCache = instance;
            return dependencyCache;
        }
    }

    private DependencyCache(Workspace workspace) {
        this.$init$();
        this.workspace = workspace;
        workspace.attach((Observer)this.workspaceObserver);
    }

    public synchronized Collection<Project> getUpstreamProjects(Project project) throws InterruptedException {
        this.update();
        Collection<Project> upList = this.up.get(project);
        return upList == null ? null : Collections.unmodifiableCollection(upList);
    }

    public synchronized Collection<Project> getDownstreamProjects(Project project) throws InterruptedException {
        this.update();
        Collection<Project> downList = this.down.get(project);
        return downList == null ? null : Collections.unmodifiableCollection(downList);
    }

    public synchronized Collection<Project> getProjectsUsing(Context context, String ... fqClassNames) throws InterruptedException {
        this.update();
        HashSet<Project> results = new HashSet<Project>();
        LinkedList<Project> queue = new LinkedList<Project>();
        ArrayList<String> classNames = new ArrayList<String>(Arrays.asList(fqClassNames));
        queue.add(context.getProject());
        while (!queue.isEmpty() && !classNames.isEmpty()) {
            Collection<Project> upList;
            boolean found = false;
            Project current = (Project)queue.removeFirst();
            JavaManager javaManager = JavaManager.getJavaManager((Project)current);
            Iterator iterator = classNames.iterator();
            while (iterator.hasNext()) {
                JavaClass javaClass = javaManager.getClass((String)iterator.next());
                if (javaClass == null) continue;
                found = true;
                if (!this.isOwner(current, javaClass)) continue;
                iterator.remove();
            }
            if (!found) continue;
            results.add(current);
            Collection<Project> downList = this.down.get(current);
            if (downList != null) {
                results.addAll(downList);
            }
            if ((upList = this.up.get(current)) == null) continue;
            for (Project upProject : upList) {
                if (results.contains(upProject)) continue;
                queue.add(upProject);
            }
        }
        return Collections.unmodifiableCollection(results);
    }

    private void dispose() {
        this.workspace.detach((Observer)this.workspaceObserver);
        for (Project project : this.observedProjects) {
            project.detach((Observer)this.projectObserver);
        }
    }

    private synchronized void update() throws InterruptedException {
        if (this.dirty) {
            PerformanceLogger.get().startTiming("DependencyCache.update");
            try {
                for (Project project : this.observedProjects) {
                    project.detach((Observer)this.projectObserver);
                }
                this.observedProjects.clear();
                this.up.clear();
                this.down.clear();
                Collection<Project> projects = this.getProjects();
                this.observedProjects.addAll(projects);
                LinkedList<Project> queue = new LinkedList<Project>(projects);
                while (!queue.isEmpty()) {
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Project project = queue.removeFirst();
                    project.attach((Observer)this.projectObserver);
                    Collection<Project> upList = this.up.get(project);
                    for (Project dependency : this.getDependencies(project)) {
                        if (upList == null) {
                            upList = new ArrayList<Project>();
                            this.up.put(project, upList);
                        }
                        upList.add(dependency);
                        Collection<Project> downList = this.down.get(dependency);
                        if (downList == null) {
                            downList = new ArrayList<Project>();
                            this.down.put(dependency, downList);
                        }
                        downList.add(project);
                        if (this.observedProjects.contains(dependency)) continue;
                        this.observedProjects.add(dependency);
                        queue.add(dependency);
                    }
                }
                this.dirty = false;
            }
            finally {
                PerformanceLogger.get().stopTiming("DependencyCache.update", "Built dependency cache for " + this.workspace.getShortLabel());
            }
        }
    }

    private Collection<Project> getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>();
        Iterator iterator = this.workspace.getChildren();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (!(child instanceof Project)) continue;
            projects.add((Project)child);
        }
        return projects;
    }

    private Collection<Project> getDependencies(Project project) {
        ArrayList<Project> dependencies = new ArrayList<Project>();
        DependencyConfiguration dc = DependencyConfiguration.getInstance((Project)project);
        Iterator iterator = dc.getDependencies();
        while (iterator.hasNext()) {
            Dependable dependable = (Dependable)iterator.next();
            Element source = dependable.getSource();
            if (!(source instanceof Project)) continue;
            dependencies.add((Project)source);
        }
        return dependencies;
    }

    private boolean isOwner(Project project, JavaClass javaClass) {
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        if (sourceClass != null) {
            SourceFile owningSourceFile = sourceClass.getOwningSourceFile();
            ContentSet contents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            if (contents.canHaveMember(owningSourceFile.getURL())) {
                return true;
            }
        }
        return false;
    }

    static HashMap ra$INSTANCES() {
        return INSTANCES;
    }

    static void mav$dispose(DependencyCache dependencyCache) {
        dependencyCache.dispose();
    }

    static void wa$dirty(DependencyCache dependencyCache, boolean bl) {
        dependencyCache.dirty = bl;
    }

    private static class WorkspaceListener
    extends NodeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeClosed(NodeEvent e) {
            Workspace workspace = (Workspace)e.getNode();
            HashMap hashMap = DependencyCache.ra$INSTANCES();
            synchronized (hashMap) {
                DependencyCache instance = (DependencyCache)DependencyCache.ra$INSTANCES().remove(workspace);
                if (instance != null) {
                    DependencyCache.mav$dispose(instance);
                }
            }
        }

        private WorkspaceListener() {
        }

        WorkspaceListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class DependencyListener
    extends ProjectChangeListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectPropertiesChanged(ProjectChangeEvent e) {
            Project project = e.getProject();
            HashMap hashMap = DependencyCache.ra$INSTANCES();
            synchronized (hashMap) {
                for (Map.Entry entry : DependencyCache.ra$INSTANCES().entrySet()) {
                    DependencyCache instance = (DependencyCache)entry.getValue();
                    if (!instance.observedProjects.contains(project)) continue;
                    DependencyCache.wa$dirty(instance, true);
                }
            }
        }

        private DependencyListener() {
        }

        DependencyListener(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class WorkspaceObserver
    implements Observer {
        public void update(Object observed, UpdateMessage change) {
            block2: {
                int id;
                block4: {
                    block3: {
                        id = change.getMessageID();
                        if (id != UpdateMessage.OBJECT_RELOADED) break block3;
                        DependencyCache.wa$dirty(DependencyCache.this, true);
                        break block2;
                    }
                    if (id != UpdateMessage.CHILD_ADDED) break block4;
                    for (Object object : change.getAddObjects()) {
                        if (!(object instanceof Project)) continue;
                        DependencyCache.wa$dirty(DependencyCache.this, true);
                        break block2;
                    }
                    break block2;
                }
                if (id != UpdateMessage.CHILD_REMOVED) break block2;
                for (Object object : change.getRemoveObjects()) {
                    if (!(object instanceof Project)) continue;
                    DependencyCache.wa$dirty(DependencyCache.this, true);
                    break;
                }
            }
        }

        private WorkspaceObserver() {
        }

        WorkspaceObserver(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ProjectObserver
    implements Observer {
        public void update(Object observed, UpdateMessage change) {
            int id = change.getMessageID();
            if (id == UpdateMessage.OBJECT_RELOADED) {
                DependencyCache.wa$dirty(DependencyCache.this, true);
            }
        }

        private ProjectObserver() {
        }

        ProjectObserver(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

