/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ResourcePaths;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.model.ProjectDependencyFactory;
import oracle.jdeveloper.resource.JProjectArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JProjectDependencyPanel
extends ProjectSettingsTraversablePanel {
    private JMutableTreeNode _rootNode;
    private final DefaultTreeModel _treeModel;
    private final CustomJTree _depsTree;
    private final JButton _btnOrdering;
    private Project _curProject;
    private List _deps;
    private transient Workspace _curWorkspace;
    private static final String[] PROPERTY_KEYS = new String[]{"dependencyList"};

    private void $init$() {
        this._rootNode = new JMutableTreeNode();
        this._treeModel = new DefaultTreeModel((TreeNode)this._rootNode);
        this._depsTree = new CustomJTree((TreeModel)this._treeModel);
        this._btnOrdering = new JButton();
        this._curProject = null;
    }

    public JProjectDependencyPanel() {
        this.$init$();
        JLabel prompt = new JLabel(JProjectArb.getString((int)73));
        prompt.setDisplayedMnemonic(JProjectArb.getMnemonic((int)118));
        prompt.setLabelFor((Component)this._depsTree);
        ResourceUtils.resButton((AbstractButton)this._btnOrdering, (String)JProjectArb.getString((int)157));
        this._depsTree.setRootVisible(false);
        this._depsTree.setShowsRootHandles(true);
        this._depsTree.setScrollsOnExpand(true);
        this._depsTree.setPropagateCheckState(false);
        L l = new L(null);
        this._btnOrdering.addActionListener(l);
        this._depsTree.addTreeExpansionListener((TreeExpansionListener)l);
        this._depsTree.addTreeCellCheckedListener((TreeCellCheckedListener)l);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add((Component)this._depsTree, null);
        this.setLayout(new GridBagLayout());
        this.add(prompt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.add(scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this._btnOrdering, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setHelpID("f1_idedprojsetdependencies_html");
    }

    public String getDataKey() {
        return DependencyConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        boolean isDefaultProject = JProjectDependencyPanel.isDefaultProject((Namespace)tc);
        if (isDefaultProject) {
            this._deps = null;
            this._rootNode = new JMutableTreeNode();
            this._treeModel.setRoot((TreeNode)this._rootNode);
            this._curWorkspace = null;
        } else {
            this._depsTree.setVisible(true);
            PropertyStorage propertyData = JProjectDependencyPanel.getPropertyData((Namespace)tc);
            DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((PropertyStorage)propertyData);
            this._deps = dependencyConfiguration.getDependencyList();
            this._curWorkspace = Ide.getActiveWorkspace();
            this._curProject = (Project)tc.find("Project");
            this.initTree(this._curWorkspace);
        }
        this.updateOrderingButton();
    }

    public void onExit(TraversableContext tc) {
        PropertyStorage propertyData = JProjectDependencyPanel.getPropertyData((Namespace)tc);
        DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((PropertyStorage)propertyData);
        dependencyConfiguration.setDependencyList(this._deps);
    }

    private void updateOrderingButton() {
        this._btnOrdering.setEnabled(this._deps != null && this._deps.size() > 1);
    }

    private static URL tryGetURL(Element element, Element parent) {
        if (element instanceof Profile && parent instanceof Project) {
            return DeployUtil.getProfileURL((DataContainer)((Project)parent), (Profile)element);
        }
        return element instanceof Locatable ? ((Locatable)element).getURL() : null;
    }

    private boolean matches(Dependable dep, URL depSourceURL, URL depOwnerURL) {
        if (dep == null) {
            return false;
        }
        Element depSource = dep.getSource();
        Folder depSourceOwner = dep.getSourceOwner();
        if (depSourceOwner == null && depSource instanceof Project) {
            depSourceOwner = this._curWorkspace;
        } else if (depSourceOwner != this._curWorkspace && depSourceOwner instanceof Workspace) {
            depSourceOwner = this._curWorkspace;
        }
        return URLFileSystem.equals((URL)JProjectDependencyPanel.tryGetURL(depSource, (Element)depSourceOwner), (URL)depSourceURL) && URLFileSystem.equals((URL)JProjectDependencyPanel.tryGetURL((Element)depSourceOwner, null), (URL)depOwnerURL);
    }

    private static Element getDepSource(JMutableTreeNode node) {
        return (Element)node.getUserObject();
    }

    private void initTree(Workspace workspace) {
        Enumeration iter = this._depsTree.getExpandedDescendants(new TreePath(this._rootNode));
        ArrayList<Object> expandedElems = new ArrayList<Object>();
        if (iter != null) {
            while (iter.hasMoreElements()) {
                TreePath tp = (TreePath)iter.nextElement();
                JMutableTreeNode node = (JMutableTreeNode)tp.getLastPathComponent();
                expandedElems.add(node.getUserObject());
            }
        }
        this._rootNode = this.createTreeNode(null, (Element)workspace, false);
        this.addChildren(this._rootNode, true);
        this._treeModel.setRoot((TreeNode)this._rootNode);
        this.restoreOrInitExpandedTreeNodes(this._rootNode, iter != null, expandedElems);
    }

    private void restoreOrInitExpandedTreeNodes(JMutableTreeNode parent, boolean restore, ArrayList expandedElems) {
        Enumeration iter = parent.children();
        while (iter.hasMoreElements()) {
            JMutableTreeNode node = (JMutableTreeNode)iter.nextElement();
            Element elem = (Element)node.getUserObject();
            if (restore && expandedElems.contains(elem) || !restore && this.depsListContains(elem)) {
                this._depsTree.expandPath(new TreePath(node.getPath()));
            }
            if (node.isLeaf()) continue;
            this.restoreOrInitExpandedTreeNodes(node, restore, expandedElems);
        }
    }

    private boolean depsListContains(Element elem) {
        if (this._deps != null) {
            for (Dependable dep : this._deps) {
                if (dep == null || dep.getSource() != elem && dep.getSourceOwner() != elem) continue;
                return true;
            }
        }
        return false;
    }

    private JMutableTreeNode createTreeNode(Element parent, Element element, boolean withCheckBox) {
        TriStateBoolean isSelected = TriStateBoolean.getState((withCheckBox && this.isSelected(parent, element) ? 1 : 0) != 0);
        JTreeCellData data = new JTreeCellData(element.getIcon(), element.getShortLabel(), withCheckBox, isSelected);
        1 node = new 1(data, element.mayHaveChildren());
        node.setUserObject(element);
        return node;
    }

    private boolean isSelected(Element parent, Element element) {
        URL elemURL;
        if (this._deps != null && (elemURL = JProjectDependencyPanel.tryGetURL(element, parent)) != null) {
            URL parentURL = JProjectDependencyPanel.tryGetURL(parent, null);
            for (Dependable dep : this._deps) {
                if (!this.matches(dep, elemURL, parentURL)) continue;
                return true;
            }
        }
        return false;
    }

    private void addChildren(JMutableTreeNode parent, boolean withCheckBox) {
        block17: {
            Element parentElement;
            block18: {
                parentElement = (Element)parent.getUserObject();
                if (!parentElement.mayHaveChildren()) break block17;
                URL curProjectURL = this._curProject.getURL();
                if (!(parentElement instanceof Workspace)) break block18;
                ArrayList<Element> sortedList = new ArrayList<Element>();
                Iterator children = parentElement.getChildren();
                while (children.hasNext()) {
                    sortedList.add((Element)children.next());
                }
                int depsCount = this._deps != null ? this._deps.size() : 0;
                ArrayList<Element> errors = new ArrayList<Element>(depsCount);
                ArrayList<Element> warnings = new ArrayList<Element>(depsCount);
                if (depsCount > 0) {
                    for (Dependable nextDependable : this._deps) {
                        URL nextURL;
                        Element dependableElement = nextDependable.getSource();
                        if (!(dependableElement instanceof Locatable) || this.contains(nextURL = ((Locatable)dependableElement).getURL(), sortedList)) continue;
                        sortedList.add(dependableElement);
                        (URLFileSystem.exists((URL)nextURL) ? warnings : errors).add(dependableElement);
                    }
                }
                Collections.sort(sortedList, new 2());
                for (Element childElement : sortedList) {
                    if (!JProjectDependencyPanel.isShownInTree(childElement, withCheckBox) || JProjectDependencyPanel.isCurrentProject(childElement, curProjectURL)) continue;
                    JMutableTreeNode treeNode = this.createTreeNode(parentElement, childElement, withCheckBox);
                    parent.add((MutableTreeNode)treeNode);
                    if (warnings.size() <= 0 && errors.size() <= 0 || !(childElement instanceof Locatable)) continue;
                    URL url = ((Locatable)childElement).getURL();
                    JTreeCellData cellData = treeNode.getModel();
                    if (this.contains(url, warnings)) {
                        cellData.setCheckBoxState(true);
                        cellData.setIcon(OracleIcons.getIcon((String)"warning.png"));
                        cellData.setText(String.format("%s %s", cellData.getText(), JProjectArb.getString((int)109)));
                        warnings.remove(url);
                        continue;
                    }
                    if (!this.contains(url, errors)) continue;
                    cellData.setCheckBoxState(true);
                    cellData.setIcon(OracleIcons.getIcon((String)"error.png"));
                    cellData.setText(String.format("%s %s", cellData.getText(), JProjectArb.getString((int)153)));
                    errors.remove(url);
                }
                break block17;
            }
            if (!(parentElement instanceof Profile)) {
                Iterator children;
                if (parentElement instanceof Project) {
                    ResourcePaths resourcePaths = ResourcePaths.getInstance((PropertyStorage)((Project)parentElement));
                    children = resourcePaths.getResourcesContentSet().nodeIterator("");
                } else {
                    children = parentElement.getChildren();
                }
                ArrayList excludeList = new ArrayList();
                while (children.hasNext()) {
                    Element child = (Element)children.next();
                    if (JProjectDependencyPanel.isShownInTree(child, withCheckBox)) {
                        parent.add((MutableTreeNode)this.createTreeNode(parentElement, child, withCheckBox));
                        continue;
                    }
                    if (!Deployment.isDeploymentContainerProfile(child)) continue;
                    parent.add((MutableTreeNode)this.createTreeNode(parentElement, child, false));
                    Iterator containedProfiles = child.getChildren();
                    while (containedProfiles.hasNext()) {
                        excludeList.add(containedProfiles.next());
                    }
                }
                if (!excludeList.isEmpty()) {
                    int n = parent.getChildCount();
                    int i = n - 1;
                    while (i >= 0) {
                        JMutableTreeNode node = (JMutableTreeNode)parent.getChildAt(i);
                        Object userObj = node.getUserObject();
                        if (excludeList.contains(userObj)) {
                            parent.remove((MutableTreeNode)node);
                        }
                        --i;
                    }
                }
            }
            if (!(parentElement instanceof Project)) break block17;
            Project project = (Project)parentElement;
            DeploymentProfiles profiles = DeploymentProfiles.getInstance((DataContainer)project);
            Map profileMap = profiles.getDefinedProfiles(true);
            Set entrySet = profileMap.entrySet();
            for (Map.Entry entry : entrySet) {
                Profile profile = (Profile)entry.getValue();
                JMutableTreeNode treeNode = this.createTreeNode(parentElement, profile, withCheckBox && !profile.mayHaveChildren());
                if (treeNode != null) {
                    parent.add((MutableTreeNode)treeNode);
                }
                if (!profile.mayHaveChildren()) continue;
                Iterator iter = profile.getChildren();
                while (iter != null && iter.hasNext()) {
                    Profile childProfile = (Profile)iter.next();
                    JMutableTreeNode childTreeNode = this.createTreeNode(parentElement, childProfile, withCheckBox);
                    if (childTreeNode == null) continue;
                    treeNode.add((MutableTreeNode)childTreeNode);
                }
            }
        }
    }

    private boolean contains(URL url, List<Element> list) {
        if (list != null && list.size() > 0) {
            for (Element element : list) {
                if (!(element instanceof Locatable) || !((Locatable)element).getURL().equals(url)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isShownInTree(Element child, boolean withCheckBox) {
        return !withCheckBox || ProjectDependencyFactory.hasFactory((Element)child);
    }

    private static boolean isCurrentProject(Element child, URL curProjectURL) {
        return child instanceof Project && URLFileSystem.equals((URL)curProjectURL, (URL)((Project)child).getURL());
    }

    static List ra$_deps(JProjectDependencyPanel jProjectDependencyPanel) {
        return jProjectDependencyPanel._deps;
    }

    static Element maS$getDepSource(JMutableTreeNode jMutableTreeNode) {
        return JProjectDependencyPanel.getDepSource(jMutableTreeNode);
    }

    static URL maS$tryGetURL(Element element, Element element2) {
        return JProjectDependencyPanel.tryGetURL(element, element2);
    }

    static boolean mav$matches(JProjectDependencyPanel jProjectDependencyPanel, Dependable dependable, URL uRL, URL uRL2) {
        return jProjectDependencyPanel.matches(dependable, uRL, uRL2);
    }

    static void mav$updateOrderingButton(JProjectDependencyPanel jProjectDependencyPanel) {
        jProjectDependencyPanel.updateOrderingButton();
    }

    static void wa$_deps(JProjectDependencyPanel jProjectDependencyPanel, List list) {
        jProjectDependencyPanel._deps = list;
    }

    static JButton ra$_btnOrdering(JProjectDependencyPanel jProjectDependencyPanel) {
        return jProjectDependencyPanel._btnOrdering;
    }

    static void mav$addChildren(JProjectDependencyPanel jProjectDependencyPanel, JMutableTreeNode jMutableTreeNode, boolean bl) {
        jProjectDependencyPanel.addChildren(jMutableTreeNode, bl);
    }

    static DefaultTreeModel ra$_treeModel(JProjectDependencyPanel jProjectDependencyPanel) {
        return jProjectDependencyPanel._treeModel;
    }

    private class L
    implements ActionListener,
    TreeExpansionListener,
    TreeCellCheckedListener {
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == JProjectDependencyPanel.ra$_btnOrdering(JProjectDependencyPanel.this)) {
                Object[] depsArray;
                Ordering panel = new Ordering();
                Namespace data = new Namespace();
                data.put("deps-array", JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this) != null ? JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).toArray() : null);
                TDialogLauncher tdl = new TDialogLauncher((Component)((Object)JProjectDependencyPanel.this), JProjectArb.getString((int)167), (Traversable)panel, data);
                tdl.setPackDialog(true);
                boolean okResponse = tdl.showDialog();
                if (okResponse && (depsArray = (Object[])data.find("deps-array")) != null) {
                    JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).clear();
                    JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).addAll(Arrays.asList(depsArray));
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            JMutableTreeNode node = (JMutableTreeNode)path.getLastPathComponent();
            if (!node.isLeaf()) {
                Ide.getWaitCursor().show();
                SwingUtilities.invokeLater(new 1(this, node));
            }
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void cellChecked(TreeCellCheckedEvent e) {
            JMutableTreeNode node = (JMutableTreeNode)e.getSource();
            Folder depOwner = this.getDepSourceOwner(node);
            try {
                Element depSource = JProjectDependencyPanel.maS$getDepSource(node);
                Dependable dep = null;
                dep = depSource instanceof Profile ? Deployment.getDependableFactory().findOrCreate(depSource, depOwner) : ProjectDependencyFactory.findOrCreate((Element)depSource, (Folder)depOwner);
                if (dep != null) {
                    if (JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this) == null) {
                        JProjectDependencyPanel.wa$_deps(JProjectDependencyPanel.this, new ArrayList());
                    }
                    JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).add(dep);
                    JProjectDependencyPanel.mav$updateOrderingButton(JProjectDependencyPanel.this);
                }
            }
            catch (Exception ex) {
                Assert.printStackTrace((Throwable)ex);
            }
        }

        private Project getParentProject(JMutableTreeNode node) {
            Object obj;
            JMutableTreeNode curNode = node;
            do {
                if ((curNode = (JMutableTreeNode)curNode.getParent()) != null) continue;
                return null;
            } while (!((obj = curNode.getUserObject()) instanceof Project));
            return (Project)obj;
        }

        public void cellUnchecked(TreeCellCheckedEvent e) {
            if (JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this) != null) {
                JMutableTreeNode node = (JMutableTreeNode)e.getSource();
                Project project = this.getParentProject(node);
                URL depSourceURL = JProjectDependencyPanel.maS$tryGetURL(JProjectDependencyPanel.maS$getDepSource(node), (Element)project);
                URL depOwnerURL = JProjectDependencyPanel.maS$tryGetURL((Element)this.getDepSourceOwner(node), null);
                int i = 0;
                while (i < JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).size()) {
                    Dependable dep = (Dependable)JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).get(i);
                    if (JProjectDependencyPanel.mav$matches(JProjectDependencyPanel.this, dep, depSourceURL, depOwnerURL)) {
                        JProjectDependencyPanel.ra$_deps(JProjectDependencyPanel.this).remove(i);
                    }
                    ++i;
                }
                JProjectDependencyPanel.mav$updateOrderingButton(JProjectDependencyPanel.this);
            }
        }

        private Folder getDepSourceOwner(JMutableTreeNode node) {
            Object depSourceOwner;
            JMutableTreeNode curNode = node;
            do {
                if ((curNode = (JMutableTreeNode)curNode.getParent()) != null) continue;
                return null;
            } while (!((depSourceOwner = curNode.getUserObject()) instanceof Project) && !(depSourceOwner instanceof Workspace));
            return (Folder)depSourceOwner;
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ JMutableTreeNode v$node;
            final /* synthetic */ L this$0;

            public void run() {
                if (this.v$node.getChildCount() == 0) {
                    JProjectDependencyPanel.mav$addChildren(this.this$0.JProjectDependencyPanel.this, this.v$node, true);
                    JProjectDependencyPanel.ra$_treeModel(this.this$0.JProjectDependencyPanel.this).reload((TreeNode)this.v$node);
                }
                Ide.getWaitCursor().hide();
            }

            public 1(L l, JMutableTreeNode jMutableTreeNode) {
                this.v$node = jMutableTreeNode;
                this.this$0 = l;
            }
        }
    }

    private static class Ordering
    extends DefaultTraversablePanel
    implements ActionListener,
    ListSelectionListener {
        private static final String DEPS_ARRAY = "deps-array";
        private final JList _list;
        private final JButton _btnUp;
        private final JButton _btnDown;
        private Object[] _depsArray;

        private void $init$() {
            this._list = new JList();
            this._btnUp = new JButton();
            this._btnDown = new JButton();
        }

        Ordering() {
            this.$init$();
            this._btnUp.setIcon(ComponentArb.getIcon((int)3));
            this._btnUp.setDisabledIcon(ComponentArb.getIcon((int)23));
            this._btnDown.setIcon(ComponentArb.getIcon((int)9));
            this._btnDown.setDisabledIcon(ComponentArb.getIcon((int)0));
            this._list.addListSelectionListener(this);
            this._btnUp.addActionListener(this);
            this._btnDown.addActionListener(this);
            Insets buttonMargin = new Insets(2, 2, 2, 2);
            this._btnUp.setMargin(buttonMargin);
            this._btnDown.setMargin(buttonMargin);
            JScrollPane sp = new JScrollPane();
            sp.getViewport().add((Component)this._list, null);
            this.setLayout(new GridBagLayout());
            this.add(sp, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this._btnUp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 8, 5, 0), 0, 0));
            this.add(this._btnDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 8, 0, 0), 0, 0));
            this.setHelpID("f1_idedprojectdependenciesordering_html");
        }

        public void onEntry(TraversableContext tc) {
            this._depsArray = (Object[])tc.find(DEPS_ARRAY);
            this._list.setListData(this._depsArray != null ? this._depsArray : new Object[]{});
            this.enableButtons();
        }

        public void onExit(TraversableContext tc) {
            tc.findAndReplace(DEPS_ARRAY, (Object)this._depsArray);
        }

        public void valueChanged(ListSelectionEvent e) {
            this.enableButtons();
        }

        private void enableButtons() {
            int selected = this._list.getSelectedIndex();
            this._btnUp.setEnabled(selected > 0);
            this._btnDown.setEnabled(selected >= 0 && selected < this._depsArray.length - 1);
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            int index = this._list.getSelectedIndex();
            if (source == this._btnUp) {
                this.swapAndSet(index, index - 1);
            } else if (source == this._btnDown) {
                this.swapAndSet(index, index + 1);
            }
        }

        private void swapAndSet(int i, int j) {
            Object swap = this._depsArray[i];
            this._depsArray[i] = this._depsArray[j];
            this._depsArray[j] = swap;
            this._list.setListData(this._depsArray);
            this._list.setSelectedIndex(j);
        }
    }

    final class 1
    extends JMutableTreeNode {
        public boolean isLeaf() {
            return this.allowsChildren ^ true;
        }

        public 1(JTreeCellData jTreeCellData, boolean bl) {
            super(jTreeCellData, bl);
        }
    }

    final class 2
    implements Comparator {
        public int compare(Element o1, Element o2) {
            return o1.getShortLabel().compareToIgnoreCase(o2.getShortLabel());
        }
    }
}

