/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.cmd.OpenCommandData;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.model.panels.PropertiesDialog;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideri.util.Product;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cmd.NewInterfaceCommand;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JDevTechnologies;
import oracle.jdeveloper.model.JProjectTechnologyNotifier;
import oracle.jdeveloper.resource.CommandArb;
import oracle.jdeveloper.resource.ModelArb;

class JProjectStructureController
implements Controller,
Addin {
    public static final int ADD_TO_PROJECT_CMD_ID = AddContentCommand.ADD_TO_PROJECT_CMD_ID;
    private static JMenuItem editConfigurationsDlgItem;
    private static JMenuItem addToProjectContextItem;
    private static boolean menusBuilt;
    private JMenuItem emptyItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem eraseMenuItem;
    private IdeAction projectSettingsAction;
    private IdeAction defaultProjectSettingsAction;
    private static final String APPLICATION_PROPERTIES_CMD = "oracle.jdeveloper.model.JProjectStructureController.APPLICATION_PROPERTIES_CMD";
    private static int APPLICATION_PROPERTIES_CMD_ID;

    public JProjectStructureController() {
        APPLICATION_PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)APPLICATION_PROPERTIES_CMD);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 35) {
            Project project = context.getProject();
            if (project != null) {
                ProjectPropertiesDialog.showDialog((Context)context, (Project)project);
            }
            return true;
        }
        if (cmdId == APPLICATION_PROPERTIES_CMD_ID) {
            Workspace workspace = context.getWorkspace();
            if (workspace != null) {
                PropertiesDialog.getInstance((String)"Application").showDialog(context, (HashStructureNode)workspace);
            }
            return true;
        }
        if (cmdId == 37) {
            Project project = Ide.getDefaultProject();
            if (project != null) {
                ProjectPropertiesDialog.showDialog((Context)context, (Project)project);
            }
            return true;
        }
        if (cmdId == NewInterfaceCommand.CMD_ID) {
            CommandProcessor cmdProc = CommandProcessor.getInstance();
            Command cmd = CommandProcessor.createCommand((String)action.getCommand(), (Context)context);
            try {
                cmdProc.invoke(cmd);
            }
            catch (Exception ex) {
                oracle.ide.dialogs.ExceptionDialog.showExceptionDialog((Context)context, (Throwable)ex);
            }
            return true;
        }
        if (cmdId == ADD_TO_PROJECT_CMD_ID) {
            Element element = context.getElement();
            if (element == null) {
                return false;
            }
            OpenCommandData data = new OpenCommandData(true);
            String openTitle = null;
            DefaultURLFilter urlFilter = null;
            if (element.getData() instanceof Workspaces) {
                openTitle = ModelArb.getString((int)83);
                urlFilter = new DefaultURLFilter(ModelArb.getString((int)78));
                urlFilter.addExtension(".jws");
            } else if (element instanceof Workspace) {
                openTitle = ModelArb.getString((int)46);
                urlFilter = new DefaultURLFilter(ModelArb.getString((int)18));
                urlFilter.addExtension(".jpr");
            }
            if (urlFilter != null) {
                data.dialogTitle = openTitle;
                data.urlFilter = urlFilter;
                IdeAction openAction = IdeAction.find((int)9);
                openAction.putValue("UserData", (Object)data);
                try {
                    try {
                        openAction.performAction(context);
                    }
                    catch (Exception ex) {
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex);
                    }
                }
                finally {
                    openAction.putValue("UserData", null);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 35) {
            boolean enabled = context.getProject() != null;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length > 1 && selection[0] instanceof Project) {
                enabled = false;
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == APPLICATION_PROPERTIES_CMD_ID) {
            boolean enabled = context.getWorkspace() != null;
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == ADD_TO_PROJECT_CMD_ID) {
            Element[] selection = context.getSelection();
            String label = null;
            boolean enableAction = false;
            if (selection == null || selection.length == 0 || selection.length > 1 || selection[0] == null) {
                label = ModelArb.getString((int)51);
                enableAction = false;
            } else {
                Element element = selection[0];
                if (element.getData() instanceof Workspaces || element instanceof Workspace) {
                    label = ModelArb.format((int)106, (Object)element.getShortLabel());
                    enableAction = true;
                } else if (element instanceof Project || context.getProject() != null) {
                    label = ModelArb.getString((int)51);
                    enableAction = true;
                }
            }
            action.setEnabled(enableAction);
            action.putValue("Name", (Object)StringUtils.stripMnemonic((String)label));
            return true;
        }
        if (cmdId == 21) {
            View view;
            String target = null;
            View view2 = view = context != null ? context.getView() : null;
            if (view instanceof ProjectNavigatorWindow) {
                Element[] selection = context.getSelection();
                if (selection != null && selection.length > 0) {
                    if (selection[0] instanceof Project) {
                        target = context.getWorkspace().getShortLabel();
                        action.setEnabled(true);
                    } else if (selection[0] instanceof Workspace) {
                        target = Ide.getWorkspaces().getShortLabel();
                        action.setEnabled(true);
                    } else if (selection[0] == Ide.getWorkspaces() || selection[0].getData() == Ide.getWorkspaces()) {
                        action.setEnabled(false);
                    } else {
                        Project project = context.getProject();
                        if (project != null) {
                            target = project.getShortLabel();
                            action.setEnabled(false);
                        }
                    }
                } else {
                    action.setEnabled(false);
                }
                String label = null;
                label = target == null ? IdeArb.getString((int)428) : IdeArb.format((int)139, target);
                action.putValue("Name", (Object)label);
                return true;
            }
        } else if (cmdId == NewInterfaceCommand.CMD_ID) {
            boolean enabled = context != null && context.getProject() != null;
            action.setEnabled(enabled);
            return true;
        }
        return false;
    }

    private IdeAction getProjectSettingsAction() {
        if (this.projectSettingsAction == null) {
            this.projectSettingsAction = IdeAction.find((int)35);
        }
        return this.projectSettingsAction;
    }

    private synchronized void buildMenus(MenuManager mgr) {
        if (!menusBuilt) {
            IdeAction action = this.getAction(8, IdeArb.getString((int)263), IdeArb.getInteger((int)81), IdeArb.getInstance(), 127, null);
            action.setEnabled(true);
            action = this.getAction(NewInterfaceCommand.CMD_ID, CommandArb.getString(39), CommandArb.getInteger(4), CommandArb.getInstance(), 44, this);
            action.setCommand(NewInterfaceCommand.CMD_NAME);
            action.setEnabled(true);
            editConfigurationsDlgItem = mgr.createMenuItem((ToggleAction)this.getProjectSettingsAction(), MenuConstants.WEIGHT_TOOLS_PROJECT_PROPERTIES);
            action = IdeAction.find((int)ADD_TO_PROJECT_CMD_ID);
            addToProjectContextItem = mgr.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_FILE_ADD_TO_PROJECT);
            this.deleteMenuItem = mgr.createMenuItem((ToggleAction)IdeActions.getFileRemoveFromIDEAction(), MenuConstants.WEIGHT_FILE_ERASE);
            this.deleteMenuItem.setIcon(null);
            this.eraseMenuItem = mgr.createMenuItem((ToggleAction)IdeActions.getFileRemoveFromDiskAction(), MenuConstants.WEIGHT_FILE_ERASE);
            menusBuilt = true;
        }
    }

    private static boolean isApplicationNavigator(View view) {
        return view instanceof ProjectNavigatorWindow;
    }

    public void initialize() {
        JMenu toolsMenu;
        this.projectSettingsAction = IdeAction.find((int)35);
        this.projectSettingsAction.addController((Controller)this);
        this.defaultProjectSettingsAction = IdeAction.find((int)37);
        this.defaultProjectSettingsAction.addController((Controller)this);
        this.defaultProjectSettingsAction.setEnabled(true);
        if (Product.isJDeveloper() && Ide.getIdeArgs().getCreateUI() && (toolsMenu = MenuManager.getJMenu((String)"Tools")) != null) {
            IdeAction applicationPropertiesAction = IdeAction.get((int)APPLICATION_PROPERTIES_CMD_ID, (String)APPLICATION_PROPERTIES_CMD, (String)ModelArb.getString((int)100));
            applicationPropertiesAction.addController((Controller)this);
            Menubar menuMgr = Ide.getMenubar();
            JMenuItem applicationPropertiesMenuItem = menuMgr.createMenuItem((ToggleAction)applicationPropertiesAction, MenuConstants.WEIGHT_TOOLS_PROJECT_PROPERTIES);
            menuMgr.add((Component)applicationPropertiesMenuItem, toolsMenu, MenuConstants.SECTION_TOOLS_PROJECT_PROPERTIES);
        }
        IdeAction removeFileAction = IdeActions.getFileRemoveFromIDEAction();
        removeFileAction.addController((Controller)this);
        String label = ModelArb.format((int)106, (Object)"");
        IdeAction addToProjectAction = IdeAction.get((int)ADD_TO_PROJECT_CMD_ID, (String)AddinManager.getAddinManager().getCommand(ADD_TO_PROJECT_CMD_ID, null), (String)label);
        addToProjectAction.setEnabled(false);
        addToProjectAction.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)label)));
        addToProjectAction.addController((Controller)this);
        this.emptyItem = new JMenuItem(IdeArb.getString((int)368));
        this.emptyItem.setEnabled(false);
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        kscr.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdeveloper/model/projectaccelerators.xml");
        NavigatorManager navMgr = NavigatorManager.getWorkspaceNavigatorManager();
        JProjectMenuListener jpmListener = new JProjectMenuListener(null);
        navMgr.addContextMenuListener((ContextMenuListener)jpmListener, Workspaces.class);
        navMgr.addContextMenuListener((ContextMenuListener)jpmListener, Project.class);
        navMgr.addContextMenuListener((ContextMenuListener)new NodeMenuListener(null), Node.class);
        JDevTechnologies.register();
        JProjectTechnologyNotifier.initialize();
    }

    private IdeAction getAction(int cmdId, String label, Integer mnemonic, ArrayResourceBundle bundle, int key, Controller controller) {
        IdeAction action = IdeAction.get((int)cmdId, (String)AddinManager.getAddinManager().getCommand(cmdId, null), (String)label, (ArrayResourceBundle)bundle, (int)key);
        action.setEnabled(false);
        action.putValue("MnemonicKey", (Object)mnemonic);
        if (controller != null) {
            action.addController(controller);
        }
        return action;
    }

    private void checkEraseActionLabel(Context context) {
        IdeAction action = IdeActions.getFileRemoveFromDiskAction();
        action.updateAction(context);
    }

    static JMenuItem ra$deleteMenuItem(JProjectStructureController jProjectStructureController) {
        return jProjectStructureController.deleteMenuItem;
    }

    static boolean maS$isApplicationNavigator(View view) {
        return JProjectStructureController.isApplicationNavigator(view);
    }

    static boolean ra$menusBuilt() {
        return menusBuilt;
    }

    static void mav$buildMenus(JProjectStructureController jProjectStructureController, MenuManager menuManager) {
        jProjectStructureController.buildMenus(menuManager);
    }

    static JMenuItem ra$addToProjectContextItem() {
        return addToProjectContextItem;
    }

    static void mav$checkEraseActionLabel(JProjectStructureController jProjectStructureController, Context context) {
        jProjectStructureController.checkEraseActionLabel(context);
    }

    static JMenuItem ra$eraseMenuItem(JProjectStructureController jProjectStructureController) {
        return jProjectStructureController.eraseMenuItem;
    }

    static IdeAction mav$getProjectSettingsAction(JProjectStructureController jProjectStructureController) {
        return jProjectStructureController.getProjectSettingsAction();
    }

    static JMenuItem ra$editConfigurationsDlgItem() {
        return editConfigurationsDlgItem;
    }

    private class NodeMenuListener
    implements ContextMenuListener,
    ActiveViewListener {
        public void menuWillShow(ContextMenu popup) {
            Element element;
            View view;
            Context context;
            if (popup != null && (context = popup.getContext()) != null && (view = context.getView()) != null && JProjectStructureController.maS$isApplicationNavigator(view) && (element = context.getElement()) != null && !(element instanceof Library)) {
                if (!JProjectStructureController.ra$menusBuilt()) {
                    JProjectStructureController.mav$buildMenus(JProjectStructureController.this, (MenuManager)popup);
                }
                if (element instanceof Workspace) {
                    popup.add((Component)JProjectStructureController.ra$addToProjectContextItem(), 1.0f);
                }
                popup.add((Component)JProjectStructureController.ra$deleteMenuItem(JProjectStructureController.this), 1.0f);
                JProjectStructureController.mav$checkEraseActionLabel(JProjectStructureController.this, context);
                popup.add((Component)JProjectStructureController.ra$eraseMenuItem(JProjectStructureController.this), 1.0f);
                Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
            }
        }

        public void menuWillHide(ContextMenu popup) {
            Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void activeViewChanged(ActiveViewEvent e) {
            IdeAction action = (IdeAction)JProjectStructureController.ra$deleteMenuItem(JProjectStructureController.this).getAction();
            action.updateAction();
        }

        private NodeMenuListener() {
        }

        NodeMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class JProjectMenuListener
    implements ContextMenuListener {
        public void menuWillShow(ContextMenu popup) {
            Context context;
            if (popup != null && (context = popup.getContext()) != null) {
                if (!JProjectStructureController.ra$menusBuilt()) {
                    JProjectStructureController.mav$buildMenus(JProjectStructureController.this, (MenuManager)popup);
                }
                JProjectStructureController.mav$checkEraseActionLabel(JProjectStructureController.this, context);
                if (context.getProject() != null) {
                    popup.add((Component)JProjectStructureController.ra$addToProjectContextItem(), 1.0f);
                    JProjectStructureController.ra$editConfigurationsDlgItem().setEnabled(true);
                    popup.add((Component)JProjectStructureController.ra$editConfigurationsDlgItem(), MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                } else {
                    popup.add((Component)JProjectStructureController.ra$addToProjectContextItem(), 1.0f);
                }
                if (context.getProject() != null || context.getWorkspace() != null) {
                    popup.add((Component)JProjectStructureController.ra$deleteMenuItem(JProjectStructureController.this), 1.0f);
                }
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return JProjectStructureController.this.handleEvent(JProjectStructureController.mav$getProjectSettingsAction(JProjectStructureController.this), context);
        }

        private JProjectMenuListener() {
        }

        JProjectMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

