/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.javatools.data.ChangeInfo;
import oracle.jdeveloper.model.JProjectTechnologyEvent;
import oracle.jdeveloper.model.JProjectTechnologyListener;

public final class JProjectTechnologyNotifier {
    private static final HashMap _listenerMap = new HashMap();
    private static ProjectChangeListener _listener;
    private static final String ITEM_KEY;

    static void initialize() {
        if (_listener == null) {
            _listener = new 1();
            Project.addProjectChangeListener((String)TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY, (ProjectChangeListener)_listener);
        }
    }

    public static void registerTechnologyListener(String technologyKey, JProjectTechnologyListener listener) {
        LinkedList<JProjectTechnologyListener> list = (LinkedList<JProjectTechnologyListener>)_listenerMap.get(technologyKey);
        if (list == null) {
            list = new LinkedList<JProjectTechnologyListener>();
            _listenerMap.put(technologyKey, list);
        }
        list.add(listener);
    }

    public static void unregisterTechnologyListener(String technologyKey, JProjectTechnologyListener listener) {
        List list = (List)_listenerMap.get(technologyKey);
        if (list == null || !list.remove(listener)) {
            throw new IllegalArgumentException();
        }
        if (list.isEmpty()) {
            _listenerMap.remove(technologyKey);
        }
    }

    private static void fireTechnologyAdded(Project project, String technologyKey) {
        Object listenerListObj = _listenerMap.get(technologyKey);
        if (listenerListObj != null) {
            List listenerList = (List)listenerListObj;
            JProjectTechnologyEvent event = new JProjectTechnologyEvent(project, technologyKey);
            for (JProjectTechnologyListener listener : listenerList) {
                listener.technologyAdded(event);
            }
        }
    }

    private static void fireTechnologyRemoved(Project project, String technologyKey) {
        Object listenerListObj = _listenerMap.get(technologyKey);
        if (listenerListObj != null) {
            List listenerList = (List)listenerListObj;
            JProjectTechnologyEvent event = new JProjectTechnologyEvent(project, technologyKey);
            for (JProjectTechnologyListener listener : listenerList) {
                listener.technologyRemoved(event);
            }
        }
    }

    static {
        ITEM_KEY = TechnologyScopeConfiguration.TECHNOLOGY_SCOPE_KEY + "/";
    }

    static String ra$ITEM_KEY() {
        return ITEM_KEY;
    }

    static void maS$fireTechnologyAdded(Project project, String string) {
        JProjectTechnologyNotifier.fireTechnologyAdded(project, string);
    }

    static void maS$fireTechnologyRemoved(Project project, String string) {
        JProjectTechnologyNotifier.fireTechnologyRemoved(project, string);
    }

    static final class 1
    extends ProjectChangeListener {
        public void projectPropertiesChanged(ProjectChangeEvent e) {
            ChangeInfo[] details = e.getChangeDetails();
            int n = details.length;
            int i = 0;
            while (i < n) {
                ChangeInfo detail = details[i];
                if (detail.getPropertyName().startsWith(JProjectTechnologyNotifier.ra$ITEM_KEY())) {
                    switch (detail.getChangeType()) {
                        case 1: 
                        case 2: {
                            JProjectTechnologyNotifier.maS$fireTechnologyAdded(e.getProject(), detail.getNewValueAsString());
                            break;
                        }
                        case 3: {
                            JProjectTechnologyNotifier.maS$fireTechnologyRemoved(e.getProject(), detail.getOldValueAsString());
                            break;
                        }
                    }
                }
                ++i;
            }
        }
    }
}

