/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.ResourcePaths;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaContentValidator;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.model.SourceRootHelper;

final class Jpr10120to101301 {
    private static ProjectChangeListener _listener;

    static void init() {
        if (_listener == null) {
            _listener = new 1();
            Project.addProjectChangeListener((String)"###", (ProjectChangeListener)_listener);
        }
    }

    static void maybeFinishMigration(Project project) {
        HashStructure shared = project.getSharedPropertiesOnly();
        if (shared.getBoolean("project-migration-in-progress")) {
            project.applyBatchChanges((Runnable)new 2(project, shared));
        }
    }

    private static void finishMigration(Project project) {
        HashStructure shared = project.getSharedPropertiesOnly();
        boolean wasDynamicProject = shared.getBoolean("project-migration-was-dynamic-project");
        shared.remove("project-migration-was-dynamic-project");
        URL[] sourcePath = Jpr10120to101301.extractSourcePath(shared);
        ContentSetGen javaContentSetGen = new ContentSetGen(project, PathsConfiguration.JAVA_CONTENT_SET_KEY, sourcePath, "src");
        ContentSetGen webContentSetGen = new ContentSetGen(project, "oracle.jdeveloper.model.J2eeSettings/webContentSet", "public_html");
        ContentSetGen dbContentSetGen = new ContentSetGen(project, "oracle.jdeveloper.offlinedb.OfflineDBProjectSettings/offlineDBContentSet", "database");
        ContentSetGen modelersContentSetGen = new ContentSetGen(project, "oracle.bm.commonIde.data.project.ModelerProjectSettings/modelersContentSet", "model");
        modelersContentSetGen.setUsingFullyInclusiveRules(true);
        ContentSetGen[] gens = new ContentSetGen[]{javaContentSetGen, webContentSetGen, dbContentSetGen, modelersContentSetGen};
        ContentSetGenGroup genGroup = new ContentSetGenGroup(gens, ResourcePaths.getInstance((PropertyStorage)project));
        if (wasDynamicProject) {
            genGroup.markEveryRootAsAContentFolder();
        }
        ListStructure childrenList = shared.getListStructure("listOfChildren");
        for (Object hashObj : childrenList) {
            if (!(hashObj instanceof HashStructure)) continue;
            HashStructure hash = (HashStructure)hashObj;
            genGroup.associateFile(hash, "URL");
        }
        ListStructure ownerMap = shared.getListStructure("ownerMap");
        if (ownerMap != null) {
            for (Object hashObj : ownerMap) {
                if (!(hashObj instanceof HashStructure)) continue;
                HashStructure hash = (HashStructure)hashObj;
                genGroup.associateFile(hash, "nodeURL");
                genGroup.associateFile(hash, "ownerURL");
            }
        }
        genGroup.generateExcludes();
        genGroup.generateContentSets();
        ListStructure ownerMap2 = shared.getListStructure("ownerMap");
        if (ownerMap2 != null) {
            Iterator ownerMapIter = ownerMap2.iterator();
            while (ownerMapIter.hasNext()) {
                HashStructure hash;
                String nodeClass;
                Object hashObj = ownerMapIter.next();
                if (!(hashObj instanceof HashStructure) || (nodeClass = (hash = (HashStructure)hashObj).getString("nodeClass")) == null || !nodeClass.startsWith("oracle.toplink.")) continue;
                ownerMapIter.remove();
            }
        }
    }

    private static void initConstituent(ContentSet contentSet, Map.Entry entry, HashMap contentFoldersToSrcRoots) {
        String relPath;
        URL contentFolder = (URL)entry.getKey();
        ArrayList excludes = (ArrayList)entry.getValue();
        Collections.sort(excludes);
        URL srcRoot = (URL)contentFoldersToSrcRoots.get(contentFolder);
        contentSet.getURLPath().add(srcRoot);
        if (!URLFileSystem.equals((URL)srcRoot, (URL)contentFolder)) {
            contentSet.setContentFolderURL(contentFolder);
        }
        if ((relPath = URLFileSystem.toRelativeSpec((URL)contentFolder, (URL)srcRoot, (boolean)true)) == null) {
            relPath = "";
        }
        ArrayList<PatternFilter> filterList = new ArrayList<PatternFilter>(excludes.size() + 1);
        Iterator excludesIter = excludes.iterator();
        boolean excludeAll = false;
        while (excludesIter.hasNext()) {
            String exclude = excludesIter.next().toString();
            if ("**".equals(exclude)) {
                excludeAll = true;
                break;
            }
            String excludePattern = Jpr10120to101301.chopTrailingSlash(relPath + exclude);
            filterList.add(PatternFilter.newExclude((String)excludePattern));
        }
        if (excludeAll) {
            filterList.clear();
        } else {
            filterList.add(PatternFilter.newInclude((String)(relPath.length() > 0 ? relPath : "**")));
        }
        PatternFilters filters = contentSet.getPatternFilters();
        filters.setFilters(filterList.toArray(new PatternFilter[filterList.size()]));
    }

    private static String chopTrailingSlash(String s) {
        int origLen = s.length();
        int i = origLen - 1;
        while (i > 0 && s.charAt(i) == '/') {
            --i;
        }
        if (i < 0) {
            return "";
        }
        if (i == origLen - 1) {
            return s;
        }
        return s.substring(0, i + 1);
    }

    private static URL[] extractSourcePath(HashStructure shared) {
        ListStructure sourcePathList = shared.getListStructure(PathsConfiguration.DATA_KEY + "/" + "javaContentSet/url-path");
        URLPath sourcePath = new URLPath();
        if (sourcePathList != null) {
            Iterator iter = sourcePathList.iterator();
            while (iter.hasNext()) {
                try {
                    URL folderURL = (URL)iter.next();
                    ArrayList roots = JProjectUtil.getSourceRootsFromFolder((URL)folderURL, (SourceRootHelper[])JavaContentValidator.getRegisteredSourceRootHelpers());
                    if (roots.size() > 0) {
                        sourcePath.add((List)roots);
                        continue;
                    }
                    sourcePath.add(folderURL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return sourcePath.getEntries();
    }

    private static void addHeaderToDescendantList(ArrayList descendantList, URL sourceRoot, URL contentFolder, URL currentDir) {
        descendantList.add(0, currentDir);
        descendantList.add(0, contentFolder);
        descendantList.add(0, sourceRoot);
    }

    static URL sanitizeURL(URL url) {
        int lastDot;
        String newProtocol;
        String protocol = url.getProtocol();
        if (protocol != null && protocol.startsWith("ide.") && (newProtocol = protocol.substring((lastDot = protocol.lastIndexOf(46)) + 1)).length() > 0) {
            url = URLFactory.replaceProtocolPart((URL)url, (String)newProtocol);
        }
        return URLFileSystem.exists((URL)url) ? url : null;
    }

    Jpr10120to101301() {
    }

    static void maS$addHeaderToDescendantList(ArrayList arrayList, URL uRL, URL uRL2, URL uRL3) {
        Jpr10120to101301.addHeaderToDescendantList(arrayList, uRL, uRL2, uRL3);
    }

    static void maS$initConstituent(ContentSet contentSet, Map.Entry entry, HashMap hashMap) {
        Jpr10120to101301.initConstituent(contentSet, entry, hashMap);
    }

    static String maS$chopTrailingSlash(String string) {
        return Jpr10120to101301.chopTrailingSlash(string);
    }

    static void maS$finishMigration(Project project) {
        Jpr10120to101301.finishMigration(project);
    }

    static final class 1
    extends ProjectChangeListener {
        public void projectOpened(Project project) {
            Jpr10120to101301.maybeFinishMigration(project);
        }
    }

    static final class 2
    implements Runnable {
        private final /* synthetic */ Project v$project;
        private final /* synthetic */ HashStructure v$shared;

        public void run() {
            Jpr10120to101301.maS$finishMigration(this.v$project);
            this.v$shared.remove("project-migration-in-progress");
            this.v$shared.remove("listOfChildren");
        }

        public 2(Project project, HashStructure hashStructure) {
            this.v$shared = hashStructure;
            this.v$project = project;
        }
    }

    private static final class ContentSetGenGroup {
        private final ContentSetGen[] _gens;
        private final int _n;
        private final ResourcePaths _resourcePaths;
        private final HashMap _resourceDirToFiles;

        private void $init$() {
            this._resourceDirToFiles = new HashMap();
        }

        ContentSetGenGroup(ContentSetGen[] gens, ResourcePaths resourcePaths) {
            this.$init$();
            this._gens = gens;
            this._n = gens.length;
            this._resourcePaths = resourcePaths;
        }

        void markEveryRootAsAContentFolder() {
            int i = 0;
            while (i < this._n) {
                ContentSetGen gen = this._gens[i];
                gen.markEveryRootAsAContentFolder();
                ++i;
            }
        }

        boolean associateFile(HashStructure hash, String urlName) {
            boolean associated = false;
            try {
                URL sanitizedURL;
                URL fileURL = hash.getURL(urlName);
                if (fileURL != null && (sanitizedURL = Jpr10120to101301.sanitizeURL(fileURL)) != null) {
                    int i = 0;
                    while (i < this._n) {
                        ContentSetGen gen = this._gens[i];
                        associated = gen.associateFile(sanitizedURL) || associated;
                        ++i;
                    }
                    if (!associated) {
                        URL parentURL = URLFileSystem.getParent((URL)fileURL);
                        if (!this._resourceDirToFiles.containsKey(parentURL)) {
                            ArrayList<URL> files = new ArrayList<URL>();
                            files.add(fileURL);
                            this._resourceDirToFiles.put(parentURL, files);
                        } else {
                            ArrayList files = (ArrayList)this._resourceDirToFiles.get(parentURL);
                            if (!files.contains(fileURL)) {
                                files.add(fileURL);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return associated;
        }

        void generateExcludes() {
            int i = 0;
            while (i < this._n) {
                ContentSetGen gen = this._gens[i];
                gen.generateExcludes();
                ++i;
            }
        }

        void generateContentSets() {
            block5: {
                int i = 0;
                while (i < this._n) {
                    ContentSetGen gen = this._gens[i];
                    ContentSetGen.mav$generateContentSet(gen);
                    ++i;
                }
                ContentSet resourcesContentSet = this._resourcePaths.getResourcesContentSet();
                resourcesContentSet.removeAllContentSets();
                resourcesContentSet.getURLPath().setEntries(null);
                resourcesContentSet.getPatternFilters().removeFilters();
                int numResourceDirs = this._resourceDirToFiles.size();
                if (numResourceDirs <= 0) break block5;
                if (numResourceDirs == 1) {
                    for (URL resourceDir : this._resourceDirToFiles.keySet()) {
                        ArrayList files = (ArrayList)this._resourceDirToFiles.get(resourceDir);
                        this.initResourceContentSet(resourcesContentSet, resourceDir, files);
                    }
                } else {
                    for (URL resourceDir : this._resourceDirToFiles.keySet()) {
                        ArrayList files = (ArrayList)this._resourceDirToFiles.get(resourceDir);
                        ContentSet cs = new ContentSet(HashStructure.newInstance());
                        this.initResourceContentSet(cs, resourceDir, files);
                        resourcesContentSet.addContentSet(cs);
                    }
                }
            }
        }

        private void initResourceContentSet(ContentSet cs, URL parentDir, ArrayList files) {
            URLPath path = cs.getURLPath();
            path.add(parentDir);
            PatternFilters filters = cs.getPatternFilters();
            filters.setFilters(new PatternFilter[]{PatternFilter.newExclude((String)"**")});
            Collections.sort(files, new URLComparator());
            Collections.reverse(files);
            for (URL fileURL : files) {
                String relPath = URLFileSystem.toRelativeSpec((URL)fileURL, (URL)parentDir);
                filters.addInclude(relPath);
            }
        }
    }

    private static class ContentSetGen {
        private final Project _project;
        private final HashStructure _hash;
        private final String _contentSetKey;
        private final URL[] _roots;
        private final String _defaultRootRelPath;
        private final HashMap _sourceRootToChildren;
        private final LinkedHashMap _contentFolderToExcludes;
        private final HashMap _contentFolderToRoot;
        private boolean _fullyInclusiveRules;

        private void $init$() {
            this._sourceRootToChildren = new HashMap();
            this._contentFolderToExcludes = new LinkedHashMap();
            this._contentFolderToRoot = new HashMap();
            this._fullyInclusiveRules = false;
        }

        ContentSetGen(Project project, String contentSetKey, String defaultRootRelPath) {
            this(project, contentSetKey, ContentSetGen.getRoots(project, contentSetKey), defaultRootRelPath);
        }

        ContentSetGen(Project project, String contentSetKey, URL[] roots, String defaultRootRelPath) {
            this.$init$();
            this._project = project;
            this._hash = project.getSharedPropertiesOnly();
            this._contentSetKey = contentSetKey;
            this._roots = roots;
            this._defaultRootRelPath = defaultRootRelPath;
        }

        void setUsingFullyInclusiveRules(boolean fullyInclusive) {
            this._fullyInclusiveRules = fullyInclusive;
        }

        private static URL[] getRoots(Project project, String contentSetKey) {
            HashStructure shared = project.getSharedPropertiesOnly();
            URLPath otherPath = new URLPath();
            ListStructure list = shared.getListStructure(contentSetKey + "/url-path");
            if (list != null) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    otherPath.add((URL)iter.next());
                }
            }
            return otherPath.getEntries();
        }

        void markEveryRootAsAContentFolder() {
            int n = this._roots.length;
            int i = 0;
            while (i < n) {
                URL root = this._roots[i];
                this.getOrCreateContentFolderEntry(root, root);
                ++i;
            }
        }

        boolean associateFile(URL fileURL) {
            URL bestRoot = null;
            String shortestRelPath = null;
            int i = 0;
            while (i < this._roots.length) {
                URL root = this._roots[i];
                String relPath = URLFileSystem.toRelativeSpec((URL)fileURL, (URL)root, (boolean)true);
                if (relPath != null && (shortestRelPath == null || shortestRelPath.length() > relPath.length())) {
                    shortestRelPath = relPath;
                    bestRoot = root;
                }
                ++i;
            }
            if (bestRoot != null) {
                ArrayList<String> list = (ArrayList<String>)this._sourceRootToChildren.get(bestRoot);
                if (list == null) {
                    list = new ArrayList<String>();
                    this._sourceRootToChildren.put(bestRoot, list);
                    list.add(shortestRelPath);
                } else if (!list.contains(shortestRelPath)) {
                    list.add(shortestRelPath);
                }
                return true;
            }
            return false;
        }

        ArrayList getOrCreateContentFolderEntry(URL contentFolder, URL root) {
            ArrayList excludes = this.getContentFolderEntry(contentFolder);
            if (excludes == null) {
                excludes = new ArrayList();
                this._contentFolderToExcludes.put(contentFolder, excludes);
                this._contentFolderToRoot.put(contentFolder, root);
            }
            return excludes;
        }

        ArrayList getContentFolderEntry(URL contentFolder) {
            return (ArrayList)this._contentFolderToExcludes.get(contentFolder);
        }

        void generateExcludes() {
            LinkedList queue = ContentSetGen.convertToQueue(this._sourceRootToChildren);
            ArrayList<String> selectedFiles = new ArrayList<String>();
            ArrayList selectedDirs = new ArrayList();
            HashMap<String, ArrayList<String>> subdirToDescendants = new HashMap<String, ArrayList<String>>();
            ArrayList<URLFileSystem.FileInfo> filesOnDisk = new ArrayList<URLFileSystem.FileInfo>();
            ArrayList<URLFileSystem.FileInfo> dirsOnDisk = new ArrayList<URLFileSystem.FileInfo>();
            URLFilter globalFilters = GlobalIgnoreList.getURLFilter();
            while (!queue.isEmpty()) {
                boolean hasFilesOnDisk;
                ArrayList current = (ArrayList)queue.removeFirst();
                URL srcRoot = (URL)current.remove(0);
                URL contentFolder = (URL)current.remove(0);
                URL currentDir = (URL)current.remove(0);
                if (this._fullyInclusiveRules) {
                    this.getOrCreateContentFolderEntry(contentFolder, srcRoot);
                    continue;
                }
                selectedFiles.clear();
                selectedDirs.clear();
                subdirToDescendants.clear();
                Iterator iter = current.iterator();
                while (iter.hasNext()) {
                    String relPath = iter.next().toString();
                    int firstSlash = relPath.indexOf(47);
                    if (firstSlash < 0) {
                        selectedFiles.add(relPath);
                        continue;
                    }
                    String subdir = relPath.substring(0, firstSlash);
                    String relPathNext = relPath.substring(firstSlash + 1);
                    ArrayList<String> descendantList = (ArrayList<String>)subdirToDescendants.get(subdir);
                    if (descendantList == null) {
                        descendantList = new ArrayList<String>();
                        subdirToDescendants.put(subdir, descendantList);
                    }
                    descendantList.add(relPathNext);
                }
                selectedDirs.addAll(subdirToDescendants.keySet());
                filesOnDisk.clear();
                dirsOnDisk.clear();
                URLFileSystem.FileInfo[] fileInfos = URLFileSystem.ls((URL)currentDir, (URLFilter)globalFilters);
                if (fileInfos != null) {
                    int n = fileInfos.length;
                    int i = 0;
                    while (i < n) {
                        URLFileSystem.FileInfo fileInfo = fileInfos[i];
                        if (fileInfo.isDirectory()) {
                            dirsOnDisk.add(fileInfo);
                        } else if (fileInfo.isFile()) {
                            filesOnDisk.add(fileInfo);
                        }
                        ++i;
                    }
                }
                boolean hasSelectedFiles = selectedFiles.size() > 0;
                boolean hasSelectedDirs = selectedDirs.size() > 0;
                boolean bl = hasFilesOnDisk = filesOnDisk.size() > 0;
                if (hasSelectedFiles || !hasFilesOnDisk) {
                    if (hasSelectedFiles || hasFilesOnDisk) {
                        this.getOrCreateContentFolderEntry(contentFolder, srcRoot);
                    }
                    Iterator subdirIter = selectedDirs.iterator();
                    while (subdirIter.hasNext()) {
                        String subdir = subdirIter.next().toString();
                        URL subdirURL = URLFactory.newDirURL((URL)currentDir, (String)subdir);
                        ArrayList subdirDescendants = (ArrayList)subdirToDescendants.get(subdir);
                        if (!(hasSelectedFiles || hasSelectedDirs || hasFilesOnDisk)) {
                            Jpr10120to101301.maS$addHeaderToDescendantList(subdirDescendants, srcRoot, subdirURL, subdirURL);
                        } else {
                            Jpr10120to101301.maS$addHeaderToDescendantList(subdirDescendants, srcRoot, contentFolder, subdirURL);
                        }
                        queue.addFirst(subdirDescendants);
                    }
                    for (URLFileSystem.FileInfo fileInfo : dirsOnDisk) {
                        URL subdirURL = fileInfo.getURL();
                        String subdirName = Jpr10120to101301.maS$chopTrailingSlash(URLFileSystem.getFileName((URL)subdirURL));
                        if (selectedDirs.contains(subdirName)) continue;
                        String subdirRelPath = URLFileSystem.toRelativeSpec((URL)subdirURL, (URL)contentFolder, (boolean)true);
                        this.addExclude(contentFolder, srcRoot, subdirRelPath);
                    }
                    continue;
                }
                int numSelectedDirs = selectedDirs.size();
                if (numSelectedDirs > 0) {
                    String curdirRelPath = URLFileSystem.toRelativeSpec((URL)currentDir, (URL)contentFolder, (boolean)true);
                    this.addExclude(contentFolder, srcRoot, curdirRelPath);
                    Iterator subdirIter = selectedDirs.iterator();
                    while (subdirIter.hasNext()) {
                        String subdir = subdirIter.next().toString();
                        URL subdirURL = URLFactory.newDirURL((URL)currentDir, (String)subdir);
                        ArrayList subdirDescendants = (ArrayList)subdirToDescendants.get(subdir);
                        Jpr10120to101301.maS$addHeaderToDescendantList(subdirDescendants, srcRoot, subdirURL, subdirURL);
                        queue.addFirst(subdirDescendants);
                    }
                    continue;
                }
                new IllegalStateException("should not be possible to get here - no selected files or directories for " + currentDir.toString()).printStackTrace();
            }
        }

        private void generateContentSet() {
            HashStructure contentSetHash = HashStructure.newInstance();
            ContentSet contentSet = new ContentSet(contentSetHash);
            if (this._contentFolderToExcludes.size() == 0) {
                int n = this._roots.length;
                int i = 0;
                while (i < n) {
                    URL srcRoot = this._roots[i];
                    if (!URLFileSystem.exists((URL)srcRoot)) {
                        this.getOrCreateContentFolderEntry(srcRoot, srcRoot);
                    }
                    ++i;
                }
                if (this._contentFolderToExcludes.size() == 0) {
                    int numRoots = this._roots.length;
                    int i2 = 0;
                    while (i2 < numRoots) {
                        URL placeholderRoot = this._roots[i2];
                        ArrayList excludes = this.getOrCreateContentFolderEntry(placeholderRoot, placeholderRoot);
                        if (URLFileSystem.exists((URL)placeholderRoot)) {
                            excludes.add("**");
                        }
                        ++i2;
                    }
                }
            }
            if (this._contentFolderToExcludes.size() == 1) {
                Iterator contentFolderIter = this._contentFolderToExcludes.entrySet().iterator();
                Map.Entry entry = contentFolderIter.next();
                Jpr10120to101301.maS$initConstituent(contentSet, entry, this._contentFolderToRoot);
            } else {
                LinkedHashMap copy = new LinkedHashMap(this._contentFolderToExcludes);
                this._contentFolderToExcludes.clear();
                int n = this._roots.length;
                int i = 0;
                while (i < n) {
                    URL url = this._roots[i];
                    Object value = copy.remove(url);
                    if (value != null) {
                        this._contentFolderToExcludes.put(url, value);
                    }
                    ++i;
                }
                this._contentFolderToExcludes.putAll(copy);
                for (Map.Entry entry : this._contentFolderToExcludes.entrySet()) {
                    HashStructure constituentHash = HashStructure.newInstance();
                    ContentSet constituentContentSet = new ContentSet(constituentHash);
                    Jpr10120to101301.maS$initConstituent(constituentContentSet, entry, this._contentFolderToRoot);
                    contentSet.addContentSet(constituentContentSet);
                }
            }
            this._hash.putHashStructure(this._contentSetKey, contentSetHash);
        }

        private static LinkedList convertToQueue(HashMap sourceRootToChild) {
            LinkedList<ArrayList> queue = new LinkedList<ArrayList>();
            for (URL url : sourceRootToChild.keySet()) {
                ArrayList list = (ArrayList)sourceRootToChild.get(url);
                Jpr10120to101301.maS$addHeaderToDescendantList(list, url, url, url);
                queue.add(list);
            }
            return queue;
        }

        private void addExclude(URL contentFolder, URL srcRoot, String subdirRelPath) {
            if (!"".equals(subdirRelPath)) {
                ArrayList excludes = this.getOrCreateContentFolderEntry(contentFolder, srcRoot);
                excludes.add(subdirRelPath);
            }
        }

        static void mav$generateContentSet(ContentSetGen contentSetGen) {
            contentSetGen.generateContentSet();
        }
    }
}

