/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.JProjectLibraries;

final class LibraryObserver
implements Observer {
    private static ProjectChangeListener _listener;
    private final Project _project;

    static void init() {
        if (_listener == null) {
            _listener = new 1();
            Project.addProjectChangeListener((String)"###", (ProjectChangeListener)_listener);
        }
    }

    private LibraryObserver(Project project) {
        this._project = project;
    }

    public void update(Object observed, UpdateMessage change) {
        int id = change.getMessageID();
        if (id == UpdateMessage.PROPERTY_SET) {
            if (observed instanceof Library && !(observed instanceof ProjectLibrary)) {
                Library lib = (Library)observed;
                PropertyChangeEvent pce = null;
                JProjectLibraries prjLibs = JProjectLibraries.getInstance((PropertyStorage)this._project);
                JLibrary[] libs = prjLibs.getLibraries();
                int i = 0;
                while (i < libs.length) {
                    if (libs[i].getID().equals(lib.getID())) {
                        ArrayList<PropertyChangeEvent> pceList = new ArrayList<PropertyChangeEvent>();
                        pce = (PropertyChangeEvent)change.getProperty("classPath");
                        if (pce != null) {
                            pceList.add(new PropertyChangeEvent(this._project, "classPath", null, null));
                        }
                        if ((pce = (PropertyChangeEvent)change.getProperty("docPath")) != null) {
                            pceList.add(new PropertyChangeEvent(this._project, "docPath", null, null));
                        }
                        if ((pce = (PropertyChangeEvent)change.getProperty("sourcePath")) != null) {
                            pceList.add(new PropertyChangeEvent(this._project, "sourcePath", null, null));
                        }
                        if (pceList.size() > 0) {
                            UpdateMessage.firePropertiesChanged((Subject)this._project, (PropertyChangeEvent[])pceList.toArray(new PropertyChangeEvent[pceList.size()]), null);
                        }
                        break;
                    }
                    ++i;
                }
            }
        } else if ((id == UpdateMessage.CHILD_REMOVED || id == UpdateMessage.CHILD_ADDED || id == UpdateMessage.STRUCTURE_CHANGED) && observed instanceof JLibraryManager) {
            JProjectLibraries prjLibs = JProjectLibraries.getInstance((PropertyStorage)this._project);
            JLibrary[] libs = prjLibs.getLibraries();
            List list = id == UpdateMessage.CHILD_REMOVED ? change.getRemoveObjects() : (id == UpdateMessage.CHILD_ADDED ? change.getAddObjects() : change.getModifyObjects());
            Iterator i = list.iterator();
            boolean update = false;
            if (i != null) {
                block1: while (i.hasNext()) {
                    Library lib = (Library)i.next();
                    Object obj = lib.getID();
                    int j = 0;
                    while (j < libs.length) {
                        if (obj.equals(libs[j].getID())) {
                            update = true;
                            continue block1;
                        }
                        ++j;
                    }
                }
            }
            if (update) {
                ArrayList<PropertyChangeEvent> pceList = new ArrayList<PropertyChangeEvent>();
                pceList.add(new PropertyChangeEvent(this._project, "classPath", null, null));
                pceList.add(new PropertyChangeEvent(this._project, "docPath", null, null));
                pceList.add(new PropertyChangeEvent(this._project, "sourcePath", null, null));
                UpdateMessage.firePropertiesChanged((Subject)this._project, (PropertyChangeEvent[])pceList.toArray(new PropertyChangeEvent[pceList.size()]), null);
            }
        }
    }

    LibraryObserver(Project project, 1 var2_2) {
        this(project);
    }

    static final class 1
    extends ProjectChangeListener {
        public void projectOpened(Project project) {
            JLibraryManager manager = JLibraryManager.getInstance();
            if (manager != null) {
                LibraryObserver libObserver = new LibraryObserver(project, null);
                manager.attach((Observer)libObserver);
                project.getTransientProperties().put("LibraryObserver", libObserver);
            }
        }

        public void projectClosed(Project project) {
            LibraryObserver libObserver = (LibraryObserver)project.getTransientProperties().get("LibraryObserver");
            if (libObserver != null) {
                JLibraryManager.getInstance().detach((Observer)libObserver);
            }
        }
    }
}

