/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.model.JDevTechnologyInfo;
import oracle.jdeveloper.model.JDevTechnologyRegistry;
import oracle.jdeveloper.resource.TechArb;

public final class TechnologiesPanel
extends ProjectSettingsTraversablePanel {
    public static final String TECHNOLOGY_SCOPE_DATA_KEY = "technologyScope";
    private static final String HELP_ID = "f1_idedprojsettechnologyscopedpp_html";
    private final DefaultListModel _fromModel;
    private final DefaultListModel _toModel;
    private final JTabbedPane _tabs;
    private JPanel _technologiesPanel;
    private FilesPanel _generatedComponentsPanel;
    private LibrariesPanel _librariesPanel;
    private final GridBagLayout _layout;
    private final JLabel _fromLabel;
    private final JList _fromList;
    private final JLabel _toLabel;
    private final JList _toList;
    private final Shuttle _technologiesShuttle;
    private final JLabel _descriptionLabel;
    private final DescriptionScrollPane _descriptionScrollPane;
    private final ListPicker _fromPicker;
    private final ListPicker _toPicker;
    private TechnologyScope _scope;
    private static final String[] PROPERTY_KEYS = new String[]{"technologyScope"};
    public static final String SELECTED_TECH_SCOPES = "SelectedTechnologyScopes";
    private transient PropertyChangeSupport _propertyChangeSupport;
    private transient TechId[] _fixedTechnologies;

    private void $init$() {
        this._fromModel = new DefaultListModel();
        this._toModel = new DefaultListModel();
        this._tabs = new JTabbedPane();
        this._technologiesPanel = new JPanel();
        this._generatedComponentsPanel = new FilesPanel();
        this._librariesPanel = new LibrariesPanel();
        this._layout = new GridBagLayout();
        this._fromLabel = new JLabel();
        this._fromList = new JList();
        this._toLabel = new JLabel();
        this._toList = new JList();
        this._technologiesShuttle = new Shuttle();
        this._descriptionLabel = new JLabel();
        this._descriptionScrollPane = new DescriptionScrollPane();
        this._fromPicker = new CustomFromListPicker(this._fromList);
        this._toPicker = new CustomToListPicker(this._toList);
        this._propertyChangeSupport = new PropertyChangeSupport((Object)this);
        this._fixedTechnologies = new TechId[0];
    }

    public TechnologiesPanel() {
        this.$init$();
        this.setHelpID(HELP_ID);
        EventAdapter eventAdapter = new EventAdapter(null);
        this._fromList.addFocusListener(eventAdapter);
        this._fromList.addListSelectionListener(eventAdapter);
        this._toList.addFocusListener(eventAdapter);
        this._toList.addListSelectionListener(eventAdapter);
        this._technologiesShuttle.addShuttleListener((ShuttleListener)eventAdapter);
        this._fromList.setModel(this._fromModel);
        this._fromList.setSelectionMode(2);
        this._fromPicker.setItemsSorted(true);
        this._toList.setModel(this._toModel);
        this._toList.setSelectionMode(2);
        this._toPicker.setItemsSorted(true);
        ResourceUtils.resLabel((JLabel)this._fromLabel, (Component)this._fromList, (String)TechArb.getString(2));
        ResourceUtils.resLabel((JLabel)this._toLabel, (Component)this._toList, (String)TechArb.getString(8));
        ResourceUtils.resLabel((JLabel)this._descriptionLabel, (Component)this._descriptionScrollPane.getLabelComponent(), (String)TechArb.getString(0));
        Border headerLabelBorder = BorderFactory.createEmptyBorder(0, 0, 2, 0);
        this._fromLabel.setBorder(headerLabelBorder);
        this._toLabel.setBorder(headerLabelBorder);
        this._technologiesShuttle.setButtonsShown(5);
        this._technologiesShuttle.add((Component)this._fromLabel, (Object)"FromHeader");
        this._technologiesShuttle.setFromPicker((ItemPicker)this._fromPicker);
        this._technologiesShuttle.add((Component)this._toLabel, (Object)"ToHeader");
        this._technologiesShuttle.setToPicker((ItemPicker)this._toPicker);
        this._technologiesPanel.setLayout(this._layout);
        this._technologiesPanel.add((Component)this._technologiesShuttle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.8, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._technologiesPanel.add((Component)this._descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 2, 0), 0, 0));
        this._technologiesPanel.add((Component)this._descriptionScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.2, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        int margin = 10;
        this._technologiesPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this._generatedComponentsPanel.setBorder(border);
        this._librariesPanel.setBorder(border);
        this._tabs.add((Component)this._technologiesPanel, TechArb.getString(10));
        this._tabs.add((Component)this._generatedComponentsPanel, TechArb.getString(9));
        this._tabs.add((Component)this._librariesPanel, TechArb.getString(14));
        this.setLayout(new BorderLayout());
        this.add(this._tabs, "Center");
    }

    public void setUnremoveableTechnologies(TechId ... techIds) {
        this._fixedTechnologies = techIds;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        TechnologyScope scope = this.getTechnologyScopeFromContext(tc);
        this._scope = new TechnologyScope(scope);
        this.populateModels(this._scope);
    }

    public void onExit(TraversableContext tc) {
        TechId[] projectTechnologies = this._scope.toArray();
        boolean visible = false;
        int i = 0;
        while (i < projectTechnologies.length) {
            TechId techId = projectTechnologies[i];
            if (techId.isVisible()) {
                visible = true;
                break;
            }
            ++i;
        }
        if (!visible) {
            this._scope.clear();
        }
        this.putTechnologyScopeToContext(tc, this._scope);
    }

    public String getDataKey() {
        return TechnologyScopeConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public TechId[] getSelectedTechnologies() {
        return this._scope != null ? this._scope.toArray() : new TechId[]{};
    }

    private TechnologyScope getTechnologyScopeFromContext(TraversableContext tc) {
        PropertyStorage propertyData;
        TechnologyScope scope = (TechnologyScope)tc.getDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY);
        if (scope != null) {
            return scope;
        }
        Object object = propertyData = tc.find("PropertyData") != null ? TechnologiesPanel.getPropertyData((Namespace)tc) : (Project)tc.find("Project");
        if (propertyData != null) {
            TechnologyScopeConfiguration techScopeConfiguration = TechnologyScopeConfiguration.getInstance((PropertyStorage)propertyData);
            return techScopeConfiguration.getTechnologyScope();
        }
        return null;
    }

    private void putTechnologyScopeToContext(TraversableContext tc, TechnologyScope scope) {
        PropertyStorage propertyData;
        if (tc.getDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY) != null) {
            tc.putDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY, (Object)scope);
            return;
        }
        Object object = propertyData = tc.find("PropertyData") != null ? TechnologiesPanel.getPropertyData((Namespace)tc) : (Project)tc.find("Project");
        if (propertyData != null) {
            TechnologyScopeConfiguration techScopeConfiguration = TechnologyScopeConfiguration.getInstance((PropertyStorage)propertyData);
            techScopeConfiguration.setTechnologyScope(scope);
        }
    }

    private boolean canRemoveTechId(TechId techId) {
        TechId[] techIdArray = this._fixedTechnologies;
        int n = 0;
        while (n < techIdArray.length) {
            TechId id = techIdArray[n];
            if (id.equals((Object)techId)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void populateModels(TechnologyScope scope) {
        TechnologyRegistry techReg = TechnologyRegistry.getInstance();
        Object[] technologies = techReg.getVisibleTechIds();
        Arrays.sort(technologies);
        this._fromModel.clear();
        this._fromModel.ensureCapacity(technologies.length);
        int i = 0;
        while (i < technologies.length) {
            Object techId = technologies[i];
            this._fromModel.addElement(techId);
            ++i;
        }
        Object[] projectTechnologies = scope.toArray();
        Arrays.sort(projectTechnologies);
        int i2 = this._toModel.size() - 1;
        while (i2 >= 0) {
            TechId tech = (TechId)this._toModel.getElementAt(i2);
            if (this.canRemoveTechId(tech)) {
                this._toModel.remove(i2);
            }
            --i2;
        }
        this._toModel.ensureCapacity(projectTechnologies.length);
        int i3 = 0;
        while (i3 < projectTechnologies.length) {
            Object techId = projectTechnologies[i3];
            if (techId.isVisible() && this._fromModel.contains(techId)) {
                this._fromModel.removeElement(techId);
                if (!this._toModel.contains(techId)) {
                    this._toModel.addElement(techId);
                }
            }
            ++i3;
        }
        this._fromList.ensureIndexIsVisible(0);
        this._fromList.setSelectedIndex(0);
        this._toList.ensureIndexIsVisible(0);
        this._toList.setSelectedIndex(0);
        this.refreshScope();
    }

    private void refreshScope() {
        TechId[] techIds = this._scope.toArray();
        this._generatedComponentsPanel.setTechnologies(techIds);
        this._librariesPanel.setTechnologies(techIds);
    }

    public void addTechnologyPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null.");
        }
        this._propertyChangeSupport.addPropertyChangeListener(SELECTED_TECH_SCOPES, listener);
    }

    public void removeTechnologyPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null.");
        }
        this._propertyChangeSupport.removePropertyChangeListener(SELECTED_TECH_SCOPES, listener);
    }

    static DescriptionScrollPane ra$_descriptionScrollPane(TechnologiesPanel technologiesPanel) {
        return technologiesPanel._descriptionScrollPane;
    }

    static TechnologyScope ra$_scope(TechnologiesPanel technologiesPanel) {
        return technologiesPanel._scope;
    }

    static boolean mav$canRemoveTechId(TechnologiesPanel technologiesPanel, TechId techId) {
        return technologiesPanel.canRemoveTechId(techId);
    }

    static JList ra$_toList(TechnologiesPanel technologiesPanel) {
        return technologiesPanel._toList;
    }

    static void mav$populateModels(TechnologiesPanel technologiesPanel, TechnologyScope technologyScope) {
        technologiesPanel.populateModels(technologyScope);
    }

    static PropertyChangeSupport ra$_propertyChangeSupport(TechnologiesPanel technologiesPanel) {
        return technologiesPanel._propertyChangeSupport;
    }

    static JList ra$_fromList(TechnologiesPanel technologiesPanel) {
        return technologiesPanel._fromList;
    }

    static TechId[] ra$_fixedTechnologies(TechnologiesPanel technologiesPanel) {
        return technologiesPanel._fixedTechnologies;
    }

    private final class EventAdapter
    implements FocusListener,
    ListSelectionListener,
    ShuttleListener {
        public void focusGained(FocusEvent event) {
            this.updateDescription((JList)event.getSource());
        }

        public void focusLost(FocusEvent event) {
        }

        public void valueChanged(ListSelectionEvent event) {
            this.updateDescription((JList)event.getSource());
        }

        public void shuttleItemsMoved(ShuttleEvent event) {
            TechId[] orginalTechnologies = TechnologiesPanel.ra$_scope(TechnologiesPanel.this).toArray();
            Transferable[] items = event.getItems();
            int i = 0;
            while (i < items.length) {
                TechId techId = this.extractTechId(items[i]);
                if (techId != null) {
                    TechnologiesPanel.ra$_scope(TechnologiesPanel.this).add(techId);
                }
                ++i;
            }
            int anchor = TechnologiesPanel.ra$_fromList(TechnologiesPanel.this).getAnchorSelectionIndex();
            TechnologiesPanel.mav$populateModels(TechnologiesPanel.this, TechnologiesPanel.ra$_scope(TechnologiesPanel.this));
            TechnologiesPanel.ra$_propertyChangeSupport(TechnologiesPanel.this).firePropertyChange(TechnologiesPanel.SELECTED_TECH_SCOPES, orginalTechnologies, TechnologiesPanel.ra$_scope(TechnologiesPanel.this).toArray());
            this.restoreRelativeSelection(TechnologiesPanel.ra$_fromList(TechnologiesPanel.this), anchor);
        }

        public void shuttleItemsRemoved(ShuttleEvent event) {
            TechId[] orginalTechnologies = TechnologiesPanel.ra$_scope(TechnologiesPanel.this).toArray();
            Transferable[] items = event.getItems();
            int i = 0;
            while (i < items.length) {
                TechId techId = this.extractTechId(items[i]);
                if (techId != null && TechnologiesPanel.mav$canRemoveTechId(TechnologiesPanel.this, techId)) {
                    TechnologiesPanel.ra$_scope(TechnologiesPanel.this).remove(techId);
                }
                ++i;
            }
            int anchor = TechnologiesPanel.ra$_toList(TechnologiesPanel.this).getAnchorSelectionIndex();
            TechnologiesPanel.mav$populateModels(TechnologiesPanel.this, TechnologiesPanel.ra$_scope(TechnologiesPanel.this));
            TechnologiesPanel.ra$_propertyChangeSupport(TechnologiesPanel.this).firePropertyChange(TechnologiesPanel.SELECTED_TECH_SCOPES, orginalTechnologies, TechnologiesPanel.ra$_scope(TechnologiesPanel.this).toArray());
            this.restoreRelativeSelection(TechnologiesPanel.ra$_toList(TechnologiesPanel.this), anchor);
        }

        private void restoreRelativeSelection(JList list, int lastIndex) {
            int maxIndex = list.getModel().getSize() - 1;
            int index = Math.min(lastIndex, maxIndex);
            list.setSelectedIndex(index);
        }

        public void shuttleItemsReordered(ShuttleEvent event) {
        }

        private void updateDescription(JList list) {
            TechId techId = (TechId)list.getSelectedValue();
            if (techId != null) {
                TechnologiesPanel.ra$_descriptionScrollPane(TechnologiesPanel.this).setText(techId.getDescription());
            } else {
                TechnologiesPanel.ra$_descriptionScrollPane(TechnologiesPanel.this).setText(null);
            }
        }

        private TechId extractTechId(Transferable t) {
            if (t instanceof ObjectTransferable) {
                ObjectTransferable item = (ObjectTransferable)t;
                DataFlavor flavor = TransferUtils.getDataFlavor(TechId.class);
                try {
                    TechId techId = (TechId)item.getTransferData(flavor);
                    return techId;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return null;
        }

        private EventAdapter() {
        }

        EventAdapter(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static abstract class TechScopeAssociationsPanel
    extends JPanel
    implements ListSelectionListener {
        protected TechId[] _technologies;
        private final BorderLayout _layout;
        private final JSplitPane _splitPane;
        private final JLabel _tableLabel;
        protected final DefaultTableModel _model;
        private final JTable _table;
        private final DescriptionScrollPane _descriptionScrollPane;

        private void $init$() {
            this._layout = new BorderLayout();
            this._splitPane = new JSplitPane();
            this._tableLabel = new JLabel();
            this._model = new DefaultTableModel();
            this._table = new JTable(this._model);
            this._descriptionScrollPane = new DescriptionScrollPane();
        }

        TechScopeAssociationsPanel() {
            this.$init$();
            this._tableLabel.setText(this.getTitle());
            this._tableLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this._table.setSelectionMode(0);
            this._table.setColumnSelectionAllowed(false);
            this._table.setRowSelectionAllowed(true);
            this._table.getSelectionModel().addListSelectionListener(this);
            JScrollPane listScroller = new JScrollPane(this._table);
            listScroller.setBorder(null);
            listScroller.setHorizontalScrollBarPolicy(31);
            listScroller.setVerticalScrollBarPolicy(20);
            this._descriptionScrollPane.setBorder(null);
            this._descriptionScrollPane.setHorizontalScrollBarPolicy(31);
            this._descriptionScrollPane.setVerticalScrollBarPolicy(20);
            this._splitPane.setResizeWeight(0.7);
            this._splitPane.setOrientation(0);
            this._splitPane.setTopComponent(listScroller);
            this._splitPane.setBottomComponent((Component)this._descriptionScrollPane);
            this.setLayout(this._layout);
            this.add((Component)this._tableLabel, "North");
            this.add((Component)this._splitPane, "Center");
        }

        protected void setTechnologies(TechId[] techIds) {
            if (!Arrays.equals(this._technologies, techIds)) {
                this._technologies = techIds;
                this.refreshList();
            }
        }

        private void refreshList() {
            this._model.getDataVector().clear();
            if (this._technologies != null) {
                int r = this._table.getSelectedRow();
                int c = this._table.getSelectedColumn();
                this._model.setDataVector(this.getDataVector(), this.getColumnsVector());
                if (r >= 0 && c >= 0 && r < this._model.getRowCount() && c < this._model.getColumnCount()) {
                    this._table.changeSelection(r, c, true, true);
                }
            }
            this._model.fireTableDataChanged();
            this._table.removeColumn(this._table.getColumnModel().getColumn(0));
        }

        protected abstract Vector getDataVector();

        protected abstract Vector getColumnsVector();

        protected abstract String getTitle();

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (this._table.getSelectedRow() == -1) {
                    this._descriptionScrollPane.setText(null);
                } else {
                    String desc = (String)this._model.getValueAt(this._table.getSelectedRow(), 0);
                    this._descriptionScrollPane.setText(desc == null ? "" : desc);
                }
            }
        }
    }

    class FilesPanel
    extends TechScopeAssociationsPanel {
        final String[] columns;

        private void $init$() {
            this.columns = new String[]{"", "File Name", "Path", "Type"};
        }

        public FilesPanel() {
            this.$init$();
        }

        protected Vector getDataVector() {
            Vector data = new Vector();
            TechId[] techIdArray = this._technologies;
            int n = 0;
            while (n < techIdArray.length) {
                JDevTechnologyInfo.GeneratedFileInfo[] files;
                TechId technology = techIdArray[n];
                JDevTechnologyRegistry jdevTechnologyRegistry = JDevTechnologyRegistry.getInstance();
                JDevTechnologyInfo jdevTechInfo = jdevTechnologyRegistry.getJDevTechnologyInfo(technology);
                if (jdevTechInfo != null && (files = jdevTechInfo.getGeneratedFiles()) != null && files.length > 0) {
                    JDevTechnologyInfo.GeneratedFileInfo[] generatedFileInfoArray = files;
                    int n2 = 0;
                    while (n2 < generatedFileInfoArray.length) {
                        JDevTechnologyInfo.GeneratedFileInfo file = generatedFileInfoArray[n2];
                        Vector<String> v = new Vector<String>();
                        v.add(ModelUtil.hasLength((String)file.getDescription()) ? file.getDescription() : file.toString());
                        v.add(file.getName());
                        v.add(file.getPath());
                        v.add(file.getFileType());
                        data.add(v);
                        ++n2;
                    }
                }
                ++n;
            }
            return data;
        }

        protected Vector getColumnsVector() {
            return new Vector<String>(Arrays.asList(this.columns));
        }

        protected String getTitle() {
            return "These files will be generated and included in the Project";
        }
    }

    class LibrariesPanel
    extends TechScopeAssociationsPanel {
        final String[] columns;

        private void $init$() {
            this.columns = new String[]{"", "Library Name"};
        }

        public LibrariesPanel() {
            this.$init$();
        }

        protected Vector getDataVector() {
            Vector data = new Vector();
            TechId[] techIdArray = this._technologies;
            int n = 0;
            while (n < techIdArray.length) {
                Object[] libIds;
                TechId technology = techIdArray[n];
                JDevTechnologyRegistry jdevTechnologyRegistry = JDevTechnologyRegistry.getInstance();
                JDevTechnologyInfo jdevTechInfo = jdevTechnologyRegistry.getJDevTechnologyInfo(technology);
                if (jdevTechInfo != null && (libIds = jdevTechInfo.getLibraryIDs()) != null && libIds.length > 0) {
                    Object[] objectArray = libIds;
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        Object id = objectArray[n2];
                        JLibrary library = JLibraryManager.findLibrary((Object)id);
                        if (library != null) {
                            Vector<String> v = new Vector<String>();
                            v.add(library.getToolTipText());
                            v.add(library.getName());
                            data.add(v);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            return data;
        }

        protected Vector getColumnsVector() {
            return new Vector<String>(Arrays.asList(this.columns));
        }

        protected String getTitle() {
            return "JDeveloper will add these libraries to this project.";
        }
    }

    private class CustomFromListPicker
    extends ListPicker {
        public CustomFromListPicker(JList list) {
            super(list);
        }

        public boolean isSelectableItemPresent() {
            if (!TechnologiesPanel.this.isEnabled()) {
                return false;
            }
            return super.isSelectableItemPresent();
        }
    }

    private class CustomToListPicker
    extends ListPicker {
        public CustomToListPicker(JList list) {
            super(list);
        }

        private boolean hasUnmoveableItems() {
            return TechnologiesPanel.ra$_fixedTechnologies(TechnologiesPanel.this).length > 0 && !this.getList().isSelectionEmpty();
        }

        public boolean isItemSelected() {
            if (!TechnologiesPanel.this.isEnabled()) {
                return false;
            }
            if (!this.hasUnmoveableItems()) {
                return super.isItemSelected();
            }
            ListModel listModel = this.getList().getModel();
            int[] indices = this.getList().getSelectedIndices();
            int i = 0;
            while (i < indices.length) {
                TechId tech = (TechId)listModel.getElementAt(indices[i]);
                if (TechnologiesPanel.mav$canRemoveTechId(TechnologiesPanel.this, tech)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public boolean isSelectableItemPresent() {
            if (!TechnologiesPanel.this.isEnabled()) {
                return false;
            }
            if (!this.hasUnmoveableItems()) {
                return super.isSelectableItemPresent();
            }
            ListModel listModel = this.getList().getModel();
            int[] indices = this.getList().getSelectedIndices();
            int i = 0;
            while (i < indices.length) {
                TechId tech = (TechId)listModel.getElementAt(indices[i]);
                if (TechnologiesPanel.mav$canRemoveTechId(TechnologiesPanel.this, tech)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Transferable[] getSelectedItems() {
            if (!TechnologiesPanel.this.isEnabled()) {
                return new Transferable[0];
            }
            if (!this.hasUnmoveableItems()) {
                return super.getSelectedItems();
            }
            ListModel listModel = this.getList().getModel();
            ArrayList<Transferable> list = new ArrayList<Transferable>();
            int[] indices = this.getList().getSelectedIndices();
            int i = 0;
            while (i < indices.length) {
                Object element = listModel.getElementAt(indices[i]);
                if (TechnologiesPanel.mav$canRemoveTechId(TechnologiesPanel.this, (TechId)element)) {
                    list.add(this.createTransferable(element));
                }
                ++i;
            }
            return list.toArray(new Transferable[list.size()]);
        }

        public Transferable[] getAllSelectableItems() {
            if (!this.hasUnmoveableItems()) {
                return super.getAllSelectableItems();
            }
            ArrayList<Transferable> transferables = new ArrayList<Transferable>();
            ListModel listModel = this.getList().getModel();
            int i = 0;
            while (i < listModel.getSize()) {
                Object element = listModel.getElementAt(i);
                if (TechnologiesPanel.mav$canRemoveTechId(TechnologiesPanel.this, (TechId)element)) {
                    transferables.add(this.createTransferable(element));
                }
                ++i;
            }
            return transferables.toArray(new Transferable[transferables.size()]);
        }
    }
}

