/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.palette.EditorArb;

public class ImagePanel
extends JPanel {
    private final JLabel _imagePreviewLbl;
    private JLabel _imageLbl;
    private final GridBagLayout gridBagLayout1;
    private final JScrollPane _pane;

    private void $init$() {
        this._imagePreviewLbl = new JLabel();
        this._imageLbl = new JLabel();
        this.gridBagLayout1 = new GridBagLayout();
        this._pane = new JScrollPane(this._imageLbl);
    }

    public ImagePanel() {
        this.$init$();
        this.setLayout(this.gridBagLayout1);
        this._imageLbl.setHorizontalAlignment(0);
        this._imageLbl.setHorizontalTextPosition(0);
        this._imageLbl.setVerticalTextPosition(3);
        this._imagePreviewLbl.setText(EditorArb.getString(10));
        this._pane.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)this._pane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 2), 0, 0));
        this.add((Component)this._imagePreviewLbl, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 11, 0, new Insets(0, 0, 2, 2), 0, 0));
    }

    public void clear() {
        this._imageLbl.setIcon(null);
    }

    public void setIcon(URL imageURL) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(imageURL);
            if (image != null) {
                ImageIcon icon = new ImageIcon(image);
                int height = icon.getIconHeight();
                int width = icon.getIconWidth();
                this._imageLbl.setIcon(new ImageIcon(image));
                String suffix = URLFileSystem.getSuffix((URL)imageURL).substring(1).toUpperCase();
                int length = (int)URLFileSystem.getLength((URL)imageURL) / 1000;
                if (length == 0) {
                    length = 1;
                }
                this._imageLbl.setText(width + "x" + height + " " + suffix + ", " + length + "k");
            } else {
                Assert.print((String)(imageURL + " not found."));
            }
        }
        catch (Exception ex) {
            Assert.printStackTrace();
        }
    }
}

