/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.palette;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.jdeveloper.palette.IncrementFieldListener;

public final class IncrementalField
extends JPanel
implements ActionListener {
    private final JTextField _numberFld;
    private final GridBagLayout gridBagLayout1;
    private final ArrayList _listeners;
    private JButton _increaseBtn;
    private JButton _decreaseBtn;
    private int _index;

    private void $init$() {
        this._numberFld = new JTextField();
        this.gridBagLayout1 = new GridBagLayout();
        this._listeners = new ArrayList();
        this._increaseBtn = new JButton(".");
        this._decreaseBtn = new JButton(".");
        this._index = 1;
    }

    public IncrementalField(int index) {
        this.$init$();
        this._index = index;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this._increaseBtn = this.decorate(this._increaseBtn);
        this._decreaseBtn = this.decorate(this._decreaseBtn);
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this._decreaseBtn, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), -2, -12));
        this.add((Component)this._increaseBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), -2, -12));
        this.add((Component)this._numberFld, new GridBagConstraints(0, 0, 1, 2, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._numberFld.setText("" + this._index);
        this._increaseBtn.addActionListener(this);
        this._decreaseBtn.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.getValue().length() == 0) {
            this._numberFld.setText("" + this._index);
        }
        if (e.getSource() == this._increaseBtn) {
            int no = Integer.valueOf(this.getValue());
            this._numberFld.setText("" + ++no);
        } else {
            int no = Integer.valueOf(this.getValue());
            if (--no < 0) {
                no = 0;
            }
            this._numberFld.setText("" + no);
        }
        for (IncrementFieldListener listener : this._listeners) {
            listener.valueChanged(Integer.valueOf(this.getValue()));
        }
    }

    public String getValue() {
        String v = this._numberFld.getText().trim();
        int i = 0;
        while (i < v.length()) {
            char c = v.charAt(i);
            if (!Character.isDigit(c)) {
                return "1";
            }
            ++i;
        }
        return this._numberFld.getText().trim();
    }

    public JButton decorate(JButton button) {
        button.setRolloverEnabled(true);
        button.setBorderPainted(true);
        button.setVerticalTextPosition(0);
        button.setHorizontalAlignment(0);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    public void addIncrementFieldListener(IncrementFieldListener listener) {
        this._listeners.add(listener);
    }

    public void removeIncrementFieldListener(IncrementFieldListener listener) {
        this._listeners.remove(listener);
    }

    public final JTextField getTextComponent() {
        return this._numberFld;
    }
}

