/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.changes;

import java.net.URL;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;

public class CreateNode
extends RefactoringChange {
    private Project _project;
    private URL _url;
    private String _text;

    public CreateNode(Project project, URL url, String text) {
        super(null);
        this._project = project;
        this._url = url;
        this._text = text;
    }

    public boolean doit() throws Exception {
        JavaManager javaManager = JavaManager.getJavaManager((Project)this._project);
        CacheSupport cacheSupport = javaManager.getCacheSupport();
        try {
            cacheSupport.beginCacheUse();
            TextNode node = (TextNode)NodeFactory.findOrCreate((URL)this._url);
            this._project.add((Element)node);
            TextBuffer textBuffer = node.acquireTextBuffer();
            textBuffer.append(this._text.toCharArray());
            this.setNode((Node)node);
            UpdateMessage.fireChildAdded((Subject)this._project, (Element)node);
            UpdateMessage.fireStructureChanged((Subject)this._project);
        }
        finally {
            cacheSupport.endCacheUse();
        }
        return true;
    }

    public boolean undo() throws Exception {
        JavaManager javaManager = JavaManager.getJavaManager((Project)this._project);
        CacheSupport cacheSupport = javaManager.getCacheSupport();
        boolean ret = false;
        try {
            cacheSupport.beginCacheUse();
            Node node = NodeFactory.find((URL)this._url);
            if (node != null) {
                node.delete();
                ret = true;
            } else {
                URLFileSystem.delete((URL)this._url);
                ret = true;
            }
        }
        finally {
            cacheSupport.endCacheUse();
        }
        return ret;
    }
}

