/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.changes;

import java.io.IOException;
import java.net.URL;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;

public class DeleteNode
extends RefactoringChange {
    private Project _project;
    private URL _url;
    private String _text;

    public DeleteNode(Project project, URL url) {
        super(null);
        this._project = project;
        this._url = url;
        TextNode node = (TextNode)NodeFactory.find((URL)url);
        TextBuffer textBuffer = node.acquireTextBuffer();
        this._text = textBuffer.getString(0, textBuffer.getLength());
        this.setNode((Node)node);
    }

    public boolean doit() throws Exception {
        boolean ret = DeleteNode.deleteNode(this._project, this._url);
        this.setNode(null);
        return ret;
    }

    public static boolean deleteNode(Project project, URL url) throws IOException {
        boolean ret = false;
        JavaManager javaManager = JavaManager.getJavaManager((Project)project);
        CacheSupport cacheSupport = javaManager.getCacheSupport();
        try {
            cacheSupport.beginCacheUse();
            Node node = NodeFactory.find((URL)url);
            if (node != null) {
                node.delete();
                ret = true;
            } else {
                URLFileSystem.delete((URL)url);
                ret = true;
            }
        }
        finally {
            cacheSupport.endCacheUse();
        }
        return ret;
    }

    public boolean undo() throws Exception {
        JavaManager javaManager = JavaManager.getJavaManager((Project)this._project);
        CacheSupport cacheSupport = javaManager.getCacheSupport();
        try {
            cacheSupport.beginCacheUse();
            TextNode node = (TextNode)NodeFactory.findOrCreate((URL)this._url);
            this._project.add((Element)node);
            TextBuffer textBuffer = node.acquireTextBuffer();
            textBuffer.append(this._text.toCharArray());
            UpdateMessage.fireChildAdded((Subject)this._project, (Element)node);
            UpdateMessage.fireStructureChanged((Subject)this._project);
        }
        finally {
            cacheSupport.endCacheUse();
        }
        return true;
    }
}

