/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.changes;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.VetoableSubject;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;
import oracle.jdeveloper.refactoring.changes.TextChange;

public class RenameNode
extends RefactoringChange {
    private URL _urlBefore;
    private URL _urlAfter;

    public RenameNode(Node node, URL urlBefore, URL urlAfter) {
        super(node);
        this._urlBefore = urlBefore;
        this._urlAfter = urlAfter;
    }

    public boolean doit() throws Exception {
        Node node = this.getNode();
        return CopyOfRenameCommand.rename(node, this._urlBefore, this._urlAfter);
    }

    public boolean undo() throws Exception {
        Node node = this.getNode();
        return CopyOfRenameCommand.rename(node, this._urlAfter, this._urlBefore);
    }

    public int compareTo(Object o) {
        if (o instanceof TextChange) {
            TextChange otherRefChange = (TextChange)o;
            return -otherRefChange.compareTo(this);
        }
        return this.hashCode() - o.hashCode();
    }

    static class CopyOfRenameCommand {
        public static boolean rename(Node node, URL urlBefore, URL urlAfter) {
            boolean ret = false;
            Context[] contexts = CopyOfRenameCommand.getOwners(node);
            if (CopyOfRenameCommand.canRename(contexts, node) && CopyOfRenameCommand.doSaveAs(contexts, node, urlBefore, urlAfter)) {
                if (URLFileSystem.exists((URL)urlBefore) && !URLFileSystem.isDirectory((URL)urlBefore) && !URLFileSystem.equals((URL)urlBefore, (URL)urlAfter) && !URLFileSystem.delete((URL)urlBefore)) {
                    String msg = IdeArb.format((int)374, (Object)URLFileSystem.getPlatformPathName((URL)urlBefore), (Object)URLFileSystem.getPlatformPathName((URL)urlAfter));
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), msg, IdeArb.getString((int)170), 0);
                }
                ret = true;
            }
            return ret;
        }

        private static boolean canRename(Context[] contexts, Node node) {
            int i = 0;
            while (i < contexts.length) {
                Context context = contexts[i];
                Project project = context.getProject();
                try {
                    UpdateMessage.fireCanRenameChild((VetoableSubject)project, (Object)node);
                }
                catch (Exception e) {
                    boolean bl = false;
                    return bl;
                }
                ++i;
            }
            return true;
        }

        private static boolean saveNode(Node node, URL urlBefore, URL urlAfter) {
            if (!URLFileSystem.exists((URL)urlBefore)) {
                return CopyOfRenameCommand.saveNode2(node, urlBefore, urlAfter);
            }
            if (URLFileSystem.exists((URL)urlAfter) && !URLFileSystem.equals((URL)urlBefore, (URL)urlAfter) && !URLFileSystem.delete((URL)urlAfter)) {
                String msg = IdeArb.format((int)369, (Object)URLFileSystem.getPlatformPathName((URL)urlAfter));
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), msg, IdeArb.getString((int)170), 0);
                return false;
            }
            if (!URLFileSystem.renameTo((URL)urlBefore, (URL)urlAfter)) {
                String msg = IdeArb.format((int)88, (Object)URLFileSystem.getPlatformPathName((URL)urlBefore), (Object)URLFileSystem.getPlatformPathName((URL)urlAfter));
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), msg, IdeArb.getString((int)170), 0);
                return false;
            }
            node.setURL(urlAfter);
            return true;
        }

        private static boolean saveAsNewNode(Context[] contexts, Node node, URL urlBefore, URL urlAfter) {
            CacheSupport[] cacheSupports = new CacheSupport[contexts.length];
            int i = 0;
            while (i < contexts.length) {
                Context context = contexts[i];
                Project project = context.getProject();
                JavaManager javaManager = JavaManager.getJavaManager((Project)project);
                cacheSupports[i] = javaManager.getCacheSupport();
                cacheSupports[i].beginCacheUse();
                try {
                    RenameMessage.firePreChildRenamed((Subject)project, (Context)context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            boolean result = CopyOfRenameCommand.saveNode(node, urlBefore, urlAfter);
            int i2 = 0;
            while (i2 < contexts.length) {
                Context context = contexts[i2];
                cacheSupports[i2].endCacheUse();
                if (result) {
                    try {
                        Project project = context.getProject();
                        RenameMessage.fireObjectRenamed((Subject)node, (URL)urlBefore, (Context)context);
                        RenameMessage.fireChildRenamed((Subject)project, (URL)urlBefore, (Node)node, (Context)context);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i2;
            }
            return result;
        }

        private static boolean doSaveAs(Context[] contexts, Node node, URL urlBefore, URL urlAfter) {
            boolean result = CopyOfRenameCommand.saveAsNewNode(contexts, node, urlBefore, urlAfter);
            if (result) {
                int i = 0;
                while (i < contexts.length) {
                    Context context = contexts[i];
                    Project project = context.getProject();
                    project.markDirty(true);
                    ++i;
                }
            }
            return result;
        }

        private static boolean saveNode2(Node node, URL urlBefore, URL urlAfter) {
            boolean ret = false;
            node.setURL(urlAfter);
            if (!URLFileSystem.isReadOnly((URL)urlAfter) || URLFileSystem.setReadOnly((URL)urlAfter, (boolean)false)) {
                node.markDirty(true);
                node.isReadOnly();
                try {
                    node.save();
                    ret = true;
                }
                catch (IOException e) {
                    node.setURL(urlBefore);
                    System.err.println("**** ERROR: IOException trying to save " + node.getURL());
                    System.err.println("****        Reason: " + e.getLocalizedMessage());
                }
            }
            return ret;
        }

        private static Context[] getOwners(Node node) {
            ArrayList<Context> ret = new ArrayList<Context>(1);
            Workspaces workspacesRoot = Ide.getWorkspaces();
            Iterator workspaces = workspacesRoot.getChildren();
            while (workspaces.hasNext()) {
                Workspace workspace = (Workspace)workspaces.next();
                Iterator projects = workspace.getChildren();
                while (projects.hasNext()) {
                    Project project = (Project)projects.next();
                    if (!project.containsChild((Element)node)) continue;
                    Context context = new Context(workspace, project);
                    context.setNode(node);
                    context.setElement((Element)node);
                    ret.add(context);
                }
            }
            return ret.toArray(new Context[ret.size()]);
        }

        CopyOfRenameCommand() {
        }
    }
}

