/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.changes;

import javax.swing.undo.UndoableEdit;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.jdeveloper.refactoring.changes.RefactoringChange;

public class TextChange
extends RefactoringChange {
    private UndoableEdit _undoableEdit;
    private int _offset;
    private int _length;
    private String _textAfter;

    public TextChange(TextNode node, int offset, String textBefore, String textAfter) {
        super((Node)node);
        this.init(offset, textBefore.length(), textAfter);
    }

    public TextChange(TextNode node, int offsetFrom, int offsetTo, String textAfter) {
        this(node, offsetFrom, offsetTo, textAfter, false);
    }

    public TextChange(TextNode node, int offsetFrom, int offsetTo, String textAfter, boolean extend) {
        super((Node)node);
        TextBuffer textBuffer = node.acquireTextBuffer();
        if (extend) {
            LineMap lineMap = textBuffer.getLineMap();
            int line = lineMap.getLineFromOffset(offsetFrom);
            int lineStartOffset = lineMap.getLineStartOffset(line);
            String prefix = textBuffer.getString(lineStartOffset, offsetFrom - lineStartOffset);
            int prefixLen = prefix.length() - 1;
            while (prefixLen >= 0 && Character.isWhitespace(prefix.charAt(prefixLen))) {
                --offsetFrom;
                --prefixLen;
            }
            int line2 = lineMap.getLineFromOffset(offsetTo);
            int lineEndOffset = lineMap.getLineEndOffset(line2);
            String suffix = textBuffer.getString(offsetTo, lineEndOffset - offsetTo);
            int suffixLength = suffix.length();
            int j = 0;
            while (j < suffixLength && Character.isWhitespace(suffix.charAt(j))) {
                ++offsetTo;
                ++j;
            }
        }
        String textBefore = textBuffer.getString(offsetFrom, offsetTo - offsetFrom);
        this.init(offsetFrom, textBefore.length(), textAfter);
    }

    private void init(int offset, int length, String textAfter) {
        this._offset = offset;
        this._length = length;
        this._textAfter = textAfter == null ? "" : textAfter;
    }

    public int compareTo(Object o) {
        RefactoringChange that = (RefactoringChange)o;
        int ret = TextChange.compareChangeTypes(this, that);
        if (ret == 0) {
            Node otherNode;
            RefactoringChange otherRefChange = that;
            Node myNode = this.getNode();
            if (myNode == (otherNode = otherRefChange.getNode())) {
                TextChange otherTextChange = (TextChange)that;
                int myOffset = this.getOffset();
                int otherOffset = otherTextChange.getOffset();
                ret = myOffset - otherOffset;
            } else {
                String myLongLabel = myNode.getLongLabel();
                String otherLongLabel = otherNode.getLongLabel();
                ret = myLongLabel.compareTo(otherLongLabel);
            }
            ret &= 0x8FFFFFFF;
        }
        return ret;
    }

    public int getOffset() {
        return this._offset;
    }

    public String getTextAfter() {
        return this._textAfter;
    }

    public TextNode getTextNode() {
        return (TextNode)this.getNode();
    }

    public int getLength() {
        return this._length;
    }

    public boolean doit() throws Exception {
        if (this._undoableEdit == null) {
            String textAfter = this.getTextAfter();
            TextNode textNode = this.getTextNode();
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            int offset = this.getOffset();
            int length = this.getLength();
            textBuffer.beginEdit();
            textBuffer.remove(offset, length);
            textBuffer.insert(offset, textAfter.toCharArray());
            this._undoableEdit = textBuffer.endEdit();
        } else {
            this._undoableEdit.redo();
        }
        return true;
    }

    public boolean undo() throws Exception {
        this._undoableEdit.undo();
        return true;
    }
}

