/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.awt.event.ActionListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.MetParam;
import oracle.jdeveloper.refactoring.criteria.SearchVariableCriteria;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.BaseUsageEntry;
import oracle.jdeveloper.refactoring.model.ProgressIndicator;
import oracle.jdeveloper.refactoring.model.SearchResults;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.model.SearchOperationImpl;

public final class ChangeMethodCriteria
extends AbstractSearchCriteria {
    private SourceMethod _sourceMethod;
    private String _newMethodName;
    private String _newReturnType;
    private MetParam[] _params;
    private Integer _newModifiers;
    private boolean _useTasks;
    private Boolean _paramOrderChanged;
    private boolean _useExistingMethod;
    private boolean _preview;
    private Context _context;
    private boolean _safeRefactoring;
    private SourceFormalParameter[] _paramsToBeChecked;

    public ChangeMethodCriteria(SourceMethod method, MetParam[] params) {
        this._sourceMethod = method;
        this._params = params;
    }

    public int getSearchType() {
        return -2147483532;
    }

    public String getShortTitle() {
        return RefactoringArb.getString(101);
    }

    public String getLongTitle() {
        String fullMethodName = Util.getFullMethodName((JavaMethod)this.getSourceMethod(), true, true, false);
        String ret = MessageFormat.format(RefactoringArb.getString(17), fullMethodName);
        return ret;
    }

    public String getNewMethodName() {
        return this._newMethodName;
    }

    public String getNewReturnType() {
        return this._newReturnType;
    }

    public Integer getNewModifiers() {
        return this._newModifiers;
    }

    public SourceMethod getSourceMethod() {
        return this._sourceMethod;
    }

    public MetParam[] getParams() {
        return this._params;
    }

    public void setNewMethodName(String newMethodName) {
        String oldMethodName = this.getSourceMethod().getName();
        this._newMethodName = oldMethodName.equals(newMethodName) ? null : newMethodName;
    }

    public void setNewReturnType(String newReturnType) {
        SourceTypeReference sourceReturnType = this.getSourceMethod().getSourceReturnType();
        boolean isSameType = ChangeMethodCriteria.isSameType(sourceReturnType, newReturnType);
        this._newReturnType = isSameType ? null : newReturnType;
    }

    public void setAccessibility(int accessibilityModifier) {
        this._newModifiers = null;
        int modifiers = this.getSourceMethod().getModifiers() & 7;
        if (modifiers != accessibilityModifier) {
            this._newModifiers = new Integer(accessibilityModifier);
        }
    }

    public void setUseTaks(boolean useTasks) {
        this._useTasks = useTasks;
    }

    public boolean isUseTasks() {
        return this._useTasks;
    }

    public void setUseExistingMethod(boolean useExistingMethod) {
        this._useExistingMethod = useExistingMethod;
    }

    public boolean isUseExistingMethod() {
        return this._useExistingMethod;
    }

    public static boolean isSameType(SourceTypeReference sourceType, String newReturnType) {
        boolean isSameType = false;
        String oldTypeName = sourceType.getText();
        if (newReturnType.equals(oldTypeName)) {
            isSameType = true;
        } else {
            String oldFqTypeName;
            JavaType resolvedType = sourceType.getResolvedType();
            if (resolvedType != null && newReturnType.equals(oldFqTypeName = resolvedType.getQualifiedName())) {
                isSameType = true;
            }
        }
        return isSameType;
    }

    public boolean isParamOrderChanged() {
        if (this._paramOrderChanged == null) {
            Collection oldParams = this.getSourceMethod().getParameters();
            if (oldParams.size() == this.getParams().length) {
                this._paramOrderChanged = Boolean.FALSE;
                int i = 0;
                while (this._paramOrderChanged == Boolean.FALSE && i < this.getParams().length) {
                    MetParam param = this.getParams()[i];
                    if (param.getOldPosition() != i) {
                        this._paramOrderChanged = Boolean.TRUE;
                    }
                    ++i;
                }
            } else {
                this._paramOrderChanged = Boolean.TRUE;
            }
        }
        return this._paramOrderChanged;
    }

    public boolean areParamsChanged() {
        if (this.isParamOrderChanged()) {
            return true;
        }
        int i = 0;
        while (i < this.getParams().length) {
            MetParam param = this.getParams()[i];
            if (param.isNameChanged() || param.isTypeChanged()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setPreview(boolean preview) {
        this._preview = preview;
    }

    public boolean isPreview() {
        return this._preview;
    }

    public void setSafeRefactoring(boolean safeRefactoring) {
        this._safeRefactoring = safeRefactoring;
    }

    public boolean isSafeRefactoring() {
        return this._safeRefactoring;
    }

    public boolean verifySearchResults(SearchResults methodUsages) {
        if (this._paramsToBeChecked != null) {
            return this.checkParameterUsages(methodUsages);
        }
        return this.hasInvocationUsages(methodUsages) ^ true;
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public void setParametersToBeChecked(SourceFormalParameter[] parameters) {
        this._paramsToBeChecked = parameters;
    }

    private boolean checkParameterUsages(SearchResults methodUsages) {
        ArrayList methodUsageEntries = methodUsages.getUsageModel().getUsageEntries();
        for (BaseUsageEntry methodEntry : methodUsageEntries) {
            SourceMethod sourceMethod;
            if (methodEntry.getUsageType() == 1) {
                return false;
            }
            SourceElement sourceElement = this.findSourceElementInURLByOffset(methodEntry.getOffset(), methodEntry.getURL(), this._context.getProject()).getParent();
            if (!(sourceElement instanceof SourceMethod) || this._sourceMethod.equals((Object)(sourceMethod = (SourceMethod)sourceElement))) continue;
            int i = 0;
            while (i < this._paramsToBeChecked.length) {
                SourceFormalParameter _param = this._paramsToBeChecked[i];
                int index = this._sourceMethod.getFormalParameterList().getSourceParameters().indexOf(_param);
                SourceVariable sourceVariable = (SourceVariable)sourceMethod.getFormalParameterList().getSourceParameters().get(index);
                SearchResults variableUsages = this.getVariableUsages(this._context, sourceVariable);
                ArrayList variableUsageEntries = variableUsages.getUsageModel().getUsageEntries();
                for (BaseUsageEntry variableEntry : variableUsageEntries) {
                    if (variableEntry.getUsageType() != 1) continue;
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean hasInvocationUsages(SearchResults methodUsages) {
        ArrayList methodUsageEntries = methodUsages.getUsageModel().getUsageEntries();
        for (BaseUsageEntry usageEntry : methodUsageEntries) {
            if (usageEntry.getUsageType() != 1) continue;
            return true;
        }
        return false;
    }

    private SearchResults getVariableUsages(Context context, SourceVariable variable) {
        SearchVariableCriteria criteria = new SearchVariableCriteria(variable, variable.getOwningSourceFile(), false);
        SearchOperationImpl searchOperation = new SearchOperationImpl(new Context(context.getWorkspace(), context.getProject()), criteria);
        searchOperation.doSearch(new NullSearchProgress(null));
        return searchOperation.getSearchResults();
    }

    private SourceElement findSourceElementInURLByOffset(int offset, URL url, Project project) {
        JavaManager manager = JavaManager.getJavaManager((Project)project);
        SourceFile file = manager.getSourceFile(url);
        return this.getSourceElement(offset, (SourceElement)file);
    }

    private SourceElement getSourceElement(int offset, SourceElement element) {
        List children = element.getChildren();
        for (SourceElement child : children) {
            if (offset < child.getStartOffset() || offset >= child.getEndOffset()) continue;
            return this.getSourceElement(offset, child);
        }
        return element;
    }

    private class NullSearchProgress
    implements ProgressIndicator {
        public void setProgressStepText(String text) {
        }

        public void setProgressText(String text) {
        }

        public void addActionListener(ActionListener listener) {
        }

        public void removeActionListener(ActionListener listener) {
        }

        public boolean isUserCancelled() {
            return false;
        }

        private NullSearchProgress() {
        }

        NullSearchProgress(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

