/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.resource.RefactoringArb;

public class ExtractInterfaceCriteria
extends AbstractSearchCriteria {
    private ClassDescription _sourceClassDescription;
    private String _pkgName;
    private String _interfaceName;
    private MethodDescription[] _methodDescriptions;
    private FieldDescription[] _fieldDescriptions;
    private final JavaType[] _selectedInterfaces;

    public ExtractInterfaceCriteria(ClassDescription sourceClassDescription, String pkgName, String interfaceName, JavaType[] selectedInterfaces, SourceMethod[] selectedMethods, SourceFieldVariable[] selectedFields) {
        this._sourceClassDescription = sourceClassDescription;
        this._pkgName = pkgName;
        this._interfaceName = interfaceName;
        this._selectedInterfaces = selectedInterfaces;
        this._methodDescriptions = new MethodDescription[selectedMethods.length];
        int i = 0;
        while (i < selectedMethods.length) {
            SourceMethod selectedMethod = selectedMethods[i];
            this._methodDescriptions[i] = new MethodDescription((JavaMethod)selectedMethod);
            ++i;
        }
        this._fieldDescriptions = new FieldDescription[selectedFields.length];
        int i2 = 0;
        while (i2 < selectedFields.length) {
            SourceFieldVariable selectedField = selectedFields[i2];
            this._fieldDescriptions[i2] = new FieldDescription((JavaField)selectedField);
            ++i2;
        }
    }

    public String getShortTitle() {
        return RefactoringArb.getString(198);
    }

    public int getSearchType() {
        return -2147483534;
    }

    public ClassDescription getSourceClassDescription() {
        return this._sourceClassDescription;
    }

    public String[] getExtractedInterfaceNames() {
        String[] ret = new String[this._selectedInterfaces.length];
        int i = 0;
        while (i < this._selectedInterfaces.length) {
            JavaType selectedInterface = this._selectedInterfaces[i];
            ret[i] = selectedInterface.getQualifiedName();
            ++i;
        }
        return ret;
    }

    public JavaType[] getSelectedInterfaces(JavaProvider javaProvider) {
        return this._selectedInterfaces;
    }

    public SourceMethod[] getSelectedMethods(JavaProvider javaProvider) {
        SourceMethod[] ret = new SourceMethod[this._methodDescriptions.length];
        int i = 0;
        while (i < this._methodDescriptions.length) {
            MethodDescription methodDescription = this._methodDescriptions[i];
            JavaMethod javaMethod = methodDescription.getJavaMethod(javaProvider);
            ret[i] = (SourceMethod)javaMethod.getSourceElement();
            ++i;
        }
        return ret;
    }

    public SourceFieldVariable[] getSelectedFields(JavaProvider javaProvider) {
        SourceFieldVariable[] ret = new SourceFieldVariable[this._fieldDescriptions.length];
        int i = 0;
        while (i < this._fieldDescriptions.length) {
            FieldDescription fieldDescription = this._fieldDescriptions[i];
            JavaField javaField = fieldDescription.getJavaField(javaProvider);
            ret[i] = (SourceFieldVariable)javaField.getSourceElement();
            ++i;
        }
        return ret;
    }

    public String getPkgName() {
        return this._pkgName;
    }

    public String getInterfaceName() {
        return this._interfaceName;
    }

    public FieldDescription[] getFieldDescriptions() {
        return this._fieldDescriptions;
    }

    public MethodDescription[] getMethodDescriptions() {
        return this._methodDescriptions;
    }
}

