/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ModelUtil;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.criteria.MoveFilesCriteria;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;

public class MoveClassesCriteria
extends MoveFilesCriteria {
    private boolean _searchInComments;
    private boolean _searchInNonJavaFiles;
    private ArrayList _movedClasses;
    private HashMap _mapClasses;
    private HashSet _mapOldPackages;
    private HashMap _mapNewClasses;
    private String _longTitle;
    private String _shortTitle;
    private ArrayList _packagePrefixes;
    private final HashMap _misplacedClasses;

    private void $init$() {
        this._packagePrefixes = new ArrayList();
        this._misplacedClasses = new HashMap();
    }

    public MoveClassesCriteria(boolean searchInComments, boolean searchInNonJavaFiles, String longTitle, String shortTitle) {
        super(longTitle, shortTitle);
        this.$init$();
        this._longTitle = longTitle;
        this._shortTitle = shortTitle;
        this._movedClasses = new ArrayList();
        this._mapClasses = new HashMap();
        this._mapNewClasses = new HashMap();
        this._mapOldPackages = new HashSet();
        this._searchInComments = searchInComments;
        this._searchInNonJavaFiles = searchInNonJavaFiles;
    }

    public int getSearchType() {
        return -2147483535;
    }

    public String getShortTitle() {
        if (this._shortTitle == null) {
            return MessageFormat.format(RefactoringArb.getString(65), Integer.toString(this._movedClasses.size()) + " classes");
        }
        return this._shortTitle;
    }

    public String getLongTitle() {
        if (this._longTitle == null) {
            return this.getShortTitle();
        }
        return this._longTitle;
    }

    public void setPreferredPackageUrl(String pkgName, URL preferredUrl) {
        if (pkgName.endsWith(".")) {
            pkgName = pkgName.substring(0, pkgName.length() - 1);
        }
        if (this.getPreferredUrl(pkgName) == null) {
            this.removePackagePrefix(pkgName);
            Object[] objects = new Object[]{pkgName, preferredUrl};
            this._packagePrefixes.add(objects);
        }
    }

    private void removePackagePrefix(String pkgName) {
        int i = this._packagePrefixes.size() - 1;
        while (i >= 0) {
            Object[] objects = (Object[])this._packagePrefixes.get(i);
            String pkgName_i = (String)objects[0];
            if (pkgName_i.startsWith(pkgName)) {
                this._packagePrefixes.remove(i);
            }
            --i;
        }
    }

    public URL getPreferredUrl(String pkgName) {
        int i = 0;
        while (i < this._packagePrefixes.size()) {
            Object[] objects = (Object[])this._packagePrefixes.get(i);
            String pkgName_i = (String)objects[0];
            if (pkgName.equals(pkgName_i)) {
                URL url = (URL)objects[1];
                return url;
            }
            if (pkgName.startsWith(pkgName_i + '.')) {
                URL url = (URL)objects[1];
                String pkgSuffix = pkgName.substring(pkgName_i.length() + 1);
                String urlSuffix = pkgSuffix.replace('.', '/');
                URL ret = URLFactory.newURL((URL)url, (String)urlSuffix);
                return ret;
            }
            ++i;
        }
        return null;
    }

    private SingleMove addSingleMove(String oldPackageName, String oldClsName, String newPackageName, String newClsName) {
        SingleMove entry = new SingleMove(oldPackageName, oldClsName, newPackageName, newClsName);
        this._movedClasses.add(entry);
        this._mapClasses.put(entry.getFqOldClassName(), entry);
        this._mapNewClasses.put(entry.getFqNewClassName(), entry);
        this._mapOldPackages.add(entry.getOldPackageName());
        return entry;
    }

    public void addClassMove(JavaManager javaManager, String oldPackageName, String oldClsName, String newPackageName, String newClsName) {
        String oldFqClsName = Util.getFqClassName(oldPackageName, oldClsName);
        SourceClass sourceClass = this.findSourceClass(javaManager, oldFqClsName);
        if (sourceClass != null) {
            SourceClass sc;
            SourceFile sourceFile;
            JavaClass primaryClass;
            String fqOldClassName;
            SingleMove entry = this.addClassMove(sourceClass, newPackageName, newClsName);
            if (oldClsName.indexOf(46) == -1 && (fqOldClassName = entry.getFqOldClassName()).equals((primaryClass = (sourceFile = (sc = this.findSourceClass(javaManager, fqOldClassName)).getOwningSourceFile()).getPrimaryClass()).getQualifiedName())) {
                URL urlAfter;
                URL urlBefore = sourceFile.getURL();
                String path = urlBefore.getPath();
                int dotPos = path.lastIndexOf(46);
                String extension = path.substring(dotPos);
                URL preferredUrl = this.getPreferredUrl(newPackageName);
                String fileName = newClsName + extension;
                if (preferredUrl == null) {
                    URL oldPackageURL = URLFileSystem.getParent((URL)urlBefore);
                    String oldPackagePath = URLFileSystem.getPath((URL)oldPackageURL);
                    int oldPackageNameLength = oldPackageName != null && !oldPackageName.equals("") ? oldPackageName.length() : -1;
                    int oldPackagePathLength = oldPackagePath.length();
                    String packagePrefix = oldPackagePath.substring(0, oldPackagePathLength - oldPackageNameLength - 1);
                    String newPackageSuffix = newPackageName.replace('.', '/');
                    if (!newPackageSuffix.equals("")) {
                        newPackageSuffix = newPackageSuffix + '/';
                    }
                    urlAfter = URLFactory.newFileURL((String)(packagePrefix + newPackageSuffix + fileName));
                } else {
                    urlAfter = URLFactory.newURL((URL)preferredUrl, (String)fileName);
                }
                if (!urlBefore.equals(urlAfter)) {
                    super.moveUrl(urlBefore, urlAfter);
                }
            }
        }
    }

    public void addDirectoryMove(JavaManager javaManager, URL sourceEntry, String sourceSuffix, Project targetProject, URL targetEntry, String targetSuffix) {
        if (!sourceSuffix.endsWith("/")) {
            sourceSuffix = sourceSuffix + '/';
        }
        if (!targetSuffix.endsWith("/")) {
            targetSuffix = targetSuffix + '/';
        }
        URL sourceUrl = URLFactory.newDirURL((URL)sourceEntry, (String)sourceSuffix);
        URL targetUrl = URLFactory.newDirURL((URL)targetEntry, (String)targetSuffix);
        super.moveUrl(sourceUrl, targetUrl);
        this._addDirectoryMove(javaManager, sourceEntry, sourceSuffix, targetSuffix);
    }

    private void _addDirectoryMove(JavaManager javaManager, URL sourceEntry, String sourceSuffix, String targetSuffix) {
        block3: {
            URL sourceUrl;
            block2: {
                sourceUrl = URLFactory.newURL((URL)sourceEntry, (String)sourceSuffix);
                URL[] urls = URLFileSystem.list((URL)sourceUrl);
                if (urls == null) break block2;
                String sourcePath = URLFileSystem.getPath((URL)sourceUrl);
                int i = 0;
                while (i < urls.length) {
                    URL childUrl = urls[i];
                    String childPath = URLFileSystem.getPath((URL)childUrl);
                    String childSuffix = childPath.substring(sourcePath.length());
                    this._addDirectoryMove(javaManager, sourceEntry, sourceSuffix + childSuffix, targetSuffix + childSuffix);
                    ++i;
                }
                break block3;
            }
            if (!Util.isJavaSource(sourceUrl)) break block3;
            String fileName = URLFileSystem.getFileName((URL)sourceUrl);
            String targetPath = targetSuffix.substring(0, targetSuffix.length() - fileName.length() - 1);
            String targetPackage = targetPath.replace('/', '.');
            SourceFile sourceFile = javaManager.getSourceFile(sourceUrl);
            this.hintMisplacedFile(sourceFile);
            Collection classes = sourceFile.getClasses();
            for (SourceClass sourceClass : classes) {
                this.addClassMove(sourceClass, targetPackage, sourceClass.getName());
            }
        }
    }

    public void addFileMove(Context context, URL oldFileUrl, URL newFileUrl) {
        super.moveUrl(oldFileUrl, newFileUrl);
    }

    private SingleMove addClassMove(SourceClass sourceClass, String newPackage, String newClassName) {
        String sourcePackage = sourceClass.getPackageName();
        int pkgLen = sourcePackage.length() == 0 ? 0 : sourcePackage.length() + 1;
        String qualifiedName = sourceClass.getQualifiedName();
        String className = qualifiedName.substring(pkgLen);
        SingleMove singleMove = this.addSingleMove(sourcePackage, className, newPackage, newClassName);
        Collection declaredClasses = sourceClass.getDeclaredClasses();
        for (JavaClass javaClass : declaredClasses) {
            SourceClass innerClass;
            if (javaClass.getName() == null || (innerClass = (SourceClass)javaClass.getSourceElement()) == null) continue;
            String innerName = innerClass.getName();
            this.addClassMove(innerClass, newPackage, newClassName + '.' + innerName);
        }
        return singleMove;
    }

    public void hintMisplacedFile(SourceFile sourceFile) {
        List sourceClasses = sourceFile.getSourceClasses();
        this.hintMisplacedClasses(sourceClasses);
    }

    private void hintMisplacedClasses(Collection sourceClasses) {
        for (SourceClass sourceClass : sourceClasses) {
            String rawName = sourceClass.getRawName();
            this._misplacedClasses.put(rawName, sourceClass);
            Collection declaredClasses = sourceClass.getDeclaredClasses();
            this.hintMisplacedClasses(declaredClasses);
        }
    }

    public SourceClass findSourceClass(JavaManager javaManager, String fqClassName) {
        SourceClass sourceClass = javaManager.getSourceClass(fqClassName);
        SourceClass ret = sourceClass != null ? sourceClass : (SourceClass)this._misplacedClasses.get(fqClassName);
        return ret;
    }

    public boolean isSearchInComments() {
        return this._searchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this._searchInNonJavaFiles;
    }

    public String[] getFqOldClassesNames() {
        String[] res = new String[this._movedClasses.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = ((SingleMove)this._movedClasses.get(i)).getFqOldClassName();
            ++i;
        }
        return res;
    }

    public String[] getFqNewClassesNames() {
        String[] res = new String[this._movedClasses.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = ((SingleMove)this._movedClasses.get(i)).getFqNewClassName();
            ++i;
        }
        return res;
    }

    public String[] getNewClsNames() {
        String[] res = new String[this._movedClasses.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = ((SingleMove)this._movedClasses.get(i)).getNewClsName();
            ++i;
        }
        return res;
    }

    public String[] getOldClsNames() {
        String[] res = new String[this._movedClasses.size()];
        int i = 0;
        while (i < res.length) {
            res[i] = ((SingleMove)this._movedClasses.get(i)).getOldClsName();
            ++i;
        }
        return res;
    }

    public String[] getOldPackageNames() {
        String[] res = new String[this._mapOldPackages.size()];
        res = this._mapOldPackages.toArray(res);
        return res;
    }

    public String[] getNewPackageNames() {
        HashSet<String> hs = new HashSet<String>();
        int i = 0;
        while (i < this._movedClasses.size()) {
            String pname = ((SingleMove)this._movedClasses.get(i)).getNewPackageName();
            hs.add(pname);
            ++i;
        }
        String[] res = new String[hs.size()];
        res = hs.toArray(res);
        return res;
    }

    public boolean isMovedClass(String fqOldName) {
        Object o = this._mapClasses.get(fqOldName);
        return o != null;
    }

    public boolean isChangedPackage(String pname) {
        return this._mapOldPackages.contains(pname);
    }

    public String convertClassName(String fqOldName) {
        SingleMove sm = (SingleMove)this._mapClasses.get(fqOldName);
        if (sm != null) {
            return sm.getFqNewClassName();
        }
        return fqOldName;
    }

    public String getPackageFromFqClassName(String fqOldName) {
        SingleMove sm = (SingleMove)this._mapClasses.get(fqOldName);
        if (sm != null) {
            return sm.getNewPackageName();
        }
        return null;
    }

    public String getNewPackageFromFqNewClassName(String fqNewName) {
        SingleMove sm = (SingleMove)this._mapNewClasses.get(fqNewName);
        if (sm != null) {
            return sm.getNewPackageName();
        }
        return null;
    }

    public String getNewClsNameFromFqClassName(String fqOldName) {
        SingleMove sm = (SingleMove)this._mapClasses.get(fqOldName);
        if (sm != null) {
            return sm.getNewClsName();
        }
        return null;
    }

    public String getOldClsNameFromFqClassName(String fqOldName) {
        SingleMove sm = (SingleMove)this._mapClasses.get(fqOldName);
        if (sm != null) {
            return sm.getOldClsName();
        }
        return null;
    }

    public String getNewClsNameFromFqNewClassName(String fqNewName) {
        SingleMove sm = (SingleMove)this._mapNewClasses.get(fqNewName);
        if (sm != null) {
            return sm.getNewClsName();
        }
        return null;
    }

    public String getNewFqClsNameFromFqOldClassName(String fqOldName) {
        SingleMove sm = (SingleMove)this._mapClasses.get(fqOldName);
        if (sm != null) {
            return sm.getFqNewClassName();
        }
        return null;
    }

    public String getOldPackageNameAtIndex(int i) {
        return ((SingleMove)this._movedClasses.get(i)).getOldPackageName();
    }

    public String getNewPackageNameAtIndex(int i) {
        return ((SingleMove)this._movedClasses.get(i)).getNewPackageName();
    }

    public String getNewClsNameAtIndex(int i) {
        return ((SingleMove)this._movedClasses.get(i)).getNewClsName();
    }

    public URL[][] getMovedDirectories() {
        URL[] oldUrls;
        ArrayList<URL[]> ret = new ArrayList<URL[]>();
        URL[] uRLArray = oldUrls = this.getOldUrls();
        int n = 0;
        while (n < uRLArray.length) {
            URL oldUrl = uRLArray[n];
            if (URLFileSystem.isDirectory((URL)oldUrl)) {
                URL newUrl = this.getNewUrlFor(oldUrl);
                URL[] urls = new URL[]{oldUrl, newUrl};
                ret.add(urls);
            }
            ++n;
        }
        URL[][] array = new URL[ret.size()][];
        ret.toArray((T[])array);
        return array;
    }

    public void updateClassMap(String fqOldName, String fqNewName) {
        SingleMove sm = (SingleMove)this._mapClasses.get(fqOldName);
        this._mapClasses.put(fqNewName, sm);
    }

    class SingleMove {
        private String _oldPackageName;
        private String _oldClsName;
        private String _newClsName;
        private String _newPackageName;

        SingleMove(String oldPackageName, String oldClsName, String newPackageName, String newClsName) {
            this._oldPackageName = oldPackageName;
            this._oldClsName = oldClsName;
            this._newPackageName = newPackageName;
            this._newClsName = newClsName;
        }

        public String getOldPackageName() {
            return this._oldPackageName;
        }

        public String getNewPackageName() {
            return this._newPackageName;
        }

        public String getOldClsName() {
            return this._oldClsName;
        }

        public String getNewClsName() {
            return this._newClsName;
        }

        public String getFqOldClassName() {
            if (!ModelUtil.hasLength((String)this._oldPackageName)) {
                return this._oldClsName;
            }
            return this._oldPackageName + "." + this._oldClsName;
        }

        public String getFqNewClassName() {
            if (!ModelUtil.hasLength((String)this._newPackageName)) {
                return this._newClsName;
            }
            return this._newPackageName + "." + this._newClsName;
        }
    }
}

