/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.RenameFilesCriteria;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.resource.RefactoringArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveFilesCriteria
extends AbstractSearchCriteria
implements RenameFilesCriteria {
    private final List<Pair<URL, URL>> _movesSequence;
    private final Map<URL, URL> _old2New;
    private final HashSet<URL> _reCaseOnly;
    protected String _longTitle;
    protected String _shortTitle;

    private void $init$() {
        this._movesSequence = new ArrayList<Pair<URL, URL>>();
        this._old2New = new HashMap<URL, URL>();
        this._reCaseOnly = new HashSet(1);
    }

    public MoveFilesCriteria(String longTitle, String shortTitle) {
        this.$init$();
        this._longTitle = longTitle;
        this._shortTitle = shortTitle;
    }

    @Override
    public int getSearchType() {
        return -2147483530;
    }

    @Override
    public String getShortTitle() {
        if (this._shortTitle == null) {
            this._shortTitle = MessageFormat.format(RefactoringArb.getString(65), Integer.toString(this._old2New.size()) + " files");
        }
        return this._shortTitle;
    }

    @Override
    public String getLongTitle() {
        if (this._longTitle != null) {
            return this._longTitle;
        }
        return super.getLongTitle();
    }

    public final URL[] getOldUrls() {
        Set<URL> urls = this._old2New.keySet();
        return urls.toArray(new URL[urls.size()]);
    }

    public final URL[] getNewUrls() {
        Collection<URL> urls = this._old2New.values();
        return urls.toArray(new URL[urls.size()]);
    }

    public final URL getNewUrlFor(URL oldUrl) {
        return this._old2New.get(oldUrl);
    }

    public final void moveUrl(URL oldUrl, URL newUrl) {
        this.recursiveMoveUrl(oldUrl, newUrl);
    }

    private void recursiveMoveUrl(URL oldUrl, URL newUrl) {
        String newPath;
        String oldPath = URLFileSystem.getPlatformPathName((URL)oldUrl);
        if (oldPath.equalsIgnoreCase(newPath = URLFileSystem.getPlatformPathName((URL)newUrl))) {
            this._reCaseOnly.add(oldUrl);
        }
        if (URLFileSystem.isDirectory((URL)oldUrl)) {
            this.moveDirectory(oldUrl, newUrl);
        } else {
            Pair pair = new Pair((Object)oldUrl, (Object)newUrl);
            this._movesSequence.add((Pair<URL, URL>)pair);
        }
        this.moveSingleUrl(oldUrl, newUrl);
    }

    private void moveSingleUrl(URL oldUrl, URL newUrl) {
        URL existingOpr = this._old2New.put(oldUrl, newUrl);
        if (existingOpr != null) {
            String s = MessageFormat.format("File has already been moved: {0} and {1} both moved to {2}", URLFileSystem.getPlatformPathName((URL)existingOpr), URLFileSystem.getPlatformPathName((URL)oldUrl), URLFileSystem.getPlatformPathName((URL)newUrl));
            throw new IllegalArgumentException(s);
        }
    }

    private void moveDirectory(URL oldUrl, URL newUrl) {
        URL[] children = URLFileSystem.list((URL)oldUrl);
        int i = 0;
        while (i < children.length) {
            URL oldChild = children[i];
            if (this.getNewUrlFor(oldChild) == null) {
                URL newChild;
                String suffix = URLFileSystem.toRelativeSpec((URL)oldChild, (URL)oldUrl);
                if (URLFileSystem.isDirectory((URL)oldChild)) {
                    newChild = URLFactory.newDirURL((URL)newUrl, (String)suffix);
                } else {
                    newChild = URLFactory.newURL((URL)newUrl, (String)suffix);
                    Pair pair = new Pair((Object)oldChild, (Object)newChild);
                    this._movesSequence.add((Pair<URL, URL>)pair);
                }
                this.recursiveMoveUrl(oldChild, newChild);
            }
            ++i;
        }
    }

    public List<Pair<URL, URL>> getMovesSequence() {
        return this._movesSequence;
    }

    public final URL getOverwrittenUrl() {
        URL[] oldUrls = this.getOldUrls();
        int i = 0;
        while (i < oldUrls.length) {
            URL newUrl;
            URL oldUrl = oldUrls[i];
            if (!this._reCaseOnly.contains(oldUrl) && URLFileSystem.exists((URL)(newUrl = this.getNewUrlFor(oldUrl)))) {
                return newUrl;
            }
            ++i;
        }
        return null;
    }
}

