/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.text.MessageFormat;
import oracle.jdeveloper.refactoring.criteria.RenameMemberCriteria;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.resource.RefactoringArb;

public class RenameFieldCriteria
extends RenameMemberCriteria {
    private MethodDescription _getterDescription;
    private String _getterNameBefore;
    private String _getterNameAfter;
    private MethodDescription _setterDescription;
    private String _setterNameBefore;
    private String _setterNameAfter;

    public RenameFieldCriteria(FieldDescription fieldDescription, String fieldNameAfter, MethodDescription getterDescription, String getterNameAfter, MethodDescription setterDescription, String setterNameAfter, boolean searchInComments, boolean searchNonJavaFiles) {
        super(fieldDescription, fieldNameAfter, searchInComments, searchNonJavaFiles);
        this._getterDescription = getterDescription;
        if (this._getterDescription != null) {
            this._getterNameBefore = this._getterDescription.getMemberName();
        }
        this._getterNameAfter = getterNameAfter;
        this._setterDescription = setterDescription;
        if (this._setterDescription != null) {
            this._setterNameBefore = this._setterDescription.getMemberName();
        }
        this._setterNameAfter = setterNameAfter;
    }

    public FieldDescription getFieldDescription() {
        return (FieldDescription)this.getMemberDescription();
    }

    public MethodDescription getGetterDescription() {
        return this._getterDescription;
    }

    public String getGetterNameBefore() {
        return this._getterNameBefore;
    }

    public String getGetterNameAfter() {
        return this._getterNameAfter;
    }

    public MethodDescription getSetterDescription() {
        return this._setterDescription;
    }

    public String getSetterNameBefore() {
        return this._setterNameBefore;
    }

    public String getSetterNameAfter() {
        return this._setterNameAfter;
    }

    public int getSearchType() {
        return -2147483545;
    }

    public String getShortTitle() {
        String fieldName = this.getClassName() + "." + this.getMemberNameBefore();
        return MessageFormat.format(RefactoringArb.getString(246), fieldName);
    }

    public String getLongTitle() {
        return MessageFormat.format(RefactoringArb.getString(262), this.getFqClassName() + "." + this.getMemberNameBefore(), this.getMemberNameAfter());
    }

    public String getFieldType() {
        return this.getFieldDescription().getType();
    }
}

