/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.net.URLFileSystem;
import oracle.ide.refactoring.SafeDeleteFilesCriteria;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.resource.RefactoringArb;

public class SafeDeleteClassesCriteria
extends AbstractSearchCriteria
implements SafeDeleteFilesCriteria {
    private URL[] _urls;
    private ClassDescription[] _classDescriptions;

    public SafeDeleteClassesCriteria(URL[] urls, ClassDescription[] classDescriptions) {
        this._urls = urls;
        this._classDescriptions = classDescriptions;
    }

    public int getSearchType() {
        return -2147483538;
    }

    public String getShortTitle() {
        int classCount = this._classDescriptions.length;
        String objectName = this._urls.length == 1 ? URLFileSystem.getFileName((URL)this._urls[0]) : (classCount == 1 ? this._classDescriptions[0].getClassName() : (this._urls.length > 1 ? URLFileSystem.getFileName((URL)this._urls[0]) + ", ..." : (classCount > 1 ? this._classDescriptions[0].getClassName() + ", ..." : "...")));
        return MessageFormat.format(RefactoringArb.getString(138), objectName);
    }

    public String getLongTitle() {
        int classCount = this._classDescriptions.length;
        String objectName = this._urls.length == 1 ? URLFileSystem.getPlatformPathName((URL)this._urls[0]) : (classCount == 1 ? this._classDescriptions[0].getQualifiedName() : (this._urls.length > 1 ? URLFileSystem.getPlatformPathName((URL)this._urls[0]) + ", ..." : (classCount > 1 ? this._classDescriptions[0].getQualifiedName() + ", ..." : "...")));
        String message = MessageFormat.format(RefactoringArb.getString(210), objectName);
        return message;
    }

    public String[] getFqClassNames() {
        String[] strings = new String[this._classDescriptions.length];
        int i = 0;
        while (i < this._classDescriptions.length) {
            ClassDescription classDescription = this._classDescriptions[i];
            strings[i] = classDescription.getQualifiedName();
            ++i;
        }
        return strings;
    }

    public URL[] getUrls() {
        return this._urls;
    }
}

