/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.text.MessageFormat;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.FieldDescription;
import oracle.jdeveloper.resource.RefactoringArb;

public class SafeDeleteFieldCriteria
extends AbstractSearchCriteria {
    private FieldDescription _fieldDescription;

    public SafeDeleteFieldCriteria(FieldDescription fieldDescription) {
        this._fieldDescription = fieldDescription;
    }

    public FieldDescription getFieldDescription() {
        return this._fieldDescription;
    }

    public int getSearchType() {
        return -2147483536;
    }

    private String getFullFieldName() {
        JavaField javaField = this._fieldDescription.getJavaField();
        JavaClass owningClass = javaField.getOwningClass();
        String name = owningClass.getName();
        String fieldName = javaField.getName();
        if (name.length() == 0) {
            return fieldName;
        }
        return owningClass.getQualifiedName() + "." + fieldName;
    }

    public String getShortTitle() {
        String shortName = this.getFullFieldName();
        return MessageFormat.format(RefactoringArb.getString(138), shortName);
    }

    public String getClassName() {
        return this._fieldDescription.getFqClassName();
    }

    public String getFieldName() {
        return this._fieldDescription.getMemberName();
    }

    public String getLongTitle() {
        String fullName = this.getFullFieldName();
        String message = MessageFormat.format(RefactoringArb.getString(210), fullName);
        return message;
    }

    public String getFieldType() {
        return this._fieldDescription.getType();
    }
}

