/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.text.MessageFormat;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.refactoring.util.Util;
import oracle.jdeveloper.resource.RefactoringArb;

public class SafeDeleteMethodCriteria
extends AbstractSearchCriteria {
    private MethodDescription _methodDescription;

    public SafeDeleteMethodCriteria(MethodDescription methodDescription) {
        this._methodDescription = methodDescription;
    }

    public MethodDescription getMethodDescription() {
        return this._methodDescription;
    }

    public int getSearchType() {
        return -2147483537;
    }

    public String getShortTitle() {
        String shortName = this._methodDescription.getShortName();
        return MessageFormat.format(RefactoringArb.getString(138), shortName);
    }

    public String getClassName() {
        return this._methodDescription.getFqClassName();
    }

    public String getMethodName() {
        return this._methodDescription.getMemberName();
    }

    public String[] getParameterTypes() {
        return this._methodDescription.getParameterTypes();
    }

    public String getLongTitle() {
        String className = this.getClassName();
        String methodName = this.getMethodName();
        String[] parameterTypes = this.getParameterTypes();
        String fullName = Util.getFullMethodName(className, methodName, parameterTypes);
        String message = MessageFormat.format(RefactoringArb.getString(210), fullName);
        return message;
    }
}

