/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.text.MessageFormat;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.ClassDescription;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.search.Scope;

public class SearchClassCriteria
extends AbstractSearchCriteria {
    private ClassDescription _classDescription;
    private boolean _includeDeclaration;
    private boolean _includeClass;
    private boolean _includeAllocation;
    private boolean _includeImports;
    private boolean _includeMembers;
    private boolean _includeExtends;
    private boolean _includeLibraries;
    private boolean _searchInComments;
    private boolean _searchInNonJavaFiles;
    private Scope _scope;

    private void $init$() {
        this._includeDeclaration = true;
        this._includeClass = true;
        this._includeAllocation = true;
        this._includeImports = true;
        this._includeMembers = true;
        this._includeExtends = true;
        this._includeLibraries = false;
        this._searchInComments = false;
        this._searchInNonJavaFiles = false;
        this._scope = Scope.DUMMY_SCOPE;
    }

    public SearchClassCriteria(ClassDescription classDescription, boolean searchInComments, boolean searchInNonJavaFiles) {
        this.$init$();
        this._classDescription = classDescription;
        this._searchInComments = searchInComments;
        this._searchInNonJavaFiles = searchInNonJavaFiles;
    }

    public int getSearchType() {
        return 1;
    }

    public String getShortTitle() {
        return MessageFormat.format(RefactoringArb.getString(46), this.getClassName());
    }

    public String getLongTitle() {
        return MessageFormat.format(RefactoringArb.getString(46), this.getFqClassName());
    }

    public String getPackageName() {
        return this._classDescription.getPackageName();
    }

    public String getClassName() {
        return this._classDescription.getClassName();
    }

    public String getFqClassName() {
        return this._classDescription.getQualifiedName();
    }

    public void setInclude(boolean includeDeclaration, boolean includeClass, boolean includeAllocation, boolean includeImports, boolean includeMembers, boolean includeExtends) {
        this._includeDeclaration = includeDeclaration;
        this._includeClass = includeClass;
        this._includeAllocation = includeAllocation;
        this._includeImports = includeImports;
        this._includeMembers = includeMembers;
        this._includeExtends = includeExtends;
    }

    public void setScope(Scope scope) {
        this._scope = scope;
    }

    public boolean isIncludeDeclaration() {
        return this._includeDeclaration;
    }

    public void setIncludeDeclaration(boolean includeDeclaration) {
        this._includeDeclaration = includeDeclaration;
    }

    public boolean isIncludeAllocation() {
        return this._includeAllocation;
    }

    public void setIncludeAllocation(boolean includeAllocation) {
        this._includeAllocation = includeAllocation;
    }

    public boolean isIncludeClass() {
        return this._includeClass;
    }

    public void setIncludeClass(boolean includeClass) {
        this._includeClass = includeClass;
    }

    public boolean isIncludeImports() {
        return this._includeImports;
    }

    public void setIncludeImports(boolean includeImports) {
        this._includeImports = includeImports;
    }

    public boolean isIncludeMembers() {
        return this._includeMembers;
    }

    public void setIncludeMembers(boolean includeMembers) {
        this._includeMembers = includeMembers;
    }

    public boolean isIncludeExtends() {
        return this._includeExtends;
    }

    public void setIncludeExtends(boolean includeExtends) {
        this._includeExtends = includeExtends;
    }

    public boolean isIncludeLibraries() {
        return this._includeLibraries;
    }

    public void setIncludeLibraries(boolean includeLibraries) {
        this._includeLibraries = includeLibraries;
    }

    public boolean isSearchInComments() {
        return this._searchInComments;
    }

    public boolean isSearchInNonJavaFiles() {
        return this._searchInNonJavaFiles;
    }

    public Scope getScope() {
        return this._scope;
    }
}

