/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.text.MessageFormat;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.refactoring.model.MethodDescription;
import oracle.jdeveloper.resource.RefactoringArb;
import oracle.jdevimpl.refactoring.search.Scope;

public class SearchMethodCriteria
extends AbstractSearchCriteria {
    private MethodDescription _methodDescription;
    private boolean _overloadedMethods;
    private boolean _searchInComments;
    private boolean _searchInLibraries;
    private boolean _searchInNonJavaFiles;
    private boolean _includeDeclaration;
    private boolean _includeInvocation;
    private Scope _scope;

    private void $init$() {
        this._includeDeclaration = true;
        this._includeInvocation = true;
        this._scope = Scope.DUMMY_SCOPE;
    }

    public SearchMethodCriteria(MethodDescription methodDescription) {
        this(methodDescription, false);
    }

    public SearchMethodCriteria(MethodDescription methodDescription, boolean overloadedMethods) {
        this.$init$();
        this._methodDescription = methodDescription;
        this._overloadedMethods = overloadedMethods;
    }

    public int getSearchType() {
        return 2;
    }

    public String getShortTitle() {
        String shortName = this._overloadedMethods ? this._methodDescription.getClassName() + "." + this._methodDescription.getMemberName() + "(_)" : this._methodDescription.getShortName();
        return MessageFormat.format(RefactoringArb.getString(46), shortName);
    }

    public String getLongTitle() {
        String methodName = this._overloadedMethods ? this._methodDescription.getFqClassName() + "." + this._methodDescription.getMemberName() + "(_)" : this._methodDescription.getLongName();
        return MessageFormat.format(RefactoringArb.getString(46), methodName);
    }

    public MethodDescription getMethodDescription() {
        return this._methodDescription;
    }

    public String getFqClassName() {
        return this._methodDescription.getFqClassName();
    }

    public String getMethodName() {
        return this._methodDescription.getMemberName();
    }

    public boolean isOverloadedMethods() {
        return this._overloadedMethods;
    }

    public String[] getParameterTypes() {
        if (this.isOverloadedMethods()) {
            return null;
        }
        return this._methodDescription.getParameterTypes();
    }

    public boolean isIncludeDeclaration() {
        return this._includeDeclaration;
    }

    public void setIncludeDeclaration(boolean includeDeclaration) {
        this._includeDeclaration = includeDeclaration;
    }

    public boolean isIncludeInvocation() {
        return this._includeInvocation;
    }

    public void setIncludeInvocation(boolean includeInvocation) {
        this._includeInvocation = includeInvocation;
    }

    public boolean isSearchInComments() {
        return this._searchInComments;
    }

    public void setSearchInComments(boolean searchInComments) {
        this._searchInComments = searchInComments;
    }

    public boolean isSearchInLibraries() {
        return this._searchInLibraries;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        this._searchInLibraries = searchInLibraries;
    }

    public boolean isSearchInNonJavaFiles() {
        return this._searchInNonJavaFiles;
    }

    public void setSearchInNonJavaFiles(boolean searchInNonJavaFiles) {
        this._searchInNonJavaFiles = searchInNonJavaFiles;
    }

    public Scope getScope() {
        return this._scope;
    }

    public void setScope(Scope scope) {
        this._scope = scope;
    }
}

