/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.refactoring.criteria;

import java.net.URL;
import java.text.MessageFormat;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.jdeveloper.refactoring.model.AbstractSearchCriteria;
import oracle.jdeveloper.resource.RefactoringArb;

public class SearchVariableCriteria
extends AbstractSearchCriteria
implements TextBufferListener {
    private SourceVariable _sourceVariable;
    private SourceFile _sourceFile;
    private boolean _searchInComments;
    private OffsetMark _offsetMark;
    private int _startOffset;
    private int _length;
    private boolean _valid;

    private void $init$() {
        this._valid = true;
    }

    public SearchVariableCriteria(SourceVariable sourceVariable, SourceFile sourceFile, boolean searchInComments) {
        this.$init$();
        this._sourceVariable = sourceVariable;
        this._sourceFile = sourceFile;
        this._searchInComments = searchInComments;
        URL url = sourceFile.getURL();
        TextNode node = (TextNode)NodeFactory.find((URL)url);
        TextBuffer textBuffer = node.acquireTextBuffer();
        this._startOffset = sourceVariable.getStartOffset();
        this._length = sourceVariable.getEndOffset() - sourceVariable.getStartOffset();
        this._offsetMark = textBuffer.addOffsetMark(this._startOffset);
        textBuffer.addTextBufferListener((TextBufferListener)this);
    }

    public int getSearchType() {
        return 6;
    }

    public String getShortTitle() {
        return MessageFormat.format(RefactoringArb.getString(46), this.getVariableName());
    }

    public boolean isValid() {
        return this._valid;
    }

    public SourceVariable getVariable() {
        return this._sourceVariable;
    }

    public String getVariableName() {
        return this._sourceVariable.getName();
    }

    public SourceFile getSourceFile() {
        return this._sourceFile;
    }

    public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
        this.whenTextChangesAt(offset, count);
    }

    public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
    }

    public void attributeUpdate(TextBuffer buffer, int attribute) {
    }

    private void whenTextChangesAt(int offset, int count) {
        int myOffset = this._offsetMark.getOffset();
        if (SearchVariableCriteria.intersects(offset, offset + count, myOffset) || SearchVariableCriteria.intersects(myOffset, myOffset + this._length, offset)) {
            this.whenTextHasChanged();
        }
    }

    private void whenTextHasChanged() {
        this._valid = false;
    }

    private static boolean intersects(int from, int to, int at) {
        return from <= at && at <= to;
    }

    public boolean isSearchInComments() {
        return this._searchInComments;
    }
}

